/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.workflow.core.utils.nuix.CaseType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NuixCaseUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixCaseUtils.class);

    private static String getNuixCaseMetadata(String location, String name) {
        try {
            Path fbiFile = Paths.get(location, new String[0]).resolve("case.fbi2");
            if (!Files.exists(fbiFile, new LinkOption[0])) {
                return null;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fbiFile.toFile());
            doc.getDocumentElement().normalize();
            Node metadataNode = doc.getElementsByTagName("metadata").item(0);
            Element metadataElement = (Element)metadataNode;
            return metadataElement.getElementsByTagName(name).item(0).getTextContent();
        }
        catch (Exception e) {
            LOGGER.error("Cannot get case metadata " + name, (Throwable)e);
            return null;
        }
    }

    public static long getNuixCaseCreationTime(String location) {
        String creationDateString = NuixCaseUtils.getNuixCaseMetadata(location, "creation-date");
        if (creationDateString != null) {
            return DateTime.parse((String)creationDateString).getMillis();
        }
        return 0L;
    }

    public static CaseType getNuixCaseType(String location) {
        String caseTypeString = NuixCaseUtils.getNuixCaseMetadata(location, "caseType");
        if (caseTypeString != null) {
            try {
                return CaseType.valueOf(caseTypeString);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Cannot parse caseType", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static String getNuixCaseGuid(String location) {
        String caseGuid = NuixCaseUtils.getNuixCaseMetadata(location, "guid");
        return caseGuid;
    }

    public static List<Path> getNuixSubCasePaths(String location) {
        try {
            ArrayList<Path> results = new ArrayList<Path>();
            Path fbiFile = Paths.get(location, new String[0]).resolve("case.fbi2");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fbiFile.toFile());
            doc.getDocumentElement().normalize();
            Node subcasesNode = doc.getElementsByTagName("subcases").item(0);
            Element subcasesElement = (Element)subcasesNode;
            NodeList subcasesNodeList = subcasesElement.getElementsByTagName("subcase");
            for (int i = 0; i < subcasesNodeList.getLength(); ++i) {
                String subcaseLocation = subcasesNodeList.item(i).getAttributes().getNamedItem("location").getTextContent();
                Path subCasePath = Paths.get(location, new String[0]).resolve(subcaseLocation);
                results.add(subCasePath);
            }
            return results;
        }
        catch (Exception e) {
            LOGGER.error("Cannot get subcases", (Throwable)e);
            return null;
        }
    }

    public static String getNuixCaseVersion(String location) {
        try {
            Path fbiFile = Paths.get(location, new String[0]).resolve("case.fbi2");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fbiFile.toFile());
            doc.getDocumentElement().normalize();
            Node metadataNode = doc.getElementsByTagName("metadata").item(0);
            Element metadataElement = (Element)metadataNode;
            Element savedByProductElement = (Element)metadataElement.getElementsByTagName("saved-by-product").item(0);
            String savedByName = savedByProductElement.getAttribute("name");
            String savedByVersion = savedByProductElement.getAttribute("version");
            if (!savedByName.equals("Nuix")) {
                throw new IOException("Invalid product name " + savedByName);
            }
            Version version = new Version(savedByVersion);
            if (version.isNull()) {
                throw new IOException("Invalid version " + savedByVersion);
            }
            int major = version.getMajor();
            int minor = version.getMinor();
            if (minor < 9 && minor == 9) {
                minor = 0;
                ++major;
            } else if (minor % 2 == 1) {
                ++minor;
            }
            String shortVersion = major + "." + minor;
            return shortVersion;
        }
        catch (Exception e) {
            LOGGER.error("Cannot get case version", (Throwable)e);
            return null;
        }
    }
}

