/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.google.gson.Gson;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Format;
import jakarta.xml.bind.annotation.adapters.HexBinaryAdapter;
import java.lang.invoke.CallSite;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import nuix.Licence;
import org.apache.commons.lang3.StringUtils;

public class NuixLicenceUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixLicenceUtils.class);

    public static Set<String> getLicenceFingerprint(Licence licence) {
        HashSet<String> fingerprints = new HashSet<String>();
        HashSet<String> whitelistedProperties = new HashSet<String>();
        whitelistedProperties.add("deadline");
        whitelistedProperties.add("created-at");
        whitelistedProperties.add("profile");
        whitelistedProperties.add("owner");
        whitelistedProperties.add("source.name");
        whitelistedProperties.add("source.location.srv");
        whitelistedProperties.add("source.location.auth");
        String fingerPrint1 = NuixLicenceUtils.getLicenceFingerprint(licence, whitelistedProperties);
        fingerprints.add(fingerPrint1);
        Map<String, String> idOwner = NuixLicenceUtils.getLicenseIdAndOwner(licence);
        String id = idOwner.get("nuixLicenseId");
        if (id != null) {
            String[] splits = id.split("@");
            fingerprints.add(splits[splits.length - 1]);
        }
        return fingerprints;
    }

    public static String getLicenceFingerprint(Licence licence, Set<String> whitelistedProperties) {
        String fingerprint = null;
        String licenceDetails = NuixLicenceUtils.getLicenceDetails(licence, whitelistedProperties, Format.TEXT);
        if (licenceDetails == null || "n/a".equals(licenceDetails)) {
            return "n/a";
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(licenceDetails.getBytes(StandardCharsets.UTF_8));
            fingerprint = new HexBinaryAdapter().marshal(messageDigest.digest());
            fingerprint = fingerprint.toLowerCase().substring(0, 8);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Cannot get fingerprint", (Throwable)e);
        }
        return fingerprint;
    }

    public static Map<String, String> getLicenseIdAndOwner(Licence licence) {
        HashMap<String, String> result = new HashMap<String, String>();
        String id = "id";
        String owner = "owner";
        HashSet<String> propertiesList = new HashSet<String>();
        propertiesList.add(id);
        propertiesList.add(owner);
        try {
            String licenseDetails = NuixLicenceUtils.getLicenceDetails(licence, null, Format.JSON);
            if (licenseDetails != null && !"n/a".equals(licenseDetails)) {
                Object nuixLicenseOwner;
                LOGGER.info("License details: " + licenseDetails);
                Map licenseDetailsProperties = (Map)SerializationUtils.fromJson((String)licenseDetails, Map.class);
                Object nuixLicenseId = licenseDetailsProperties.get(id);
                if (nuixLicenseId != null) {
                    String nuixLicenseIdString = nuixLicenseId.toString();
                    String[] splits = nuixLicenseIdString.split("@");
                    if (splits.length == 2 && splits[1].startsWith("NX")) {
                        result.put("nuixLicenseId", splits[1]);
                    } else {
                        result.put("nuixLicenseId", nuixLicenseIdString);
                    }
                }
                if ((nuixLicenseOwner = licenseDetailsProperties.get(owner)) != null) {
                    result.put("nuixLicenseOwner", nuixLicenseOwner.toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get Engine License ID", (Throwable)e);
        }
        LOGGER.info("License ID and Owner: " + SerializationUtils.toJson(result));
        return result;
    }

    public static String getLicenceDetails(Licence licence, Format format) {
        return NuixLicenceUtils.getLicenceDetails(licence, null, format);
    }

    public static String getLicenceDetails(Licence licence, Set<String> whitelistedProperties, Format format) {
        if (licence == null) {
            return "n/a";
        }
        LOGGER.info("Getting fingerprint for licence " + licence.toString());
        String licenceDetails = NuixLicenceUtils.logObjectReflectionInfo("", licence, licence.getClass(), ObjectType.LICENCE, whitelistedProperties, false, format);
        if (licenceDetails == null) {
            licenceDetails = NuixLicenceUtils.logObjectReflectionInfo("", licence, licence.getClass(), ObjectType.LICENCE_IMPLEMENTATION, whitelistedProperties, false, format);
        }
        if (licenceDetails == null) {
            licenceDetails = "n/a";
        }
        return licenceDetails;
    }

    /*
     * WARNING - void declaration
     */
    private static String logObjectReflectionInfo(String prefix, Object o, Class c, ObjectType objectType, Set<String> whitelistedProperties, boolean logEnabled, Format format) {
        String result;
        Class superClass;
        AccessibleObject method;
        AccessibleObject[] methods;
        String result2;
        String fieldValue;
        Field[] fields;
        int n;
        int n2;
        AccessibleObject[] accessibleObjectArray;
        if (logEnabled) {
            LOGGER.info(prefix + "==== Inspection " + String.valueOf((Object)objectType) + "\t" + c.toString() + " " + o.toString());
        }
        if (objectType == ObjectType.LICENCE) {
            Method[] methods2 = c.getDeclaredMethods();
            accessibleObjectArray = methods2;
            n2 = accessibleObjectArray.length;
            for (n = 0; n < n2; ++n) {
                AccessibleObject accessibleObject = accessibleObjectArray[n];
                if (logEnabled) {
                    LOGGER.info(prefix + "Method: " + ((Method)accessibleObject).getName() + "\t" + String.valueOf(((Method)accessibleObject).getReturnType()) + "\t" + ((Method)accessibleObject).toString());
                }
                if (!((Method)accessibleObject).getName().equals("getInvocationHandler")) continue;
                try {
                    if (logEnabled) {
                        LOGGER.info(prefix + "Attempting to get invocation handler");
                    }
                    Object invocationHandlerO = ((Method)accessibleObject).invoke(o, o);
                    InvocationHandler invocationHandler = (InvocationHandler)invocationHandlerO;
                    String result22 = NuixLicenceUtils.logObjectReflectionInfo(prefix + "\t", invocationHandlerO, invocationHandlerO.getClass(), ObjectType.INVOCATION_HANDLER, whitelistedProperties, logEnabled, format);
                    if (result22 != null) {
                        return result22;
                    }
                    continue;
                }
                catch (Exception e) {
                    if (!logEnabled) continue;
                    LOGGER.info(prefix + " Cannot invoke method, " + e.getMessage());
                }
            }
        }
        if (objectType == ObjectType.INVOCATION_HANDLER) {
            fields = c.getDeclaredFields();
            accessibleObjectArray = fields;
            n2 = accessibleObjectArray.length;
            for (n = 0; n < n2; ++n) {
                AccessibleObject accessibleObject;
                block41: {
                    accessibleObject = accessibleObjectArray[n];
                    ((Field)accessibleObject).setAccessible(true);
                    fieldValue = "n/a";
                    try {
                        if (((Field)accessibleObject).get(o) == null) continue;
                        fieldValue = ((Field)accessibleObject).get(o).toString();
                    }
                    catch (IllegalAccessException e) {
                        if (!logEnabled) break block41;
                        LOGGER.info(prefix + " Cannot get field value, " + e.getMessage());
                    }
                }
                if (logEnabled) {
                    LOGGER.info(prefix + "Field: " + ((Field)accessibleObject).getName() + "\t" + String.valueOf(((Field)accessibleObject).getType()) + "\t" + fieldValue);
                }
                if (!fieldValue.contains("shortName=")) continue;
                try {
                    Object licenceImplementation = ((Field)accessibleObject).get(o);
                    result2 = NuixLicenceUtils.logObjectReflectionInfo(prefix + "\t", licenceImplementation, licenceImplementation.getClass(), ObjectType.LICENCE_IMPLEMENTATION, whitelistedProperties, logEnabled, format);
                    if (result2 == null) continue;
                    return result2;
                }
                catch (Exception e) {
                    if (!logEnabled) continue;
                    LOGGER.info(prefix + " Cannot case field value, " + e.getMessage());
                }
            }
        }
        if (objectType == ObjectType.LICENCE_IMPLEMENTATION) {
            void var11_20;
            fields = c.getDeclaredFields();
            for (AccessibleObject accessibleObject : fields) {
                block42: {
                    ((Field)accessibleObject).setAccessible(true);
                    fieldValue = "n/a";
                    try {
                        if (((Field)accessibleObject).get(o) == null) continue;
                        fieldValue = ((Field)accessibleObject).get(o).toString();
                    }
                    catch (IllegalAccessException e) {
                        if (!logEnabled) break block42;
                        LOGGER.info(prefix + " Cannot get field value, " + e.getMessage());
                    }
                }
                if (logEnabled) {
                    LOGGER.info(prefix + "Field: " + ((Field)accessibleObject).getName() + "\t" + String.valueOf(((Field)accessibleObject).getType()) + "\t" + fieldValue);
                }
                if (!((Field)accessibleObject).getType().toString().contains("product")) continue;
                try {
                    Object licenceProduct = ((Field)accessibleObject).get(o);
                    result2 = NuixLicenceUtils.logObjectReflectionInfo(prefix + "\t", licenceProduct, licenceProduct.getClass(), ObjectType.PRODUCT, whitelistedProperties, logEnabled, format);
                    if (result2 == null) continue;
                    return result2;
                }
                catch (Exception e) {
                    if (!logEnabled) continue;
                    LOGGER.info(prefix + " Cannot case field value, " + String.valueOf(e));
                }
            }
            AccessibleObject[] accessibleObjectArray2 = methods = c.getDeclaredMethods();
            n = accessibleObjectArray2.length;
            boolean bl = false;
            while (var11_20 < n) {
                method = accessibleObjectArray2[var11_20];
                if (logEnabled) {
                    LOGGER.info(prefix + "Method: " + ((Method)method).getName() + "\t" + String.valueOf(((Method)method).getReturnType()) + "\t" + ((Method)method).toString());
                }
                ++var11_20;
            }
        }
        if (objectType == ObjectType.PRODUCT) {
            void var11_23;
            fields = c.getDeclaredFields();
            methods = fields;
            int n3 = methods.length;
            for (n = 0; n < n3; ++n) {
                AccessibleObject accessibleObject;
                block43: {
                    accessibleObject = methods[n];
                    ((Field)accessibleObject).setAccessible(true);
                    fieldValue = "n/a";
                    try {
                        if (((Field)accessibleObject).get(o) == null) continue;
                        fieldValue = ((Field)accessibleObject).get(o).toString();
                    }
                    catch (IllegalAccessException e) {
                        if (!logEnabled) break block43;
                        LOGGER.info(prefix + " Cannot get field value, " + e.getMessage());
                    }
                }
                if (logEnabled) {
                    LOGGER.info(prefix + "Field: " + ((Field)accessibleObject).getName() + "\t" + String.valueOf(((Field)accessibleObject).getType()) + "\t" + fieldValue);
                }
                if (!((Field)accessibleObject).getType().toString().contains("java.util.Properties")) continue;
                try {
                    Properties licenceProperties = (Properties)((Field)accessibleObject).get(o);
                    if (!licenceProperties.stringPropertyNames().contains("id") || !licenceProperties.stringPropertyNames().contains("deadline") && !licenceProperties.stringPropertyNames().contains("created-at") && !licenceProperties.stringPropertyNames().contains("profile") && !licenceProperties.stringPropertyNames().contains("max-version-family")) continue;
                    TreeSet<CallSite> flattenedProperties = new TreeSet<CallSite>();
                    TreeSet keyProperties = new TreeSet();
                    switch (format) {
                        case TEXT: {
                            for (String propertyName : licenceProperties.stringPropertyNames()) {
                                String propertyValue = null;
                                if (whitelistedProperties == null || whitelistedProperties.contains(propertyName)) {
                                    propertyValue = licenceProperties.get(propertyName).toString();
                                }
                                if (propertyName.equals("id")) {
                                    propertyValue = licenceProperties.get(propertyName).toString();
                                    String[] splits = propertyValue.split("@");
                                    propertyValue = splits[splits.length - 1];
                                }
                                if (propertyName.startsWith("source.location")) {
                                    propertyValue = StringUtils.strip((String)propertyValue, (String)"/");
                                }
                                if (propertyValue == null) continue;
                                flattenedProperties.add((CallSite)((Object)(propertyName + "=" + propertyValue)));
                            }
                            return String.join((CharSequence)", ", flattenedProperties);
                        }
                    }
                    Gson gson = new Gson();
                    return gson.toJson((Object)licenceProperties);
                }
                catch (IllegalAccessException e) {
                    if (!logEnabled) continue;
                    LOGGER.info(prefix + " Cannot get field value, " + e.getMessage());
                }
            }
            AccessibleObject[] accessibleObjectArray2 = methods = c.getDeclaredMethods();
            n = accessibleObjectArray2.length;
            boolean bl = false;
            while (var11_23 < n) {
                method = accessibleObjectArray2[var11_23];
                if (logEnabled) {
                    LOGGER.info(prefix + "Method: " + ((Method)method).getName() + "\t" + String.valueOf(((Method)method).getReturnType()) + "\t" + ((Method)method).toString());
                }
                ++var11_23;
            }
        }
        if ((superClass = c.getSuperclass()) != null && superClass != c && (result = NuixLicenceUtils.logObjectReflectionInfo(prefix, o, superClass, objectType, whitelistedProperties, logEnabled, format)) != null) {
            return result;
        }
        return null;
    }

    static enum ObjectType {
        LICENCE,
        INVOCATION_HANDLER,
        LICENCE_IMPLEMENTATION,
        PRODUCT;

    }
}

