/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureNuixOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.configuration.ParallelProcessingSettingsSource;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import nuix.AddedWorkers;
import nuix.LicenceException;
import nuix.ParallelProcessingConfigurable;
import nuix.ProcessingJob;
import nuix.profile.ProcessingProfile;

public class NuixWorkerUtils {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixWorkerUtils.class);
    protected static transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");

    private static Map<String, Object> getProcessingProfileParallelProcessingSettings(ExecutionContext executionContext, String processingProfileName) {
        ProcessingProfile existingProfile = NuixUtils.getProcessingProfile(executionContext.nuixCase, executionContext.nuixUtilities, processingProfileName);
        if (existingProfile != null) {
            return existingProfile.getParallelProcessingSettings();
        }
        return null;
    }

    private static ConfigureNuixOperation getLastRanConfigureNuixOperation(ExecutionContext executionContext, Operation currentOperation) {
        ConfigureNuixOperation previousConfigureNuixOperation = null;
        if (executionContext != null && executionContext.workflowExecution != null) {
            for (int i = 0; i < executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
                Operation operation = executionContext.workflowExecution.getWorkflow().getOperations().get(i);
                if (operation instanceof ConfigureNuixOperation) {
                    previousConfigureNuixOperation = (ConfigureNuixOperation)operation;
                }
                if (i == currentOperation.executionPosition) break;
            }
        }
        return previousConfigureNuixOperation;
    }

    public static void verifyWorkerSettings(ExecutionContext executionContext, Operation currentOperation) {
        ConfigureNuixOperation previousConfigureNuixOperation = NuixWorkerUtils.getLastRanConfigureNuixOperation(executionContext, currentOperation);
        if (previousConfigureNuixOperation == null) {
            Map<String, Object> processingProfileParallelSettings = NuixWorkerUtils.getProcessingProfileParallelProcessingSettings(executionContext, "Default");
            currentOperation.addExecutionLog(iu.getString("NuixWorkerUtils.NoConfigureNuix"));
            if (processingProfileParallelSettings == null) {
                currentOperation.addWarning(iu.getString("NuixWorkerUtils.InvalidProcessingProfile"));
                return;
            }
            executionContext.getExecutionBuiltInParameters().put(currentOperation.trackParameter((Parameter)new StaticParameter("{wfn_processing_profile_name}", "Default")));
        }
    }

    public static void setWorkerSettings(ExecutionContext executionContext, Operation currentOperation, ParallelProcessingConfigurable processor, boolean logAdditionalInfo) throws Exception {
        Boolean runLocalWorkers;
        ConfigureNuixOperation previousConfigureNuixOperation = NuixWorkerUtils.getLastRanConfigureNuixOperation(executionContext, currentOperation);
        boolean applyProcessingProfileSettings = NuixWorkerUtils.shouldApplyProcessingProfileWorkerSettings(executionContext, currentOperation, previousConfigureNuixOperation);
        String processingProfileName = "Default";
        if (applyProcessingProfileSettings) {
            String evaluatedProcessingProfileName = executionContext.evalParameters("{wfn_processing_profile_name}", currentOperation);
            if (!evaluatedProcessingProfileName.equalsIgnoreCase("{wfn_processing_profile_name}")) {
                processingProfileName = evaluatedProcessingProfileName;
            }
            LOGGER.info("Settings worker settings from processing profile " + processingProfileName);
            if (previousConfigureNuixOperation == null) {
                currentOperation.addExecutionLog(iu.getString("NuixWorkerUtils.NoConfigureNuix"));
            } else {
                currentOperation.addExecutionLog(iu.getFormattedString("NuixWorkerUtils.MissingWorkerBasedSettings", (Object)processingProfileName));
            }
            Map<String, Object> profileParallelSettings = NuixWorkerUtils.getProcessingProfileParallelProcessingSettings(executionContext, processingProfileName);
            if (profileParallelSettings == null) {
                LOGGER.error("Failed to set parallel processing settings from processing profile " + processingProfileName + " processing profile does not exist or has null settings");
                currentOperation.addWarning(iu.getFormattedString("NuixWorkerUtils.CannotSetParallelProcessingSettingsFromProfile", (Object)processingProfileName));
            } else {
                try {
                    Integer localWorkerCount = (Integer)profileParallelSettings.get("workerCount");
                    if (localWorkerCount != null && localWorkerCount >= 1 && !profileParallelSettings.containsKey("runLocalWorkers")) {
                        profileParallelSettings.put("runLocalWorkers", true);
                    }
                    processor.setParallelProcessingSettings(profileParallelSettings);
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to apply settings from processing profile " + processingProfileName, t);
                    currentOperation.addWarning(iu.getFormattedString("NuixWorkerUtils.CannotApplyParallelProcessingSettingsFromProfile", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)t)));
                }
            }
        }
        if (executionContext.workflowParallelSettings) {
            LOGGER.info("Setting workflow-defined parallel settings");
            Map parallelSettings = processor.getParallelProcessingSettings();
            if (executionContext.workflowLocalWorkersCount == 0) {
                LOGGER.info("Setting runLocalWorkers to false");
                parallelSettings.put("runLocalWorkers", false);
                if (logAdditionalInfo) {
                    currentOperation.addWarning(iu.getString("NuixWorkerUtils.OperationMustUseAtLeastLocalWorker"));
                }
                parallelSettings.put("workerCount", 1);
            } else {
                LOGGER.info("Setting runLocalWorkers to true");
                parallelSettings.put("runLocalWorkers", true);
                parallelSettings.put("workerCount", Math.min(executionContext.nuixUtilities.getLicence().getWorkers(), executionContext.workflowLocalWorkersCount));
            }
            try {
                Files.createDirectories(Paths.get(executionContext.workflowLocalWorkersTempFolder, new String[0]), new FileAttribute[0]);
            }
            catch (Throwable t) {
                throw new Exception(iu.getString("NuixWorkerUtils.InvalidWorkerTempFolder"), t);
            }
            parallelSettings.put("workerTemp", executionContext.workflowLocalWorkersTempFolder);
            parallelSettings.put("workerMemory", executionContext.workflowLocalWorkersMemoryMb);
            if (executionContext.workflowBrokerWorkersCount > 0) {
                parallelSettings.put("workerBrokerAddress", executionContext.workflowBrokerIp + ":" + executionContext.workflowBrokerPort);
            }
            try {
                processor.setParallelProcessingSettings(parallelSettings);
            }
            catch (Throwable t) {
                throw new Exception(iu.getString("NuixWorkerUtils.CannotSetParallelProcessingSettings"), t);
            }
        }
        if (Objects.equals(processor.getParallelProcessingSettings().get("runLocalWorkers"), false)) {
            if (logAdditionalInfo) {
                currentOperation.addWarning(iu.getString("NuixWorkerUtils.NuixProfileSelectedWasConfiguredWithNoLocalWorkers"));
            }
            executionContext.workflowBrokerWorkersCount = 2;
            executionContext.workflowParallelSettings = true;
        }
        if ((runLocalWorkers = (Boolean)processor.getParallelProcessingSettings().get("runLocalWorkers")) == null) {
            processor.getParallelProcessingSettings().put("runLocalWorkers", true);
            processor.getParallelProcessingSettings().put("workerCount", executionContext.nuixUtilities.getLicence().getWorkers());
            runLocalWorkers = true;
        }
        if (runLocalWorkers.booleanValue()) {
            Integer configurationWorkerCount = (Integer)processor.getParallelProcessingSettings().get("workerCount");
            if (configurationWorkerCount != null && logAdditionalInfo) {
                currentOperation.addExecutionLog(iu.getFormattedString("NuixWorkerUtils.LocalWorkers", (Object)Math.min(executionContext.nuixUtilities.getLicence().getWorkers(), configurationWorkerCount)));
            }
            Object workerTemp = processor.getParallelProcessingSettings().get("workerTemp");
            String commandLineWorkerTemp = System.getProperty("nuix.worker.tmpdir");
            if (commandLineWorkerTemp != null) {
                LOGGER.warn("Setting worker temp from command line");
                processor.getParallelProcessingSettings().put("workerTemp", commandLineWorkerTemp);
                workerTemp = commandLineWorkerTemp;
            }
            if (workerTemp != null) {
                currentOperation.addExecutionLog(iu.getFormattedString("NuixWorkerUtils.WorkerTemp", workerTemp));
            } else {
                currentOperation.addExecutionLog(iu.getString("NuixWorkerUtils.InvalidWorkerTempFolder"));
            }
        }
        if (executionContext.jobBrokerIp != null) {
            if (logAdditionalInfo) {
                currentOperation.addExecutionLog(iu.getFormattedString("General.Log.JobRemoteBroker", (Object)(executionContext.jobBrokerIp + ":" + executionContext.jobBrokerPort)));
            }
            processor.getParallelProcessingSettings().put("workerBrokerAddress", executionContext.jobBrokerIp + ":" + executionContext.jobBrokerPort);
        }
    }

    public static Integer getProcessorWorkerMemory(ParallelProcessingConfigurable processor) {
        try {
            return Integer.parseInt(String.valueOf(processor.getParallelProcessingSettings().get("workerMemory")));
        }
        catch (Exception e) {
            LOGGER.warn("Unable to get memory settings from processor", (Throwable)e);
            return null;
        }
    }

    public static void addRemoteWorkers(ExecutionContext executionContext, Operation operation, ProcessingJob processor, AtomicInteger fulfilledWorkerCount) throws Exception {
        int workersPendingCount = executionContext.workflowBrokerWorkersCount;
        int failedAttemptsToAddWorkers = 0;
        if (executionContext.jobBrokerIp != null && executionContext.workflowBrokerWorkersCount > 0) {
            while (workersPendingCount > 0) {
                try {
                    if (processor == null || processor.hasFinished() || operation.getStopRequested()) break;
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException(iu.getString("OcrOperation.Exception.Aborting"));
                    }
                    AddedWorkers addedWorkers = processor.addWorkers(workersPendingCount);
                    InetAddress addedWorkersAddress = addedWorkers.getAddress();
                    int addedWorkersCount = addedWorkers.getCount();
                    fulfilledWorkerCount.addAndGet(addedWorkersCount);
                    if (addedWorkersCount > 0) {
                        if (addedWorkersAddress != null) {
                            operation.addExecutionLog(iu.getFormattedString("General.Log.RemoteWorkers", new Object[]{addedWorkersCount, addedWorkersAddress.toString()}));
                        }
                        NuixWorkerUtils.resetCurrentWorkerDelay(operation);
                        workersPendingCount -= addedWorkers.getCount();
                    } else {
                        if (++failedAttemptsToAddWorkers == 10) {
                            int countAvailable = executionContext.workflowBrokerWorkersCount - workersPendingCount;
                            Object countAvailableRendering = countAvailable == 0 ? "none" : (countAvailable == 1 ? "only 1" : "only " + countAvailable);
                            LOGGER.warn(iu.getFormattedString("ExportItemsOperation.Warning.AttemptedToStartInitially", new Object[]{executionContext.workflowBrokerWorkersCount, countAvailableRendering}));
                        }
                        NuixWorkerUtils.increaseCurrentWorkerDelay(operation);
                    }
                    LOGGER.info(workersPendingCount + " remote workers remain to be added");
                }
                catch (LicenceException e) {
                    NuixWorkerUtils.increaseCurrentWorkerDelay(operation);
                    Thread.sleep(operation.currentRemoteWorkerDelay);
                }
                catch (InterruptedException e) {
                    LOGGER.info("Interrupted ", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    if (ExceptionUtils.isCausedByInterrupt((Throwable)e)) continue;
                    LOGGER.warn("Cannot add remote workers", (Throwable)e);
                    NuixWorkerUtils.increaseCurrentWorkerDelay(operation);
                    Thread.sleep(operation.currentRemoteWorkerDelay);
                }
            }
        }
    }

    private static void increaseCurrentWorkerDelay(Operation operation) {
        long previousRemoteWorkerDelay = operation.currentRemoteWorkerDelay;
        operation.currentRemoteWorkerDelay = Math.min(operation.currentRemoteWorkerDelay * 2L, 10000L);
        if (previousRemoteWorkerDelay != operation.currentRemoteWorkerDelay) {
            LOGGER.info("Increasing remote worker delay to " + operation.currentRemoteWorkerDelay);
        }
    }

    private static void resetCurrentWorkerDelay(Operation operation) {
        LOGGER.info("Resetting remote worker delay");
        operation.currentRemoteWorkerDelay = 5000L;
    }

    private static boolean shouldApplyProcessingProfileWorkerSettings(ExecutionContext executionContext, Operation currentOperation, ConfigureNuixOperation previousConfigureNuixOperation) throws ParameterException {
        if (previousConfigureNuixOperation != null) {
            boolean configurationProfileSet = executionContext.evalParameters("{wfn_use_configuration_profile}", currentOperation).equalsIgnoreCase("true");
            boolean profileWorkerConfigurationSource = previousConfigureNuixOperation.parallelProcessingSettingsSource == ParallelProcessingSettingsSource.PROFILE;
            int localWorkerCount = -1;
            try {
                localWorkerCount = Integer.parseInt(executionContext.evalParameters("{local_worker_count}", currentOperation));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int localWorkerMemory = -1;
            try {
                localWorkerMemory = Integer.parseInt(executionContext.evalParameters("{local_worker_memory}", currentOperation));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return !configurationProfileSet && profileWorkerConfigurationSource && localWorkerCount == -1 && localWorkerMemory == -1;
        }
        return true;
    }
}

