/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.ocr;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.MimeTypeUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.genAi.openAi.DataElement;
import com.nuix.automate.workflow.core.utils.ocr.GenAiConsumption;
import com.nuix.automate.workflow.core.utils.ocr.OcrResult;
import com.nuix.automate.workflow.core.utils.ocr.OcrStatus;
import com.nuix.automate.workflow.core.utils.ocr.OcrUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;

public class GenAiOcrUtils
extends OcrUtils {
    private String contextPrompt;
    private String transcriptionPrompt;
    private GenAiHelper genAiHelper;
    private boolean temperatureEnabled;
    private double temperature;
    private boolean maxTokensEnabled;
    private int maxTokens;

    public GenAiOcrUtils(ExecutionContext executionContext, Operation operation, Path defaultTempFolder, String contextPrompt, String transcriptionPrompt, GenAiHelper genAiHelper, boolean temperatureEnabled, double temperature, boolean maxTokensEnabled, int maxTokens) throws IOException {
        super(executionContext, operation, defaultTempFolder, new GenAiConsumption(null, null));
        this.contextPrompt = contextPrompt;
        this.transcriptionPrompt = transcriptionPrompt;
        this.genAiHelper = genAiHelper;
        this.temperatureEnabled = temperatureEnabled;
        this.temperature = temperature;
        this.maxTokensEnabled = maxTokensEnabled;
        this.maxTokens = maxTokens;
    }

    @Override
    public void test() throws IOException {
    }

    @Override
    protected Path autoRotateImage(Path image, Path sourceImagePath, Path tempFolder, Path destinationText, BufferedImage sourceImageContent, int rasterizeDpi, long startEpoch, double totalAngle, String label) {
        return image;
    }

    @Override
    protected OcrResult ocrImageFile(long startEpoch, Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Integer expectedPages, Path tempPath, AtomicLong pagesProcessed) {
        GenAiConsumption consumption = new GenAiConsumption(null, null);
        try {
            byte[] imageBytes = Files.readAllBytes(sourceImage);
            String imageBase64 = Base64.getEncoder().encodeToString(imageBytes);
            ArrayList<GenAiMessage> messages = new ArrayList<GenAiMessage>();
            if (this.contextPrompt != null && this.contextPrompt.length() > 0) {
                messages.add(new GenAiMessage("system", this.contextPrompt));
            }
            String fileExtension = FileUtils.getFileExtension((String)sourceImage.getFileName().toString()).toLowerCase();
            String mimeType = MimeTypeUtils.getInstance().getMimeType(fileExtension);
            ArrayList<DataElement> images = new ArrayList<DataElement>();
            images.add(new DataElement(mimeType, imageBase64));
            messages.add(new GenAiMessage("user", this.transcriptionPrompt, images));
            String id = UidUtils.fromString((String)(sourceImage.toAbsolutePath().toString() + String.valueOf(DateTime.now())));
            GenAiRequest request = new GenAiRequest(id, messages);
            if (this.temperatureEnabled) {
                request.setTemperature(this.temperature);
            }
            if (this.maxTokensEnabled) {
                request.setMaxResponseTokens(this.maxTokens);
            }
            GenAiResponse response = this.genAiHelper.getCompletions(request);
            String text = response.getMessage().getContent();
            consumption = new GenAiConsumption(response.getUsage().getPromptTokens(), response.getUsage().getCompletionTokens());
            if (text == null) {
                return new OcrResult("", consumption, OcrStatus.UNSUPPORTED, 1);
            }
            Path destinationTextWithExtension = Paths.get(String.valueOf(destinationText.toAbsolutePath()) + ".txt", new String[0]);
            if (!Files.exists(destinationTextWithExtension.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(destinationTextWithExtension.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to create directory for destination text file: " + String.valueOf(destinationTextWithExtension.getParent()), (Throwable)e);
                }
            }
            OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(destinationTextWithExtension, new OpenOption[0]), StandardCharsets.UTF_8);
            writer.write(text);
            ((Writer)writer).close();
            return new OcrResult("", consumption, OcrStatus.SUCCESS, 1);
        }
        catch (IOException e) {
            return new OcrResult(ExceptionUtils.getExceptionPrintableMessage((Throwable)e), consumption, OcrStatus.FAILED, 1);
        }
    }
}

