/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.ocr;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ImageUtil {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ImageUtil.class);

    public static boolean isBlack(BufferedImage image, int x, int y) {
        if (image.getType() == 12) {
            WritableRaster raster = image.getRaster();
            int pixelRGBValue = raster.getSample(x, y, 0);
            return pixelRGBValue == 0;
        }
        int luminanceValue = 140;
        return ImageUtil.isBlack(image, x, y, luminanceValue);
    }

    public static boolean isBlack(BufferedImage image, int x, int y, int luminanceCutOff) {
        double luminance = 0.0;
        if (x < 0 || y < 0 || x > image.getWidth() || y > image.getHeight()) {
            return false;
        }
        try {
            int pixelRGBValue = image.getRGB(x, y);
            int r = pixelRGBValue >> 16 & 0xFF;
            int g = pixelRGBValue >> 8 & 0xFF;
            int b = pixelRGBValue & 0xFF;
            luminance = (double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114;
        }
        catch (Exception e) {
            LOGGER.warn("Cannot detect if image is black", (Throwable)e);
        }
        return luminance < (double)luminanceCutOff;
    }

    public static BufferedImage rotate(BufferedImage image, double angle, int cx, int cy) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int maxY = 0;
        int maxX = 0;
        int minY = 0;
        int minX = 0;
        int[] corners = new int[]{0, 0, width, 0, width, height, 0, height};
        double theta = Math.toRadians(angle);
        for (int i = 0; i < corners.length; i += 2) {
            int x = (int)(Math.cos(theta) * (double)(corners[i] - cx) - Math.sin(theta) * (double)(corners[i + 1] - cy) + (double)cx);
            int y = (int)(Math.sin(theta) * (double)(corners[i] - cx) + Math.cos(theta) * (double)(corners[i + 1] - cy) + (double)cy);
            if (x > maxX) {
                maxX = x;
            }
            if (x < minX) {
                minX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (y >= minY) continue;
            minY = y;
        }
        cx -= minX;
        cy -= minY;
        BufferedImage bi = new BufferedImage(maxX - minX, maxY - minY, image.getType());
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setBackground(Color.white);
        g2.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        AffineTransform at = new AffineTransform();
        at.rotate(theta, cx, cy);
        g2.setTransform(at);
        g2.drawImage((Image)image, -minX, -minY, null);
        g2.dispose();
        return bi;
    }

    public static BufferedImage convertToBufferedImage(Image image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return newImage;
    }
}

