/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.relativity;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.RelativityService;
import com.nuix.automate.utils.models.api.thirdparty.RelativityUserCredential;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.IndexBuildProgress;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityDtSearchIndexAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityScriptParameter;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.objectmanager.ObjectManagerQueryRequest;
import com.nuix.automate.workflow.core.execution.options.relativityscript.RelativityScriptDetails;
import com.nuix.automate.workflow.core.execution.options.relativityscript.RelativityScriptExportType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityRestV1Client;
import jakarta.ws.rs.core.GenericType;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Relativity11RestV1Client
extends RelativityRestV1Client {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Relativity11RestV1Client.class);

    protected Relativity11RestV1Client(RelativityService relativityService, RelativityUserCredential userCredential, String clientName, LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(relativityService, userCredential, clientName, logChannel, whitelistedCertFingerprints);
    }

    @Override
    protected Set<RelativityFieldObject> queryObjectFields(long objectArtifactTypeId, Long workspaceArtifactId) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap<String, Cloneable> request = new HashMap<String, Cloneable>();
        payload.put("request", request);
        HashMap<String, Long> objectType = new HashMap<String, Long>();
        request.put("ObjectType", objectType);
        objectType.put("ArtifactTypeID", objectArtifactTypeId);
        ArrayList fields = new ArrayList();
        request.put("Fields", fields);
        HashMap<String, String> field = new HashMap<String, String>();
        fields.add(field);
        field.put("Name", "*");
        request.put("Condition", null);
        payload.put("start", Integer.valueOf(1));
        payload.put("length", Integer.valueOf(1));
        Object workspaceArtifactIdString = workspaceArtifactId == null ? "-1" : "" + workspaceArtifactId;
        String response = this.callApi("/Relativity.REST/api/Relativity.Objects/workspace/" + (String)workspaceArtifactIdString + "/object/query", "POST", payload, new GenericType<String>(){});
        HashSet<RelativityFieldObject> relativityFields = new HashSet<RelativityFieldObject>();
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonArray array = object.getAsJsonArray("Objects").get(0).getAsJsonObject().getAsJsonArray("FieldValues");
        array.forEach(item -> {
            JsonObject itemObject = item.getAsJsonObject();
            RelativityFieldObject itemField = (RelativityFieldObject)this.gson.fromJson(itemObject.getAsJsonObject("Field").toString(), RelativityFieldObject.class);
            relativityFields.add(itemField);
        });
        return relativityFields;
    }

    @Override
    protected String queryObjectManager(long objectArtifactTypeId, Long workspaceArtifactId, String condition, int start, int length, List<String> fieldNames) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap<String, Object> request = new HashMap<String, Object>();
        payload.put("request", request);
        HashMap<String, Long> objectType = new HashMap<String, Long>();
        request.put("ObjectType", objectType);
        objectType.put("ArtifactTypeID", objectArtifactTypeId);
        ArrayList<Object> fields = new ArrayList<Object>();
        request.put("Fields", fields);
        if (fieldNames == null) {
            fields.add(this.addField("Name"));
        } else {
            for (String field : fieldNames) {
                fields.add(this.addField(field));
            }
        }
        request.put("Condition", null);
        if (condition != null) {
            request.put("Condition", condition);
        }
        payload.put("start", Integer.valueOf(start));
        payload.put("length", Integer.valueOf(length));
        Object workspaceArtifactIdString = workspaceArtifactId == null ? "-1" : "" + workspaceArtifactId;
        return this.callApi("/Relativity.REST/api/Relativity.Objects/workspace/" + (String)workspaceArtifactIdString + "/object/query", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public String queryObjectManager(ObjectManagerQueryRequest request) throws IOException {
        String workspaceArtifactIdString = request.getRequest().getWorkspaceArtifactId() == null ? "-1" : "" + request.getRequest().getWorkspaceArtifactId();
        return this.callApi("/Relativity.REST/api/Relativity.Objects/workspace/" + workspaceArtifactIdString + "/object/query", "POST", request, new GenericType<String>(){});
    }

    @Override
    public Long createClient(String clientName, String clientNumber, String keywords, String notes, Long statusArtifactId) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Object> clientRequest = new HashMap<String, Object>();
        payload.put("clientDTO", clientRequest);
        clientRequest.put("Name", clientName);
        clientRequest.put("Number", clientNumber);
        clientRequest.put("Keywords", keywords);
        clientRequest.put("Notes", notes);
        HashMap<String, Long> status = new HashMap<String, Long>();
        clientRequest.put("Status", status);
        status.put("ArtifactID", statusArtifactId);
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Client.IClientModule/Client%20Manager/CreateSingleAsync", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public Long createMatter(String matterName, String matterNumber, String keywords, String notes, Long clientArtifactId, Long statusArtifactId) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Object> matterRequest = new HashMap<String, Object>();
        payload.put("MatterRequest", matterRequest);
        matterRequest.put("Name", matterName);
        matterRequest.put("Number", matterNumber);
        matterRequest.put("Keywords", keywords);
        matterRequest.put("Notes", notes);
        HashMap<String, Serializable> status = new HashMap<String, Serializable>();
        matterRequest.put("Status", status);
        status.put("Secured", Boolean.valueOf(false));
        HashMap<String, Long> statusSecured = new HashMap<String, Long>();
        status.put("Value", statusSecured);
        statusSecured.put("ArtifactID", statusArtifactId);
        HashMap client = new HashMap();
        matterRequest.put("Client", client);
        HashMap<String, Long> clientSecured = new HashMap<String, Long>();
        client.put("Value", clientSecured);
        clientSecured.put("ArtifactID", clientArtifactId);
        String response = this.callApi("/Relativity.rest/api/relativity.matters/workspace/-1/matters", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public Long importLibraryScript(Long workspaceArtifactId, Long libraryScriptArtifactId, Long applicationArtifactId) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Cloneable> scriptImportRequest = new HashMap<String, Cloneable>();
        payload.put("ScriptImportRequest", scriptImportRequest);
        HashMap<String, Long> libraryScript = new HashMap<String, Long>();
        scriptImportRequest.put("LibraryScript", libraryScript);
        libraryScript.put("ArtifactID", libraryScriptArtifactId);
        scriptImportRequest.put("RelativityApplications", null);
        if (applicationArtifactId != null) {
            ArrayList applications = new ArrayList();
            HashMap<String, Long> relativityApplications = new HashMap<String, Long>();
            scriptImportRequest.put("RelativityApplications", applications);
            relativityApplications.put("ArtifactID", applicationArtifactId);
            applications.add(relativityApplications);
        }
        String response = this.callApi("/Relativity.Rest/api/Relativity.Scripts/workspace/" + workspaceArtifactId + "/scripts/import", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public void deleteScript(Long workspaceArtifactId, Long scriptArtifactId) throws IOException {
        this.callApi("/Relativity.Rest/api/Relativity.Scripts/workspace/" + workspaceArtifactId + "/scripts/" + scriptArtifactId, "DELETE", new GenericType<String>(){});
    }

    @Override
    public String queueScript(long workspaceArtifactId, long scriptId, Map<String, Object> parameters) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("Inputs", new ArrayList());
        if (parameters.size() > 0) {
            payload.put("Inputs", this.buildScriptParameters(parameters));
        }
        payload.put("TimeZoneOffset", 0);
        try {
            String response = this.callApi("/Relativity.Rest/api/Relativity.Scripts/workspace/" + workspaceArtifactId + "/scripts/" + scriptId + "/run", "POST", payload, new GenericType<String>(){});
            JsonObject responseObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            return responseObject.get("RunJobID").getAsString();
        }
        catch (IOException e) {
            String message = e.getMessage();
            CharSequence[] invalidInputs = message.split("\r\n");
            if (invalidInputs.length > 1) {
                List<RelativityScriptParameter> existingParameters = this.getRelativityScriptParameters(workspaceArtifactId, scriptId);
                for (int i = 0; i < invalidInputs.length; ++i) {
                    String invalidField = invalidInputs[i];
                    if (invalidField.startsWith("Cannot query Relativity API")) continue;
                    for (RelativityScriptParameter parameter : existingParameters) {
                        if (!invalidField.contains("'" + parameter.getIdentifier() + "'")) continue;
                        invalidInputs[i] = invalidField + " " + parameter.toDisplayValue();
                    }
                }
                message = String.join((CharSequence)"\r\n", invalidInputs);
            }
            throw new IOException(message);
        }
    }

    @Override
    public String getScriptStatus(Long workspaceArtifactId, String runJobId) throws IOException {
        String scriptDetails = this.callApi("/Relativity.Rest/api/Relativity.Scripts/workspace/" + workspaceArtifactId + "/scripts/runs/" + runJobId, "GET", new GenericType<String>(){});
        JsonObject scriptInfo = (JsonObject)this.gson.fromJson(scriptDetails, JsonObject.class);
        return scriptInfo.get("Status").getAsString();
    }

    @Override
    public RelativityScriptDetails readScriptOutput(long workspaceArtifactId, String runJobId) throws IOException {
        RelativityScriptDetails details = new RelativityScriptDetails();
        String scriptDetails = this.callApi("/Relativity.Rest/api/Relativity.Scripts/workspace/" + workspaceArtifactId + "/scripts/runs/" + runJobId, "GET", new GenericType<String>(){});
        JsonObject scriptInfo = (JsonObject)this.gson.fromJson(scriptDetails, JsonObject.class);
        details.setStatus(scriptInfo.get("Status").getAsString());
        details.setErrorMessage(scriptInfo.get("ErrorMessage").getAsString());
        return details;
    }

    @Override
    public String exportScript(long workspaceArtifactId, String runJobId, RelativityScriptExportType exportType, String exportLocation) throws IOException {
        Path exportPath = Paths.get(exportLocation, new String[0]);
        Path parentFolderPath = exportPath.getParent();
        if (!Files.exists(parentFolderPath, new LinkOption[0])) {
            Files.createDirectories(parentFolderPath, new FileAttribute[0]);
        }
        HashMap payload = new HashMap();
        HashMap<String, String> scriptRequest = new HashMap<String, String>();
        payload.put("ScriptExportRequest", scriptRequest);
        scriptRequest.put("FileType", exportType.name());
        byte[] readResponse = this.callApi("/Relativity.Rest/api/Relativity.Scripts/workspace/" + workspaceArtifactId + "/scripts/runs/" + runJobId + "/export", "POST", payload, new GenericType<byte[]>(){});
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(exportPath.toFile()));){
            outputStream.write(readResponse);
        }
        return exportPath.toAbsolutePath().toString();
    }

    @Override
    public void runDtSearchIndexAction(Long workspaceArtifactId, Long searchProviderArtifactId, RelativityDtSearchIndexAction action) throws IOException {
        String dtSearchUrlSuffix = "";
        HashMap<String, Boolean> payload = new HashMap<String, Boolean>();
        switch (action) {
            default: {
                payload.put("isActive", true);
                dtSearchUrlSuffix = "fullBuildIndex";
                break;
            }
            case INCREMENTAL: {
                payload.put("isActive", true);
                dtSearchUrlSuffix = "incrementalBuildIndex";
                break;
            }
            case ACTIVATE: {
                dtSearchUrlSuffix = "activateIndex";
                break;
            }
            case COMPRESS: {
                payload.put("isActive", true);
                dtSearchUrlSuffix = "compressIndex";
                break;
            }
            case DEACTIVATE: {
                dtSearchUrlSuffix = "deactivateIndex";
            }
        }
        String dtSearchUrl = "/Relativity.Rest/API/Relativity.Compute.DtSearchIndexes/workspace/" + workspaceArtifactId + "/dtSearchIndexes/" + searchProviderArtifactId + "/" + dtSearchUrlSuffix;
        this.callApi(dtSearchUrl, "POST", payload, new GenericType<String>(){});
    }

    @Override
    public IndexBuildProgress getIndexBuildProgress(Long workspaceArtifactId, Long searchProviderArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/API/Relativity.Compute.DtSearchIndexes/workspace/" + workspaceArtifactId + "/dtSearchIndexes/" + searchProviderArtifactId + "/indexJobProgress", "GET", new GenericType<String>(){});
        return (IndexBuildProgress)this.gson.fromJson(response, IndexBuildProgress.class);
    }

    @Override
    protected List<Object> buildScriptParameters(Map<String, Object> values) {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("ID", entry.getKey());
            parameter.put("Value", entry.getValue());
            parameterValues.add(parameter);
        }
        return parameterValues;
    }

    @Override
    protected List<RelativityScriptParameter> getRelativityScriptParameters(Long workspaceArtifactId, Long scriptArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/api/Relativity.Scripts/workspace/" + workspaceArtifactId + "/scripts/" + scriptArtifactId + "/parameters", "GET", new GenericType<String>(){});
        RelativityScriptParameter[] parameters = (RelativityScriptParameter[])this.gson.fromJson(response, RelativityScriptParameter[].class);
        List<RelativityScriptParameter> parametersList = Arrays.asList(parameters);
        return parametersList;
    }

    @Override
    public List<EligibleObject> queryEligibleStatusesClients() throws IOException {
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Client.IClientModule/Client%20Manager/GetStatusChoicesForClientAsync", "POST", new HashMap(), new GenericType<String>(){});
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        if (array.size() == 0) {
            throw new IOException("No statuses available");
        }
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        array.forEach(ele -> {
            JsonObject object = ele.getAsJsonObject();
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId(object.get("ArtifactID").getAsLong());
            eligibleObject.setName(object.get("Name").getAsString());
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleStatusesMatters() throws IOException {
        String response = this.callApi("/Relativity.rest/api/relativity.matters/workspace/-1/availablestatuses", "GET", new GenericType<String>(){});
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        if (array.size() == 0) {
            throw new IOException("No statuses available");
        }
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        array.forEach(ele -> {
            JsonObject object = ele.getAsJsonObject();
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId(object.get("ArtifactID").getAsLong());
            eligibleObject.setName(object.get("Name").getAsString());
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }
}

