/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.relativity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.thirdparty.RelativityService;
import com.nuix.automate.utils.models.api.thirdparty.RelativityUserCredential;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.RelativityCondition;
import com.nuix.automate.utils.workflow.RelativityConditionType;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.operations.RelativityView;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.AnalyticIndexRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.AssociatedResourcePoolType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.BooleanConditionOperator;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.CriteriaOperator;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.DocumentField;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.DtSearchIndex;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleSearchResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ExportMetadataType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.GenericRelativityApiCallResponse;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.GroupPermission;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ImagingJobStopResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ImagingSetStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.IndexBuildProgress;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ItemLevelPermissionInfo;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ItemLevelPermissionObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OcrSetJobResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OcrSetJobStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OcrSetStopJobResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityAnalyticIndexAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityAnalyticIndexStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityBasicUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityClientObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityDtSearchIndexAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldValue;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldValueType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityIndexType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityItemLevelSecurity;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityLoginProfile;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityMatterObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityScriptParameter;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchDetails;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchScope;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchSortField;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SearchContainer;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SearchResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SearchTermReportProgress;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SearchTermReportRunType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.Workspace;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroup;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroupPermissions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroups;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceObjectType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.ArmJobStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmArchive;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.restore.ArmRestore;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.objectmanager.ObjectManagerQuery;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.objectmanager.ObjectManagerQueryRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.CreateProductionSetRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.ProductionSetDataSource;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RelativityProductionSetProgress;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RelativityProductionSetStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RunProductionSetActionType;
import com.nuix.automate.workflow.core.execution.options.relativityscript.RelativityScriptDetails;
import com.nuix.automate.workflow.core.execution.options.relativityscript.RelativityScriptExportType;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaCollection;
import com.nuix.automate.workflow.core.utils.relativity.RelativityArtifactIdType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityClient;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import jakarta.ws.rs.core.GenericType;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class RelativityRestV1Client
extends RelativityClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityRestV1Client.class);
    private static int PAGE_SIZE = 10000;

    protected RelativityRestV1Client(RelativityService relativityService, RelativityUserCredential userCredential, String clientName, LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(relativityService, userCredential, clientName, logChannel, whitelistedCertFingerprints);
    }

    protected String getConditionFromIdentifier(RelativityIdentifierType identifierType, String identifier) {
        if (identifierType != null && identifier != null) {
            switch (identifierType) {
                case ARTIFACT_ID: {
                    return "'ArtifactId' == '" + this.encodeForQuery(identifier) + "'";
                }
                case NAME: {
                    return "'Name' == '" + this.encodeForQuery(identifier) + "'";
                }
                case NAME_LIKE: {
                    return "'Name' LIKE '" + this.encodeForQuery(identifier) + "'";
                }
            }
        }
        return null;
    }

    protected Set<RelativityFieldObject> queryObjectFields(long objectArtifactTypeId, Long workspaceArtifactId) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap<String, Cloneable> request = new HashMap<String, Cloneable>();
        payload.put("request", request);
        HashMap<String, Long> objectType = new HashMap<String, Long>();
        request.put("ObjectType", objectType);
        objectType.put("ArtifactTypeID", objectArtifactTypeId);
        ArrayList fields = new ArrayList();
        request.put("Fields", fields);
        HashMap<String, String> field = new HashMap<String, String>();
        fields.add(field);
        field.put("Name", "*");
        request.put("Condition", null);
        payload.put("start", Integer.valueOf(1));
        payload.put("length", Integer.valueOf(1));
        Object workspaceArtifactIdString = workspaceArtifactId == null ? "-1" : "" + workspaceArtifactId;
        String response = this.callApi("/Relativity.Rest/api/Relativity.ObjectManager/v1/workspace/" + (String)workspaceArtifactIdString + "/object/query", "POST", payload, new GenericType<String>(){});
        HashSet<RelativityFieldObject> relativityFields = new HashSet<RelativityFieldObject>();
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonArray array = object.getAsJsonArray("Objects").get(0).getAsJsonObject().getAsJsonArray("FieldValues");
        array.forEach(item -> {
            JsonObject itemObject = item.getAsJsonObject();
            RelativityFieldObject itemField = (RelativityFieldObject)this.gson.fromJson(itemObject.getAsJsonObject("Field").toString(), RelativityFieldObject.class);
            relativityFields.add(itemField);
        });
        return relativityFields;
    }

    protected String queryObjectManager(long objectArtifactTypeId, Long workspaceArtifactId, String condition, int start, int length, List<String> fieldNames) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap<String, Object> request = new HashMap<String, Object>();
        payload.put("request", request);
        HashMap<String, Long> objectType = new HashMap<String, Long>();
        request.put("ObjectType", objectType);
        objectType.put("ArtifactTypeID", objectArtifactTypeId);
        ArrayList<Object> fields = new ArrayList<Object>();
        request.put("Fields", fields);
        if (fieldNames == null) {
            fields.add(this.addField("Name"));
        } else {
            for (String field : fieldNames) {
                fields.add(this.addField(field));
            }
        }
        request.put("Condition", null);
        if (condition != null) {
            request.put("Condition", condition);
        }
        payload.put("start", Integer.valueOf(start));
        payload.put("length", Integer.valueOf(length));
        Object workspaceArtifactIdString = workspaceArtifactId == null ? "-1" : "" + workspaceArtifactId;
        return this.callApi("/Relativity.Rest/api/Relativity.ObjectManager/v1/workspace/" + (String)workspaceArtifactIdString + "/object/query", "POST", payload, new GenericType<String>(){});
    }

    public String queryObjectManager(ObjectManagerQueryRequest request) throws IOException {
        String workspaceArtifactIdString = request.getRequest().getWorkspaceArtifactId() == null ? "-1" : "" + request.getRequest().getWorkspaceArtifactId();
        return this.callApi("/Relativity.Rest/api/Relativity.ObjectManager/v1/workspace/" + workspaceArtifactIdString + "/object/query", "POST", request, new GenericType<String>(){});
    }

    @Override
    public String queryObjectManagerSlim(ObjectManagerQueryRequest request) throws IOException {
        String workspaceArtifactIdString = request.getRequest().getWorkspaceArtifactId() == null ? "-1" : "" + request.getRequest().getWorkspaceArtifactId();
        return this.callApi("/Relativity.Rest/api/Relativity.ObjectManager/v1/workspace/" + workspaceArtifactIdString + "/object/queryslim", "POST", request, new GenericType<String>(){});
    }

    public List<EligibleObject> queryEligibleObjects(ObjectManagerQuery query) throws IOException {
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        int receivedResults = 0;
        ObjectManagerQueryRequest request = new ObjectManagerQueryRequest(query, 1, PAGE_SIZE);
        while (true) {
            String response = this.queryObjectManager(request);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("FieldValues");
                EligibleObject eligibleObject = new EligibleObject();
                eligibleObject.setName(fieldValuesArray.get(0).getAsJsonObject().get("Value").getAsString());
                eligibleObject.setArtifactId(arrayObject.get("ArtifactID").getAsLong());
                eligibleObjects.add(eligibleObject);
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            request.setNextPage(objectsArray.size());
        }
        return eligibleObjects;
    }

    public String queryResourcePoolAssociatedObject(Long resourcePoolId, String subType, int start, int length) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap request = new HashMap();
        payload.put("request", request);
        ArrayList fields = new ArrayList();
        request.put("Fields", fields);
        HashMap<String, String> fieldName = new HashMap<String, String>();
        fields.add(fieldName);
        fieldName.put("Name", "Name");
        HashMap<String, String> fieldArtifactId = new HashMap<String, String>();
        fields.add(fieldArtifactId);
        fieldArtifactId.put("Name", "ArtifactID");
        request.put("Condition", null);
        payload.put("start", Integer.valueOf(start));
        payload.put("length", Integer.valueOf(length));
        return this.callApi("/Relativity.Rest/API/Relativity.ResourcePools/workspace/-1/resource-pools/" + resourcePoolId + "/" + subType + "/query-associated", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public String getProperty(String propertyName, String workspaceArtifactId) throws IOException {
        Map<String, Object> responseJson = this.callApi("/Relativity.REST/API/relativity-environment/v1/workspace/" + workspaceArtifactId, "GET", new GenericType<Map<String, Object>>(){});
        if (!responseJson.containsKey(propertyName)) {
            throw new IOException("Invalid property name " + propertyName + ", use one of " + String.join((CharSequence)", ", responseJson.keySet()));
        }
        return this.getProperty(propertyName, responseJson);
    }

    @Override
    public String getFieldId(String name, String workspaceArtifactId) throws IOException {
        throw new IOException("Cannot get ArtifactId for the field with named " + name + ": Method not implemented");
    }

    @Override
    public String getFieldName(String id, String workspaceArtifactId, boolean isIdentifier) throws IOException {
        boolean fieldIsIdentifier;
        String responseJsonString = this.callApi("/Relativity.REST/api/Relativity-Object-Model/v1/workspaces/" + workspaceArtifactId + "/fields/" + id, "GET", new GenericType<String>(){});
        Map responseJson = (Map)SerializationUtils.fromJson((String)responseJsonString, Map.class);
        Map objectIdentifier = (Map)responseJson.get("ObjectIdentifier");
        String fieldName = (String)objectIdentifier.get("Name");
        if (isIdentifier && !(fieldIsIdentifier = ((Boolean)responseJson.get("IsIdentifier")).booleanValue())) {
            throw new IOException("Field " + fieldName + " with artifact ID " + id + " is not an identifier field");
        }
        return fieldName;
    }

    @Override
    public String getVersion() throws IOException {
        String version = this.callApi("/relativity.rest/api/Relativity.Services.InstanceDetails.IInstanceDetailsModule/InstanceDetailsService/GetRelativityVersionAsync", "POST", new HashMap(), new GenericType<String>(){});
        return (String)this.gson.fromJson(version, String.class);
    }

    @Override
    public String getInstanceId() throws IOException {
        this.computedInstanceId = this.getGenericInstanceId();
        return this.computedInstanceId;
    }

    @Override
    public long getWorkspaceArtifactId(String workspaceName) throws IOException {
        String response = this.queryObjectManager(8L, null, "'Name' == '" + this.encodeForQuery(workspaceName) + "'", 1, PAGE_SIZE, null);
        SearchResult searchResult = (SearchResult)this.gson.fromJson(response, SearchResult.class);
        if (searchResult.getTotalCount() == 0L) {
            throw new IOException("No workspaces match the name provided");
        }
        if (searchResult.getTotalCount() > 1L) {
            throw new IOException("More than 1 workspace matches the name provided");
        }
        RelativityObject workspace = searchResult.getObjects().get(0);
        for (RelativityFieldValue relativityFieldValue : workspace.fieldValues) {
            if (!relativityFieldValue.getField().getName().equalsIgnoreCase("name")) continue;
            LOGGER.info("Matched workspace: " + relativityFieldValue.getValue());
        }
        return workspace.artifactID;
    }

    @Override
    public String getWorkspaceName(Long workspaceArtifactId) throws IOException {
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        String response = this.callApi("/Relativity.REST/API/relativity-environment/v1/workspace/" + workspaceArtifactId, "GET", new GenericType<String>(){});
        Workspace workspace = (Workspace)this.gson.fromJson(response, Workspace.class);
        LOGGER.info("Matched workspace: " + workspace.getName());
        return workspace.getName();
    }

    @Override
    public List<String> getWorkspaceFields(long workspaceArtifactId) throws IOException {
        throw new IOException("Not Implemented");
    }

    @Override
    public List<EligibleObject> queryEligibleScripts(long workspaceArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(28L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> queryEligibleApplications(long workspaceArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(1000011L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> queryEligibleScriptsNoWorkspace() throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setObjectTypeId(28L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public Long importLibraryScript(Long workspaceArtifactId, Long libraryScriptArtifactId, Long applicationArtifactId) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Cloneable> scriptImportRequest = new HashMap<String, Cloneable>();
        payload.put("ScriptImportRequest", scriptImportRequest);
        HashMap<String, Long> libraryScript = new HashMap<String, Long>();
        scriptImportRequest.put("LibraryScript", libraryScript);
        libraryScript.put("ArtifactID", libraryScriptArtifactId);
        scriptImportRequest.put("RelativityApplications", null);
        if (applicationArtifactId != null) {
            ArrayList applications = new ArrayList();
            HashMap<String, Long> relativityApplications = new HashMap<String, Long>();
            scriptImportRequest.put("RelativityApplications", applications);
            relativityApplications.put("ArtifactID", applicationArtifactId);
            applications.add(relativityApplications);
        }
        String response = this.callApi("/Relativity.Rest/api/relativity-extensibility/v1/workspaces/" + workspaceArtifactId + "/scripts/import", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public List<EligibleObject> queryEligibleClients(RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setObjectTypeId(5L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> queryEligibleWorkspaces(RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setObjectTypeId(8L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> queryEligibleGroups(Long clientArtifactID) throws IOException {
        String condition = clientArtifactID != null ? "'Client' == " + clientArtifactID : null;
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(condition).setObjectTypeId(3L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> queryEligibleMattersNoWorkspace(RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setObjectTypeId(6L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> queryEligibleGroupClients() throws IOException {
        int start = 1;
        int receivedResults = 0;
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        while (true) {
            HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
            HashMap<String, Cloneable> request = new HashMap<String, Cloneable>();
            payload.put("request", request);
            HashMap<String, Integer> objectType = new HashMap<String, Integer>();
            request.put("ObjectType", objectType);
            objectType.put("ArtifactTypeID", 5);
            ArrayList fields = new ArrayList();
            request.put("Fields", fields);
            HashMap<String, String> field = new HashMap<String, String>();
            fields.add(field);
            field.put("Name", "Name");
            request.put("Condition", null);
            payload.put("start", Integer.valueOf(start));
            payload.put("length", Integer.valueOf(PAGE_SIZE));
            String response = this.callApi("/Relativity.Rest/API/Relativity.Groups/workspace/-1/Groups/query-eligible-clients", "POST", payload, new GenericType<String>(){});
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("Values");
                EligibleObject eligibleObject = new EligibleObject();
                eligibleObject.setName(fieldValuesArray.get(0).getAsString());
                eligibleObject.setArtifactId(arrayObject.get("ArtifactID").getAsLong());
                eligibleObjects.add(eligibleObject);
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            start += objectsArray.size();
        }
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleMatters(RelativityIdentifierType identifierType, String identifier) throws IOException {
        int start = 1;
        int receivedResults = 0;
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        while (true) {
            HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
            HashMap<String, Object> request = new HashMap<String, Object>();
            payload.put("request", request);
            ArrayList fields = new ArrayList();
            request.put("Fields", fields);
            HashMap<String, String> field = new HashMap<String, String>();
            fields.add(field);
            field.put("Name", "Name");
            request.put("Condition", this.getConditionFromIdentifier(identifierType, identifier));
            payload.put("start", Integer.valueOf(start));
            payload.put("length", Integer.valueOf(PAGE_SIZE));
            String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/query-eligible-matters", "POST", payload, new GenericType<String>(){});
            EligibleSearchResult results = (EligibleSearchResult)this.gson.fromJson(response, EligibleSearchResult.class);
            long resultsTotalCount = results.getTotalCount();
            for (EligibleResult result : results.getResults()) {
                EligibleObject eligibleObject = new EligibleObject();
                eligibleObject.setArtifactId(result.getArtifactId());
                eligibleObject.setName(result.getFieldValues().get("Name"));
                eligibleObjects.add(eligibleObject);
            }
            if ((long)(receivedResults = (int)((long)receivedResults + results.getResultCount())) >= resultsTotalCount) break;
            start = (int)((long)start + results.getResultCount());
        }
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleWorkspaceTemplates(RelativityIdentifierType identifierType, String identifier) throws IOException {
        int start = 1;
        int receivedResults = 0;
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        while (true) {
            HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
            HashMap<String, Object> request = new HashMap<String, Object>();
            payload.put("request", request);
            ArrayList fields = new ArrayList();
            request.put("Fields", fields);
            HashMap<String, String> field = new HashMap<String, String>();
            fields.add(field);
            field.put("Name", "Name");
            request.put("Condition", this.getConditionFromIdentifier(identifierType, identifier));
            payload.put("start", Integer.valueOf(start));
            payload.put("length", Integer.valueOf(PAGE_SIZE));
            String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/query-eligible-templates", "POST", payload, new GenericType<String>(){});
            EligibleSearchResult results = (EligibleSearchResult)this.gson.fromJson(response, EligibleSearchResult.class);
            for (EligibleResult result : results.getResults()) {
                EligibleObject eligibleObject = new EligibleObject();
                eligibleObject.setArtifactId(result.getArtifactId());
                eligibleObject.setName(result.getFieldValues().get("Name"));
                eligibleObjects.add(eligibleObject);
            }
            if ((long)(receivedResults += results.getResults().size()) >= results.getTotalCount()) break;
            start = (int)((long)start + results.getResultCount());
        }
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleResourcePools() throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/eligible-resource-pools", "GET", new GenericType<String>(){});
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        if (array.size() == 0) {
            throw new IOException("No resource pools available");
        }
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        array.forEach(ele -> {
            JsonObject object = ele.getAsJsonObject();
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId(object.get("ArtifactID").getAsLong());
            eligibleObject.setName(object.get("Name").getAsString());
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleSQLServers(long resourcePoolArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/eligible-resource-pools/" + resourcePoolArtifactId + "/eligible-sql-servers", "GET", new GenericType<String>(){});
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        if (array.size() == 0) {
            throw new IOException("No SQL servers available");
        }
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        array.forEach(ele -> {
            JsonObject object = ele.getAsJsonObject();
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId(object.get("ArtifactID").getAsLong());
            eligibleObject.setName(object.get("Name").getAsString());
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleFileRepositories(long resourcePoolArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/eligible-resource-pools/" + resourcePoolArtifactId + "/eligible-file-repositories", "GET", new GenericType<String>(){});
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        if (array.size() == 0) {
            throw new IOException("No file repositories available");
        }
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        array.forEach(ele -> {
            JsonObject object = ele.getAsJsonObject();
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId(object.get("ArtifactID").getAsLong());
            eligibleObject.setName(object.get("Name").getAsString());
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleCacheLocations(long resourcePoolArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/eligible-resource-pools/" + resourcePoolArtifactId + "/eligible-cache-locations", "GET", new GenericType<String>(){});
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        if (array.size() == 0) {
            throw new IOException("No cache locations available");
        }
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        array.forEach(ele -> {
            JsonObject object = ele.getAsJsonObject();
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId(object.get("ArtifactID").getAsLong());
            eligibleObject.setName(object.get("Name").getAsString());
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleStatusesWorkspaces() throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/eligible-statuses", "GET", new GenericType<String>(){});
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        if (array.size() == 0) {
            throw new IOException("No statuses available");
        }
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        array.forEach(ele -> {
            JsonObject object = ele.getAsJsonObject();
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId(object.get("ArtifactID").getAsLong());
            eligibleObject.setName(object.get("Name").getAsString());
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleSqlLanguages() throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/eligible-sql-full-text-languages", "GET", new GenericType<String>(){});
        Map responseMap = (Map)this.gson.fromJson(response, Map.class);
        ArrayList languages = (ArrayList)responseMap.get("Languages");
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        languages.forEach(ele -> {
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId((long)Double.parseDouble(ele.get("ID").toString()));
            eligibleObject.setName((String)ele.get("Name"));
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleStatusesClients() throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-identity/v1/workspaces/-1/clients/eligible-statuses", "GET", new GenericType<String>(){});
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        if (array.size() == 0) {
            throw new IOException("No statuses available");
        }
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        array.forEach(ele -> {
            JsonObject object = ele.getAsJsonObject();
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId(object.get("ArtifactID").getAsLong());
            eligibleObject.setName(object.get("Name").getAsString());
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }

    @Override
    public List<EligibleObject> queryEligibleStatusesMatters() throws IOException {
        String response = this.callApi("/Relativity.rest/api/relativity-environment/v1/workspaces/-1/matters/eligible-statuses", "GET", new GenericType<String>(){});
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        if (array.size() == 0) {
            throw new IOException("No statuses available");
        }
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        array.forEach(ele -> {
            JsonObject object = ele.getAsJsonObject();
            EligibleObject eligibleObject = new EligibleObject();
            eligibleObject.setArtifactId(object.get("ArtifactID").getAsLong());
            eligibleObject.setName(object.get("Name").getAsString());
            eligibleObjects.add(eligibleObject);
        });
        return eligibleObjects;
    }

    @Override
    public String queryDefaultDownloadHandlerUrl() throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/default-download-handler-url", "GET", new GenericType<String>(){});
        if (response != null) {
            response = response.replace("\"", "");
        }
        return response;
    }

    @Override
    public Map<String, Object> createRelativityWorkspace(String workspaceName, long matterArtifactId, long templateArtifactId, long resourcePoolArtifactId, long fileRepositoryArtifactId, long sqlServerArtifactId, long cacheLocationArtifactId, long workspaceStatusArtifactId, long sqlFullTextLanguage) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Object> workspaceRequest = new HashMap<String, Object>();
        workspaceRequest.put("DownloadHandlerUrl", this.queryDefaultDownloadHandlerUrl());
        workspaceRequest.put("Name", workspaceName);
        Map<String, Object> matter = this.createRequestField(matterArtifactId);
        workspaceRequest.put("Matter", matter);
        Map<String, Object> template = this.createRequestField(templateArtifactId);
        workspaceRequest.put("Template", template);
        Map<String, Object> resourcePool = this.createRequestField(resourcePoolArtifactId);
        workspaceRequest.put("ResourcePool", resourcePool);
        Map<String, Object> defaultFileRepository = this.createRequestField(fileRepositoryArtifactId);
        workspaceRequest.put("DefaultFileRepository", defaultFileRepository);
        Map<String, Object> sqlServer = this.createRequestField(sqlServerArtifactId);
        workspaceRequest.put("SqlServer", sqlServer);
        Map<String, Object> defaultCacheLocation = this.createRequestField(cacheLocationArtifactId);
        workspaceRequest.put("DefaultCacheLocation", defaultCacheLocation);
        HashMap<String, Long> status = new HashMap<String, Long>();
        status.put("ArtifactID", workspaceStatusArtifactId);
        workspaceRequest.put("Status", status);
        workspaceRequest.put("SqlFullTextLanguage", sqlFullTextLanguage);
        payload.put("workspaceRequest", workspaceRequest);
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace", "POST", payload, new GenericType<String>(){});
        JsonObject workspace = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        HashMap<String, Object> workspaceMap = new HashMap<String, Object>();
        workspaceMap.put("artifactId", workspace.get("ArtifactID").getAsString());
        workspaceMap.put("name", workspace.get("Name").getAsString());
        return workspaceMap;
    }

    @Override
    public long uploadCustomScript(long workspaceArtifactId, String scriptCode) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, String> scriptRequest = new HashMap<String, String>();
        payload.put("ScriptRequest", scriptRequest);
        scriptRequest.put("RelativityApplications", null);
        scriptRequest.put("ScriptBody", scriptCode);
        String response = this.callApi("/Relativity.Rest/api/relativity-extensibility/v1/workspaces/" + workspaceArtifactId + "/scripts", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public String queueScript(long workspaceArtifactId, long scriptId, Map<String, Object> parameters) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("Inputs", new ArrayList());
        if (parameters.size() > 0) {
            payload.put("Inputs", this.buildScriptParameters(parameters));
        }
        payload.put("TimeZoneOffset", 0);
        try {
            String response = this.callApi("/Relativity.Rest/api/relativity-extensibility/v1/workspaces/" + workspaceArtifactId + "/scripts/" + scriptId + "/run", "POST", payload, new GenericType<String>(){});
            JsonObject responseObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            return responseObject.get("RunJobID").getAsString();
        }
        catch (IOException e) {
            String message = e.getMessage();
            CharSequence[] invalidInputs = message.split("\r\n");
            if (invalidInputs.length > 1) {
                List<RelativityScriptParameter> existingParameters = this.getRelativityScriptParameters(workspaceArtifactId, scriptId);
                for (int i = 0; i < invalidInputs.length; ++i) {
                    String invalidField = invalidInputs[i];
                    if (invalidField.startsWith("Cannot query Relativity API")) continue;
                    for (RelativityScriptParameter parameter : existingParameters) {
                        if (!invalidField.contains("'" + parameter.getIdentifier() + "'")) continue;
                        invalidInputs[i] = invalidField + " " + parameter.toDisplayValue();
                    }
                }
                message = String.join((CharSequence)"\r\n", invalidInputs);
            }
            throw new IOException(message);
        }
    }

    protected List<RelativityScriptParameter> getRelativityScriptParameters(Long workspaceArtifactId, Long scriptArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/api/relativity-extensibility/v1/workspaces/" + workspaceArtifactId + "/scripts/" + scriptArtifactId + "/parameters", "GET", new GenericType<String>(){});
        RelativityScriptParameter[] parameters = (RelativityScriptParameter[])this.gson.fromJson(response, RelativityScriptParameter[].class);
        List<RelativityScriptParameter> parametersList = Arrays.asList(parameters);
        return parametersList;
    }

    protected List<Object> buildScriptParameters(Map<String, Object> values) {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("Identifier", entry.getKey());
            parameter.put("Value", entry.getValue());
            parameterValues.add(parameter);
        }
        return parameterValues;
    }

    @Override
    public RelativityScriptDetails readScriptOutput(long workspaceArtifactId, String runJobId) throws IOException {
        RelativityScriptDetails details = new RelativityScriptDetails();
        String scriptDetails = this.callApi("/Relativity.Rest/api/relativity-extensibility/v1/workspaces/" + workspaceArtifactId + "/scripts/run-jobs/" + runJobId, "GET", new GenericType<String>(){});
        JsonObject scriptInfo = (JsonObject)this.gson.fromJson(scriptDetails, JsonObject.class);
        details.setStatus(scriptInfo.get("Status").getAsString());
        details.setErrorMessage(scriptInfo.get("ErrorMessage").getAsString());
        HashMap payload = new HashMap();
        HashMap actionExportRequest = new HashMap();
        payload.put("ActionExportRequest", actionExportRequest);
        HashMap queryRequest = new HashMap();
        actionExportRequest.put("QueryRequest", queryRequest);
        queryRequest.put("Condition", null);
        queryRequest.put("Sorts", null);
        ArrayList<String> cNames = new ArrayList<String>();
        cNames.add("*");
        queryRequest.put("ColumnNames", cNames);
        String response = this.callApi("/Relativity.Rest/api/relativity-extensibility/v1/workspaces/" + workspaceArtifactId + "/scripts/run-jobs/" + runJobId + "/actions/0/export-results", "POST", payload, new GenericType<String>(){});
        details.setResponseOutput(response);
        return details;
    }

    @Override
    public String exportScript(long workspaceArtifactId, String runJobId, RelativityScriptExportType exportType, String exportLocation) throws IOException {
        Path exportPath = Paths.get(exportLocation, new String[0]);
        Path parentFolderPath = exportPath.getParent();
        if (!Files.exists(parentFolderPath, new LinkOption[0])) {
            Files.createDirectories(parentFolderPath, new FileAttribute[0]);
        }
        HashMap payload = new HashMap();
        HashMap<String, String> scriptRequest = new HashMap<String, String>();
        payload.put("ScriptExportRequest", scriptRequest);
        scriptRequest.put("FileType", exportType.name());
        String readResponse = this.callApi("/Relativity.Rest/api/relativity-extensibility/v1/workspaces/" + workspaceArtifactId + "/scripts/run-jobs/" + runJobId + "/export-report", "POST", payload, new GenericType<String>(){});
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(exportPath.toFile()));){
            outputStream.write(readResponse.getBytes(StandardCharsets.UTF_8));
        }
        return exportPath.toAbsolutePath().toString();
    }

    @Override
    public Long createClient(String clientName, String clientNumber, String keywords, String notes, Long statusArtifactId) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Object> clientRequest = new HashMap<String, Object>();
        payload.put("clientRequest", clientRequest);
        clientRequest.put("Name", clientName);
        clientRequest.put("Number", clientNumber);
        clientRequest.put("Keywords", keywords);
        clientRequest.put("Notes", notes);
        HashMap<String, Long> status = new HashMap<String, Long>();
        clientRequest.put("Status", status);
        status.put("ArtifactID", statusArtifactId);
        String response = this.callApi("/Relativity.Rest/API/relativity-identity/v1/workspaces/-1/clients", "POST", payload, new GenericType<String>(){});
        JsonObject responseObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        return responseObject.get("ArtifactID").getAsLong();
    }

    @Override
    public Long createGroup(String groupName, Long clientArtifactId, String keywords, String notes) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Object> groupRequest = new HashMap<String, Object>();
        payload.put("groupRequest", groupRequest);
        groupRequest.put("Name", groupName);
        groupRequest.put("Keywords", keywords);
        groupRequest.put("Notes", notes);
        HashMap client = new HashMap();
        groupRequest.put("Client", client);
        HashMap<String, Long> clientSecured = new HashMap<String, Long>();
        client.put("Value", clientSecured);
        clientSecured.put("ArtifactID", clientArtifactId);
        String response = this.callApi("/Relativity.REST/api/Relativity-Identity/v1/groups/", "POST", payload, new GenericType<String>(){});
        JsonObject responseObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        return responseObject.get("ArtifactID").getAsLong();
    }

    @Override
    public Long createMatter(String matterName, String matterNumber, String keywords, String notes, Long clientArtifactId, Long statusArtifactId) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Object> matterRequest = new HashMap<String, Object>();
        payload.put("MatterRequest", matterRequest);
        matterRequest.put("Name", matterName);
        matterRequest.put("Number", matterNumber);
        matterRequest.put("Keywords", keywords);
        matterRequest.put("Notes", notes);
        HashMap<String, Serializable> status = new HashMap<String, Serializable>();
        matterRequest.put("Status", status);
        status.put("Secured", Boolean.valueOf(false));
        HashMap<String, Long> statusSecured = new HashMap<String, Long>();
        status.put("Value", statusSecured);
        statusSecured.put("ArtifactID", statusArtifactId);
        HashMap client = new HashMap();
        matterRequest.put("Client", client);
        HashMap<String, Long> clientSecured = new HashMap<String, Long>();
        client.put("Value", clientSecured);
        clientSecured.put("ArtifactID", clientArtifactId);
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspaces/-1/matters", "POST", payload, new GenericType<String>(){});
        LOGGER.error("Response: " + response);
        return Long.parseLong(response);
    }

    private Map<String, Object> createRequestField(long artifactId) {
        HashMap<String, Object> requestField = new HashMap<String, Object>();
        requestField.put("Secured", false);
        HashMap<String, Long> artifact = new HashMap<String, Long>();
        artifact.put("ArtifactID", artifactId);
        requestField.put("Value", artifact);
        return requestField;
    }

    @Override
    public void deleteScript(Long workspaceArtifactId, Long scriptArtifactId) throws IOException {
        this.callApi("/Relativity.Rest/api/relativity-extensibility/v1/workspaces/" + workspaceArtifactId + "/scripts/" + scriptArtifactId, "DELETE", new GenericType<String>(){});
    }

    @Override
    public void runDtSearchIndexAction(Long workspaceArtifactId, Long searchProviderArtifactId, RelativityDtSearchIndexAction action) throws IOException {
        String dtSearchUrlSuffix = "";
        HashMap<String, Boolean> payload = new HashMap<String, Boolean>();
        switch (action) {
            default: {
                payload.put("isActive", true);
                dtSearchUrlSuffix = "full-build-index";
                break;
            }
            case INCREMENTAL: {
                payload.put("isActive", true);
                dtSearchUrlSuffix = "incremental-build-index";
                break;
            }
            case ACTIVATE: {
                dtSearchUrlSuffix = "activate-index";
                break;
            }
            case COMPRESS: {
                payload.put("isActive", true);
                dtSearchUrlSuffix = "compress-index";
                break;
            }
            case DEACTIVATE: {
                dtSearchUrlSuffix = "deactivate-index";
            }
        }
        String dtSearchUrl = "/Relativity.Rest/API/relativity-dtsearch/v1/workspaces/" + workspaceArtifactId + "/dtsearch-indexes/" + searchProviderArtifactId + "/" + dtSearchUrlSuffix;
        this.callApi(dtSearchUrl, "POST", payload, new GenericType<String>(){});
    }

    @Override
    public List<EligibleObject> getDtSearchIndexes(Long workspaceArtifactId, boolean forceCondition) throws IOException {
        String queryCondition = null;
        if (forceCondition) {
            queryCondition = "'Type' == 'dtSearch'";
        }
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setCondition(queryCondition).setObjectTypeId(29L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public void updateDtSearchIndex(Long workspaceArtifactId, Long searchProviderArtifactId, String data) throws IOException {
        HashMap<String, DtSearchIndex> payload = new HashMap<String, DtSearchIndex>();
        DtSearchIndex dtSearchIndexRequest = (DtSearchIndex)this.gson.fromJson(data, DtSearchIndex.class);
        DtSearchIndex mergedDtSearchIndex = this.mergeDtSearchSettingWithOriginalIndex(workspaceArtifactId, searchProviderArtifactId, dtSearchIndexRequest);
        payload.put("dtSearchIndexRequest", mergedDtSearchIndex);
        this.callApi("/Relativity.Rest/API/relativity-dtsearch/v1/workspaces/" + workspaceArtifactId + "/dtsearch-indexes/" + searchProviderArtifactId, "PUT", payload, new GenericType<String>(){});
    }

    private DtSearchIndex mergeDtSearchSettingWithOriginalIndex(Long workspaceArtifactId, Long dtSearchIndexArtifactId, DtSearchIndex updatedIndex) throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-dtsearch/v1/workspaces/" + workspaceArtifactId + "/dtsearch-indexes/" + dtSearchIndexArtifactId, "GET", new GenericType<String>(){});
        DtSearchIndex dtSearchIndex = (DtSearchIndex)this.gson.fromJson(response, DtSearchIndex.class);
        DtSearchIndex mergedSearchIndex = new DtSearchIndex(dtSearchIndex);
        mergedSearchIndex.merge(updatedIndex);
        return mergedSearchIndex;
    }

    @Override
    public IndexBuildProgress getIndexBuildProgress(Long workspaceArtifactId, Long searchProviderArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-dtsearch/v1/workspaces/" + workspaceArtifactId + "/dtsearch-indexes/" + searchProviderArtifactId + "/index-job-progress", "GET", new GenericType<String>(){});
        return (IndexBuildProgress)this.gson.fromJson(response, IndexBuildProgress.class);
    }

    @Override
    public String getScriptStatus(Long workspaceArtifactId, String runJobId) throws IOException {
        String scriptDetails = this.callApi("/Relativity.Rest/api/relativity-extensibility/v1/workspaces/" + workspaceArtifactId + "/scripts/run-jobs/" + runJobId, "GET", new GenericType<String>(){});
        JsonObject scriptInfo = (JsonObject)this.gson.fromJson(scriptDetails, JsonObject.class);
        return scriptInfo.get("Status").getAsString();
    }

    @Override
    public WorkspaceGroups getWorkspaceGroups(Long workspaceArtifactId) throws IOException {
        WorkspaceGroups groups = new WorkspaceGroups();
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/GetWorkspaceGroupSelectorAsync", "POST", payload, new GenericType<String>(){});
        JsonObject obj = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        String lastModified = obj.get("LastModified").getAsString();
        groups.setLastModified(lastModified);
        JsonArray disabledGroups = obj.getAsJsonArray("DisabledGroups");
        disabledGroups.forEach(item -> {
            JsonObject group = item.getAsJsonObject();
            Long artifactId = group.get("ArtifactID").getAsLong();
            String name = group.get("Name").getAsString();
            groups.getWorkspaceGroups().add(new WorkspaceGroup(name, artifactId, false));
        });
        JsonArray enabledGroups = obj.getAsJsonArray("EnabledGroups");
        enabledGroups.forEach(item -> {
            JsonObject group = item.getAsJsonObject();
            Long artifactId = group.get("ArtifactID").getAsLong();
            String name = group.get("Name").getAsString();
            groups.getWorkspaceGroups().add(new WorkspaceGroup(name, artifactId, true));
        });
        return groups;
    }

    @Override
    public void setWorkspaceGroups(Long workspaceArtifactId, WorkspaceGroups groups) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        HashMap<String, Object> groupSelector = new HashMap<String, Object>();
        payload.put("groupSelector", groupSelector);
        groupSelector.put("LastModified", groups.getLastModified());
        ArrayList disabledGroups = new ArrayList();
        ArrayList enabledGroups = new ArrayList();
        groupSelector.put("DisabledGroups", disabledGroups);
        groupSelector.put("EnabledGroups", enabledGroups);
        for (WorkspaceGroup workspaceGroup : groups.getWorkspaceGroups()) {
            HashMap<String, Long> artifactIdObject = new HashMap<String, Long>();
            artifactIdObject.put("ArtifactID", workspaceGroup.getArtifactId());
            if (workspaceGroup.getEnabled().booleanValue()) {
                enabledGroups.add(artifactIdObject);
                continue;
            }
            disabledGroups.add(artifactIdObject);
        }
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/AddRemoveWorkspaceGroupsAsync", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public List<RelativityBasicUser> queryUsers() throws IOException {
        String response = this.callApi("/Relativity.Rest/API/Relativity.Users/workspace/-1/users/retrieveall", "GET", new GenericType<String>(){});
        ArrayList<RelativityBasicUser> relativityBasicUserList = new ArrayList<RelativityBasicUser>();
        JsonArray basicUsers = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        basicUsers.forEach(user -> {
            JsonObject obj = user.getAsJsonObject();
            RelativityBasicUser basicUser = new RelativityBasicUser();
            basicUser.setFullName(obj.get("FullName").getAsString());
            basicUser.setEmail(obj.get("Email").getAsString());
            basicUser.setArtifactId(obj.get("ArtifactID").getAsLong());
            relativityBasicUserList.add(basicUser);
        });
        return relativityBasicUserList;
    }

    @Override
    public RelativityUser getRelativityUserProperties(Long userId) throws IOException {
        String response = this.callApi("/Relativity.REST/api/Relativity-Identity/v1/users/" + userId, "GET", new GenericType<String>(){});
        RelativityUser user = (RelativityUser)this.gson.fromJson(response, RelativityUser.class);
        return user;
    }

    @Override
    public RelativityUser createUser(RelativityUser relativityUser) throws IOException {
        HashMap<String, RelativityUser> payload = new HashMap<String, RelativityUser>();
        payload.put("UserRequest", relativityUser);
        String response = this.callApi("/Relativity.REST/api/Relativity-Identity/v1/users", "POST", payload, new GenericType<String>(){});
        RelativityUser createdUser = (RelativityUser)this.gson.fromJson(response, RelativityUser.class);
        return createdUser;
    }

    @Override
    public void deleteUser(Long userArtifactId) throws IOException {
        this.callApi("/Relativity.REST/api/Relativity-Identity/v1/users/" + userArtifactId, "DELETE", new GenericType<String>(){});
    }

    @Override
    public void enableUser(RelativityUser relativityUser) throws IOException {
        HashMap<String, RelativityUser> payload = new HashMap<String, RelativityUser>();
        payload.put("UserRequest", relativityUser);
        String response = this.callApi("/Relativity.REST/api/Relativity-Identity/v1/users/" + relativityUser.getArtifactId(), "PUT", payload, new GenericType<String>(){});
    }

    @Override
    public void disableUser(RelativityUser relativityUser) throws IOException {
        HashMap<String, RelativityUser> payload = new HashMap<String, RelativityUser>();
        payload.put("UserRequest", relativityUser);
        String response = this.callApi("/Relativity.REST/api/Relativity-Identity/v1/users/" + relativityUser.getArtifactId(), "PUT", payload, new GenericType<String>(){});
    }

    @Override
    public void addUsersToGroup(Long groupArtifactId, List<RelativityBasicUser> userObjects) throws IOException {
        HashMap payload = new HashMap();
        ArrayList users = new ArrayList();
        payload.put("users", users);
        for (RelativityBasicUser user : userObjects) {
            HashMap<String, Long> userArtifactId = new HashMap<String, Long>();
            userArtifactId.put("ArtifactID", user.getArtifactId());
            users.add(userArtifactId);
        }
        this.callApi("/Relativity.REST/api/Relativity-Identity/v1/groups/" + groupArtifactId + "/members", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public void removeUsersFromGroup(Long groupArtifactId, List<RelativityBasicUser> userObjects) throws IOException {
        HashMap payload = new HashMap();
        ArrayList users = new ArrayList();
        payload.put("users", users);
        for (RelativityBasicUser user : userObjects) {
            HashMap<String, Long> userArtifactId = new HashMap<String, Long>();
            userArtifactId.put("ArtifactID", user.getArtifactId());
            users.add(userArtifactId);
        }
        this.callApi("/Relativity.REST/api/Relativity-Identity/v1/groups/" + groupArtifactId + "/members", "DELETE", payload, new GenericType<String>(){});
    }

    @Override
    public List<EligibleObject> queryGroupMembers(Long groupArtifactId) throws IOException {
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap request = new HashMap();
        payload.put("request", request);
        ArrayList fields = new ArrayList();
        request.put("Fields", fields);
        HashMap<String, String> field = new HashMap<String, String>();
        fields.add(field);
        field.put("Name", "E-mail Address");
        request.put("Condition", null);
        payload.put("length", Integer.valueOf(PAGE_SIZE));
        int start = 1;
        int receivedResults = 0;
        while (true) {
            payload.put("start", Integer.valueOf(start));
            String response = this.callApi("Relativity.REST/api/Relativity-Identity/v1/groups/" + groupArtifactId + "/query-members", "POST", payload, new GenericType<String>(){});
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("Values");
                EligibleObject eligibleObject = new EligibleObject();
                eligibleObject.setName(fieldValuesArray.get(0).getAsString());
                eligibleObject.setArtifactId(arrayObject.get("ArtifactID").getAsLong());
                eligibleObjects.add(eligibleObject);
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            start += objectsArray.size();
        }
        return eligibleObjects;
    }

    @Override
    public WorkspaceGroupPermissions getWorkspaceGroupPermissions(Long workspaceArtifactId, Long groupArtifactId) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        HashMap<String, Long> group = new HashMap<String, Long>();
        payload.put("group", group);
        group.put("ArtifactID", groupArtifactId);
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/GetWorkspaceGroupPermissionsAsync", "POST", payload, new GenericType<String>(){});
        WorkspaceGroupPermissions workspaceGroupPermissions = (WorkspaceGroupPermissions)this.gson.fromJson(response, WorkspaceGroupPermissions.class);
        return workspaceGroupPermissions;
    }

    @Override
    public Long getWorkspaceGroupId(Long workspaceArtifactId, Long groupArtifactId) throws IOException {
        WorkspaceGroupPermissions workspaceGroupPermissions = this.getWorkspaceGroupPermissions(workspaceArtifactId, groupArtifactId);
        return (long)workspaceGroupPermissions.getGroupID();
    }

    @Override
    public void setWorkspaceGroupPermissions(Long workspaceArtifactId, WorkspaceGroupPermissions permissions) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("groupPermissions", permissions);
        this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/SetWorkspaceGroupPermissionsAsync", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public Map<String, RelativityFieldValueType> getFieldValueTypeIdentifiers(Long objectTypeArtifactId, Long workspaceArtifactId) throws IOException {
        Set<RelativityFieldObject> fields = this.queryObjectFields(objectTypeArtifactId, workspaceArtifactId);
        HashMap<String, RelativityFieldValueType> fieldTypeMap = new HashMap<String, RelativityFieldValueType>();
        for (RelativityFieldObject field : fields) {
            fieldTypeMap.put(field.getName(), RelativityFieldValueType.fromRelativityName(field.getFieldType()));
        }
        return fieldTypeMap;
    }

    @Override
    public Map<String, RelativityFieldObject> getFieldIdentifiers(Long objectTypeArtifactId, Long workspaceArtifactId) throws IOException {
        Set<RelativityFieldObject> fields = this.queryObjectFields(objectTypeArtifactId, workspaceArtifactId);
        HashMap<String, RelativityFieldObject> fieldTypeMap = new HashMap<String, RelativityFieldObject>();
        for (RelativityFieldObject field : fields) {
            fieldTypeMap.put(field.getName(), field);
        }
        return fieldTypeMap;
    }

    @Override
    public Map<String, EligibleObject> queryChoiceValues(Long workspaceArtifactId, String fieldName) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setCondition("'Field' IN ['" + fieldName + "']").setObjectTypeId(7L).addFields("Name").build();
        HashMap<String, EligibleObject> eligibleObjectsMap = new HashMap<String, EligibleObject>();
        List<EligibleObject> eligibleObjects = this.queryEligibleObjects(query);
        for (EligibleObject eligibleObject : eligibleObjects) {
            eligibleObjectsMap.put(eligibleObject.getName(), eligibleObject);
        }
        return eligibleObjectsMap;
    }

    @Override
    public Long retrieveFieldArtifactTypeId(Long workspaceArtifactId, Long fieldArtifactId) throws IOException {
        String response = this.callApi("/relativity.rest/api/Relativity-Object-Model/v1/workspaces/" + workspaceArtifactId + "/fields/" + fieldArtifactId, "GET", new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonObject objectType = object.getAsJsonObject("AssociativeObjectType").getAsJsonObject("Value");
        Long artifactTypeId = objectType.get("ArtifactTypeID").getAsLong();
        return artifactTypeId;
    }

    @Override
    public Map<String, EligibleObject> queryObjectValues(Long workspaceArtifactId, Long artifactTypeId) throws IOException {
        HashMap<String, EligibleObject> eligibleObjects = new HashMap<String, EligibleObject>();
        int start = 1;
        int receivedResults = 0;
        while (true) {
            String response = this.queryObjectManager(artifactTypeId, workspaceArtifactId, null, start, PAGE_SIZE, null);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("FieldValues");
                EligibleObject eligibleObject = new EligibleObject();
                eligibleObject.setArtifactId(arrayObject.get("ArtifactID").getAsLong());
                try {
                    eligibleObject.setName(fieldValuesArray.get(0).getAsJsonObject().get("Value").getAsString());
                }
                catch (NullPointerException e) {
                    eligibleObject.setName("" + eligibleObject.getArtifactId());
                }
                eligibleObjects.put(eligibleObject.getName(), eligibleObject);
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            start += objectsArray.size();
        }
        return eligibleObjects;
    }

    @Override
    public boolean massCreateDynamicObjects(Long artifactTypeId, Long workspaceArtifactTypeId, String[] headers, List<Object[]> values) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Object> request = new HashMap<String, Object>();
        payload.put("massRequest", request);
        HashMap<String, Long> objectType = new HashMap<String, Long>();
        request.put("ObjectType", objectType);
        objectType.put("ArtifactTypeID", artifactTypeId);
        ArrayList fields = new ArrayList();
        request.put("Fields", fields);
        for (String header : headers) {
            HashMap<String, String> identifier = new HashMap<String, String>();
            identifier.put("Name", header);
            fields.add(identifier);
        }
        request.put("ValueLists", values);
        String response = this.callApi("/Relativity.Rest/API/Relativity.Objects/workspace/" + workspaceArtifactTypeId + "/object/create", "POST", payload, new GenericType<String>(){});
        JsonObject responseObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        boolean createdObjects = responseObject.get("Success").getAsBoolean();
        if (createdObjects) {
            return true;
        }
        String message = responseObject.get("Message").getAsString();
        throw new IOException(message);
    }

    @Override
    public List<EligibleObject> queryObjectTypes(String identifier, RelativityIdentifierType identifierType, Long workspaceArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setObjectTypeId(25L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public Long queryObjectTypeArtifactIdFromArtifactId(Long workspaceArtifactId, Long objectTypeArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/api/relativity-object-model/v1/workspaces/" + workspaceArtifactId + "/object-types/" + objectTypeArtifactId, "GET", new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        Long artifactTypeId = object.get("ArtifactTypeID").getAsLong();
        return artifactTypeId;
    }

    @Override
    public boolean instanceContainsArmApplication() throws IOException {
        int start = 1;
        int receivedResults = 0;
        while (true) {
            String response = this.queryObjectManager(34L, -1L, null, start, PAGE_SIZE, null);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("FieldValues");
                String applicationName = fieldValuesArray.get(0).getAsJsonObject().get("Value").getAsString();
                if (!applicationName.equalsIgnoreCase("ARM")) continue;
                return true;
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            start += objectsArray.size();
        }
        return false;
    }

    @Override
    public Long createArmArchive(Long workspaceArtifactId, ArmArchive archive) throws IOException {
        HashMap<String, ArmArchive> payload = new HashMap<String, ArmArchive>();
        payload.put("request", archive);
        String response = this.callApi("/Relativity.REST/api/relativity-arm/v1/archive-jobs", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public ArmJobStatus getArmJobStatus(Long jobArtifactId) throws IOException {
        String response = this.callApi("/Relativity.REST/api/relativity-arm/v1/jobs/" + jobArtifactId + "/status", "GET", new GenericType<String>(){});
        return (ArmJobStatus)this.gson.fromJson(response, ArmJobStatus.class);
    }

    @Override
    public void runArmJob(Long jobArtifactId) throws IOException {
        HashMap payload = new HashMap();
        this.callApi("/Relativity.REST/api/relativity-arm/v1/jobs/" + jobArtifactId + "/run", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public String getArmArchivePath(Long jobArtifactId) throws IOException {
        String response = this.callApi("/Relativity.REST/api/relativity-arm/v1/archive-jobs/" + jobArtifactId, "GET", new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        String path = object.get("ArchivePath").getAsString();
        return path;
    }

    @Override
    public List<EligibleObject> queryAssociatedResourcePoolObject(Long resourcePoolId, AssociatedResourcePoolType associatedResourcePoolType) throws IOException {
        ArrayList<EligibleObject> eligibleObjects = new ArrayList<EligibleObject>();
        int start = 0;
        int receivedResults = 0;
        while (true) {
            String response = this.queryResourcePoolAssociatedObject(resourcePoolId, associatedResourcePoolType.toString(), start, PAGE_SIZE);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("Values");
                EligibleObject eligibleObject = new EligibleObject();
                eligibleObject.setName(fieldValuesArray.get(0).getAsString());
                eligibleObject.setArtifactId(fieldValuesArray.get(1).getAsLong());
                eligibleObjects.add(eligibleObject);
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            start += objectsArray.size();
        }
        return eligibleObjects;
    }

    private RelativityClientObject getClient(Long clientArtifactId) throws IOException {
        if (clientArtifactId == null) {
            return null;
        }
        RelativityClientObject client = (RelativityClientObject)this.cachedObjects.get(String.valueOf(clientArtifactId));
        if (client != null) {
            return client;
        }
        client = new RelativityClientObject();
        String response = this.callApi("/Relativity.rest/api/relativity-identity/v1/workspaces/-1/clients/" + clientArtifactId, "GET", new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        client.setArtifactId(clientArtifactId);
        client.setName(object.get("Name").getAsString());
        client.setNumber(object.get("Number").getAsString());
        this.cachedObjects.put(String.valueOf(clientArtifactId), (Object)client);
        return client;
    }

    private RelativityMatterObject getMatter(Long matterArtifactId) throws IOException {
        if (matterArtifactId == null) {
            return null;
        }
        RelativityMatterObject matter = (RelativityMatterObject)this.cachedObjects.get(String.valueOf(matterArtifactId));
        if (matter != null) {
            return matter;
        }
        matter = new RelativityMatterObject();
        String response = this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspaces/-1/matters/" + matterArtifactId, "GET", new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        matter.setArtifactId(matterArtifactId);
        matter.setName(object.get("Name").getAsString());
        matter.setNumber(object.get("Number").getAsString());
        matter.setClientArtifactId(object.getAsJsonObject("Client").getAsJsonObject("Value").get("ArtifactID").getAsLong());
        this.cachedObjects.put(String.valueOf(matterArtifactId), (Object)matter);
        return matter;
    }

    public List<AllowedValueItem> queryAllowedValueItems(ObjectManagerQuery query) throws IOException {
        ArrayList<AllowedValueItem> allowedValueItems = new ArrayList<AllowedValueItem>();
        int receivedResults = 0;
        ObjectManagerQueryRequest request = new ObjectManagerQueryRequest(query, 1, PAGE_SIZE);
        while (true) {
            String response = this.queryObjectManager(request);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("FieldValues");
                if (query.getParentArtifactId() != null) {
                    Long parentArtifactId = arrayObject.getAsJsonObject("ParentObject").get("ArtifactID").getAsLong();
                    if (!query.getParentArtifactId().equals(parentArtifactId)) continue;
                }
                AllowedValueItem allowedValueItem = new AllowedValueItem();
                allowedValueItem.setName(fieldValuesArray.get(0).getAsJsonObject().get("Value").getAsString());
                allowedValueItem.setValue(String.valueOf(arrayObject.get("ArtifactID").getAsLong()));
                allowedValueItems.add(allowedValueItem);
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            request.setNextPage(objectsArray.size());
        }
        if (query.getCacheKey() != null) {
            this.cachedObjects.put(query.getCacheKey(), allowedValueItems);
        }
        return allowedValueItems;
    }

    @Override
    public List<AllowedValueItem> filterRelativityObjects(RelativityCondition condition, ParameterType type, String filterParameterValue) throws IOException {
        if (condition.getFilterType() != null && condition.getFilterParameter() != null && (filterParameterValue == null || filterParameterValue.equals(""))) {
            return new ArrayList<AllowedValueItem>();
        }
        switch (type) {
            case RELATIVITY_WORKSPACE: {
                return this.filterObjectWithForCondition(RelativityArtifactIdType.WORKSPACE, condition, filterParameterValue);
            }
            case RELATIVITY_CLIENT: {
                return this.filterObjectWithForCondition(RelativityArtifactIdType.CLIENT, condition, filterParameterValue);
            }
            case RELATIVITY_MATTER: {
                return this.filterObjectWithForCondition(RelativityArtifactIdType.MATTER, condition, filterParameterValue);
            }
            case RELATIVITY_DT_SEARCH: {
                return this.filterObjectWithForCondition(RelativityArtifactIdType.SEARCH_INDEX, condition, filterParameterValue);
            }
            case RELATIVITY_WORKSPACE_FIELD: {
                return this.filterObjectWithForCondition(RelativityArtifactIdType.FIELD, condition, filterParameterValue);
            }
            case RELATIVITY_VIEW: {
                return this.filterObjectWithForCondition(RelativityArtifactIdType.VIEW, condition, filterParameterValue);
            }
            case RELATIVITY_FOLDER: {
                return this.filterObjectWithForCondition(RelativityArtifactIdType.FOLDER, condition, filterParameterValue);
            }
            case RELATIVITY_SAVED_SEARCH: {
                return this.filterObjectWithForCondition(RelativityArtifactIdType.SEARCH, condition, filterParameterValue);
            }
        }
        return new ArrayList<AllowedValueItem>();
    }

    private List<AllowedValueItem> filterObjectWithForCondition(RelativityArtifactIdType relativityArtifactIdType, RelativityCondition condition, String filterParameterValue) throws IOException {
        Object queryCondition = null;
        Long workspaceArtifactId = null;
        Long parentArtifactId = null;
        String cacheKey = null;
        switch (relativityArtifactIdType) {
            case MATTER: {
                if (filterParameterValue == null) break;
                queryCondition = "'Client' == OBJECT " + this.encodeForQuery(filterParameterValue);
                break;
            }
            case WORKSPACE: {
                cacheKey = String.valueOf(condition.getFilterType()) + String.valueOf(condition.getFilterParameter()) + String.valueOf(filterParameterValue);
                List allowedValues = (List)this.cachedObjects.get(cacheKey);
                if (allowedValues != null) {
                    return allowedValues;
                }
                if (filterParameterValue == null) break;
                if (condition.getFilterType() == RelativityConditionType.RELATIVITY_CLIENT) {
                    RelativityClientObject client = this.getClient(Long.parseLong(filterParameterValue));
                    if (client == null) {
                        return null;
                    }
                    parentArtifactId = client.getArtifactId();
                    queryCondition = "('Client Name' == '" + this.encodeForQuery(client.getName()) + "') AND ('Client Number' == '" + this.encodeForQuery(client.getNumber()) + "')";
                } else if (condition.getFilterType() == RelativityConditionType.RELATIVITY_MATTER) {
                    RelativityMatterObject matter = this.getMatter(Long.parseLong(filterParameterValue));
                    if (matter == null) {
                        return null;
                    }
                    parentArtifactId = matter.getClientArtifactId();
                    queryCondition = "('Matter Name' == '" + this.encodeForQuery(matter.getName()) + "') AND ('Matter Number' == '" + this.encodeForQuery(matter.getNumber()) + "')";
                }
                if (parentArtifactId != null) break;
                return null;
            }
            case SEARCH_INDEX: {
                if (filterParameterValue != null) {
                    workspaceArtifactId = Long.parseLong(filterParameterValue);
                }
                queryCondition = "'Type' == 'dtSearch'";
                break;
            }
            case SEARCH: 
            case FOLDER: 
            case VIEW: 
            case FIELD: {
                if (filterParameterValue == null) break;
                workspaceArtifactId = Long.parseLong(filterParameterValue);
                break;
            }
        }
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setParentArtifactId(parentArtifactId).setWorkspaceArtifactId(workspaceArtifactId).setObjectType(relativityArtifactIdType).setCondition((String)queryCondition).setCacheKey(cacheKey).addFields("Name").build();
        return this.queryAllowedValueItems(query);
    }

    @Override
    public List<EligibleObject> queryResourcePools() throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setObjectTypeId(31L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public Long createArmRestore(ArmRestore restore) throws IOException {
        HashMap<String, ArmRestore> payload = new HashMap<String, ArmRestore>();
        payload.put("request", restore);
        String response = this.callApi("/Relativity.REST/api/relativity-arm/v1/restore-jobs", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public void deleteWorkspace(Long workspaceArtifactId) throws IOException {
        this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/" + workspaceArtifactId, "DELETE", new GenericType<String>(){});
    }

    @Override
    public RelativityLoginProfile getUserLoginProfile(Long userArtifactId) throws IOException {
        String response = this.callApi("/Relativity.REST/api/Relativity-Identity/v1/users/" + userArtifactId + "/login-profile", "GET", new GenericType<String>(){});
        return (RelativityLoginProfile)this.gson.fromJson(response, RelativityLoginProfile.class);
    }

    @Override
    public void setUserLoginProfile(RelativityLoginProfile loginProfile, Long userArtifactId) throws IOException {
        HashMap<String, RelativityLoginProfile> payload = new HashMap<String, RelativityLoginProfile>();
        payload.put("profile", loginProfile);
        this.callApi("/Relativity.REST/api/Relativity-Identity/v1/users/" + userArtifactId + "/login-profile", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public Map<Long, String> sendEmailInvitationLink(Set<Long> userArtifactIds) throws IOException {
        HashMap<String, Set<Long>> payload = new HashMap<String, Set<Long>>();
        payload.put("userIDList", userArtifactIds);
        String response = this.callApi("/Relativity.REST/api/Relativity-Identity/v1/users/bulk-invitation", "POST", payload, new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        boolean successful = object.get("Success").getAsBoolean();
        if (successful) {
            return null;
        }
        HashMap<Long, String> artifactIdErrorMap = new HashMap<Long, String>();
        JsonArray array = object.getAsJsonArray("Errors");
        array.forEach(error -> {
            JsonObject errorObject = error.getAsJsonObject();
            Long userArtifactId = errorObject.get("UserID").getAsLong();
            String exception = errorObject.get("Exception").getAsString();
            artifactIdErrorMap.put(userArtifactId, exception);
        });
        return artifactIdErrorMap;
    }

    @Override
    public List<EligibleObject> querySearchTermReports(String identifier, RelativityIdentifierType identifierType, Long workspaceArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setObjectTypeId(1000006L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public void runSearchTermsReport(Long workspaceArtifactId, Long searchTermsReportId, SearchTermReportRunType searchTermReportRunType) throws IOException {
        String runType = searchTermReportRunType == SearchTermReportRunType.RUN_ALL_TERMS ? "run-all-terms" : "run-pending-terms";
        this.callApi("/Relativity.REST/api/relativity-search-terms-report/v1/workspace/" + workspaceArtifactId + "/SearchTermsReport/" + searchTermsReportId + "/" + runType, "POST", new HashMap(), new GenericType<String>(){});
    }

    @Override
    public SearchTermReportProgress getSearchTermReportProgress(Long workspaceArtifactId, Long searchTermsReportId) throws IOException {
        String response = this.callApi("/Relativity.REST/api/relativity-search-terms-report/v1/workspace/" + workspaceArtifactId + "/SearchTermsReport/" + searchTermsReportId + "/get-progress", "POST", new HashMap(), new GenericType<String>(){});
        return (SearchTermReportProgress)this.gson.fromJson(response, SearchTermReportProgress.class);
    }

    @Override
    public String getSearchTermResults(Long workspaceArtifactId, Long searchTermsReportId) throws IOException {
        String[] fields;
        String response = this.callApi("/Relativity.REST/api/relativity-search-terms-report/v1/workspace/" + workspaceArtifactId + "/SearchTermsReport/" + searchTermsReportId + "/get-results-url", "POST", new HashMap(), new GenericType<String>(){});
        String customPageUrl = (String)this.gson.fromJson(response, String.class);
        Long viewArtifactId = null;
        for (String field : fields = customPageUrl.split("&")) {
            if (!field.startsWith("ViewID=")) continue;
            viewArtifactId = Long.parseLong(field.split("=")[1]);
            break;
        }
        if (viewArtifactId == null) {
            LOGGER.error("Unable to retrieve view artifact ID from results URL, " + customPageUrl);
            return "";
        }
        HashMap payload = new HashMap();
        HashMap<String, Object> request = new HashMap<String, Object>();
        payload.put("request", request);
        request.put("artifactTypeId", 1000007L);
        request.put("databaseTokenRequired", false);
        HashMap<String, Object> query = new HashMap<String, Object>();
        request.put("query", query);
        query.put("condition", "((('SearchTermsReport' == OBJECT " + searchTermsReportId + ")))");
        query.put("executingViewId", viewArtifactId);
        query.put("relationalField", null);
        query.put("rowCondition", "");
        query.put("sampleParameters", null);
        query.put("searchProviderCondition", null);
        query.put("sorts", new ArrayList());
        String massOperationQueryResponse = this.callApi("/Relativity.Rest/API/MassOperation/v1/MassOperationManager/workspace/" + workspaceArtifactId + "/CreateMassProcessTables", "POST", payload, new GenericType<String>(){});
        JsonObject obj = (JsonObject)this.gson.fromJson(massOperationQueryResponse, JsonObject.class);
        Long processId = obj.get("ProcessID").getAsLong();
        HashMap payloadPublish = new HashMap();
        HashMap<String, Object> requestPublish = new HashMap<String, Object>();
        payloadPublish.put("request", requestPublish);
        requestPublish.put("artifactTypeID", 1000007L);
        requestPublish.put("escapeFormulas", false);
        requestPublish.put("exportEncodingType", 65001);
        requestPublish.put("exportFileFormat", 0);
        requestPublish.put("hasRank", false);
        requestPublish.put("massProcessID", processId);
        requestPublish.put("viewFields", new ArrayList());
        requestPublish.put("viewID", viewArtifactId);
        return this.callApi("/Relativity.REST/api/MassOperation/v1/MassOperationManager/workspace/" + workspaceArtifactId + "/PublishMassExportToFileJobRequest", "POST", payloadPublish, new GenericType<String>(){});
    }

    @Override
    public List<String> getSearchTermViewFields(Long workspaceArtifactId, Long viewId) throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-data-visualization/v1/workspaces/" + workspaceArtifactId + "/views/" + viewId, "GET", new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonObject fields = object.get("Fields").getAsJsonObject();
        JsonArray viewableItems = fields.get("ViewableItems").getAsJsonArray();
        ArrayList<String> headers = new ArrayList<String>();
        viewableItems.forEach(item -> headers.add(item.getAsJsonObject().get("Name").getAsString()));
        return headers;
    }

    private String queryWorkspaceDocumentsObjectManager(Long workspaceArtifactId, int start, int length) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap<String, Cloneable> request = new HashMap<String, Cloneable>();
        payload.put("request", request);
        HashMap<String, String> objectType = new HashMap<String, String>();
        request.put("ObjectType", objectType);
        objectType.put("Name", "Document");
        ArrayList fields = new ArrayList();
        request.put("Fields", fields);
        HashMap<String, String> field = new HashMap<String, String>();
        fields.add(field);
        field.put("Name", "Relativity Text Identifier");
        request.put("Condition", null);
        payload.put("start", Integer.valueOf(start));
        payload.put("length", Integer.valueOf(length));
        return this.callApi("/Relativity.Rest/api/Relativity.ObjectManager/v1/workspace/" + workspaceArtifactId + "/object/query", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public Set<String> getWorkspaceDocumentIds(Long workspaceArtifactId) throws IOException {
        HashSet<String> documentIdNames = new HashSet<String>();
        int start = 1;
        int receivedResults = 0;
        while (true) {
            String response = this.queryWorkspaceDocumentsObjectManager(workspaceArtifactId, start, PAGE_SIZE);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("FieldValues");
                documentIdNames.add(fieldValuesArray.get(0).getAsJsonObject().get("Value").getAsString());
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            start += objectsArray.size();
        }
        return documentIdNames;
    }

    @Override
    public List<EligibleObject> querySearchesForWorkspace(Long workspaceArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(15L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public SavedSearchDetails readSavedSearchNoCondition(Long workspaceArtifactId, Long savedSearchArtifactId) throws IOException {
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("searchArtifactID", savedSearchArtifactId);
        SavedSearchDetails details = new SavedSearchDetails();
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Search.ISearchModule/Keyword%20Search%20Manager/ReadSingleAsync", "POST", payload, new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        String name = object.get("Name").getAsString();
        details.setName(name);
        ArrayList<String> fields = new ArrayList<String>();
        JsonArray jsonFieldsArray = object.get("Fields").getAsJsonArray();
        jsonFieldsArray.forEach(field -> {
            JsonObject fieldObject = field.getAsJsonObject();
            String fieldName = fieldObject.get("Name").getAsString();
            if (fieldName.equals("FileIcon")) {
                fieldName = "File Icon";
            }
            fields.add(fieldName);
        });
        details.setFieldNames(fields);
        ArrayList<String> sorts = new ArrayList<String>();
        JsonArray jsonSorts = object.get("Sorts").getAsJsonArray();
        jsonSorts.forEach(sort -> {
            JsonObject sortObject = sort.getAsJsonObject();
            String sortDirection = sortObject.get("Direction").getAsString();
            JsonObject fieldIdentifierObject = sortObject.get("FieldIdentifier").getAsJsonObject();
            String fieldName = fieldIdentifierObject.get("Name").getAsString();
            sorts.add(fieldName + " [" + sortDirection + "]");
        });
        details.setSortingFields(sorts);
        return details;
    }

    @Override
    public SavedSearchDetails readSavedSearch(Long workspaceArtifactId, Long savedSearchArtifactId, Map<Long, String> absoluteContainerPaths, boolean generateQuery) throws IOException {
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("searchArtifactID", savedSearchArtifactId);
        SavedSearchDetails details = new SavedSearchDetails();
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Search.ISearchModule/Keyword%20Search%20Manager/ReadSingleAsync", "POST", payload, new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        String name = object.get("Name").getAsString();
        details.setName(name);
        JsonObject container = object.get("SearchContainer").getAsJsonObject();
        Long folderArtifactId = container.get("ArtifactID").getAsLong();
        details.setFolder(absoluteContainerPaths.get(folderArtifactId));
        details.setSavedSearchQuery("");
        if (generateQuery) {
            JsonObject searchCriteria = object.get("SearchCriteria").getAsJsonObject();
            StringBuilder savedSearchQuery = new StringBuilder();
            JsonArray conditions = searchCriteria.get("Conditions").getAsJsonArray();
            this.handleConditions(conditions, savedSearchQuery);
            details.setSavedSearchQuery(savedSearchQuery.toString());
        }
        ArrayList<String> fields = new ArrayList<String>();
        JsonArray jsonFieldsArray = object.get("Fields").getAsJsonArray();
        jsonFieldsArray.forEach(field -> {
            JsonObject fieldObject = field.getAsJsonObject();
            String fieldName = fieldObject.get("Name").getAsString();
            if (fieldName.equals("FileIcon")) {
                fieldName = "File Icon";
            }
            fields.add(fieldName);
        });
        details.setFieldNames(fields);
        ArrayList<String> sorts = new ArrayList<String>();
        JsonArray jsonSorts = object.get("Sorts").getAsJsonArray();
        jsonSorts.forEach(sort -> {
            JsonObject sortObject = sort.getAsJsonObject();
            String sortDirection = sortObject.get("Direction").getAsString();
            JsonObject fieldIdentifierObject = sortObject.get("FieldIdentifier").getAsJsonObject();
            String fieldName = fieldIdentifierObject.get("Name").getAsString();
            sorts.add(fieldName + " [" + sortDirection + "]");
        });
        details.setSortingFields(sorts);
        String scope = object.get("Scope").getAsString();
        if (scope.equals("Folders")) {
            details.setScope(SavedSearchScope.FOLDER);
        } else if (scope.equals("Subfolders")) {
            details.setScope(SavedSearchScope.SUB_FOLDERS);
        } else {
            details.setScope(SavedSearchScope.WORKSPACE);
        }
        if (details.getScope() == SavedSearchScope.FOLDER || details.getScope() == SavedSearchScope.SUB_FOLDERS) {
            ArrayList<Long> folderArtifactIds = new ArrayList<Long>();
            JsonArray searchFolders = object.getAsJsonArray("SearchFolders");
            searchFolders.forEach(item -> folderArtifactIds.add(item.getAsJsonObject().get("ArtifactID").getAsLong()));
            List<String> scopeFolderPaths = this.getFolderPaths(workspaceArtifactId, folderArtifactIds);
            details.setScopeFolders(scopeFolderPaths);
        } else {
            details.setScopeFolders(new ArrayList<String>());
        }
        return details;
    }

    @Override
    public SavedSearchDetails readSavedSearch(Long workspaceArtifactId, Long savedSearchArtifactId, Map<Long, String> absoluteContainerPaths) throws IOException {
        return this.readSavedSearch(workspaceArtifactId, savedSearchArtifactId, absoluteContainerPaths, true);
    }

    private void handleConditions(JsonArray conditions, StringBuilder query) {
        for (int i = 0; i < conditions.size(); ++i) {
            JsonObject condition = conditions.get(i).getAsJsonObject();
            boolean isCondition = condition.has("Condition");
            if (isCondition) {
                this.handleCondition(condition.getAsJsonObject("Condition"), query);
            } else {
                query.append("(");
                this.handleConditions(condition.getAsJsonArray("Conditions"), query);
                query.append(")");
            }
            BooleanConditionOperator operator = BooleanConditionOperator.fromRelativityName(condition.get("BooleanOperator").getAsString());
            if (operator == BooleanConditionOperator.NONE) continue;
            query.append(" ").append(operator.getOperator()).append(" ");
        }
    }

    private void handleCondition(JsonObject condition, StringBuilder query) {
        CriteriaOperator operator = CriteriaOperator.fromRelativityName(condition.get("Operator").getAsString());
        String fieldName = condition.get("FieldIdentifier").getAsJsonObject().get("Name").getAsString();
        boolean notOperator = condition.get("NotOperator").getAsBoolean();
        if (fieldName.equals("(Saved Search)")) {
            fieldName = "Saved Search";
        }
        query.append("[").append(fieldName).append("] ").append(CriteriaOperator.toQueryString(operator, notOperator));
        if (condition.get("Value").isJsonArray()) {
            JsonArray values = condition.getAsJsonArray("Value");
            if (operator == CriteriaOperator.BETWEEN) {
                query.append(" ").append(values.get(0).getAsString()).append(" - ").append(values.get(1).getAsString());
            } else if (operator == CriteriaOperator.IS && condition.get("ConditionType").getAsString().equals("CriteriaDate")) {
                String date = values.get(0).getAsString().split("T")[0];
                query.append(" ").append(date);
            } else {
                CharSequence[] arr = new String[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    arr[i] = values.get(i).getAsString();
                }
                query.append(" [").append(String.join((CharSequence)",", arr)).append("]");
            }
        } else if (condition.get("Value").isJsonObject()) {
            if (condition.get("Value").getAsJsonObject().has("Conditions")) {
                query.append(" ").append("{");
                this.handleConditions(condition.get("Value").getAsJsonObject().getAsJsonArray("Conditions"), query);
                query.append("}");
            }
        } else {
            String value;
            String string = value = operator != CriteriaOperator.IS_SET ? condition.get("Value").getAsString() : "";
            if (condition.get("ConditionType").getAsString().equals("CriteriaDate")) {
                switch (value) {
                    case "MonthOf": {
                        value = condition.get("Month").getAsString();
                        break;
                    }
                    case "ThisWeek": {
                        value = "this week";
                        break;
                    }
                    case "ThisMonth": {
                        value = "this month";
                        break;
                    }
                    case "NextWeek": {
                        value = "next week";
                        break;
                    }
                    case "LastWeek": {
                        value = "last week";
                        break;
                    }
                    case "Last30Days": {
                        value = "the last 30 days";
                        break;
                    }
                    case "Last7Days": {
                        value = "the last 7 days";
                    }
                }
                query.append(" ").append(value);
            } else if (!value.equals("")) {
                query.append(" \"").append(value).append("\"");
            }
        }
    }

    private String queryFieldsForObject(String objectTypeName, Long workspaceArtifactId) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        HashMap<String, Object> request = new HashMap<String, Object>();
        payload.put("request", request);
        HashMap<String, Long> objectType = new HashMap<String, Long>();
        request.put("ObjectType", objectType);
        objectType.put("ArtifactTypeID", 14L);
        ArrayList<Object> fields = new ArrayList<Object>();
        request.put("Fields", fields);
        fields.add(this.addField("Name"));
        fields.add(this.addField("Field Type"));
        fields.add(this.addField("ArtifactID"));
        request.put("Condition", "((('Object Type' IN ['" + objectTypeName + "'])))");
        payload.put("start", Integer.valueOf(1));
        payload.put("length", Integer.valueOf(PAGE_SIZE));
        String workspaceArtifact = workspaceArtifactId == null ? "-1" : String.valueOf(workspaceArtifactId);
        return this.callApi("/Relativity.Rest/api/Relativity.ObjectManager/v1/workspace/" + workspaceArtifact + "/object/query", "POST", payload, new GenericType<String>(){});
    }

    public Object addField(String field) {
        HashMap<String, String> fieldObject = new HashMap<String, String>();
        fieldObject.put("Name", field);
        return fieldObject;
    }

    public Object addSorts(SavedSearchSortField sortField, int index) {
        HashMap<String, Object> sortObject = new HashMap<String, Object>();
        sortObject.put("Order", index);
        sortObject.put("Direction", sortField.getDirection());
        HashMap<String, String> fieldIdentifier = new HashMap<String, String>();
        fieldIdentifier.put("Name", sortField.getName());
        sortObject.put("FieldIdentifier", fieldIdentifier);
        return sortObject;
    }

    @Override
    public Map<String, DocumentField> getDocumentSavedSearchFields(Long workspaceArtifactId) throws IOException {
        String response = this.queryFieldsForObject("Document", workspaceArtifactId);
        HashMap<String, DocumentField> documentFieldMap = new HashMap<String, DocumentField>();
        JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonArray objectsArray = results.getAsJsonArray("Objects");
        for (JsonElement element : objectsArray) {
            JsonObject arrayObject = element.getAsJsonObject();
            JsonArray fieldValuesArray = arrayObject.getAsJsonArray("FieldValues");
            DocumentField documentField = new DocumentField();
            fieldValuesArray.forEach(field -> {
                String fieldName = field.getAsJsonObject().get("Field").getAsJsonObject().get("Name").getAsString();
                if (fieldName.equals("Name")) {
                    documentField.setName(field.getAsJsonObject().get("Value").getAsString());
                } else if (fieldName.equals("Field Type")) {
                    String fieldType = field.getAsJsonObject().get("Value").getAsString();
                    fieldType = fieldType.replace(" ", "").replace("-", "").replace("/", "");
                    documentField.setFieldType(RelativityFieldValueType.fromRelativityName(fieldType));
                } else if (fieldName.equals("Artifact ID")) {
                    Long artifactId = field.getAsJsonObject().get("Value").getAsLong();
                    documentField.setArtifactId(artifactId);
                }
            });
            documentFieldMap.put(documentField.getName(), documentField);
        }
        documentFieldMap.put("Saved Search", new DocumentField("Saved Search", 0L, RelativityFieldValueType.SAVED_SEARCH));
        documentFieldMap.put("(Saved Search)", new DocumentField("(Saved Search)", 0L, RelativityFieldValueType.SAVED_SEARCH));
        return documentFieldMap;
    }

    @Override
    public Long createSavedSearch(Long workspaceArtifactId, CriteriaCollection searchCriteria, SavedSearchRequest search) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactId", workspaceArtifactId);
        HashMap<String, Object> searchDto = new HashMap<String, Object>();
        payload.put("searchDTO", searchDto);
        searchDto.put("ArtifactTypeID", 10);
        searchDto.put("Name", search.getName());
        searchDto.put("SearchCriteria", searchCriteria);
        if (search.getScope() == SavedSearchScope.FOLDER) {
            searchDto.put("Scope", "Folders");
        } else if (search.getScope() == SavedSearchScope.SUB_FOLDERS) {
            searchDto.put("Scope", "Subfolders");
        } else {
            searchDto.put("Scope", "EntireCase");
        }
        ArrayList<Object> fields = new ArrayList<Object>();
        for (String fieldName : search.getFields()) {
            if (fieldName.equals("Saved Search") || fieldName.equals("(Saved Search)")) continue;
            fields.add(this.addField(fieldName));
        }
        if (fields.size() == 0) {
            fields.add(this.addField("Edit"));
            fields.add(this.addField("File Icon"));
            fields.add(this.addField("Control Number"));
        }
        searchDto.put("Fields", fields);
        if (search.getSortingFields() != null && search.getSortingFields().size() > 0) {
            ArrayList<Object> sorts = new ArrayList<Object>();
            for (int i = 0; i < search.getSortingFields().size(); ++i) {
                sorts.add(this.addSorts(search.getSortingFields().get(i), i));
            }
            searchDto.put("Sorts", sorts);
        }
        if (search.getScopeFolderArtifactIds() != null && search.getScopeFolderArtifactIds().size() > 0) {
            ArrayList artifactIds = new ArrayList();
            searchDto.put("SearchFolders", artifactIds);
            for (Long artifactId : search.getScopeFolderArtifactIds()) {
                HashMap<String, Long> scope = new HashMap<String, Long>();
                scope.put("ArtifactID", artifactId);
                artifactIds.add(scope);
            }
        }
        String serializedPayload = this.gson.toJson(payload);
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Search.ISearchModule/Keyword%20Search%20Manager/CreateSingleAsync", "POST", serializedPayload, new GenericType<String>(){}, true);
        return Long.parseLong(response);
    }

    @Override
    public List<EligibleObject> querySearchContainersForWorkspace(Long workspaceArtifactId) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("expandedNodes", new ArrayList<Integer>(){
            {
                this.add(0);
            }
        });
        String response = this.callApi("/Relativity.Rest/API/Relativity.Services.Search.ISearchModule/Search%20Container%20Manager/GetSearchContainerTreeAsync", "POST", payload, new GenericType<String>(){});
        ArrayList<EligibleObject> containers = new ArrayList<EligibleObject>();
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonArray array = object.getAsJsonArray("SearchContainerItems");
        for (JsonElement element : array) {
            JsonObject searchContainer = element.getAsJsonObject().get("SearchContainer").getAsJsonObject();
            EligibleObject o = new EligibleObject();
            o.setName(searchContainer.get("Name").getAsString());
            o.setArtifactId(searchContainer.get("ArtifactID").getAsLong());
            containers.add(o);
        }
        return containers;
    }

    @Override
    public void moveSavedSearch(Long workspaceArtifactId, Long folderArtifactId, Long savedSearchArtifactId) throws IOException {
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("artifactID", savedSearchArtifactId);
        payload.put("destinationContainerID", folderArtifactId);
        this.callApi("/Relativity.REST/api/Relativity.Services.Search.ISearchModule/Keyword%20Search%20Manager/MoveAsync", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public List<WorkspaceObjectType> queryObjectTypes(Long workspaceArtifactId) throws IOException {
        ArrayList<WorkspaceObjectType> objectTypes = new ArrayList<WorkspaceObjectType>();
        int start = 1;
        int receivedResults = 0;
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("Name");
        fields.add("Artifact Type ID");
        while (true) {
            String response = this.queryObjectManager(25L, workspaceArtifactId, null, start, PAGE_SIZE, fields);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("FieldValues");
                WorkspaceObjectType objectType = new WorkspaceObjectType();
                objectType.setName(fieldValuesArray.get(0).getAsJsonObject().get("Value").getAsString());
                objectType.setArtifactTypeId(fieldValuesArray.get(1).getAsJsonObject().get("Value").getAsLong());
                objectType.setArtifactId(arrayObject.get("ArtifactID").getAsLong());
                objectTypes.add(objectType);
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            start += objectsArray.size();
        }
        return objectTypes;
    }

    @Override
    public Map<Long, ItemLevelPermissionObject> getItemLevelObjectsForObjectType(Long artifactTypeId, Long workspaceArtifactId) throws IOException {
        String field = "Name";
        if (artifactTypeId == 10L) {
            field = "Control Number";
        }
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(artifactTypeId).addFields(field).build();
        return this.queryItemLevelPermissionObjects(query);
    }

    private Map<Long, ItemLevelPermissionObject> queryItemLevelPermissionObjects(ObjectManagerQuery query) throws IOException {
        HashMap<Long, ItemLevelPermissionObject> itemLevelObjectPermissions = new HashMap<Long, ItemLevelPermissionObject>();
        int receivedResults = 0;
        ObjectManagerQueryRequest request = new ObjectManagerQueryRequest(query, 1, PAGE_SIZE);
        while (true) {
            String response = this.queryObjectManager(request);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("FieldValues");
                ItemLevelPermissionObject item = new ItemLevelPermissionObject();
                item.setName(fieldValuesArray.get(0).getAsJsonObject().get("Value").getAsString());
                item.setArtifactId(arrayObject.get("ArtifactID").getAsLong());
                itemLevelObjectPermissions.put(item.getArtifactId(), item);
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            request.setNextPage(objectsArray.size());
        }
        return itemLevelObjectPermissions;
    }

    private Map<Long, Boolean> getItemLevelSecurityMap(Long workspaceArtifactId, Set<Long> artifactIds) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("artifactIDs", artifactIds);
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/GetItemLevelSecurityListAsync", "POST", payload, new GenericType<String>(){});
        JsonObject itemLevelObjectSecurityList = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        HashMap<Long, Boolean> itemLevelSecurityMap = new HashMap<Long, Boolean>();
        for (Long artifactId : artifactIds) {
            String key = String.valueOf(artifactId);
            if (itemLevelObjectSecurityList.get(key).isJsonNull()) continue;
            Boolean isItemLevelSecurityEnabled = itemLevelObjectSecurityList.getAsJsonObject(key).get("Enabled").getAsBoolean();
            itemLevelSecurityMap.put(artifactId, isItemLevelSecurityEnabled);
        }
        return itemLevelSecurityMap;
    }

    @Override
    public Map<Long, Boolean> getItemLevelSecurity(Long workspaceArtifactId, Set<Long> artifactIds) throws IOException {
        if (artifactIds != null && artifactIds.size() > 500) {
            HashMap<Long, Boolean> results = new HashMap<Long, Boolean>();
            HashSet<Long> subSet = new HashSet<Long>();
            for (Long artifactId : artifactIds) {
                subSet.add(artifactId);
                if (subSet.size() < 500) continue;
                results.putAll(this.getItemLevelSecurityMap(workspaceArtifactId, subSet));
                subSet.clear();
            }
            if (subSet.size() > 0) {
                results.putAll(this.getItemLevelSecurityMap(workspaceArtifactId, subSet));
            }
            return results;
        }
        return this.getItemLevelSecurityMap(workspaceArtifactId, artifactIds);
    }

    @Override
    public RelativityItemLevelSecurity getItemLevelSecurity(Long artifactId, Long workspaceArtifactId) throws IOException {
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("ArtifactID", artifactId);
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/GetItemLevelSecurityAsync", "POST", payload, new GenericType<String>(){});
        return (RelativityItemLevelSecurity)this.gson.fromJson(response, RelativityItemLevelSecurity.class);
    }

    @Override
    public void setItemLevelSecurity(Long artifactId, Long workspaceArtifactId, boolean enabled) throws IOException {
        RelativityItemLevelSecurity itemLevelSecurity = this.getItemLevelSecurity(artifactId, workspaceArtifactId);
        if (itemLevelSecurity == null || itemLevelSecurity != null && itemLevelSecurity.isEnabled() == enabled) {
            return;
        }
        itemLevelSecurity.setEnabled(enabled);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("itemLevelSecurity", itemLevelSecurity);
        this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/SetItemLevelSecurityAsync", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public WorkspaceGroupPermissions getItemPermissions(Long artifactId, Long groupArtifactId, Long workspaceArtifactId) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("ArtifactID", artifactId);
        HashMap<String, Long> group = new HashMap<String, Long>();
        payload.put("group", group);
        group.put("ArtifactID", groupArtifactId);
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/GetItemGroupPermissionsAsync", "POST", payload, new GenericType<String>(){});
        WorkspaceGroupPermissions workspaceGroupPermissions = (WorkspaceGroupPermissions)this.gson.fromJson(response, WorkspaceGroupPermissions.class);
        return workspaceGroupPermissions;
    }

    @Override
    public void setItemPermissions(Long artifactId, Long workspaceArtifactId, WorkspaceGroupPermissions permissions) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("artifactID", artifactId);
        payload.put("groupPermissions", permissions);
        this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/SetItemGroupPermissionsAsync", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public Map<Long, ItemLevelPermissionObject> getObjectsForTypeWithPermissions(String typeName, Long workspaceArtifactId, Long groupArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeName(typeName).addFields("Name").build();
        return this.handleObjectsForType(query, workspaceArtifactId, groupArtifactId);
    }

    @Override
    public Map<Long, ItemLevelPermissionObject> getObjectsForTypeWithPermissions(Long typeId, Long workspaceArtifactId, Long groupArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(typeId).addFields("Name").build();
        return this.handleObjectsForType(query, workspaceArtifactId, groupArtifactId);
    }

    @Override
    public Map<Long, ItemLevelPermissionInfo> getItemLevelPermissionInfo(Long workspaceArtifactId, Long typeId, String typeName) throws IOException {
        String field = "Name";
        if (typeId == 10L) {
            field = "Control Number";
        }
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(typeId).setObjectTypeName(typeName).addFields(field).build();
        Map<Long, ItemLevelPermissionObject> result = this.queryItemLevelPermissionObjects(query);
        Map<Long, Boolean> itemLevelSecurity = this.getItemLevelSecurity(workspaceArtifactId, result.keySet());
        HashMap<Long, ItemLevelPermissionInfo> infos = new HashMap<Long, ItemLevelPermissionInfo>();
        for (Map.Entry<Long, Boolean> entry : itemLevelSecurity.entrySet()) {
            ItemLevelPermissionObject itemObject = result.get(entry.getKey());
            if (itemObject == null) continue;
            infos.put(itemObject.getArtifactId(), new ItemLevelPermissionInfo(itemObject, entry.getValue()));
        }
        return infos;
    }

    private Map<Long, ItemLevelPermissionObject> handleObjectsForType(ObjectManagerQuery query, Long workspaceArtifactId, Long groupArtifactId) throws IOException {
        Map<Long, ItemLevelPermissionObject> result = this.queryItemLevelPermissionObjects(query);
        Map<Long, Boolean> itemLevelSecurity = this.getItemLevelSecurity(workspaceArtifactId, result.keySet());
        for (Map.Entry<Long, Boolean> itemSecurity : itemLevelSecurity.entrySet()) {
            WorkspaceGroups itemGroups = this.getItemGroups(itemSecurity.getKey(), workspaceArtifactId, true);
            for (WorkspaceGroup group : itemGroups.getWorkspaceGroups()) {
                GroupPermission groupPermission = new GroupPermission();
                result.get(itemSecurity.getKey()).getGroupPermissions().add(groupPermission);
                groupPermission.setGroupId(group.getArtifactId());
                groupPermission.setGroupName(group.getName());
                if (itemSecurity.getValue().booleanValue()) {
                    try {
                        WorkspaceGroupPermissions itemPermissions = this.getItemPermissions(itemSecurity.getKey(), groupArtifactId, workspaceArtifactId);
                        groupPermission.setOverwrittenPermissions(itemPermissions);
                    }
                    catch (Exception e) {
                        groupPermission.setOverwrittenPermissions(null);
                    }
                    continue;
                }
                groupPermission.setOverwrittenPermissions(null);
            }
        }
        return result;
    }

    @Override
    public WorkspaceGroups getItemGroups(Long itemArtifactId, Long workspaceArtifactId, boolean onlyShowEnabledGroups) throws IOException {
        WorkspaceGroups groups = new WorkspaceGroups();
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("artifactID", itemArtifactId);
        String response = this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/GetItemGroupSelectorAsync", "POST", payload, new GenericType<String>(){});
        JsonObject obj = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        String lastModified = obj.get("LastModified").getAsString();
        groups.setLastModified(lastModified);
        if (!onlyShowEnabledGroups) {
            JsonArray disabledGroups = obj.getAsJsonArray("DisabledGroups");
            disabledGroups.forEach(item -> {
                JsonObject group = item.getAsJsonObject();
                Long artifactId = group.get("ArtifactID").getAsLong();
                String name = group.get("Name").getAsString();
                groups.getWorkspaceGroups().add(new WorkspaceGroup(name, artifactId, false));
            });
        }
        JsonArray enabledGroups = obj.getAsJsonArray("EnabledGroups");
        enabledGroups.forEach(item -> {
            JsonObject group = item.getAsJsonObject();
            Long artifactId = group.get("ArtifactID").getAsLong();
            String name = group.get("Name").getAsString();
            groups.getWorkspaceGroups().add(new WorkspaceGroup(name, artifactId, true));
        });
        return groups;
    }

    @Override
    public void setItemGroups(Long itemArtifactId, Long workspaceArtifactId, WorkspaceGroups groups) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("artifactID", itemArtifactId);
        HashMap<String, Object> groupSelector = new HashMap<String, Object>();
        payload.put("groupSelector", groupSelector);
        groupSelector.put("LastModified", groups.getLastModified());
        ArrayList disabledGroups = new ArrayList();
        ArrayList enabledGroups = new ArrayList();
        groupSelector.put("DisabledGroups", disabledGroups);
        groupSelector.put("EnabledGroups", enabledGroups);
        for (WorkspaceGroup workspaceGroup : groups.getWorkspaceGroups()) {
            HashMap<String, Long> artifactIdObject = new HashMap<String, Long>();
            artifactIdObject.put("ArtifactID", workspaceGroup.getArtifactId());
            if (workspaceGroup.getEnabled().booleanValue()) {
                enabledGroups.add(artifactIdObject);
                continue;
            }
            disabledGroups.add(artifactIdObject);
        }
        this.callApi("/Relativity.REST/api/Relativity.Services.Permission.IPermissionModule/Permission%20Manager/AddRemoveItemGroupsAsync", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public boolean workspaceContainsGroup(Long workspaceArtifactId, RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(3L).addFields("*").build();
        List<EligibleObject> eligibleGroups = this.queryEligibleObjects(query);
        return RelativityUtils.getInstance().filterEligibleObject(identifier, identifierType, eligibleGroups, RelativityFieldType.GROUP) != null;
    }

    @Override
    public GenericRelativityApiCallResponse callGenericApi(String location, Verb verb, Object payload) throws IOException {
        if (verb != Verb.POST && verb != Verb.PUT) {
            return this.callApi(location, verb.name(), new GenericType<GenericRelativityApiCallResponse>(){});
        }
        return this.callApi(location, verb.name(), payload, new GenericType<GenericRelativityApiCallResponse>(){});
    }

    @Override
    public GenericRelativityApiCallResponse callGenericApiEncoded(String location, Verb verb, String payload) throws IOException {
        if (verb != Verb.POST && verb != Verb.PUT) {
            return this.callApi(location, verb.name(), new GenericType<GenericRelativityApiCallResponse>(){});
        }
        return this.callApi(location, verb.name(), payload, new GenericType<GenericRelativityApiCallResponse>(){}, true);
    }

    @Override
    public void deleteSavedSearch(Long workspaceArtifactId, Long savedSearchArtifactId) throws IOException {
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("searchArtifactID", savedSearchArtifactId);
        this.callApi("/Relativity.REST/api/Relativity.Services.Search.ISearchModule/Keyword%20Search%20Manager/DeleteSingleAsync", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public List<EligibleObject> queryImagingSets(Long workspaceArtifactId, RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeName("Imaging Set").addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public ImagingSetStatus getImagingSetStatus(Long workspaceArtifactId, Long imagingSetArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/API/relativity-imaging/v1/workspaces/" + workspaceArtifactId + "/imaging-sets/" + imagingSetArtifactId + "/status", "GET", new GenericType<String>(){});
        return (ImagingSetStatus)this.gson.fromJson(response, ImagingSetStatus.class);
    }

    @Override
    public Long runImagingSet(Long workspaceArtifactId, Long imagingSetArtifactId, boolean qcEnabled) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Boolean> imagingSetRequest = new HashMap<String, Boolean>();
        payload.put("imagingSetRequest", imagingSetRequest);
        imagingSetRequest.put("QcEnabled", qcEnabled);
        String response = this.callApi("/Relativity.Rest/API/relativity-imaging/v1/workspaces/" + workspaceArtifactId + "/imaging-sets/" + imagingSetArtifactId + "/run", "POST", payload, new GenericType<String>(){});
        JsonObject o = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        return o.get("ImagingJobID").getAsLong();
    }

    @Override
    public void deleteRelativityIndex(Long workspaceArtifactId, Long indexArtifactId, RelativityIndexType indexType) throws IOException {
        if (indexType == RelativityIndexType.DT_SEARCH) {
            this.callApi("/Relativity.Rest/API/relativity-dtsearch/v1/workspaces/" + workspaceArtifactId + "/dtsearch-indexes/" + indexArtifactId + "/delete-index", "DELETE", new GenericType<String>(){});
        } else {
            this.callApi("/Relativity.REST/API/" + indexType.getRelativityType() + "/v1/workspaces/" + workspaceArtifactId + "/indexes/" + indexArtifactId, "DELETE", new GenericType<String>(){});
        }
    }

    @Override
    public Map<RelativityIndexType, List<EligibleObject>> queryAnalyticIndexes(Long workspaceArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeName("Analytics Index").addFields("Name", "Index Type").build();
        ObjectManagerQueryRequest request = new ObjectManagerQueryRequest(query, 1, PAGE_SIZE);
        HashMap<RelativityIndexType, List<EligibleObject>> analyticIndexes = new HashMap<RelativityIndexType, List<EligibleObject>>();
        analyticIndexes.put(RelativityIndexType.CLASSIFICATION, new ArrayList());
        analyticIndexes.put(RelativityIndexType.CONCEPTUAL, new ArrayList());
        int receivedResults = 0;
        while (true) {
            String response = this.queryObjectManager(request);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                JsonArray fieldValuesArray = arrayObject.getAsJsonArray("FieldValues");
                EligibleObject index = new EligibleObject();
                index.setName(fieldValuesArray.get(0).getAsJsonObject().get("Value").getAsString());
                index.setArtifactId(arrayObject.get("ArtifactID").getAsLong());
                String indexType = fieldValuesArray.get(1).getAsJsonObject().get("Value").getAsJsonObject().get("Name").getAsString();
                if (indexType.equals("Conceptual")) {
                    ((List)analyticIndexes.get((Object)RelativityIndexType.CONCEPTUAL)).add(index);
                    continue;
                }
                if (!indexType.equals("Classification")) continue;
                ((List)analyticIndexes.get((Object)RelativityIndexType.CLASSIFICATION)).add(index);
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            request.setNextPage(objectsArray.size());
        }
        return analyticIndexes;
    }

    @Override
    public EligibleObject getWorkspaceResourcePoolArtifactId(Long workspaceArtifactId) throws IOException {
        String response = this.callApi("/Relativity.Rest/API/Relativity.Workspaces/workspace/" + workspaceArtifactId, "GET", new GenericType<String>(){});
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonObject resourcePoolJson = object.get("ResourcePool").getAsJsonObject().get("Value").getAsJsonObject();
        EligibleObject resourcePool = new EligibleObject();
        resourcePool.setArtifactId(resourcePoolJson.get("ArtifactID").getAsLong());
        resourcePool.setName(resourcePoolJson.get("Name").getAsString());
        return resourcePool;
    }

    @Override
    public long createAnalyticIndex(Long workspaceArtifactId, AnalyticIndexRequest index, RelativityIndexType indexType) throws IOException {
        HashMap<String, AnalyticIndexRequest> payload = new HashMap<String, AnalyticIndexRequest>();
        payload.put("index", index);
        String response = this.callApi("/Relativity.REST/API/" + indexType.getRelativityType() + "/v1/workspaces/" + workspaceArtifactId + "/indexes", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public List<EligibleObject> queryRepeatedFilters(Long workspaceArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeName("Repeated Content Filter").addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    private String queryWorkspacesForGroup(Long groupArtifactId, int start, int length) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("start", Integer.valueOf(start));
        payload.put("length", Integer.valueOf(length));
        HashMap request = new HashMap();
        payload.put("request", request);
        request.put("Condition", null);
        ArrayList<Object> fields = new ArrayList<Object>();
        request.put("Fields", fields);
        fields.add(this.addField("Name"));
        return this.callApi("/Relativity.Rest/API/relativity-environment/v1/workspace/query-by-group/" + groupArtifactId, "POST", payload, new GenericType<String>(){});
    }

    @Override
    public Set<Long> queryWorkspacesAssociatedWithGroup(Long groupArtifactId) throws IOException {
        HashSet<Long> workspaceArtifactIds = new HashSet<Long>();
        int receivedResults = 0;
        int start = 1;
        while (true) {
            String response = this.queryWorkspacesForGroup(groupArtifactId, start, PAGE_SIZE);
            JsonObject results = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            long resultsTotalCount = results.get("TotalCount").getAsLong();
            JsonArray objectsArray = results.getAsJsonArray("Objects");
            for (JsonElement element : objectsArray) {
                JsonObject arrayObject = element.getAsJsonObject();
                workspaceArtifactIds.add(arrayObject.get("ArtifactID").getAsLong());
            }
            if ((long)(receivedResults += objectsArray.size()) >= resultsTotalCount) break;
            start += objectsArray.size();
        }
        return workspaceArtifactIds;
    }

    @Override
    public Map<Long, WorkspaceGroup> getWorkspaceGroupsWithArtifactIds(Long workspaceArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setObjectTypeName("Group").addFields("Name").build();
        List<EligibleObject> groups = this.queryEligibleObjects(query);
        HashMap<Long, WorkspaceGroup> groupsWithArtifactId = new HashMap<Long, WorkspaceGroup>();
        WorkspaceGroups workspaceGroups = this.getWorkspaceGroups(workspaceArtifactId);
        for (EligibleObject group : groups) {
            for (WorkspaceGroup workspaceGroup : workspaceGroups.getWorkspaceGroups()) {
                WorkspaceGroupPermissions workspaceGroupPermissions;
                if (workspaceGroup.getEnabled().booleanValue() && workspaceGroup.getArtifactId().equals(group.getArtifactId()) && workspaceGroup.getName().equals(group.getName())) {
                    groupsWithArtifactId.put(workspaceGroup.getArtifactId(), new WorkspaceGroup(workspaceGroup.getName(), group.getArtifactId(), true));
                    continue;
                }
                if (!workspaceGroup.getEnabled().booleanValue() || !workspaceGroup.getName().equals(group.getName()) || workspaceGroup.getArtifactId().equals(group.getArtifactId()) || (workspaceGroupPermissions = this.getWorkspaceGroupPermissions(workspaceArtifactId, group.getArtifactId())) == null) continue;
                Long groupId = (long)workspaceGroupPermissions.getGroupID();
                if (!workspaceGroup.getArtifactId().equals(groupId)) continue;
                groupsWithArtifactId.put(groupId, new WorkspaceGroup(workspaceGroup.getName(), group.getArtifactId(), true));
            }
        }
        return groupsWithArtifactId;
    }

    @Override
    public ImagingJobStopResult stopImagingJob(Long workspaceArtifactId, Long imagingJobArtifactId) throws IOException {
        HashMap payload = new HashMap();
        payload.put("stopImagingJobRequest", new HashMap());
        String response = this.callApi("/Relativity.Rest/API/relativity-imaging/v1/workspaces/" + workspaceArtifactId + "/jobs/" + imagingJobArtifactId + "/stop", "POST", payload, new GenericType<String>(){});
        return (ImagingJobStopResult)this.gson.fromJson(response, ImagingJobStopResult.class);
    }

    private void resolveParents(SearchContainer item, List<String> parents, Map<Long, SearchContainer> items) {
        if (item.getParentArtifactId() == null) {
            return;
        }
        parents.add(item.getName());
        this.resolveParents(items.get(item.getParentArtifactId()), parents, items);
    }

    private String querySubsetPaths(Long workspaceArtifactId, String queryToken, int start, int length) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("queryToken", queryToken);
        payload.put("length", length);
        payload.put("start", start);
        return this.callApi("/Relativity.Rest/API/Relativity.Services.Search.ISearchModule/Search%20Container%20Manager/QuerySubsetAsync", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public Map<Long, String> resolveSearchContainerPaths(Long workspaceArtifactId) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("query", new HashMap());
        payload.put("length", Integer.valueOf(PAGE_SIZE));
        String response = this.callApi("/Relativity.Rest/API/Relativity.Services.Search.ISearchModule/Search%20Container%20Manager/QueryAsync", "POST", payload, new GenericType<String>(){});
        HashMap<Long, String> resolvedFolderPaths = new HashMap<Long, String>();
        HashMap<Long, SearchContainer> results = new HashMap<Long, SearchContainer>();
        int receivedResults = 0;
        JsonObject searchContainerJson = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonArray searchContainers = searchContainerJson.getAsJsonArray("Results");
        receivedResults += searchContainers.size();
        String queryToken = searchContainerJson.get("QueryToken").getAsString();
        while (!queryToken.equals("")) {
            response = this.querySubsetPaths(workspaceArtifactId, queryToken, receivedResults + 1, PAGE_SIZE);
            JsonObject subset = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            JsonArray subSetResults = subset.getAsJsonArray("Results");
            receivedResults += subSetResults.size();
            searchContainers.addAll(subSetResults);
            queryToken = subset.get("QueryToken").getAsString();
        }
        searchContainers.forEach(container -> {
            JsonObject parentObject = container.getAsJsonObject().getAsJsonObject("Artifact").getAsJsonObject("ParentSearchContainer");
            String containerName = container.getAsJsonObject().getAsJsonObject("Artifact").get("Name").getAsString();
            long containerArtifactId = container.getAsJsonObject().getAsJsonObject("Artifact").get("ArtifactID").getAsLong();
            if (parentObject.get("Name").getAsString().equals(containerName)) {
                results.put(containerArtifactId, new SearchContainer(containerArtifactId, null, null));
            } else {
                results.put(containerArtifactId, new SearchContainer(containerArtifactId, containerName, parentObject.get("ArtifactID").getAsLong()));
            }
        });
        for (SearchContainer container2 : results.values()) {
            ArrayList<String> parents = new ArrayList<String>();
            this.resolveParents(container2, parents, results);
            if (parents.size() == 0) {
                if (container2.getName() == null) {
                    resolvedFolderPaths.put(container2.getArtifactId(), null);
                    continue;
                }
                resolvedFolderPaths.put(container2.getArtifactId(), container2.getName());
                continue;
            }
            Collections.reverse(parents);
            resolvedFolderPaths.put(container2.getArtifactId(), String.join((CharSequence)"\\", parents));
        }
        return resolvedFolderPaths;
    }

    @Override
    public long createFolderPath(Long workspaceArtifactId, Long parentSearchContainerArtifactId, List<String> folderPaths) throws IOException {
        long currentParentArtifactId = parentSearchContainerArtifactId;
        for (String folder : folderPaths) {
            HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
            payload.put("workspaceArtifactID", workspaceArtifactId);
            HashMap<String, Object> searchContainer = new HashMap<String, Object>();
            payload.put("searchContainer", searchContainer);
            searchContainer.put("name", folder);
            HashMap<String, Long> parentSearchContainer = new HashMap<String, Long>();
            searchContainer.put("parentSearchContainer", parentSearchContainer);
            parentSearchContainer.put("ArtifactID", currentParentArtifactId);
            String response = this.callApi("/Relativity.Rest/API/Relativity.Services.Search.ISearchModule/Search%20Container%20Manager/CreateSingleAsync", "POST", payload, new GenericType<String>(){});
            currentParentArtifactId = Long.parseLong(response);
        }
        return currentParentArtifactId;
    }

    @Override
    public Map<String, Long> getChildSearchContainers(Long workspaceArtifactId, Long searchContainerArtifactId) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        HashMap<String, Long> searchContainer = new HashMap<String, Long>();
        payload.put("searchContainer", searchContainer);
        searchContainer.put("ArtifactID", searchContainerArtifactId);
        String response = this.callApi("/Relativity.Rest/API/Relativity.Services.Search.ISearchModule/Search%20Container%20Manager/GetChildSearchContainersAsync", "POST", payload, new GenericType<String>(){});
        HashMap<String, Long> folders = new HashMap<String, Long>();
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonArray array = object.getAsJsonArray("SearchContainerItems");
        array.forEach(item -> {
            JsonObject arrayItem = item.getAsJsonObject().getAsJsonObject("SearchContainer");
            folders.put(arrayItem.get("Name").getAsString(), arrayItem.get("ArtifactID").getAsLong());
        });
        return folders;
    }

    @Override
    public Set<String> getSearchContainerItemNames(Long workspaceArtifactId, Long searchContainerArtifactId) throws IOException {
        HashSet<String> savedSearches = new HashSet<String>();
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        HashMap<String, Long> searchContainer = new HashMap<String, Long>();
        payload.put("searchContainer", searchContainer);
        searchContainer.put("ArtifactID", searchContainerArtifactId);
        try {
            String response = this.callApi("/Relativity.Rest/API/Relativity.Services.Search.ISearchModule/Search%20Container%20Manager/GetSearchContainerItemsAsync", "POST", payload, new GenericType<String>(){});
            JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            JsonArray array = object.getAsJsonArray("SavedSearchContainerItems");
            array.forEach(item -> {
                JsonObject arrayItem = item.getAsJsonObject().getAsJsonObject("SavedSearch");
                savedSearches.add(arrayItem.get("Name").getAsString());
            });
        }
        catch (IOException e) {
            LOGGER.error("Unable to get search container saved search items", (Throwable)e);
        }
        return savedSearches;
    }

    @Override
    public List<EligibleObject> getSearchContainerSavedSearches(Long workspaceArtifactId, Long searchContainerArtifactId) throws IOException {
        ArrayList<EligibleObject> savedSearches = new ArrayList<EligibleObject>();
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        HashMap<String, Long> searchContainer = new HashMap<String, Long>();
        payload.put("searchContainer", searchContainer);
        searchContainer.put("ArtifactID", searchContainerArtifactId);
        try {
            String response = this.callApi("/Relativity.Rest/API/Relativity.Services.Search.ISearchModule/Search%20Container%20Manager/GetSearchContainerItemsAsync", "POST", payload, new GenericType<String>(){});
            JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            JsonArray array = object.getAsJsonArray("SavedSearchContainerItems");
            array.forEach(item -> {
                JsonObject arrayItem = item.getAsJsonObject().getAsJsonObject("SavedSearch");
                EligibleObject eligibleObject = new EligibleObject();
                eligibleObject.setName(arrayItem.get("Name").getAsString());
                eligibleObject.setArtifactId(arrayItem.get("ArtifactID").getAsLong());
                savedSearches.add(eligibleObject);
            });
        }
        catch (IOException e) {
            LOGGER.error("Unable to get search container saved search items", (Throwable)e);
        }
        return savedSearches;
    }

    @Override
    public long getOrCreateSearchContainer(Long workspaceArtifactId, Long parentFolderArtifactId, List<String> folderPaths) throws IOException {
        return this.getOrCreateSearchContainer(workspaceArtifactId, parentFolderArtifactId, folderPaths, 0);
    }

    @Override
    public long getOrCreateSearchContainer(Long workspaceArtifactId, Long parentFolderArtifactId, List<String> folderPaths, int index) throws IOException {
        String currentFolderName;
        if (index == folderPaths.size()) {
            return parentFolderArtifactId;
        }
        Map<String, Long> searchContainers = this.getChildSearchContainers(workspaceArtifactId, parentFolderArtifactId);
        if (searchContainers.containsKey(currentFolderName = folderPaths.get(index))) {
            return this.getOrCreateSearchContainer(workspaceArtifactId, searchContainers.get(currentFolderName), folderPaths, index + 1);
        }
        return this.createFolderPath(workspaceArtifactId, parentFolderArtifactId, folderPaths.subList(index, folderPaths.size()));
    }

    @Override
    public long getSearchContainerRoot(Long workspaceArtifactId) throws IOException {
        HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("query", new HashMap());
        payload.put("length", Integer.valueOf(PAGE_SIZE));
        String response = this.callApi("/Relativity.Rest/API/Relativity.Services.Search.ISearchModule/Search%20Container%20Manager/QueryAsync", "POST", payload, new GenericType<String>(){});
        JsonObject searchContainerJson = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonArray searchContainers = searchContainerJson.getAsJsonArray("Results");
        for (JsonElement container : searchContainers) {
            JsonObject parentObject = container.getAsJsonObject().getAsJsonObject("Artifact").getAsJsonObject("ParentSearchContainer");
            String containerName = container.getAsJsonObject().getAsJsonObject("Artifact").get("Name").getAsString();
            long containerArtifactId = container.getAsJsonObject().getAsJsonObject("Artifact").get("ArtifactID").getAsLong();
            if (!parentObject.get("Name").getAsString().equals(containerName)) continue;
            return containerArtifactId;
        }
        return -1L;
    }

    @Override
    public long runSavedSearch(Long workspaceArtifactId, Long savedSearchArtifactId) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setCondition("(('Artifact ID' IN SAVEDSEARCH " + savedSearchArtifactId + "))").setObjectTypeId(10L).addFields("Name").build();
        ObjectManagerQueryRequest request = new ObjectManagerQueryRequest(query, 1, PAGE_SIZE);
        String response = this.queryObjectManager(request);
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        return object.get("TotalCount").getAsLong();
    }

    @Override
    public Set<Long> getSearchContainerChildren(Long workspaceArtifactId, Long searchContainerArtifactId, Set<Long> children) throws IOException {
        children.add(searchContainerArtifactId);
        Map<String, Long> childSearchContainers = this.getChildSearchContainers(workspaceArtifactId, searchContainerArtifactId);
        for (Long artifactId : childSearchContainers.values()) {
            children.addAll(this.getSearchContainerChildren(workspaceArtifactId, artifactId, children));
        }
        return children;
    }

    @Override
    public List<EligibleObject> getAllSearchContainerSavedSearches(Long workspaceArtifactId, Set<Long> searchContainerArtifactIds) throws IOException {
        ArrayList<EligibleObject> savedSearches = new ArrayList<EligibleObject>();
        for (Long searchContainerArtifactId : searchContainerArtifactIds) {
            HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
            payload.put("workspaceArtifactID", workspaceArtifactId);
            HashMap<String, Long> searchContainer = new HashMap<String, Long>();
            payload.put("searchContainer", searchContainer);
            searchContainer.put("ArtifactID", searchContainerArtifactId);
            String response = this.callApi("/Relativity.Rest/API/Relativity.Services.Search.ISearchModule/Search%20Container%20Manager/GetSearchContainerItemsAsync", "POST", payload, new GenericType<String>(){});
            JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
            JsonArray array = object.getAsJsonArray("SavedSearchContainerItems");
            array.forEach(item -> {
                JsonObject arrayItem = item.getAsJsonObject().getAsJsonObject("SavedSearch");
                EligibleObject eligibleObject = new EligibleObject();
                eligibleObject.setName(arrayItem.get("Name").getAsString());
                eligibleObject.setArtifactId(arrayItem.get("ArtifactID").getAsLong());
                savedSearches.add(eligibleObject);
            });
        }
        return savedSearches;
    }

    @Override
    public void submitAnalyticIndexJob(Long workspaceArtifact, Long analyticsIndexArtifactId, RelativityAnalyticIndexAction action, RelativityIndexType type) throws IOException {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("jobType", action.getRelativityIdentifier());
        this.callApi("/Relativity.REST/API/" + type.getRelativityType() + "/v1/workspaces/" + workspaceArtifact + "/indexes/" + analyticsIndexArtifactId + "/job", "POST", payload, new GenericType<String>(){});
    }

    @Override
    public RelativityAnalyticIndexStatus getAnalyticIndexJobStatus(Long workspaceArtifact, Long analyticsIndexArtifactId, RelativityIndexType type) throws IOException {
        String response = this.callApi("/Relativity.REST/API/" + type.getRelativityType() + "/v1/workspaces/" + workspaceArtifact + "/indexes/" + analyticsIndexArtifactId + "/status", "GET", new GenericType<String>(){});
        return (RelativityAnalyticIndexStatus)this.gson.fromJson(response, RelativityAnalyticIndexStatus.class);
    }

    @Override
    public void cancelAnalyticJob(Long workspaceArtifact, Long analyticsIndexArtifactId, RelativityIndexType type) throws IOException {
        this.callApi("/Relativity.REST/API/" + type.getRelativityType() + "/v1/workspaces/" + workspaceArtifact + "/indexes/" + analyticsIndexArtifactId + "/job", "DELETE", new GenericType<String>(){});
    }

    @Override
    public List<EligibleObject> getOcrSets(Long workspaceArtifactId, RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeName("OCR Set").addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public OcrSetJobStatus getOcrSetJobStatus(Long workspaceArtifactId, Long ocrSetArtifactId) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Long> jobStatusRequest = new HashMap<String, Long>();
        payload.put("jobStatusRequest", jobStatusRequest);
        jobStatusRequest.put("workspaceId", workspaceArtifactId);
        jobStatusRequest.put("ocrSetId", ocrSetArtifactId);
        String response = this.callApi("/Relativity.Rest/API/Relativity.Ocr.Services.Interfaces.IOcrModule/OCR%20Job%20Manager/GetOcrJobStatusAsync", "POST", payload, new GenericType<String>(){});
        JsonObject parent = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonObject object = parent.getAsJsonObject("JobStatusInfo");
        OcrSetJobStatus job = new OcrSetJobStatus();
        JsonObject statusObject = object.getAsJsonObject("Status");
        job.setStatus(statusObject.get("Status").getAsString());
        job.setActive(statusObject.get("IsActive").getAsBoolean());
        job.setSubmitDate(object.get("SubmitDate").getAsString());
        job.setTotalImageCount(object.get("TotalImageCount").getAsInt());
        job.setImagesWithErrorCount(object.get("ImagesWithErrorCount").getAsInt());
        job.setImagesUnprocessedCount(object.get("ImagesUnprocessedCount").getAsInt());
        job.setImagesRecognizedCount(object.get("ImagesRecognizedCount").getAsInt());
        job.setTotalDocumentCount(object.get("TotalDocumentCount").getAsInt());
        job.setDocumentsImportedCount(object.get("DocumentsImportedCount").getAsInt());
        job.setDocumentsNotImportedCount(object.get("DocumentsNotImportedCount").getAsInt());
        job.setDocumentsWithImportErrorCount(object.get("DocumentsWithImportErrorCount").getAsInt());
        return job;
    }

    @Override
    public OcrSetJobResult runOcrSet(Long workspaceArtifactId, Long ocrSetArtifactId) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Long> runOcrSetRequest = new HashMap<String, Long>();
        payload.put("runOcrSetRequest", runOcrSetRequest);
        runOcrSetRequest.put("workspaceId", workspaceArtifactId);
        runOcrSetRequest.put("ocrSetId", ocrSetArtifactId);
        String response = this.callApi("/Relativity.Rest/API/Relativity.Ocr.Services.Interfaces.IOcrModule/OCR%20Job%20Manager/RunOcrJobAsync", "POST", payload, new GenericType<String>(){});
        return (OcrSetJobResult)this.gson.fromJson(response, OcrSetJobResult.class);
    }

    @Override
    public OcrSetStopJobResult stopOcrSetJob(Long workspaceArtifactId, Long ocrSetArtifactId) throws IOException {
        HashMap payload = new HashMap();
        HashMap<String, Long> stopOcrSetRequest = new HashMap<String, Long>();
        payload.put("stopOcrSetRequest", stopOcrSetRequest);
        stopOcrSetRequest.put("workspaceId", workspaceArtifactId);
        stopOcrSetRequest.put("ocrSetId", ocrSetArtifactId);
        String response = this.callApi("/Relativity.Rest/API/Relativity.Ocr.Services.Interfaces.IOcrModule/OCR%20Job%20Manager/StopOcrJobAsync", "POST", payload, new GenericType<String>(){});
        return (OcrSetStopJobResult)this.gson.fromJson(response, OcrSetStopJobResult.class);
    }

    @Override
    public List<EligibleObject> getMetadataTypes(Long workspaceArtifactId, RelativityIdentifierType identifierType, String identifier, ExportMetadataType type) throws IOException {
        Long typeId = type == ExportMetadataType.VIEW ? 4L : 15L;
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(typeId).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> getViews(Long workspaceArtifactId, RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setWorkspaceArtifactId(workspaceArtifactId).setObjectType(RelativityArtifactIdType.VIEW).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public RelativityView getRelativityView(Long workspaceArtifactId, Long viewArtifactId) throws IOException {
        if (workspaceArtifactId == null) {
            workspaceArtifactId = -1L;
        }
        RelativityView relativityView = new RelativityView();
        String response = this.callApi("/Relativity.Rest/API/relativity-data-visualization/v1/workspaces/" + workspaceArtifactId + "/views/" + viewArtifactId, "GET", new GenericType<String>(){});
        ArrayList<String> fields = new ArrayList<String>();
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonObject fieldsObject = object.get("Fields").getAsJsonObject();
        JsonArray fieldItems = fieldsObject.get("ViewableItems").getAsJsonArray();
        fieldItems.forEach(item -> {
            JsonObject itemObject = item.getAsJsonObject();
            String viewFieldName = itemObject.get("Name").getAsString();
            if (!viewFieldName.equalsIgnoreCase("Edit")) {
                fields.add(viewFieldName);
            }
        });
        relativityView.setFields(fields);
        relativityView.setArtifactTypeId(object.get("ObjectType").getAsJsonObject().get("Value").getAsJsonObject().get("ArtifactTypeID").getAsLong());
        return relativityView;
    }

    @Override
    public int queryTotalMetadataTypeObjects(Long workspaceArtifactId, Long identifierArtifactId, Long objectTypeArtifactId, ExportMetadataType type, String customCondition) throws IOException {
        Object condition = "";
        String relativityType = type == ExportMetadataType.VIEW ? "VIEW" : "SAVEDSEARCH";
        condition = customCondition != null && !customCondition.trim().equals("") ? customCondition : "(('Artifact ID' IN " + relativityType + " " + identifierArtifactId + "))";
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setCondition((String)condition).withExecutionMetadataId(type, identifierArtifactId).setObjectTypeId(objectTypeArtifactId).addFields("Name").build();
        ObjectManagerQueryRequest request = new ObjectManagerQueryRequest(query, 1, 2);
        String response = this.queryObjectManagerSlim(request);
        return ((JsonObject)this.gson.fromJson(response, JsonObject.class)).get("TotalCount").getAsInt();
    }

    @Override
    public List<Object[]> queryMetadataTypeObjectsPaged(ObjectManagerQueryRequest request) throws IOException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        String response = this.queryObjectManagerSlim(request);
        JsonObject object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        JsonArray array = object.get("Objects").getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject cols = element.getAsJsonObject();
            JsonArray values = cols.getAsJsonArray("Values");
            Object[] row = new Object[values.size()];
            int index = 0;
            for (JsonElement value : values) {
                row[index] = value.isJsonNull() || value.isJsonObject() || value.isJsonArray() ? "" : value.getAsString();
                ++index;
            }
            rows.add(row);
        }
        return rows;
    }

    @Override
    public List<EligibleObject> queryMarkupSets(Long workspaceArtifactId, RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeName("Markup Set").addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> queryProductionPlaceholders(Long workspaceArtifactId, RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeName("Production Placeholder").addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> querySavedSearches(Long workspaceArtifactId, RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(15L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public List<EligibleObject> queryProductionSets(Long workspaceArtifactId, RelativityIdentifierType identifierType, String identifier) throws IOException {
        ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setCondition(this.getConditionFromIdentifier(identifierType, identifier)).setWorkspaceArtifactId(workspaceArtifactId).setObjectTypeId(17L).addFields("Name").build();
        return this.queryEligibleObjects(query);
    }

    @Override
    public JsonObject readProductionSetJson(Long workspaceArtifactId, Long productionSetArtifactId) throws IOException {
        String response = this.callApi("/Relativity.REST/api/relativity-productions/v1/workspaces/" + workspaceArtifactId + "/productions/" + productionSetArtifactId, "GET", new GenericType<String>(){});
        return (JsonObject)this.gson.fromJson(response, JsonObject.class);
    }

    @Override
    public Long createProductionSetJsonObject(Long workspaceArtifactId, JsonObject productionRequest) throws IOException {
        String response = this.callApi("/Relativity.REST/api/relativity-productions/v1/workspaces/" + workspaceArtifactId + "/productions", "POST", productionRequest, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public Long createProductionSet(Long workspaceArtifactId, CreateProductionSetRequest productionSetRequest) throws IOException {
        HashMap<String, CreateProductionSetRequest> payload = new HashMap<String, CreateProductionSetRequest>();
        payload.put("production", productionSetRequest);
        String response = this.callApi("/Relativity.REST/api/relativity-productions/v1/workspaces/" + workspaceArtifactId + "/productions", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public Long createProductionDataSource(Long workspaceArtifactId, Long productionArtifactId, ProductionSetDataSource dataSource) throws IOException {
        HashMap<String, ProductionSetDataSource> payload = new HashMap<String, ProductionSetDataSource>();
        payload.put("datasource", dataSource);
        String response = this.callApi("/Relativity.REST/api/relativity-productions/v1/workspaces/" + workspaceArtifactId + "/productions/" + productionArtifactId + "/production-data-sources", "POST", payload, new GenericType<String>(){});
        return Long.parseLong(response);
    }

    @Override
    public RelativityProductionSetProgress getProductionSetProgress(Long workspaceArtifactId, Long productionSetArtifactId) throws IOException {
        String response = this.callApi("/Relativity.REST/api/relativity-productions/v1/workspaces/" + workspaceArtifactId + "/productions/" + productionSetArtifactId + "/progress", "GET", new GenericType<String>(){});
        return (RelativityProductionSetProgress)this.gson.fromJson(response, RelativityProductionSetProgress.class);
    }

    @Override
    public boolean runProductionJobAction(Long workspaceArtifactId, Long productionSetArtifactId, RunProductionSetActionType action) throws IOException {
        String response;
        HashMap<String, Boolean> payload = new HashMap<String, Boolean>();
        JsonObject object = null;
        if (action == RunProductionSetActionType.RUN) {
            payload.put("suppressWarnings", true);
            payload.put("overrideConflicts", false);
            response = this.callApi("/Relativity.REST/api/relativity-productions/v1/workspaces/" + workspaceArtifactId + "/productions/" + productionSetArtifactId + "/run", "POST", payload, new GenericType<String>(){});
            object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        } else {
            payload.put("automaticallyRun", action == RunProductionSetActionType.STAGE_AND_RUN);
            response = this.callApi("/Relativity.REST/api/relativity-productions/v1/workspaces/" + workspaceArtifactId + "/productions/" + productionSetArtifactId + "/stage", "POST", payload, new GenericType<String>(){});
            object = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        }
        JsonArray errorArray = object.getAsJsonArray("Errors");
        if (errorArray.size() > 0) {
            ArrayList errors = new ArrayList();
            errorArray.forEach(e -> errors.add(e.getAsString()));
            throw new IOException(this.iu.getFormattedString("RelativityRunProductionSetOperation.Exception.Conflicts", (Object)String.join((CharSequence)" ", errors)));
        }
        return object.get("WasJobCreated").getAsBoolean();
    }

    @Override
    public RelativityProductionSetStatus getProductionSetStatus(Long workspaceArtifactId, Long productionSetArtifactId) throws IOException {
        String response = this.callApi("Relativity.REST/api/relativity-productions/v1/workspaces/" + workspaceArtifactId + "/productions/" + productionSetArtifactId + "/job-status?includePercentages=true&numberOfBrandingErrors=10", "GET", new GenericType<String>(){});
        return (RelativityProductionSetStatus)this.gson.fromJson(response, RelativityProductionSetStatus.class);
    }
}

