/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.relativity;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.RelativityCondition;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldValueType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityObjectPermission;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityObjectSubPermission;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityPermission;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroupPermissions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.ArmJobState;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.ArmJobStatus;
import com.nuix.automate.workflow.core.utils.relativity.RelativityClient;
import com.nuix.automate.workflow.core.utils.relativity.mapping.Field;
import com.nuix.automate.workflow.core.utils.relativity.mapping.Mapping;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelativityUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityUtils.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private Set<String> completedScriptStates = new HashSet<String>();
    private Set<ParameterType> relativityParameterTypes;
    private Set<ParameterType> relativityFilterableParameterTypes;
    private static RelativityUtils instance;

    public static RelativityUtils getInstance() {
        if (instance == null) {
            instance = new RelativityUtils();
        }
        return instance;
    }

    public Map<String, Field> parseFieldMappingFile(Path mappingPath) throws IOException {
        LOGGER.info("Parsing mapping " + mappingPath.toString());
        String fileContent = FileUtils.readFileWithAutodetectEncoding((File)mappingPath.toFile());
        Mapping mapping = (Mapping)SerializationUtils.fromJson((String)fileContent, Mapping.class);
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field field : mapping.getFieldList()) {
            fields.put(field.getWorkspaceColumn(), field);
        }
        return fields;
    }

    public RelativityUtils() {
        this.completedScriptStates.add("Completed");
        this.completedScriptStates.add("CompletedWithErrors");
        this.completedScriptStates.add("FailedToComplete");
        this.completedScriptStates.add("AgentHasNotCheckedIn");
        this.relativityParameterTypes = new HashSet<ParameterType>();
        this.relativityParameterTypes.add(ParameterType.RELATIVITY_CLIENT);
        this.relativityParameterTypes.add(ParameterType.RELATIVITY_MATTER);
        this.relativityParameterTypes.add(ParameterType.RELATIVITY_WORKSPACE);
        this.relativityParameterTypes.add(ParameterType.RELATIVITY_DT_SEARCH);
        this.relativityParameterTypes.add(ParameterType.RELATIVITY_WORKSPACE_FIELD);
        this.relativityParameterTypes.add(ParameterType.RELATIVITY_VIEW);
        this.relativityParameterTypes.add(ParameterType.RELATIVITY_FOLDER);
        this.relativityParameterTypes.add(ParameterType.RELATIVITY_SAVED_SEARCH);
        this.relativityFilterableParameterTypes = new HashSet<ParameterType>();
        this.relativityFilterableParameterTypes.add(ParameterType.RELATIVITY_MATTER);
        this.relativityFilterableParameterTypes.add(ParameterType.RELATIVITY_WORKSPACE);
        this.relativityFilterableParameterTypes.add(ParameterType.RELATIVITY_DT_SEARCH);
        this.relativityFilterableParameterTypes.add(ParameterType.RELATIVITY_WORKSPACE_FIELD);
        this.relativityFilterableParameterTypes.add(ParameterType.RELATIVITY_VIEW);
        this.relativityFilterableParameterTypes.add(ParameterType.RELATIVITY_FOLDER);
        this.relativityFilterableParameterTypes.add(ParameterType.RELATIVITY_SAVED_SEARCH);
    }

    public boolean hasScriptCompleted(String status) {
        return this.completedScriptStates.contains(status);
    }

    public boolean isRelativityParameter(ParameterType type) {
        return this.relativityParameterTypes.contains(type);
    }

    public boolean isRelativityParameterFilterable(ParameterType type) {
        return this.relativityFilterableParameterTypes.contains(type);
    }

    public static String getRelativityClientPath(String clientVersion) {
        return SystemUtils.getProgramFilesDir((String[])new String[]{"Nuix", "Automate", "bin", "RelativityClient", "Versions", clientVersion, "bin", "RelativityClient.exe"});
    }

    public List<AllowedValueItem> filterRelativityObjects(RelativityClient client, RelativityCondition condition, ParameterType type, String filterParameterValue) {
        ArrayList<AllowedValueItem> allowedValues = new ArrayList();
        if (filterParameterValue != null && filterParameterValue.trim().equals("")) {
            filterParameterValue = null;
        }
        try {
            allowedValues = client.filterRelativityObjects(condition, type, filterParameterValue);
        }
        catch (Exception e) {
            LOGGER.error("Unable to filter relativity allowed values", (Throwable)e);
        }
        return allowedValues;
    }

    public List<EligibleObject> filterEligibleObjectsList(String identifier, RelativityIdentifierType identifierType, List<EligibleObject> eligibleObjects, RelativityFieldType type) throws IOException {
        ArrayList<EligibleObject> matches = new ArrayList<EligibleObject>();
        switch (identifierType) {
            case NAME_LIKE: 
            case NAME: {
                for (EligibleObject eligibleObject : eligibleObjects) {
                    if (!eligibleObject.getName().equals(identifier)) continue;
                    matches.add(eligibleObject);
                }
                return matches;
            }
            case ID: 
            case ARTIFACT_ID: {
                for (EligibleObject eligibleObject : eligibleObjects) {
                    Long artifactId = 0L;
                    try {
                        artifactId = Long.parseLong(identifier);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(this.iu.getFormattedString("Relativity.Exception.IncorrectArtifactId", (Object)type.toString()));
                    }
                    if (artifactId.longValue() != eligibleObject.getArtifactId()) continue;
                    matches.add(eligibleObject);
                }
                return matches;
            }
            case NAME_REGEX: {
                for (EligibleObject eligibleObject : eligibleObjects) {
                    if (!eligibleObject.getName().matches(identifier)) continue;
                    matches.add(eligibleObject);
                }
                return matches;
            }
        }
        return null;
    }

    public EligibleObject filterEligibleObject(String identifier, RelativityIdentifierType identifierType, List<EligibleObject> eligibleObjects, RelativityFieldType type) throws IOException {
        ArrayList<EligibleObject> matches = new ArrayList<EligibleObject>();
        switch (identifierType) {
            case NAME: {
                for (EligibleObject eligibleObject : eligibleObjects) {
                    if (!eligibleObject.getName().equals(identifier)) continue;
                    matches.add(eligibleObject);
                }
                if (matches.size() > 1) {
                    throw new IOException(this.iu.getFormattedString("Relativity.Exception.MultipleNamesMatches", new Object[]{matches.size(), type.toString(), identifier}));
                }
                return matches.size() == 1 ? (EligibleObject)matches.get(0) : null;
            }
            case ID: 
            case ARTIFACT_ID: {
                for (EligibleObject eligibleObject : eligibleObjects) {
                    Long artifactId = 0L;
                    try {
                        artifactId = Long.parseLong(identifier);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(this.iu.getFormattedString("Relativity.Exception.IncorrectArtifactId", (Object)type.toString()));
                    }
                    if (artifactId.longValue() != eligibleObject.getArtifactId()) continue;
                    return eligibleObject;
                }
                return null;
            }
            case NAME_REGEX: {
                for (EligibleObject eligibleObject : eligibleObjects) {
                    if (!eligibleObject.getName().matches(identifier)) continue;
                    matches.add(eligibleObject);
                }
                if (matches.size() > 1) {
                    throw new IOException(this.iu.getFormattedString("Relativity.Exception.MultipleRegexMatches", new Object[]{matches.size(), type.toString(), identifier}));
                }
                return matches.size() == 1 ? (EligibleObject)matches.get(0) : null;
            }
            case NAME_LIKE: {
                throw new IOException(this.iu.getFormattedString("Relativity.Exception.FieldDoesNotSupportLikeMatch", (Object)type.toString()));
            }
        }
        return null;
    }

    public EligibleObject filterAllEligibleObject(String identifier, RelativityIdentifierType identifierType, List<EligibleObject> eligibleObjects, RelativityFieldType type) throws IOException {
        switch (identifierType) {
            case NAME: {
                if (eligibleObjects.size() > 1) {
                    throw new IOException(this.iu.getFormattedString("Relativity.Exception.MultipleNamesMatches", new Object[]{eligibleObjects.size(), LocalizableEnumUtils.getLocalizedString((Enum)type), identifier}));
                }
                return eligibleObjects.size() == 1 ? eligibleObjects.get(0) : null;
            }
            case ARTIFACT_ID: {
                if (eligibleObjects.size() > 1) {
                    throw new IOException("Unexpected " + eligibleObjects.size() + " objects returned with the same Artifact ID");
                }
                return eligibleObjects.size() == 1 ? eligibleObjects.get(0) : null;
            }
            case NAME_LIKE: {
                if (eligibleObjects.size() > 1) {
                    throw new IOException(this.iu.getFormattedString("Relativity.Exception.MultipleLikeMatches", new Object[]{eligibleObjects.size(), LocalizableEnumUtils.getLocalizedString((Enum)type), identifier}));
                }
                return eligibleObjects.size() == 1 ? eligibleObjects.get(0) : null;
            }
            case NAME_REGEX: {
                throw new IOException(this.iu.getFormattedString("Relativity.Exception.FieldDoesNotSupportRegexMatch", (Object)type.toString()));
            }
        }
        return null;
    }

    public List<RelativityPermission> recursiveResolveRelativityChildrenPermissions(List<RelativityPermission> srcPermissions, List<RelativityPermission> copyPermissions, List<RelativityPermission> childrenPermissions) {
        HashMap<String, RelativityPermission> copyMap = new HashMap<String, RelativityPermission>();
        for (RelativityPermission permission : copyPermissions) {
            copyMap.put(permission.getName(), permission);
        }
        for (RelativityPermission permission : srcPermissions) {
            RelativityPermission copyPermission = (RelativityPermission)copyMap.get(permission.getName());
            if (copyPermission != null) {
                permission.setEditable(copyPermission.getEditable());
                permission.setSelected(copyPermission.getSelected());
                if (copyPermission.getChildren() != null && copyPermission.getChildren().size() > 0) {
                    List<RelativityPermission> children = this.recursiveResolveRelativityChildrenPermissions(permission.getChildren(), copyPermission.getChildren(), new ArrayList<RelativityPermission>());
                    permission.setChildren(children);
                }
            }
            childrenPermissions.add(permission);
        }
        return childrenPermissions;
    }

    public List<RelativityPermission> resolveRelativityPermissions(List<RelativityPermission> srcPermissions, List<RelativityPermission> copyPermissions) {
        ArrayList<RelativityPermission> permissions = new ArrayList<RelativityPermission>();
        HashMap<String, RelativityPermission> copyMap = new HashMap<String, RelativityPermission>();
        for (RelativityPermission permission : copyPermissions) {
            copyMap.put(permission.getName(), permission);
        }
        for (RelativityPermission permission : srcPermissions) {
            RelativityPermission copyPermission = (RelativityPermission)copyMap.get(permission.getName());
            if (copyPermission != null) {
                permission.setEditable(copyPermission.getEditable());
                permission.setSelected(copyPermission.getSelected());
                if (copyPermission.getChildren() != null && copyPermission.getChildren().size() > 0) {
                    List<RelativityPermission> children = this.recursiveResolveRelativityChildrenPermissions(permission.getChildren(), copyPermission.getChildren(), new ArrayList<RelativityPermission>());
                    permission.setChildren(children);
                }
            }
            permissions.add(permission);
        }
        return permissions;
    }

    public List<RelativityObjectPermission> resolveRelativityObjectPermissions(List<RelativityObjectPermission> srcPermissions, List<RelativityObjectPermission> copyPermissions) {
        ArrayList<RelativityObjectPermission> permissions = new ArrayList<RelativityObjectPermission>();
        HashMap<String, RelativityObjectPermission> copyMap = new HashMap<String, RelativityObjectPermission>();
        for (RelativityObjectPermission permission : copyPermissions) {
            copyMap.put(permission.getName(), permission);
        }
        for (RelativityObjectPermission permission : srcPermissions) {
            RelativityObjectPermission copyPermission = (RelativityObjectPermission)copyMap.get(permission.getName());
            if (copyPermission != null) {
                permission.updateFromCopy(copyPermission);
                if (permission.getSubPermissions() != null && permission.getSubPermissions().size() > 0 && copyPermission.getSubPermissions() != null && copyPermission.getSubPermissions().size() > 0) {
                    HashMap<String, RelativityObjectSubPermission> copySubPermissionMap = new HashMap<String, RelativityObjectSubPermission>();
                    for (RelativityObjectSubPermission subPermission : copyPermission.getSubPermissions()) {
                        copySubPermissionMap.put(subPermission.getName(), subPermission);
                    }
                    for (RelativityObjectSubPermission subPermission : permission.getSubPermissions()) {
                        RelativityObjectSubPermission copySubPermission = (RelativityObjectSubPermission)copySubPermissionMap.get(subPermission.getName());
                        if (copySubPermission == null) continue;
                        subPermission.setSelected(copySubPermission.getSelected());
                    }
                }
                if (permission.getCustomPermissions() != null && permission.getCustomPermissions().size() > 0 && copyPermission.getCustomPermissions() != null && copyPermission.getCustomPermissions().size() > 0) {
                    HashMap<String, RelativityObjectSubPermission> copyCustomPermissionMap = new HashMap<String, RelativityObjectSubPermission>();
                    for (RelativityObjectSubPermission subPermission : copyPermission.getCustomPermissions()) {
                        copyCustomPermissionMap.put(subPermission.getName(), subPermission);
                    }
                    for (RelativityObjectSubPermission customPermission : permission.getCustomPermissions()) {
                        RelativityObjectSubPermission copyCustomPermission = (RelativityObjectSubPermission)copyCustomPermissionMap.get(customPermission.getName());
                        if (copyCustomPermission == null) continue;
                        customPermission.setSelected(copyCustomPermission.getSelected());
                    }
                }
            }
            permissions.add(permission);
        }
        return permissions;
    }

    public Set<String> resolveMissingObjectPermissions(List<RelativityObjectPermission> src, List<RelativityObjectPermission> copy) {
        HashSet<String> missingPermissions = new HashSet<String>();
        HashMap<String, RelativityObjectPermission> srcPermissionNames = new HashMap<String, RelativityObjectPermission>();
        for (RelativityObjectPermission permission : src) {
            srcPermissionNames.put(permission.getName(), permission);
        }
        for (RelativityObjectPermission permission : copy) {
            if (srcPermissionNames.containsKey(permission.getName())) continue;
            missingPermissions.add(permission.getName());
        }
        return missingPermissions;
    }

    public Set<String> resolveMissingPermissions(List<RelativityPermission> src, List<RelativityPermission> copy) {
        HashSet<String> missingPermissions = new HashSet<String>();
        HashMap<String, RelativityPermission> srcPermissionNames = new HashMap<String, RelativityPermission>();
        for (RelativityPermission permission : src) {
            srcPermissionNames.put(permission.getName(), permission);
        }
        for (RelativityPermission permission : copy) {
            if (srcPermissionNames.containsKey(permission.getName())) continue;
            missingPermissions.add(permission.getName());
        }
        return missingPermissions;
    }

    public Set<String> resolveMissingWorkspaceGroupPermissions(WorkspaceGroupPermissions src, WorkspaceGroupPermissions copy) {
        HashSet<String> missingPermissions = new HashSet<String>();
        if (copy.getObjectPermissions() != null) {
            Set<String> missingObjectPermissions = this.resolveMissingObjectPermissions(src.getObjectPermissions(), copy.getObjectPermissions());
            missingPermissions.addAll(missingObjectPermissions);
        }
        if (copy.getTabVisibility() != null) {
            Set<String> missingTabVisibility = this.resolveMissingPermissions(src.getTabVisibility(), copy.getTabVisibility());
            missingPermissions.addAll(missingTabVisibility);
        }
        if (copy.getBrowserPermissions() != null) {
            Set<String> missingBrowserPermissions = this.resolveMissingPermissions(src.getBrowserPermissions(), copy.getBrowserPermissions());
            missingPermissions.addAll(missingBrowserPermissions);
        }
        if (copy.getAdminPermissions() != null) {
            Set<String> missingAdminPermissions = this.resolveMissingPermissions(src.getAdminPermissions(), copy.getAdminPermissions());
            missingPermissions.addAll(missingAdminPermissions);
        }
        if (copy.getMassActionPermissions() != null) {
            Set<String> missingMassActionPermissions = this.resolveMissingPermissions(src.getMassActionPermissions(), copy.getMassActionPermissions());
            missingPermissions.addAll(missingMassActionPermissions);
        }
        return missingPermissions;
    }

    public WorkspaceGroupPermissions copyPermissions(WorkspaceGroupPermissions src, WorkspaceGroupPermissions copy) {
        if (copy.getObjectPermissions() != null) {
            List<RelativityObjectPermission> objectPermissions = this.resolveRelativityObjectPermissions(src.getObjectPermissions(), copy.getObjectPermissions());
            src.setObjectPermissions(objectPermissions);
        }
        if (copy.getTabVisibility() != null) {
            List<RelativityPermission> tabVisibility = this.resolveRelativityPermissions(src.getTabVisibility(), copy.getTabVisibility());
            src.setTabVisibility(tabVisibility);
        }
        if (copy.getBrowserPermissions() != null) {
            List<RelativityPermission> browserPermissions = this.resolveRelativityPermissions(src.getBrowserPermissions(), copy.getBrowserPermissions());
            src.setBrowserPermissions(browserPermissions);
        }
        if (copy.getAdminPermissions() != null) {
            List<RelativityPermission> adminPermissions = this.resolveRelativityPermissions(src.getAdminPermissions(), copy.getAdminPermissions());
            src.setAdminPermissions(adminPermissions);
        }
        if (copy.getMassActionPermissions() != null) {
            List<RelativityPermission> massActionPermissions = this.resolveRelativityPermissions(src.getMassActionPermissions(), copy.getMassActionPermissions());
            src.setMassActionPermissions(massActionPermissions);
        }
        return src;
    }

    public Object handleFieldTypeValue(Object object, RelativityFieldValueType type, Map<String, Object> possibleValues) {
        String value = object.toString();
        switch (type) {
            case MULTIPLE_CHOICE: 
            case MULTIPLE_OBJECT: {
                String[] values;
                ArrayList<Object> objects = new ArrayList<Object>();
                for (String str : values = value.split(",")) {
                    objects.add(possibleValues.get(str));
                }
                return objects;
            }
            case SINGLE_CHOICE: 
            case SINGLE_OBJECT: 
            case USER: {
                return possibleValues.get(value);
            }
            case YES_NO: {
                if (value.equalsIgnoreCase("yes")) {
                    return Boolean.TRUE;
                }
                if (value.equalsIgnoreCase("no")) {
                    return Boolean.FALSE;
                }
                return Boolean.valueOf(value);
            }
            case FILE: {
                return null;
            }
        }
        return value;
    }

    public boolean isArmJobCompleted(ArmJobStatus status) {
        return status.getJobState() == ArmJobState.ERRORED || status.getJobState() == ArmJobState.COMPLETE || status.getJobState() == ArmJobState.CANCELLATION_COMPLETE || status.getJobState() == ArmJobState.CANCELLATION_ERRORED;
    }
}

