/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.smtp;

import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import com.nuix.automate.workflow.core.utils.general.ThirdPartyProxyRestClient;
import jakarta.ws.rs.core.GenericType;
import java.security.GeneralSecurityException;
import java.util.Set;

public class SmtpRestClient
extends ThirdPartyProxyRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SmtpRestClient.class);

    public SmtpRestClient(String thirdPartyServiceId, String schedulerUrl, String bearerToken, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(thirdPartyServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
    }

    @Override
    public String getLogFileName() {
        return System.getProperty("automate.smtp.log");
    }

    @Override
    public String getServiceName() {
        return "SMTP";
    }

    public void sendEmail(SmtpEmail smtpEmail) throws Exception {
        Status response = this.proxyApiRequest("/sendEmail", "POST", smtpEmail, new GenericType<Status>(){});
        if (response.getCode() != State.OK) {
            throw new Exception(response.getMessage());
        }
    }
}

