/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.sql;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.sqlcommand.SqlEncryption;
import com.nuix.automate.workflow.core.execution.options.sqlcommand.SqlPlatform;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SqlUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SqlUtils.class);
    protected static transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");

    public static String getConnectionString(SqlPlatform sqlPlatform, String sqlServerName, int port, String instance, String domain, String databaseName, SqlEncryption sqlEncryption, String username, String password, ExecutionContext executionContext, Operation operation) throws SQLException {
        LOGGER.info("Creating JdbcClient");
        String parameterName = "{sql_connection_string}";
        try {
            String evaluatedParameter = executionContext.evalParameters(parameterName, operation);
            if (!evaluatedParameter.equals(parameterName)) {
                operation.addExecutionLog(iu.getFormattedString("SqlOperations.Log.SettingConnectionString", new Object[]{parameterName, evaluatedParameter}));
                return evaluatedParameter;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot evaluate parameter " + parameterName);
        }
        Object connectionString = "jdbc:";
        if (sqlPlatform == SqlPlatform.MICROSOFT_SQL_SERVER) {
            connectionString = (String)connectionString + "jtds:sqlserver:";
        } else if (sqlPlatform == SqlPlatform.MICROSOFT_SQL_SERVER_NATIVE) {
            connectionString = (String)connectionString + "sqlserver:";
        } else if (sqlPlatform == SqlPlatform.POSTGRES_SQL) {
            connectionString = (String)connectionString + "postgresql:";
        }
        connectionString = (String)connectionString + "//" + sqlServerName;
        connectionString = (String)connectionString + ":" + port;
        if (sqlPlatform == SqlPlatform.MICROSOFT_SQL_SERVER || sqlPlatform == SqlPlatform.MICROSOFT_SQL_SERVER_NATIVE) {
            connectionString = (String)connectionString + ";useLOBs=false";
            if (instance != null && instance.length() > 0) {
                connectionString = (String)connectionString + ";instance=" + instance;
            }
            if (domain != null && domain.length() > 0) {
                connectionString = (String)connectionString + ";domain=" + domain;
            }
            try {
                if (sqlPlatform == SqlPlatform.MICROSOFT_SQL_SERVER) {
                    Class.forName("net.sourceforge.jtds.jdbc.Driver");
                }
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(iu.getString("SqlCommandOperation.Exception.UnableToFindSuitableDriver"), e);
            }
        } else {
            try {
                Class.forName("org.postgresql.Driver");
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(iu.getString("SqlCommandOperation.Exception.UnableToFindSuitableDriver"), e);
            }
        }
        if (databaseName != null && databaseName.length() != 0) {
            if (sqlPlatform == SqlPlatform.MICROSOFT_SQL_SERVER || sqlPlatform == SqlPlatform.MICROSOFT_SQL_SERVER_NATIVE) {
                connectionString = (String)connectionString + ";databaseName=" + databaseName;
            } else if (sqlPlatform == SqlPlatform.POSTGRES_SQL) {
                connectionString = (String)connectionString + "/" + databaseName;
            }
        } else if (databaseName != null && sqlPlatform == SqlPlatform.POSTGRES_SQL) {
            LOGGER.info("No database specified using default: postgres");
            connectionString = (String)connectionString + "/postgres";
        }
        if (sqlPlatform == SqlPlatform.MICROSOFT_SQL_SERVER) {
            connectionString = (String)connectionString + sqlEncryption.toAppendConnectionString();
        }
        if (sqlPlatform == SqlPlatform.MICROSOFT_SQL_SERVER_NATIVE) {
            connectionString = username == null || username.length() == 0 || password == null || password.length() == 0 ? (String)connectionString + ";integratedSecurity=true" : (String)connectionString + ";integratedSecurity=false";
        }
        LOGGER.info("SQL Connection String: " + (String)connectionString);
        operation.addExecutionLog(iu.getFormattedString("SqlOperations.Log.ConnectionString", connectionString));
        return connectionString;
    }

    public static Connection createConnection(SqlPlatform sqlPlatform, String sqlServerName, int port, String instance, String domain, String databaseName, SqlEncryption sqlEncryption, String username, String password, ExecutionContext executionContext, Operation operation) throws SQLException {
        String connectionString = SqlUtils.getConnectionString(sqlPlatform, sqlServerName, port, instance, domain, databaseName, sqlEncryption, username, password, executionContext, operation);
        Connection connection = !username.equals("") && !password.equals("") ? DriverManager.getConnection(connectionString, username, password) : DriverManager.getConnection(connectionString);
        LOGGER.info("SQL connection: " + String.valueOf(connection));
        return connection;
    }
}

