/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.engine;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.jacob.com.LibraryLoader;
import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.engine.EngineConfiguration;
import com.nuix.automate.engine.commands.EngineCommand;
import com.nuix.automate.engine.workers.Engine;
import com.nuix.automate.jar.utils.LibraryUtils;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.api.health.HealthInfo;
import com.nuix.automate.utils.general.CommandLineUtils;
import com.nuix.automate.utils.general.NameResolver;
import com.nuix.automate.utils.general.SystemResourcesUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.logging.CentralizedLogInterceptor;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import io.dropwizard.core.Application;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.logging.common.LoggingUtil;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EngineApplication
extends Application<EngineConfiguration>
implements AutomateApplication {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EngineApplication.class);
    private static EngineApplication instance;
    private Engine engine;
    private EngineConfiguration configuration;
    private Environment environment;
    private CentralizedLogInterceptor<ILoggingEvent> centralizedLoggingAppender;
    private LogHandler logHandler;
    private LicenceUtils licenceUtils;
    private String runId;
    private String instanceId;
    private String nuixVersion;
    private boolean initializing;
    private boolean closing;
    private int lastDayHeaderLogged;
    private Random random = new Random();

    public EngineApplication() {
        instance = this;
    }

    public static EngineApplication getInstance() {
        return instance;
    }

    public EngineConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EngineConfiguration configuration) {
        this.configuration = configuration;
    }

    public LicenceUtils getLicenceUtils() {
        return this.licenceUtils;
    }

    public String getNuixVersion() {
        return this.nuixVersion;
    }

    public void setNuixVersion(String nuixVersion) {
        this.nuixVersion = nuixVersion;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    private void logHeader(boolean force) {
        if (force) {
            this.lastDayHeaderLogged = 0;
        }
        this.logHeader();
    }

    private void logHeader() {
        int currentDay = DateTime.now().getDayOfYear();
        if (currentDay != this.lastDayHeaderLogged) {
            this.lastDayHeaderLogged = currentDay;
            LOGGER.info("################### " + ((Object)((Object)this)).getClass().getSimpleName() + " ###################");
            LOGGER.info("DateTime UTC: " + DateTime.now((DateTimeZone)DateTimeZone.UTC));
            LOGGER.info("Automate Version: " + VersionResources.getVersion());
            LOGGER.info("JVM Version: " + System.getProperty("java.vendor") + " / " + System.getProperty("java.runtime.version") + " / " + System.getProperty("java.vm.name"));
            LOGGER.info("JVM Path: " + System.getProperty("java.home"));
            LOGGER.info("OS: " + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version"));
            LOGGER.info("PATH: " + System.getenv("PATH"));
            if (this.configuration.getEngineCommandLine() != null) {
                LOGGER.info("Command-line: " + this.configuration.getEngineCommandLine());
            }
            LOGGER.info("Role: " + this.configuration.getRole());
            try {
                NameResolver nameResolver = new NameResolver(this.configuration.getNameResolutionTimeout());
                LOGGER.info("IP addresses: " + String.join((CharSequence)",", nameResolver.getLocalIpAddresses()));
            }
            catch (Exception e) {
                LOGGER.info("IP addresses: Unknown");
            }
            LOGGER.info(NetworkConfiguration.fromSystemProperties().proxySettingsToString());
        }
    }

    public void initialize(Bootstrap<EngineConfiguration> bootstrap) {
        super.initialize(bootstrap);
        bootstrap.addCommand(new EngineCommand<EngineConfiguration>(this));
        bootstrap.getObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public void configureEngine() throws RemoteException {
        this.engine = new Engine(this);
    }

    public static String loadNuixLibraries(String nuixEnginePath) throws IOException {
        try {
            String nuixWorkstationVersion;
            nuixEnginePath = StringUtils.stripEnd((String)nuixEnginePath, (String)"\\ /");
            LOGGER.info("Loading Engine from " + nuixEnginePath);
            LibraryUtils nuixEngineLibraryUtils = new LibraryUtils(nuixEnginePath + "/lib", null, false, false);
            File nonFipsLibraries = new File(nuixEnginePath + "/lib/non-fips");
            if (nonFipsLibraries.exists()) {
                LibraryUtils libraryUtils = new LibraryUtils(nuixEnginePath + "/lib/non-fips", null, false, false);
            }
            if ((nuixWorkstationVersion = nuixEngineLibraryUtils.getNuixWorkstationVersion()) != null) {
                throw new IOException("Expected Engine but detected Nuix Workstation at " + nuixEnginePath);
            }
            Set engineVersions = nuixEngineLibraryUtils.getNuixEngineVersions();
            if (engineVersions.size() == 0) {
                throw new IOException("Cannot find Engine at " + nuixEnginePath);
            }
            if (engineVersions.size() > 1) {
                throw new IOException("Detected multiple Engine versions at " + nuixEnginePath + ": " + String.join((CharSequence)", ", engineVersions));
            }
            if (OsUtils.getOsWindows()) {
                LOGGER.info("Loading Jacob library");
                File engineLibFile = new File(nuixEnginePath);
                System.setProperty("jacob.dll.path", engineLibFile.getAbsolutePath() + "\\bin\\jacob.dll");
                LibraryLoader.loadJacobLibrary();
            }
            return (String)engineVersions.iterator().next();
        }
        catch (Throwable t) {
            LOGGER.error("Cannot load Engine libraries", t);
            throw new IOException("Engine folder " + nuixEnginePath + " is invalid", t);
        }
    }

    private void loadNativeDependencies() throws IOException {
        try {
            File nativeLibFile = new File(CommandLineUtils.getJarFile().getParentFile().getAbsolutePath() + "/scheduler/rampiva-automate-native-dependencies.jar");
            LOGGER.info("Loading Native library " + nativeLibFile.getAbsolutePath());
            LibraryUtils libraryUtils = new LibraryUtils();
            libraryUtils.addJarToClasspath(nativeLibFile);
        }
        catch (Throwable t) {
            LOGGER.error("Cannot load library", t);
            throw new IOException("Cannot load library", t);
        }
    }

    private void loadWorkflowDependenciesB() throws IOException {
        try {
            File nativeLibFile = new File(CommandLineUtils.getJarFile().getParentFile().getAbsolutePath() + "/dpb/workflow-dependencies-b.jar");
            LOGGER.info("Loading Workflow Dependency B library " + nativeLibFile.getAbsolutePath());
            LibraryUtils libraryUtils = new LibraryUtils();
            libraryUtils.addJarToClasspath(nativeLibFile);
        }
        catch (Throwable t) {
            LOGGER.error("Cannot load library", t);
            throw new IOException("Cannot load library", t);
        }
    }

    public void run(EngineConfiguration configuration, Environment environment) throws Exception {
        this.initializing = true;
        this.environment = environment;
        this.configuration = configuration;
        LOGGER.info("\n\n");
        LOGGER.info("######################### INIT #########################");
        this.logHeader();
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                EngineApplication.this.logHeader();
            }
        }, 0L, 60000L);
        this.runId = UidUtils.getRandom();
        try {
            LoggerContext context = LoggingUtil.getLoggerContext();
            Logger logger = context.getLogger("ROOT");
            this.centralizedLoggingAppender = new CentralizedLogInterceptor();
            this.centralizedLoggingAppender.setName("centralized-logging");
            this.centralizedLoggingAppender.setContext((Context)context);
            this.centralizedLoggingAppender.start();
            if (configuration.getEnableCentralizedLogging()) {
                logger.addAppender(this.centralizedLoggingAppender);
            }
            this.logHandler = LogHandler.getInstance();
            this.logHandler.configureInstance((AutomateApplication)this, (AutomateConfiguration)configuration);
            this.logHandler.updateLogHandlerComponent();
            this.nuixVersion = EngineApplication.loadNuixLibraries(configuration.getNuixEnginePath());
            if (this.getJavaVersionMajor() > 8) {
                this.loadWorkflowDependenciesB();
            }
            SystemResourcesUtils.getInstance().checkMemoryUsage("Init");
            this.licenceUtils = new LicenceUtils();
            this.logHeader(true);
        }
        catch (Exception e) {
            this.closeWithDelay(10000L, "Init exception " + e.getMessage());
            throw e;
        }
        this.initializing = false;
    }

    public String getName() {
        return "Engine Application";
    }

    public String getRunId() {
        return this.runId;
    }

    public String getJavaVersion() {
        return System.getProperty("java.vendor") + " " + System.getProperty("java.runtime.version");
    }

    public int getJavaVersionMajor() {
        String[] versionElements = System.getProperty("java.version").split("\\.");
        int discard = Integer.parseInt(versionElements[0]);
        int version = discard == 1 ? Integer.parseInt(versionElements[1]) : discard;
        return version;
    }

    public CentralizedLogInterceptor<ILoggingEvent> getCentralizedLoggingAppender() {
        return this.centralizedLoggingAppender;
    }

    public void startCentralizedLoggingAdapter() {
        this.getCentralizedLoggingAppender().start();
    }

    public void stopCentralizedLoggingAdapter() {
        this.getCentralizedLoggingAppender().stop();
    }

    public HealthInfo getHealthInfo() {
        return new HealthInfo("OK", (Response.StatusType)Response.Status.OK);
    }

    public boolean getInitializing() {
        return this.initializing;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public synchronized Map<String, Object> getWorkerBrokerOptions() {
        Integer startPort;
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (this.configuration.getWorkerBrokerIP() != null && this.configuration.getWorkerBrokerIP().length() > 0) {
            options.put("bindAddress", this.configuration.getWorkerBrokerIP());
        }
        if ((startPort = this.configuration.getWorkerBrokerStartPort()) != null) {
            Integer endPort = this.configuration.getWorkerBrokerEndPort();
            if (endPort == null && endPort < startPort) {
                LOGGER.warn("Resetting workerBrokerEndPort from " + endPort + " to 65535");
                endPort = 65535;
            }
            int portRange = endPort - startPort;
            int port = startPort + this.random.nextInt(portRange + 1);
            options.put("port", port);
        }
        return options;
    }

    public void closeWithDelay(long delay, String reason) {
        LOGGER.info("Preparing to close application");
        Thread closingThread = new Thread(() -> {
            LOGGER.info("Cleaning up");
            try {
                if (delay > 0L) {
                    LOGGER.info("Waiting " + delay + " ms before stopping ...");
                    Thread.sleep(delay);
                    LOGGER.info("Finished waiting");
                }
                LOGGER.info("Closing application");
                this.close();
            }
            catch (Exception e) {
                LOGGER.error("Cannot close application", (Throwable)e);
            }
            finally {
                System.exit(0);
            }
        });
        closingThread.setName("Automate Engine - Close Thread");
        closingThread.start();
    }

    private void close() throws Exception {
        if (!this.closing) {
            this.closing = true;
            if (this.engine != null) {
                try {
                    this.engine.close();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot close Engine", (Throwable)e);
                }
            }
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        new EngineApplication().run(args);
    }
}

