/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.engine;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.utils.general.OsUtils;
import io.dropwizard.core.Configuration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EngineConfiguration
extends Configuration
implements AutomateConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(EngineConfiguration.class);
    private String engineId = null;
    private String jobId = null;
    private long engineTimeout = 300000L;
    private long engineKeepAlive = 3600000L;
    private long engineAbortTimeout = 5000L;
    private int serverLocalPort = 0;
    private ExecutionMode executionMode = ExecutionMode.AUTOMATE_NUIX;
    private String nuixEnginePath = SystemUtils.getProgramFilesDir() + "\\Nuix\\Nuix Engine";
    private String engineCommandLine = null;
    private boolean enableCentralizedLogging = true;
    private int centralizedLoggingRetention = 30;
    private long centralizedLoggingMaxSize = 1000000000L;
    private int centralizedLoggingMaxActiveLines = 10000;
    private String log4jConfigurationFile = "C:\\ProgramData\\Nuix\\Automate\\EngineServer\\config\\log4j.properties";
    private long nameResolutionTimeout = 500L;
    private boolean deleteCachedClsCredentials = true;
    private boolean deleteCookiesWhenInitializingEngine = false;
    private String workerBrokerIP = null;
    private Integer workerBrokerStartPort = null;
    private Integer workerBrokerEndPort = null;
    private int workerBrokerInitAttempts = 100;
    private int jobRunningLogMaxSize = 20;
    private long apiClientConnectionTimeout = 5000L;
    private long apiClientReadTimeout = 45000L;
    private String engineServerUserDataDirPath;
    private String engineServerJobFilesDirectory;

    public boolean getDeleteCookiesWhenInitializingEngine() {
        return this.deleteCookiesWhenInitializingEngine;
    }

    public void setDeleteCookiesWhenInitializingEngine(boolean deleteCookiesWhenInitializingEngine) {
        this.deleteCookiesWhenInitializingEngine = deleteCookiesWhenInitializingEngine;
    }

    public long getNameResolutionTimeout() {
        return this.nameResolutionTimeout;
    }

    public void setNameResolutionTimeout(long nameResolutionTimeout) {
        this.nameResolutionTimeout = nameResolutionTimeout;
    }

    public int getServerLocalPort() {
        return this.serverLocalPort;
    }

    public void setServerLocalPort(int serverLocalPort) {
        this.serverLocalPort = serverLocalPort;
    }

    public long getEngineTimeout() {
        return this.engineTimeout;
    }

    public void setEngineTimeout(long engineTimeout) {
        this.engineTimeout = engineTimeout;
    }

    public boolean shouldDeleteCachedClsCredentials() {
        return this.deleteCachedClsCredentials;
    }

    public void setDeleteCachedClsCredentials(boolean deleteCachedClsCredentials) {
        this.deleteCachedClsCredentials = deleteCachedClsCredentials;
    }

    @JsonProperty
    public String getNuixUserDataDir() {
        List userDataDirPaths = this.getNuixUserDataDirPaths().stream().map(Path::toString).collect(Collectors.toList());
        if (OsUtils.getOsWindows()) {
            return String.join((CharSequence)";", userDataDirPaths);
        }
        return String.join((CharSequence)":", userDataDirPaths);
    }

    public List<Path> getNuixUserDataDirPaths() {
        ArrayList<Path> userDataDirPaths = new ArrayList<Path>();
        if (this.engineServerUserDataDirPath != null) {
            LOGGER.info((Object)("Setting userDataDir from Server userDataDir: " + this.engineServerUserDataDirPath));
            userDataDirPaths.add(Paths.get(this.engineServerUserDataDirPath, new String[0]));
        }
        if (OsUtils.getOsWindows()) {
            LOGGER.info((Object)("Setting userDataDir APPDATA: " + Paths.get(System.getenv("APPDATA"), "Nuix")));
            userDataDirPaths.add(Paths.get(System.getenv("APPDATA"), "Nuix"));
            LOGGER.info((Object)("Setting userDataDir PROGRAMDATA: " + Paths.get(System.getenv("PROGRAMDATA"), "Nuix")));
            userDataDirPaths.add(Paths.get(System.getenv("PROGRAMDATA"), "Nuix"));
        } else {
            LOGGER.info((Object)("Setting userDataDir user.home: " + Paths.get(System.getProperty("user.home") + "/.nuix", new String[0])));
            userDataDirPaths.add(Paths.get(System.getProperty("user.home") + "/.nuix", new String[0]));
        }
        LOGGER.info((Object)("Setting userDataDir Engine: " + Paths.get(this.getNuixEnginePath() + "/user-data", new String[0])));
        userDataDirPaths.add(Paths.get(this.getNuixEnginePath() + "/user-data", new String[0]));
        return userDataDirPaths;
    }

    public SchedulerComponent getRole() {
        return SchedulerComponent.ENGINE;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public boolean getEnableCentralizedLogging() {
        return this.enableCentralizedLogging;
    }

    public int getCentralizedLoggingRetention() {
        return this.centralizedLoggingRetention;
    }

    public long getCentralizedLoggingMaxSize() {
        return this.centralizedLoggingMaxSize;
    }

    public int getCentralizedLoggingMaxActiveLines() {
        return this.centralizedLoggingMaxActiveLines;
    }

    public void setEnableCentralizedLogging(boolean enable) {
        this.enableCentralizedLogging = enable;
    }

    public void setRole(SchedulerComponent role) {
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setCentralizedLoggingRetention(int centralizedLoggingRetention) {
        this.centralizedLoggingRetention = centralizedLoggingRetention;
    }

    public void setCentralizedLoggingMaxSize(long centralizedLoggingMaxSize) {
        this.centralizedLoggingMaxSize = centralizedLoggingMaxSize;
    }

    public void setCentralizedLoggingMaxActiveLines(int centralizedLoggingMaxActiveLines) {
        this.centralizedLoggingMaxActiveLines = centralizedLoggingMaxActiveLines;
    }

    public String getLog4jConfigurationFile() {
        return this.log4jConfigurationFile;
    }

    public void setLog4jConfigurationFile(String log4jConfigurationFile) {
        this.log4jConfigurationFile = log4jConfigurationFile;
    }

    public String getWorkerBrokerIP() {
        return this.workerBrokerIP;
    }

    public void setWorkerBrokerIP(String workerBrokerIP) {
        this.workerBrokerIP = workerBrokerIP;
    }

    public Integer getWorkerBrokerStartPort() {
        return this.workerBrokerStartPort;
    }

    public void setWorkerBrokerStartPort(Integer workerBrokerStartPort) {
        this.workerBrokerStartPort = workerBrokerStartPort;
    }

    public Integer getWorkerBrokerEndPort() {
        return this.workerBrokerEndPort;
    }

    public void setWorkerBrokerEndPort(Integer workerBrokerEndPort) {
        this.workerBrokerEndPort = workerBrokerEndPort;
    }

    public int getWorkerBrokerInitAttempts() {
        return this.workerBrokerInitAttempts;
    }

    public void setWorkerBrokerInitAttempts(int workerBrokerInitAttempts) {
        this.workerBrokerInitAttempts = workerBrokerInitAttempts;
    }

    public int getJobRunningLogMaxSize() {
        return this.jobRunningLogMaxSize;
    }

    public void setJobRunningLogMaxSize(int jobRunningLogMaxSize) {
        this.jobRunningLogMaxSize = jobRunningLogMaxSize;
    }

    public String getNuixEnginePath() {
        return this.nuixEnginePath;
    }

    public void setNuixEnginePath(String nuixEnginePath) {
        this.nuixEnginePath = nuixEnginePath;
    }

    public String getEngineCommandLine() {
        return this.engineCommandLine;
    }

    public void setEngineCommandLine(String engineCommandLine) {
        this.engineCommandLine = engineCommandLine;
    }

    public long getEngineKeepAlive() {
        return this.engineKeepAlive;
    }

    public void setEngineKeepAlive(long engineKeepAlive) {
        this.engineKeepAlive = engineKeepAlive;
    }

    public long getEngineAbortTimeout() {
        return this.engineAbortTimeout;
    }

    public void setEngineAbortTimeout(long engineAbortTimeout) {
        this.engineAbortTimeout = engineAbortTimeout;
    }

    public long getApiClientConnectionTimeout() {
        return this.apiClientConnectionTimeout;
    }

    public void setApiClientConnectionTimeout(long apiClientConnectionTimeout) {
        this.apiClientConnectionTimeout = apiClientConnectionTimeout;
    }

    public long getApiClientReadTimeout() {
        return this.apiClientReadTimeout;
    }

    public void setApiClientReadTimeout(long apiClientReadTimeout) {
        this.apiClientReadTimeout = apiClientReadTimeout;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    private String getInstallationPath(String product) {
        if (OsUtils.getOsWindows()) {
            return "C:/ProgramData/Nuix/Automate/" + product;
        }
        return "/etc/nuix/automate/" + product.toLowerCase().replace(" ", "-").replace("engineserver", "engine-server");
    }

    public String getEngineServerUserDataDirPath() {
        return this.engineServerUserDataDirPath;
    }

    public void setEngineServerUserDataDirPath(String engineServerUserDataDirPath) {
        this.engineServerUserDataDirPath = engineServerUserDataDirPath;
    }

    public String getEngineServerJobFilesDirectory() {
        return this.engineServerJobFilesDirectory;
    }

    public void setEngineServerJobFilesDirectory(String engineServerJobFilesDirectory) {
        this.engineServerJobFilesDirectory = engineServerJobFilesDirectory;
    }
}

