/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.engine.nuix;

import com.nuix.automate.engine.EngineConfiguration;
import com.nuix.automate.engine.nuix.NuixLicenseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.NameResolver;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.nuixlicensesource.RelayType;
import com.nuix.automate.utils.models.api.nuixlicensesource.SourceType;
import com.nuix.automate.utils.nuix.Version;
import jakarta.xml.bind.DatatypeConverter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.ObjectName;
import nuix.engine.AvailableLicence;
import nuix.engine.CredentialsCallback;
import nuix.engine.CredentialsCallbackInfo;
import nuix.engine.Engine;
import nuix.engine.GlobalContainer;
import nuix.engine.GlobalContainerFactory;
import nuix.engine.Licensor;

public class EngineFactory
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EngineFactory.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private GlobalContainer container = GlobalContainerFactory.newContainer();
    private static EngineFactory instance = null;
    private EngineConfiguration configuration;
    private NameResolver nameResolver;
    private List<Engine> engines;

    public static synchronized EngineFactory getInstance(EngineConfiguration configuration) {
        if (instance == null) {
            instance = new EngineFactory(configuration);
        }
        return instance;
    }

    public EngineFactory(EngineConfiguration configuration) {
        this.configuration = configuration;
        this.nameResolver = new NameResolver(configuration.getNameResolutionTimeout());
        this.engines = new ArrayList<Engine>();
    }

    public Engine createUnlicensedEngine(List<Path> engineUserDataDirPaths, String log4jConfigurationFile, String nuixLibPath, Map<String, String> nuixFlags) {
        Engine engine = null;
        System.setProperty("nuix.libdir", nuixLibPath);
        System.setProperty("log4j.configuration", new File(log4jConfigurationFile).toURI().toString());
        for (Map.Entry<String, String> entry : nuixFlags.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
        HashMap<String, List<Path>> engineConfiguration = new HashMap<String, List<Path>>();
        engineConfiguration.put("userDataDirs", engineUserDataDirPaths);
        engine = this.container.newEngine(engineConfiguration);
        this.engines.add(engine);
        return engine;
    }

    public Engine createEngineWithDongleLicence(String engineName, Version nuixVersion, String filter, String engineUserName, List<Path> engineUserDataDirPaths, String log4jConfigurationFile, int nuixWorkers, int minWorkers, String nuixLibPath, Map<String, String> nuixFlags) throws IOException, NuixLicenseException {
        Engine engine = null;
        ArrayList errorMessages = new ArrayList();
        try {
            System.setProperty("nuix.libdir", nuixLibPath);
            System.setProperty("log4j.configuration", new File(log4jConfigurationFile).toURI().toString());
            for (Map.Entry<String, String> pair : nuixFlags.entrySet()) {
                System.setProperty(pair.getKey(), pair.getValue());
            }
            HashMap<String, Object> engineConfiguration = new HashMap<String, Object>();
            engineConfiguration.put("user", ObjectName.quote(engineUserName));
            engineConfiguration.put("userDataDirs", engineUserDataDirPaths);
            engine = this.container.newEngine(engineConfiguration);
            this.engines.add(engine);
            Licensor licensor = engine.getLicensor();
            HashMap<Object, Object> licensorConfiguration = new HashMap<Object, Object>();
            licensorConfiguration.put("sources", "dongle");
            this.setLicenseSourceFromFlag(licensorConfiguration);
            LOGGER.info("Engine " + engineName + " scanning for licenses");
            Iterable availableLicenses = null;
            availableLicenses = licensor.findAvailableLicences(licensorConfiguration);
            if (availableLicenses != null) {
                List<AvailableLicence> sortedAvailableLicenses = this.sortLicensesByTypeAndWorkers(availableLicenses);
                for (AvailableLicence availableLicense : sortedAvailableLicenses) {
                    LOGGER.info("Engine " + engineName + " discovered licence " + availableLicense);
                    HashMap licenseAcquisitionArgs = new HashMap();
                    Integer availableWorkers = availableLicense.getWorkers();
                    if (availableWorkers == null || availableWorkers < minWorkers) {
                        LOGGER.info("Licence does not have sufficient workers, required " + minWorkers + ", available " + availableWorkers);
                        continue;
                    }
                    if (!(filter == null || filter.length() <= 0 || availableLicense.toString().toLowerCase().contains(filter.toLowerCase()) || availableLicense.getShortName().toLowerCase().contains(filter.toLowerCase()) || availableLicense.getDescription().toLowerCase().contains(filter.toLowerCase()))) {
                        LOGGER.info("Licence " + availableLicense.toString() + " / " + availableLicense.getShortName() + " / " + availableLicense.getDescription() + " does not match filter " + filter);
                        continue;
                    }
                    availableLicense.acquire(licenseAcquisitionArgs);
                    LOGGER.info("Engine " + engineName + " acquired license " + availableLicense);
                    return engine;
                }
            }
            if (errorMessages.size() > 0) {
                throw new IOException(String.join((CharSequence)", ", (CharSequence)errorMessages.get(0)));
            }
            throw new NuixLicenseException();
        }
        catch (IOException e) {
            throw e;
        }
        catch (NuixLicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            NuixLicenseException e = new NuixLicenseException(t);
            throw e;
        }
    }

    public synchronized Engine createEngineWithCloudLicence(String engineName, String filter, String engineUserName, List<Path> engineUserDataDirPaths, String log4jConfigurationFile, String licenceUserName, String licencePassword, Integer nuixWorkers, Integer minWorkers, String nuixLibPath, Map<String, String> nuixFlags) throws IOException, NuixLicenseException {
        return this.createEngineWithCloudLicence(engineName, filter, engineUserName, engineUserDataDirPaths, log4jConfigurationFile, licenceUserName, licencePassword, nuixWorkers, minWorkers, nuixLibPath, nuixFlags, this.configuration.shouldDeleteCachedClsCredentials());
    }

    private void setLicenseSourceFromFlag(Map<Object, Object> licensorConfiguration) {
        String licenseHandlers = System.getProperty("nuix.licence.handlers");
        if (licenseHandlers != null) {
            LOGGER.info("Setting Engine nuix.licence.handlers: " + licenseHandlers);
            licensorConfiguration.put("sources", licenseHandlers);
        }
    }

    private List<AvailableLicence> sortLicensesByTypeAndWorkers(Iterable<AvailableLicence> availableLicenses) {
        ArrayList<AvailableLicence> sortedAvailableLicenses = new ArrayList<AvailableLicence>();
        for (AvailableLicence availableLicense : availableLicenses) {
            sortedAvailableLicenses.add(availableLicense);
        }
        sortedAvailableLicenses.sort((l1, l2) -> {
            int s1 = 0;
            if (l1.getShortName().contains("workstation")) {
                s1 += 10000;
            }
            if (l1.getWorkers() != null) {
                s1 += Math.max(1000, l1.getWorkers());
            }
            int s2 = 0;
            if (l2.getShortName().contains("workstation")) {
                s2 += 10000;
            }
            if (l2.getWorkers() != null) {
                s2 += Math.max(1000, l2.getWorkers());
            }
            return -Integer.compare(s1, s2);
        });
        return sortedAvailableLicenses;
    }

    private Engine createEngineWithCloudLicence(final String engineName, String filter, String engineUserName, List<Path> engineUserDataDirPaths, String log4jConfigurationFile, final String licenceUserName, final String licencePassword, Integer nuixWorkers, Integer minWorkers, String nuixLibPath, Map<String, String> nuixFlags, boolean deleteCachedClsCredentials) throws IOException, NuixLicenseException {
        Engine engine = null;
        ArrayList errorMessages = new ArrayList();
        if (deleteCachedClsCredentials) {
            this.clearCookies();
            this.deleteSecretStore();
            return this.createEngineWithCloudLicence(engineName, filter, engineUserName, engineUserDataDirPaths, log4jConfigurationFile, licenceUserName, licencePassword, nuixWorkers, minWorkers, nuixLibPath, nuixFlags, false);
        }
        try {
            System.setProperty("nuix.libdir", nuixLibPath);
            System.setProperty("log4j.configuration", new File(log4jConfigurationFile).toURI().toString());
            for (Map.Entry<String, String> pair : nuixFlags.entrySet()) {
                System.setProperty(pair.getKey(), pair.getValue());
            }
            HashMap<String, Object> engineConfiguration = new HashMap<String, Object>();
            engineConfiguration.put("user", ObjectName.quote(engineUserName));
            engineConfiguration.put("userDataDirs", engineUserDataDirPaths);
            engine = this.container.newEngine(engineConfiguration);
            this.engines.add(engine);
            engine.whenAskedForCredentials(new CredentialsCallback(){

                public void execute(CredentialsCallbackInfo credentialsCallbackInfo) {
                    LOGGER.info("Engine " + engineName + " NMS " + credentialsCallbackInfo.getAddress().toString() + " asked for credentials");
                    credentialsCallbackInfo.setUsername(licenceUserName);
                    credentialsCallbackInfo.setPassword(licencePassword);
                }
            });
            engine.whenAskedForCertificateTrust(certificateTrustCallbackInfo -> {
                errorMessages.add(this.iu.getString("EngineFactory.NmsCertificateNotTrusted"));
                certificateTrustCallbackInfo.setTrusted(false);
            });
            Licensor licensor = engine.getLicensor();
            HashMap<Object, Object> licensorConfiguration = new HashMap<Object, Object>();
            licensorConfiguration.put("sources", "cloud-server");
            this.setLicenseSourceFromFlag(licensorConfiguration);
            LOGGER.info("Engine " + engineName + " scanning for licenses");
            Iterable availableLicenses = null;
            String lastWarning = null;
            availableLicenses = licensor.findAvailableLicences(licensorConfiguration);
            if (availableLicenses != null) {
                List<AvailableLicence> sortedAvailableLicenses = this.sortLicensesByTypeAndWorkers(availableLicenses);
                for (AvailableLicence availableLicense : sortedAvailableLicenses) {
                    LOGGER.info("Engine " + engineName + " discovered licence " + availableLicense);
                    HashMap<String, Integer> licenseAcquisitionArgs = new HashMap<String, Integer>();
                    Integer availableWorkers = availableLicense.getWorkers();
                    if (filter != null && filter.length() > 0 && !availableLicense.getShortName().toLowerCase().contains(filter.toLowerCase()) && !availableLicense.getDescription().toLowerCase().contains(filter.toLowerCase())) {
                        if (lastWarning == null) {
                            lastWarning = this.iu.getFormattedString("EngineFactory.LicenceDoesNotMatchFilter", (Object)filter);
                        }
                        LOGGER.info("Licence does not match filter " + filter);
                        continue;
                    }
                    if (availableWorkers != null && availableWorkers < minWorkers) {
                        lastWarning = this.iu.getFormattedString("EngineFactory.RequiredAvailableWorkers", new Object[]{minWorkers, availableWorkers});
                        LOGGER.info("Licence does not have sufficient workers: required " + minWorkers + " / available " + availableWorkers);
                        continue;
                    }
                    if (availableLicense.canChooseWorkers()) {
                        int requestWorkerCount = Math.min(availableWorkers, nuixWorkers);
                        LOGGER.info("Requesting workerCount: " + requestWorkerCount);
                        licenseAcquisitionArgs.put("workerCount", requestWorkerCount);
                    }
                    availableLicense.acquire(licenseAcquisitionArgs);
                    LOGGER.info("Engine " + engineName + " acquired license " + availableLicense);
                    return engine;
                }
            }
            if (errorMessages.size() > 0) {
                throw new IOException(String.join((CharSequence)", ", (CharSequence)errorMessages.get(0)));
            }
            if (lastWarning != null) {
                throw new NuixLicenseException(lastWarning);
            }
            throw new NuixLicenseException();
        }
        catch (IOException e) {
            throw e;
        }
        catch (NuixLicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            NuixLicenseException e = new NuixLicenseException(t);
            throw e;
        }
    }

    private void clearCookies() {
        if (this.configuration != null && this.configuration.getDeleteCookiesWhenInitializingEngine()) {
            TreeSet<Path> cookieFolders = new TreeSet<Path>();
            cookieFolders.add(Paths.get(System.getenv("APPDATA") + "\\Nuix\\Cookies2", new String[0]));
            cookieFolders.add(Paths.get(System.getenv("PROGRAMDATA") + "\\Nuix\\Cookies2", new String[0]));
            cookieFolders.add(Paths.get(System.getProperty("user.home") + "/.nuix/Cookies2", new String[0]));
            for (Path cookieFolder : cookieFolders) {
                if (!cookieFolder.toFile().exists()) continue;
                LOGGER.info("Deleting contents of " + cookieFolder.toFile().getAbsolutePath());
                cookieFolder.forEach(path -> {
                    try {
                        LOGGER.info("Deleting " + path.toFile().getAbsolutePath());
                        path.toFile().delete();
                    }
                    catch (Throwable t) {
                        LOGGER.error("Cannot delete file", t);
                    }
                });
            }
        }
    }

    private void deleteSecretStore() {
        TreeSet<Path> secretStores = new TreeSet<Path>();
        secretStores.add(Paths.get(System.getenv("APPDATA") + "\\Nuix\\SecretStore\\default_v2.jks", new String[0]));
        secretStores.add(Paths.get(System.getenv("PROGRAMDATA") + "\\Nuix\\SecretStore\\default_v2.jks", new String[0]));
        secretStores.add(Paths.get(System.getProperty("user.home") + "/.nuix/SecretStore/default_v2.jks", new String[0]));
        for (Path secretStorePath : secretStores) {
            if (!secretStorePath.toFile().exists()) continue;
            try {
                LOGGER.info("The SecretStore " + secretStorePath.toFile().getAbsolutePath() + " was deleted");
                secretStorePath.toFile().delete();
            }
            catch (Throwable t) {
                LOGGER.error("Cannot delete " + secretStorePath.toFile().getAbsolutePath(), t);
            }
        }
    }

    public synchronized Engine createEngineWithNetworkLicence(final String engineName, Version nuixVersion, RelayType relayType, String filter, String nuixLicenceServerName, Integer nuixLicenceServerPort, String engineUserName, List<Path> engineUserDataDirPaths, String log4jConfigurationFile, final String licenceUserName, final String licencePassword, Integer nuixWorkers, Integer minWorkers, String nuixLibPath, Map<String, String> nuixFlags, SourceType sourceType, Set<String> whitelistedCertificates) throws IOException, NuixLicenseException {
        this.clearCookies();
        Engine engine = null;
        ArrayList errorMessages = new ArrayList();
        try {
            if (licencePassword == null || licencePassword.length() == 0) {
                throw new IOException(this.iu.getString("EngineFactory.NuixLicenceSourcePasswordInvalid"));
            }
            String[] serverNameSplits = nuixLicenceServerName.split("/");
            System.setProperty("nuix.registry.servers", serverNameSplits[0] + ":" + nuixLicenceServerPort);
            System.setProperty("nuix.libdir", nuixLibPath);
            System.setProperty("log4j.configuration", new File(log4jConfigurationFile).toURI().toString());
            InetSocketAddress nmsRequestedAddress = new InetSocketAddress(serverNameSplits[0], (int)nuixLicenceServerPort);
            final Set nmsRequestedNames = this.nameResolver.resolveName(nmsRequestedAddress);
            if (serverNameSplits.length > 1) {
                nmsRequestedNames.add(serverNameSplits[1]);
            }
            for (Map.Entry<String, String> pair : nuixFlags.entrySet()) {
                System.setProperty(pair.getKey(), pair.getValue());
            }
            HashMap<String, Object> engineConfiguration = new HashMap<String, Object>();
            engineConfiguration.put("user", ObjectName.quote(engineUserName));
            engineConfiguration.put("userDataDirs", engineUserDataDirPaths);
            engine = this.container.newEngine(engineConfiguration);
            this.engines.add(engine);
            engine.whenAskedForCredentials(new CredentialsCallback(){

                public void execute(CredentialsCallbackInfo credentialsCallbackInfo) {
                    Set nmsObtainedNames = EngineFactory.this.nameResolver.resolveName(credentialsCallbackInfo.getAddress());
                    LOGGER.info("Engine " + engineName + " NMS " + String.join((CharSequence)"/", nmsObtainedNames) + " asked for credentials, expected " + String.join((CharSequence)"/", nmsRequestedNames));
                    if (EngineFactory.this.nameResolver.namesNetworkEquivalent(nmsObtainedNames, nmsRequestedNames)) {
                        LOGGER.info("Engine " + engineName + " NMS " + credentialsCallbackInfo.getAddress().toString() + " authenticating as " + licenceUserName);
                        credentialsCallbackInfo.setUsername(licenceUserName);
                        credentialsCallbackInfo.setPassword(licencePassword);
                    } else {
                        LOGGER.info("Engine " + engineName + " NMS mismatched server name/IP, skipping");
                    }
                }
            });
            engine.whenAskedForCertificateTrust(certificateTrustCallbackInfo -> {
                String fingerprint = null;
                if (certificateTrustCallbackInfo.getCertificateChain().size() > 0) {
                    X509Certificate certificate = (X509Certificate)certificateTrustCallbackInfo.getCertificateChain().get(certificateTrustCallbackInfo.getCertificateChain().size() - 1);
                    try {
                        fingerprint = DatatypeConverter.printHexBinary((byte[])MessageDigest.getInstance("SHA-256").digest(certificate.getEncoded())).toLowerCase();
                    }
                    catch (NoSuchAlgorithmException e) {
                        LOGGER.error("Unexpected error", (Throwable)e);
                    }
                    catch (CertificateEncodingException e) {
                        LOGGER.error("Unexpected error", (Throwable)e);
                    }
                }
                if (fingerprint != null && whitelistedCertificates != null) {
                    for (String whitelistedCertificate : whitelistedCertificates) {
                        if (!whitelistedCertificate.trim().equalsIgnoreCase(fingerprint.trim())) continue;
                        certificateTrustCallbackInfo.setTrusted(true);
                        return;
                    }
                }
                if (fingerprint != null) {
                    errorMessages.add(this.iu.getFormattedString("EngineFactory.NmsCertificateNotTrustedPleaseWhitelist", fingerprint));
                } else {
                    errorMessages.add(this.iu.getString("EngineFactory.NMSCertificateNotTrustedNullFingerprint"));
                }
                certificateTrustCallbackInfo.setTrusted(false);
            });
            boolean usingRelay = false;
            Licensor licensor = engine.getLicensor();
            HashMap<Object, Object> licensorConfiguration = new HashMap<Object, Object>();
            if (relayType == null || RelayType.NONE.equals((Object)relayType)) {
                licensorConfiguration.put("sources", "server");
            } else if (RelayType.RELAY_CLS_AUTH.equals((Object)relayType)) {
                usingRelay = true;
                licensorConfiguration.put("sources", "local-relay-server-cls-users");
            } else if (RelayType.RELAY_NMS_AUTH.equals((Object)relayType)) {
                usingRelay = true;
                licensorConfiguration.put("sources", "local-relay-server-local-users");
            }
            this.setLicenseSourceFromFlag(licensorConfiguration);
            LOGGER.info("Engine " + engineName + " scanning for licenses");
            Iterable availableLicenses = null;
            String lastWarning = null;
            availableLicenses = licensor.findAvailableLicences(licensorConfiguration);
            if (availableLicenses != null) {
                List<AvailableLicence> sortedAvailableLicenses = this.sortLicensesByTypeAndWorkers(availableLicenses);
                for (AvailableLicence availableLicense : sortedAvailableLicenses) {
                    InetSocketAddress obtainedAddress;
                    String location;
                    LOGGER.info("Engine " + engineName + " discovered licence " + availableLicense + " from " + availableLicense.getSource().getLocation());
                    if (usingRelay) {
                        location = availableLicense.getSource().getLocation();
                        location = location.toLowerCase().replace("https://", "");
                        location = location.split("/")[0];
                    } else {
                        location = availableLicense.getSource().getLocation();
                    }
                    String[] locationSplits = location.split(":");
                    try {
                        obtainedAddress = new InetSocketAddress(locationSplits[0], Integer.parseInt(locationSplits[1]));
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot parse address " + availableLicense.getSource().getLocation(), (Throwable)e);
                        obtainedAddress = new InetSocketAddress(availableLicense.getSource().getLocation(), 27443);
                    }
                    Set nmsObtainedNames = this.nameResolver.resolveName(obtainedAddress);
                    if (!this.nameResolver.namesNetworkEquivalent(nmsObtainedNames, nmsRequestedNames)) {
                        LOGGER.info("Engine " + engineName + " license source invalid " + String.join((CharSequence)"/", nmsObtainedNames) + ", expected " + String.join((CharSequence)"/", nmsRequestedNames));
                        continue;
                    }
                    LOGGER.info("Engine " + engineName + " license source OK " + String.join((CharSequence)"/", nmsObtainedNames) + ", expected " + String.join((CharSequence)"/", nmsRequestedNames));
                    HashMap<String, Integer> licenseAcquisitionArgs = new HashMap<String, Integer>();
                    Integer availableWorkers = availableLicense.getWorkers();
                    if (filter != null && filter.length() > 0 && !availableLicense.getShortName().toLowerCase().contains(filter.toLowerCase()) && !availableLicense.getDescription().toLowerCase().contains(filter.toLowerCase())) {
                        if (lastWarning == null) {
                            lastWarning = this.iu.getFormattedString("EngineFactory.LicenceDoesNotMatchFilter", (Object)filter);
                        }
                        LOGGER.info("Licence does not match filter " + filter);
                        continue;
                    }
                    if (availableWorkers != null && availableWorkers < minWorkers) {
                        lastWarning = this.iu.getFormattedString("EngineFactory.RequiredAvailableWorkers", new Object[]{minWorkers, availableWorkers});
                        LOGGER.info("Engine " + engineName + " Licence does not have sufficient workers: required " + minWorkers + " / available " + availableWorkers);
                        continue;
                    }
                    if (availableLicense.canChooseWorkers() && availableWorkers != null) {
                        int requestWorkerCount = Math.min(availableWorkers, nuixWorkers);
                        LOGGER.info("Requesting workerCount: " + requestWorkerCount);
                        licenseAcquisitionArgs.put("workerCount", requestWorkerCount);
                    }
                    availableLicense.acquire(licenseAcquisitionArgs);
                    LOGGER.info("Engine " + engineName + " acquired license " + availableLicense);
                    return engine;
                }
            }
            LOGGER.warn("Could not acquire Nuix license. Last warning: " + lastWarning);
            if (errorMessages.size() > 0) {
                throw new IOException(String.join((CharSequence)", ", (CharSequence)errorMessages.get(0)));
            }
            if (lastWarning != null) {
                throw new NuixLicenseException(lastWarning);
            }
            throw new NuixLicenseException();
        }
        catch (IOException e) {
            throw e;
        }
        catch (NuixLicenseException e) {
            throw e;
        }
        catch (Throwable t) {
            NuixLicenseException e = new NuixLicenseException(t);
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.engines != null) {
            for (Engine engine : this.engines) {
                if (engine == null) continue;
                try {
                    LOGGER.info("Closing engine");
                    engine.close();
                }
                catch (Exception e) {
                    LOGGER.info("Cannot close engine," + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                }
            }
        }
    }
}

