/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.engine.utils;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.executionprofile.NuixProfileType;
import com.nuix.automate.utils.nuix.ProfileTypeNuix;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.utils.general.FileParameterUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class ExecutionProfileUtils {
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ExecutionProfileUtils.class);
    private ExecutionProfileModel executionProfile;
    private Map<String, FileLibraryFile> libraryFiles;
    private FileParameterUtils fileParameterUtils;
    private String casePath;

    public ExecutionProfileUtils(ExecutionProfileModel executionProfile, String casePath) {
        this.executionProfile = executionProfile;
        this.casePath = casePath;
        this.fileParameterUtils = new FileParameterUtils();
    }

    public ExecutionProfileUtils(ExecutionProfileModel executionProfile, Map<String, FileLibraryFile> libraryFiles, String casePath) {
        this.executionProfile = executionProfile;
        this.libraryFiles = libraryFiles;
        this.casePath = casePath;
        this.fileParameterUtils = new FileParameterUtils();
    }

    public ExecutionProfileUtils() {
        this.fileParameterUtils = new FileParameterUtils();
    }

    public String isUnique(Set<String> list) {
        if (list != null) {
            HashSet<String> set = new HashSet<String>();
            for (String item : list) {
                if (set.add(item)) continue;
                return item;
            }
        }
        return "";
    }

    public String isUnique(Set<String> list, Map<String, FileLibraryFile> existingFiles, LibraryNuixFileType type) {
        if (list != null && existingFiles != null) {
            HashSet<String> set = new HashSet<String>();
            for (String item : list) {
                FileLibraryFile file = existingFiles.get(item);
                if (file.getNuixFileType() != type || set.add(file.getName())) continue;
                return file.getName();
            }
        }
        return "";
    }

    private LibraryNuixFileType convertType(NuixProfileType type) {
        switch (type) {
            case CONFIGURATION_PROFILE: {
                return LibraryNuixFileType.CONFIGURATION_PROFILE;
            }
            case PRODUCTION_PROFILE: {
                return LibraryNuixFileType.PRODUCTION_PROFILE;
            }
            case PROCESSING_PROFILE: {
                return LibraryNuixFileType.PROCESSING_PROFILE;
            }
            case METADATA_PROFILE: {
                return LibraryNuixFileType.METADATA_PROFILE;
            }
            case METADATA_IMPORT_PROFILE: {
                return LibraryNuixFileType.METADATA_IMPORT_PROFILE;
            }
            case PLAYBOOK: {
                return LibraryNuixFileType.PLAYBOOK;
            }
            case IMAGING_PROFILE: {
                return LibraryNuixFileType.IMAGING_PROFILE;
            }
            case OCR_PROFILE: {
                return LibraryNuixFileType.OCR_PROFILE;
            }
        }
        return LibraryNuixFileType.CUSTOM_FILE;
    }

    private Map<String, String> filterProfiles(NuixProfileType typeFilter, boolean removeExtension) {
        HashMap<String, String> filteredProfiles = new HashMap<String, String>();
        LibraryNuixFileType type = this.convertType(typeFilter);
        if (this.libraryFiles != null) {
            for (FileLibraryFile file : this.libraryFiles.values()) {
                if (file.getNuixFileType() != type) continue;
                String fileName = file.getName();
                if (fileName.contains(".") && removeExtension) {
                    fileName = file.getName().substring(0, file.getName().lastIndexOf("."));
                }
                filteredProfiles.put(fileName, file.getData());
            }
        }
        return filteredProfiles;
    }

    private Map<ProfileTypeNuix, Set<String>> getFileLibraryNuixProfiles() {
        HashMap<ProfileTypeNuix, Set<String>> typeToProfileNames = new HashMap<ProfileTypeNuix, Set<String>>();
        if (this.libraryFiles != null && this.executionProfile != null && this.executionProfile.getNuixProfiles() != null) {
            for (String fileLibraryFileId : this.executionProfile.getNuixProfiles().keySet()) {
                FileLibraryFile executionProfileFile = this.libraryFiles.get(fileLibraryFileId);
                String fileName = FilenameUtils.removeExtension((String)executionProfileFile.getName());
                ProfileTypeNuix profileTypeNuix = ProfileTypeNuix.getProfileTypeFromFileType((LibraryNuixFileType)executionProfileFile.getNuixFileType());
                if (profileTypeNuix == null) continue;
                Set profileNames = typeToProfileNames.computeIfAbsent(profileTypeNuix, k -> new HashSet());
                profileNames.add(fileName);
            }
        }
        return typeToProfileNames;
    }

    private Map<String, FileLibraryFile> getAdditionalFiles() {
        Map additionalFiles = this.executionProfile.getAdditionalFiles();
        HashMap<String, FileLibraryFile> files = new HashMap<String, FileLibraryFile>();
        if (this.libraryFiles != null) {
            for (Map.Entry entry : additionalFiles.entrySet()) {
                files.put((String)entry.getKey(), this.libraryFiles.get(entry.getValue()));
            }
        }
        return files;
    }

    public void createNuixProfiles(WorkflowExecution workflowExecution) {
        Map nuixProfiles = this.executionProfile.getNuixProfiles();
        if (nuixProfiles != null) {
            this.createProfiles(this.casePath, this.filterProfiles(NuixProfileType.CONFIGURATION_PROFILE, false), NuixProfileType.CONFIGURATION_PROFILE, workflowExecution);
            this.createProfiles(this.casePath, this.filterProfiles(NuixProfileType.IMAGING_PROFILE, false), NuixProfileType.IMAGING_PROFILE, workflowExecution);
            this.createProfiles(this.casePath, this.filterProfiles(NuixProfileType.METADATA_PROFILE, false), NuixProfileType.METADATA_PROFILE, workflowExecution);
            this.createProfiles(this.casePath, this.filterProfiles(NuixProfileType.METADATA_IMPORT_PROFILE, false), NuixProfileType.METADATA_IMPORT_PROFILE, workflowExecution);
            this.createProfiles(this.casePath, this.filterProfiles(NuixProfileType.OCR_PROFILE, false), NuixProfileType.OCR_PROFILE, workflowExecution);
            this.createProfiles(this.casePath, this.filterProfiles(NuixProfileType.PROCESSING_PROFILE, false), NuixProfileType.PROCESSING_PROFILE, workflowExecution);
            this.createProfiles(this.casePath, this.filterProfiles(NuixProfileType.PRODUCTION_PROFILE, false), NuixProfileType.PRODUCTION_PROFILE, workflowExecution);
        }
    }

    public Map<ProfileTypeNuix, Set<String>> getNuixProfileList() {
        HashMap<ProfileTypeNuix, Set<String>> profiles = new HashMap();
        if (this.executionProfile != null && this.executionProfile.getNuixProfiles() != null) {
            profiles = this.getFileLibraryNuixProfiles();
        } else {
            profiles.put(ProfileTypeNuix.CONFIGURATION, new HashSet());
            profiles.put(ProfileTypeNuix.OCR, new HashSet());
            profiles.put(ProfileTypeNuix.IMAGING, new HashSet());
            profiles.put(ProfileTypeNuix.PROCESSING, new HashSet());
            profiles.put(ProfileTypeNuix.METADATA, new HashSet());
            profiles.put(ProfileTypeNuix.PRODUCTION, new HashSet());
        }
        return profiles;
    }

    public void createAdditionalFiles(WorkflowExecution workflowExecution, Path additionalFilesTempDirectory) {
        this.fileParameterUtils.createFiles(additionalFilesTempDirectory, this.getAdditionalFiles(), workflowExecution);
    }

    public void createFileParameters(WorkflowExecution workflowExecution, List<Parameter> sessionParameters, Path additionalFilesTempDirectory) {
        HashMap<String, FileLibraryFile> fileParameters = new HashMap<String, FileLibraryFile>();
        for (Parameter parameter : sessionParameters) {
            try {
                if (!parameter.isFile() || this.libraryFiles.get(parameter.getValue()) == null) continue;
                fileParameters.put(parameter.getName(), this.libraryFiles.get(parameter.getValue()));
            }
            catch (Exception e) {
                LOGGER.error("Unable to write " + parameter.getName() + " file", (Throwable)e);
            }
        }
        this.fileParameterUtils.createFileContentParameters(workflowExecution, sessionParameters, additionalFilesTempDirectory, fileParameters);
    }

    private void createProfiles(String casePath, Map<String, String> profiles, NuixProfileType profileType, WorkflowExecution workflowExecution) {
        if (profiles == null || profiles.size() == 0) {
            return;
        }
        try {
            Path profilesDirectory = Paths.get(casePath, profileType.getProfileDirectory());
            for (String profileName : profiles.keySet()) {
                boolean shouldCreateProfile;
                File profilePath = profilesDirectory.resolve(profileName).toFile();
                Path userDirPath = Paths.get(profileName, new String[0]);
                if (!this.fileParameterUtils.isSafePath(profilesDirectory, userDirPath)) continue;
                byte[] fileData = FileUtils.decodeFileData((String)profiles.get(profileName));
                if (profilePath.exists()) {
                    if (this.fileParameterUtils.shouldReplace(profilePath, fileData)) {
                        LOGGER.info("Replacing profile: " + profileName + " at: " + profilePath.getAbsolutePath());
                        workflowExecution.log(this.iu.getFormattedString("ExecutionProfileUtils.ReplacingProfile", new Object[]{profileType.getType(), profileName}));
                        shouldCreateProfile = true;
                    } else {
                        LOGGER.info("Existing Profile: " + profileName + " at: " + profilePath.getAbsolutePath() + " is the same");
                        shouldCreateProfile = false;
                    }
                } else {
                    LOGGER.info("Creating profile: " + profileName + " at: " + profilePath.getAbsolutePath());
                    workflowExecution.log(this.iu.getFormattedString("ExecutionProfileUtils.CreatingProfile", new Object[]{profileType.getType(), profileName}));
                    shouldCreateProfile = true;
                    if (!profilePath.getParentFile().exists()) {
                        profilePath.getParentFile().mkdirs();
                    }
                }
                if (!shouldCreateProfile) continue;
                this.fileParameterUtils.writeFileToPath(profilePath, fileData);
            }
        }
        catch (Exception e) {
            workflowExecution.log(e.getMessage(), LogLevel.ERROR);
        }
    }
}

