/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.engine.workers;

import com.nuix.automate.engine.workers.JobWorker;
import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.licence.services.Type;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Key;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.workflow.core.licence.NuixLicenceSession;
import java.io.IOException;
import nuix.Licence;

public class EngineLicenceSession
extends NuixLicenceSession {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EngineLicenceSession.class);
    private JobWorker jobWorker;

    public EngineLicenceSession(JobWorker jobWorker, LicenceInfo licenceInfo, Licence nuixLicence, Product product, String productVersion, String nuixVersion, Key key, DiagnosticLevel diagnosticLevel) {
        super(new Credentials(), licenceInfo, nuixLicence, product, productVersion, nuixVersion, key, diagnosticLevel);
        this.jobWorker = jobWorker;
    }

    public EventInfo getSessionStartEvent() {
        EventInfo eventInfo = super.getSessionStartEvent();
        if (this.jobWorker.getModel().getId() != null) {
            eventInfo.getProperties().put("jobId", this.jobWorker.getModel().getId());
        }
        if (this.jobWorker.getEngine() != null && this.jobWorker.getEngine().getWorkerAgentOnly()) {
            eventInfo.getProperties().put("remote", true);
        }
        return eventInfo;
    }

    protected synchronized void trackEvent(EventInfo eventInfo) throws IOException {
        if (eventInfo.getType() != Type.SESSION_END) {
            this.jobWorker.addSessionEventInfo(eventInfo);
        }
    }

    protected synchronized void trackConsumption(Consumption consumption) throws IOException {
        this.jobWorker.addConsumption(consumption);
    }

    protected void handleFailedEventTracking(EventInfo eventInfo, Exception e) {
    }

    protected void handleFailedConsumptionTracking(Consumption consumption, Exception e) {
    }

    protected void handleFailedUtilizationTracking(UtilizationRecords utilizationRecords, Exception e) {
    }

    protected boolean retryTrackingPreviouslyFailedEvents() {
        return false;
    }
}

