/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.api.configuration;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class NetworkConfiguration
extends UserPermissionModel {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NetworkConfiguration.class);
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTP_WHITELISTED_CERT_FINGERPRINTS = "http.whitelistedCertFingerprints";
    @Schema(description="Network Configuration ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Proxy Host", example="10.0.0.100")
    private String proxyHost;
    @Schema(description="Proxy Host", example="80")
    private Integer proxyPort;
    @Schema(description="Proxy Non-Hosts", example="[\"localhost\",\"127.*\",\"[::1]]\"]")
    private Set<String> nonProxyHosts;
    @Schema(description="Whitelisted Certificates Fingerprints (SHA-512)", example="[\"e62dd01ca608c10402d07714cfd626bfc6b1001e5a16ca039d1050a71f73ee24\",\"d5129635a050f63dd607ffa9271eefaab597c0975809765dad253973fc554d25\"]")
    private Set<String> whitelistedCertFingerprints;

    public static NetworkConfiguration fromSystemProperties() {
        NetworkConfiguration networkConfiguration = new NetworkConfiguration();
        networkConfiguration.updateFromSystemProperties();
        return networkConfiguration;
    }

    @Override
    public NetworkConfiguration clone() {
        NetworkConfiguration clone = (NetworkConfiguration)super.clone();
        clone.nonProxyHosts = new HashSet<String>();
        if (this.nonProxyHosts != null) {
            clone.nonProxyHosts.addAll(this.nonProxyHosts);
        }
        clone.whitelistedCertFingerprints = new HashSet<String>();
        if (this.whitelistedCertFingerprints != null) {
            clone.whitelistedCertFingerprints.addAll(this.whitelistedCertFingerprints);
        }
        return clone;
    }

    public NetworkConfiguration cloneLimited() {
        NetworkConfiguration limited = new NetworkConfiguration();
        limited.id = this.id;
        limited.setUserPermissions(this.cloneUserPermissions());
        return limited;
    }

    public boolean isProxyConfigured() {
        return this.proxyHost != null && !this.proxyHost.trim().isEmpty() && this.proxyPort != null;
    }

    public void validateUpdate(NetworkConfiguration configurationUpdate) throws ResponseException {
        String proxyHost = FormattingUtils.getTrimmedText(configurationUpdate.proxyHost);
        if (proxyHost != null) {
            try {
                proxyHost = FormattingUtils.getHostnameFromUrl(proxyHost);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        configurationUpdate.setProxyHost(proxyHost);
    }

    public void update(NetworkConfiguration configurationUpdate) {
        if (configurationUpdate.proxyHost != null) {
            this.setProxyHost(configurationUpdate.proxyHost);
        }
        if (configurationUpdate.proxyPort != null) {
            this.setProxyPort(configurationUpdate.proxyPort);
        }
        if (configurationUpdate.nonProxyHosts != null) {
            this.setNonProxyHosts(configurationUpdate.nonProxyHosts);
        }
        if (configurationUpdate.whitelistedCertFingerprints != null) {
            this.setWhitelistedCertFingerprints(configurationUpdate.whitelistedCertFingerprints);
        }
        this.updateNetworkSystemProperties();
    }

    public void clear() {
        this.proxyHost = null;
        this.proxyPort = null;
        this.nonProxyHosts = null;
        this.whitelistedCertFingerprints = null;
        this.updateNetworkSystemProperties();
    }

    public void updateFromSystemProperties() {
        String httpsProxyHost = System.getProperty(HTTPS_PROXY_HOST);
        String httpProxyHost = System.getProperty(HTTP_PROXY_HOST);
        if (httpsProxyHost != null && !httpsProxyHost.equals(httpProxyHost)) {
            LOGGER.info("Detected different https and http proxy host, https " + httpsProxyHost + "; http " + httpProxyHost);
        }
        this.proxyHost = httpsProxyHost;
        if (this.proxyHost == null) {
            this.proxyHost = httpProxyHost;
        }
        String httpsProxyPort = System.getProperty(HTTPS_PROXY_PORT);
        String httpProxyPort = System.getProperty(HTTP_PROXY_PORT);
        if (httpsProxyPort != null && !httpsProxyPort.equals(httpProxyPort)) {
            LOGGER.info("Detected different https and http proxy port, https " + httpsProxyPort + "; http " + httpProxyPort);
        }
        this.proxyPort = null;
        if (httpsProxyPort != null) {
            this.proxyPort = Integer.parseInt(httpsProxyPort);
        } else if (httpProxyPort != null) {
            this.proxyPort = Integer.parseInt(httpProxyPort);
        }
        this.nonProxyHosts = new HashSet<String>();
        String nonProxyHostsProp = System.getProperty(HTTP_NON_PROXY_HOSTS);
        if (nonProxyHostsProp != null) {
            String[] splits = nonProxyHostsProp.split("\\|");
            this.nonProxyHosts.addAll(Arrays.asList(splits));
        }
        this.setNonProxyHosts(this.nonProxyHosts);
        this.whitelistedCertFingerprints = new HashSet<String>();
        String whitelistedCertFingerprintsProp = System.getProperty(HTTP_WHITELISTED_CERT_FINGERPRINTS);
        if (whitelistedCertFingerprintsProp != null) {
            String[] splits = whitelistedCertFingerprintsProp.split("\\|");
            this.whitelistedCertFingerprints.addAll(Arrays.asList(splits));
        }
        this.setWhitelistedCertFingerprints(this.whitelistedCertFingerprints);
    }

    public void updateNetworkSystemProperties() {
        System.clearProperty(HTTPS_PROXY_HOST);
        System.clearProperty(HTTPS_PROXY_PORT);
        System.clearProperty(HTTP_PROXY_HOST);
        System.clearProperty(HTTP_PROXY_PORT);
        System.clearProperty(HTTP_NON_PROXY_HOSTS);
        System.clearProperty(HTTP_WHITELISTED_CERT_FINGERPRINTS);
        if (this.proxyHost != null) {
            System.setProperty(HTTPS_PROXY_HOST, this.proxyHost);
            System.setProperty(HTTP_PROXY_HOST, this.proxyHost);
        }
        if (this.proxyPort != null) {
            System.setProperty(HTTPS_PROXY_PORT, String.valueOf(this.proxyPort));
            System.setProperty(HTTP_PROXY_PORT, String.valueOf(this.proxyPort));
        }
        if (this.nonProxyHosts != null && !this.nonProxyHosts.isEmpty()) {
            System.setProperty(HTTP_NON_PROXY_HOSTS, this.getNonProxyHostsAsString());
        }
        if (this.whitelistedCertFingerprints != null && !this.whitelistedCertFingerprints.isEmpty()) {
            System.setProperty(HTTP_WHITELISTED_CERT_FINGERPRINTS, this.getWhitelistedCertFingerprintsAsString());
        }
    }

    public String toCommandLine() {
        ArrayList<String> commands = new ArrayList<String>();
        if (this.isProxyConfigured()) {
            commands.add("-Dhttps.proxyHost=" + this.proxyHost);
            commands.add("-Dhttps.proxyPort=" + this.proxyPort);
            commands.add("-Dhttp.proxyHost=" + this.proxyHost);
            commands.add("-Dhttp.proxyPort=" + this.proxyPort);
            if (this.nonProxyHosts != null && !this.nonProxyHosts.isEmpty()) {
                commands.add("-Dhttp.nonProxyHosts=" + this.getNonProxyHostsAsString());
            }
            if (this.whitelistedCertFingerprints != null && !this.whitelistedCertFingerprints.isEmpty()) {
                commands.add("-Dhttp.whitelistedCertFingerprints=" + this.getWhitelistedCertFingerprintsAsString());
            }
        }
        return String.join((CharSequence)" ", commands);
    }

    public String proxySettingsToString() {
        StringBuilder result = new StringBuilder();
        if (this.isProxyConfigured()) {
            result.append("Proxy: ");
            result.append(", Host ").append(this.proxyHost);
            result.append(", Port ").append(this.proxyPort);
            if (this.nonProxyHosts != null && !this.nonProxyHosts.isEmpty()) {
                result.append(", NonProxyHosts:").append(this.getNonProxyHostsAsString());
            }
            if (this.whitelistedCertFingerprints != null && !this.whitelistedCertFingerprints.isEmpty()) {
                result.append(", WhitelistedCertFingerprints:").append(this.getWhitelistedCertFingerprintsAsString());
            }
        } else {
            result.append("Proxy: Not configured");
        }
        return result.toString();
    }

    public String getNonProxyHostsAsString() {
        if (this.nonProxyHosts != null) {
            return String.join((CharSequence)"|", this.nonProxyHosts);
        }
        return null;
    }

    public void setNonProxyHosts(Set<String> nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
        if (this.nonProxyHosts != null) {
            this.nonProxyHosts.removeIf(e -> e == null || e.trim().isEmpty());
        }
    }

    public String getWhitelistedCertFingerprintsAsString() {
        if (this.whitelistedCertFingerprints != null) {
            return String.join((CharSequence)"|", this.whitelistedCertFingerprints);
        }
        return null;
    }

    public void setWhitelistedCertFingerprints(Set<String> whitelistedCertFingerprints) {
        this.whitelistedCertFingerprints = whitelistedCertFingerprints;
        if (this.whitelistedCertFingerprints != null) {
            this.whitelistedCertFingerprints.removeIf(e -> e == null || e.trim().isEmpty());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public Set<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public Set<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }
}

