/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.api.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

public class ResponseStatus
implements Serializable {
    @Schema(description="Response Code", example="400")
    private int code;
    @Schema(description="Response Message", example="Sample error response message")
    private String message;
    @Schema(description="Response Title", example="errorMessageId")
    private String title;
    @Schema(description="Redirect URL", example="https://example.com/logout")
    private String redirectUrl;

    public ResponseStatus() {
    }

    public ResponseStatus(int code, String message) {
        this(code, "", message);
    }

    public ResponseStatus(int code, String title, String message) {
        this.code = code;
        this.message = message;
        if (this.message != null && this.message.length() > 0 && !this.message.endsWith(".")) {
            this.message = this.message + ".";
        }
        this.title = title;
    }

    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @JsonProperty
    public int getCode() {
        return this.code;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @JsonProperty
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        String response = "";
        if (this.code > 0) {
            response = "Code " + this.code;
        }
        if (this.title != null && this.title.length() > 0) {
            if (response.length() > 0) {
                response = response + ", ";
            }
            response = response + this.title;
        }
        if (this.message != null && this.message.length() > 0) {
            if (response.length() > 0) {
                response = response + ", ";
            }
            response = response + this.message;
        }
        return response;
    }
}

