/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.azure;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.Instant;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AzureStorageClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AzureStorageClient.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");

    public String validateStorageAccountSasToken(String storageAccountSasToken, String tokenLabel) throws UnsupportedEncodingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Validating storage account SAS Token");
        }
        if (storageAccountSasToken == null || storageAccountSasToken.trim().length() == 0) {
            return this.iu.getString("AzCopy.Exception.StorageAccountSasTokenRequired" + tokenLabel);
        }
        for (String keyValuePair : URLDecoder.decode(storageAccountSasToken, "UTF-8").split("&")) {
            String[] pairSplit = keyValuePair.split("=");
            if (!pairSplit[0].equalsIgnoreCase("se")) continue;
            long expiryMillis = Instant.parse(pairSplit[1]).toEpochMilli();
            long currentMillis = new DateTime(DateTimeZone.UTC).getMillis();
            if (currentMillis > expiryMillis) {
                return this.iu.getFormattedString("AzCopy.Exception.StorageAccountSasTokenExpired" + tokenLabel, (Object)FormattingUtils.dateTimeToInternationalDateTimeString(new DateTime(expiryMillis)));
            }
            if (currentMillis <= expiryMillis - 300000L) break;
            return this.iu.getFormattedString("AzCopy.Exception.StorageAccountSasTokenExpirationImminent" + tokenLabel, (Object)FormattingUtils.dateTimeToInternationalDateTimeString(new DateTime(expiryMillis)));
        }
        return null;
    }
}

