/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.ecc.internal;

import com.nuix.automate.utils.ecc.internal.EccRemoteCommandType;
import com.nuix.automate.utils.ecc.internal.EccUtils;
import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.ecc.responses.computers.Presence;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.StaticParameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EccRemoteCommand
implements Callable<Boolean> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EccRemoteCommand.class);
    protected EccUtils utils = EccUtils.getInstance();
    protected Process remoteProcess;
    protected Thread standardOutputThread;
    protected Thread standardErrorThread;
    protected long commandStart;
    protected final String computerName;
    protected final Integer timeout;
    protected final long timeoutMillis;
    protected File outputLog;
    protected FileOutputStream outputStream;
    protected boolean processResult;
    protected ConcurrentHashMap<String, Computer> computersMap;
    private boolean stopRequested;
    protected String command;
    protected Set<Presence> presences;
    protected EccRemoteCommandType remoteCommandType;
    protected String serviceAccountUsername;
    protected String serviceAccountPassword;

    public EccRemoteCommand(String computerName, Integer timeout, ConcurrentHashMap<String, Computer> computersMap, EccRemoteCommandType remoteCommandType, String command, Set<Presence> presences, String serviceAccountUsername, String serviceAccountPassword) {
        this.computerName = computerName;
        this.timeout = timeout;
        this.timeoutMillis = timeout * 60 * 1000;
        this.computersMap = computersMap;
        this.stopRequested = false;
        this.command = command;
        this.presences = presences;
        this.remoteCommandType = remoteCommandType;
        this.serviceAccountUsername = serviceAccountUsername;
        this.serviceAccountPassword = serviceAccountPassword;
    }

    @Override
    public Boolean call() throws Exception {
        this.commandStart = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        String formattedCommand = this.getFormattedCommand(false);
        this.createOutputLog();
        String redactedCommand = this.getFormattedCommand(true);
        this.write("Running command " + redactedCommand, 1);
        try {
            this.remoteProcess = Runtime.getRuntime().exec(formattedCommand);
            this.readOutputStream();
            this.readErrorStream();
        }
        catch (Exception e) {
            LOGGER.error("Command " + redactedCommand + " failed to run", e);
        }
        this.handleThreads();
        return this.waitForComputer();
    }

    private boolean waitForComputer() {
        long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        Computer computer = this.computersMap.get(this.computerName);
        if (computer == null && !this.processResult) {
            return false;
        }
        while (currentMillis - this.commandStart < this.timeoutMillis) {
            if (this.stopRequested) {
                return false;
            }
            currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            computer = this.computersMap.get(this.computerName);
            if (computer != null && this.presences.contains((Object)computer.getPresence())) {
                return true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return false;
    }

    private String getFormattedCommand(boolean redacted) {
        StaticParameter computerNameParameter = new StaticParameter("{computer_name}", this.computerName);
        StaticParameter usernameParameter = new StaticParameter("{username}", this.serviceAccountUsername);
        StaticParameter passwordParameter = new StaticParameter("{password}", this.serviceAccountPassword);
        return this.command.replace("{computer_name}", computerNameParameter.getValue()).replace("{username}", usernameParameter.getValue()).replace("{password}", redacted ? "********" : passwordParameter.getValue());
    }

    private String getTimestampedLine(String line, int level) {
        String logLevelStr = "";
        logLevelStr = level == 1 ? "INFO" : (level == 2 ? "ERROR" : "WARN");
        return String.format("%s %s - %s\r\n", new DateTime().toString(), logLevelStr, line);
    }

    private void readOutputStream() throws IOException {
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(this.remoteProcess.getInputStream()));
        this.standardOutputThread = new Thread(() -> {
            try {
                String line = "";
                while ((line = inputReader.readLine()) != null) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    if (line.trim().length() == 0) continue;
                    this.write(line, 1);
                }
            }
            catch (IOException e) {
                LOGGER.error("Output stream error", e);
            }
            finally {
                try {
                    inputReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close stream", e);
                }
            }
        });
        this.standardOutputThread.setName(this.computerName + " Automate ECC Client Remote Installer Standard Output Thread");
        this.standardOutputThread.start();
    }

    private void createOutputLog() {
        String baseFolder = System.getProperty("java.io.tmpdir");
        if (baseFolder != null) {
            this.outputLog = Paths.get(baseFolder, this.computerName + "-" + this.remoteCommandType.toString() + ".log").toFile();
        } else {
            try {
                this.outputLog = FileUtils.createTempFile(this.computerName + "-" + this.remoteCommandType.toString(), ".log");
            }
            catch (IOException e) {
                this.outputLog = null;
            }
        }
        if (this.outputLog != null) {
            try {
                this.outputStream = new FileOutputStream(this.outputLog, true);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Cannot write command file output", e);
            }
        }
    }

    private synchronized void write(String message, int level) throws IOException {
        if (this.outputStream != null) {
            this.outputStream.write(this.getTimestampedLine(message, level).getBytes(StandardCharsets.UTF_8));
        }
    }

    public File getOutputLog() {
        return this.outputLog;
    }

    private void readErrorStream() throws IOException {
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.remoteProcess.getErrorStream()));
        this.standardErrorThread = new Thread(() -> {
            try {
                String line = "";
                while ((line = errorReader.readLine()) != null) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    if (line.trim().length() == 0) continue;
                    this.write(line, 2);
                }
            }
            catch (IOException e) {
                LOGGER.error("Output stream error", e);
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close stream", e);
                }
            }
        });
        this.standardErrorThread.setName(this.computerName + " Automate ECC Client Remote Installer Standard Error Thread");
        this.standardErrorThread.start();
    }

    private void killThreads() {
        try {
            if (this.remoteProcess.isAlive()) {
                this.remoteProcess.destroyForcibly();
            }
        }
        catch (Exception e2) {
            LOGGER.error("Unable to destroy remote process");
        }
        try {
            if (this.standardErrorThread.isAlive()) {
                this.standardErrorThread.interrupt();
            }
        }
        catch (Exception e2) {
            LOGGER.error("Unable to destroy standard error thread");
        }
        try {
            if (this.standardOutputThread.isAlive()) {
                this.standardOutputThread.interrupt();
            }
        }
        catch (Exception e2) {
            LOGGER.error("Unable to destroy standard output thread");
        }
    }

    private void handleThreads() {
        try {
            this.processResult = this.remoteProcess.waitFor(this.timeout.intValue(), TimeUnit.MINUTES);
            if (!this.processResult) {
                this.remoteProcess.destroyForcibly();
            }
            this.standardOutputThread.join();
            this.standardErrorThread.join();
        }
        catch (Exception e) {
            this.killThreads();
        }
        try {
            this.outputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close output stream");
        }
    }

    public void setStopRequested(boolean stopRequested) {
        this.stopRequested = stopRequested;
        if (stopRequested) {
            this.killThreads();
            try {
                this.outputStream.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to close output stream");
            }
        }
    }

    public void setComputersMap(ConcurrentHashMap<String, Computer> computersMap) {
        this.computersMap = computersMap;
    }
}

