/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AdaptiveThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AdaptiveThreadPoolExecutor.class);
    private int MIN_THREADS;
    private int MAX_THREADS;
    private long GC_MONITOR_INTERVAL_MS;
    private double GC_THRESHOLD_HIGH;
    private double GC_THRESHOLD_LOW;
    private double threadIncreaseRate;
    private double threadDecreaseRate;
    private volatile long gcTime = 0L;
    private volatile long upTime = 0L;

    public AdaptiveThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.initialize();
        this.startGcMonitor();
    }

    private void initialize() {
        try {
            this.MIN_THREADS = Integer.parseInt(System.getProperty("nuix.automate.adaptiveThreadPool.minThreads"));
        }
        catch (Exception e) {
            this.MIN_THREADS = 2;
        }
        try {
            this.MAX_THREADS = Integer.parseInt(System.getProperty("nuix.automate.adaptiveThreadPool.maxThreads"));
        }
        catch (Exception e) {
            this.MAX_THREADS = Runtime.getRuntime().availableProcessors();
        }
        try {
            this.GC_MONITOR_INTERVAL_MS = Integer.parseInt(System.getProperty("nuix.automate.adaptiveThreadPool.monitorInterval"));
        }
        catch (Exception e) {
            this.GC_MONITOR_INTERVAL_MS = 5000L;
        }
        try {
            this.GC_THRESHOLD_HIGH = Double.parseDouble(System.getProperty("nuix.automate.adaptiveThreadPool.thresholdHigh"));
        }
        catch (Exception e) {
            this.GC_THRESHOLD_HIGH = 0.25;
        }
        try {
            this.GC_THRESHOLD_LOW = Double.parseDouble(System.getProperty("nuix.automate.adaptiveThreadPool.thresholdLow"));
        }
        catch (Exception e) {
            this.GC_THRESHOLD_LOW = 0.05;
        }
        try {
            this.threadIncreaseRate = Double.parseDouble(System.getProperty("nuix.automate.adaptiveThreadPool.threadIncreaseRate"));
        }
        catch (Exception e) {
            this.threadIncreaseRate = Math.sqrt(2.0);
        }
        try {
            this.threadDecreaseRate = Double.parseDouble(System.getProperty("nuix.automate.adaptiveThreadPool.threadDecreaseRate"));
        }
        catch (Exception e) {
            this.threadDecreaseRate = Math.sqrt(2.0);
        }
        if (this.getCorePoolSize() > this.MIN_THREADS) {
            this.setCorePoolSize(this.MIN_THREADS);
            this.setMaximumPoolSize(this.MIN_THREADS);
        } else {
            this.setMaximumPoolSize(this.MIN_THREADS);
            this.setCorePoolSize(this.MIN_THREADS);
        }
    }

    private void startGcMonitor() {
        Thread gcMonitorThread = new Thread(() -> {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            while (!Thread.currentThread().isInterrupted()) {
                long currentUpTime = runtimeMXBean.getUptime();
                long currentGcTime = this.getTotalGcTime(ManagementFactory.getGarbageCollectorMXBeans());
                long deltaUpTime = currentUpTime - this.upTime;
                long deltaGcTime = currentGcTime - this.gcTime;
                double gcPercentage = (double)deltaGcTime / (double)deltaUpTime;
                this.adjustThreadPool(gcPercentage);
                this.upTime = currentUpTime;
                this.gcTime = currentGcTime;
                try {
                    Thread.sleep(this.GC_MONITOR_INTERVAL_MS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        gcMonitorThread.setName("GC Thread Pool Monitor");
        gcMonitorThread.setDaemon(true);
        gcMonitorThread.start();
    }

    private long getTotalGcTime(List<GarbageCollectorMXBean> gcBeans) {
        return gcBeans.stream().mapToLong(GarbageCollectorMXBean::getCollectionTime).sum();
    }

    private void adjustThreadPool(double gcPercentage) {
        int currentThreads = this.getCorePoolSize();
        if (gcPercentage > this.GC_THRESHOLD_HIGH && currentThreads > this.MIN_THREADS) {
            int newThreadCount = (int)Math.floor((double)currentThreads / this.threadDecreaseRate);
            newThreadCount = Math.max(this.MIN_THREADS, newThreadCount);
            this.setCorePoolSize(newThreadCount);
            this.setMaximumPoolSize(newThreadCount);
            LOGGER.info("Reducing threads to " + newThreadCount);
        } else if (gcPercentage < this.GC_THRESHOLD_LOW && currentThreads < this.MAX_THREADS) {
            int newThreadCount = (int)Math.ceil((double)currentThreads * this.threadIncreaseRate);
            newThreadCount = Math.min(this.MAX_THREADS, newThreadCount);
            this.setMaximumPoolSize(newThreadCount);
            this.setCorePoolSize(newThreadCount);
            LOGGER.info("Increasing threads to " + newThreadCount);
        }
    }
}

