/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CountingZipInputStream
extends ZipInputStream {
    private static final int DEFAULT_COMPRESSION_RATIO_THRESHOLD = 1032;
    private static final int DEFAULT_TOTAL_ENTRIES_THRESHOLD = 0x100000;
    private static final long DEFAULT_TOTAL_SIZE_THRESHOLD = 0x10000000000L;
    private int entriesThreshold;
    private long sizeThreshold;
    private double compressionRatioThreshold;
    private int totalEntriesRead;
    private long totalSizeRead;
    private long totalEntrySizeRead;
    private ZipEntry currentEntry;

    public CountingZipInputStream(@NotNull InputStream in) {
        this(in, StandardCharsets.UTF_8);
    }

    public CountingZipInputStream(@NotNull InputStream in, @NotNull Charset charset) {
        this(in, charset, 0x100000, 0x10000000000L);
    }

    public CountingZipInputStream(@NotNull InputStream in, int entriesThreshold, long sizeThreshold) {
        this(in, StandardCharsets.UTF_8, entriesThreshold, sizeThreshold);
    }

    public CountingZipInputStream(@NotNull InputStream in, @NotNull Charset charset, int entriesThreshold, long sizeThreshold) {
        super((InputStream)new CountingInputStream(in), charset);
        this.entriesThreshold = entriesThreshold;
        this.sizeThreshold = sizeThreshold;
        this.compressionRatioThreshold = 1032.0;
    }

    @Override
    @Nullable
    public ZipEntry getNextEntry() throws IOException {
        if (this.entriesThreshold > 0 && this.totalEntriesRead++ > this.entriesThreshold) {
            throw new IllegalStateException("Zip surpassed total entries threshold of " + this.entriesThreshold);
        }
        this.currentEntry = super.getNextEntry();
        this.totalEntrySizeRead = 0L;
        return this.currentEntry;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        double compressionRatio;
        int count = super.read(b, off, len);
        this.totalSizeRead += (long)count;
        this.totalEntrySizeRead += (long)count;
        if (this.sizeThreshold > 0L && this.totalSizeRead > this.sizeThreshold) {
            throw new IllegalStateException("Zip surpassed total size threshold of " + this.sizeThreshold);
        }
        if (this.compressionRatioThreshold > 0.0 && (compressionRatio = (double)this.totalEntrySizeRead / (double)this.currentEntry.getCompressedSize()) > this.compressionRatioThreshold) {
            throw new IllegalStateException("Zip entry surpassed compression threshold of " + this.compressionRatioThreshold);
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = super.skip(n);
        this.totalSizeRead += skip;
        this.totalEntrySizeRead += skip;
        return skip;
    }

    public void setEntriesThreshold(int entriesThreshold) {
        this.entriesThreshold = entriesThreshold;
    }

    public void setSizeThreshold(long sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public void setCompressionRatioThreshold(double compressionRatioThreshold) {
        this.compressionRatioThreshold = compressionRatioThreshold;
    }

    public void setTotalEntriesRead(int totalEntriesRead) {
        this.totalEntriesRead = totalEntriesRead;
    }

    public void setTotalSizeRead(long totalSizeRead) {
        this.totalSizeRead = totalSizeRead;
    }

    public void setTotalEntrySizeRead(long totalEntrySizeRead) {
        this.totalEntrySizeRead = totalEntrySizeRead;
    }

    public void setCurrentEntry(ZipEntry currentEntry) {
        this.currentEntry = currentEntry;
    }

    public int getEntriesThreshold() {
        return this.entriesThreshold;
    }

    public long getSizeThreshold() {
        return this.sizeThreshold;
    }

    public double getCompressionRatioThreshold() {
        return this.compressionRatioThreshold;
    }

    public int getTotalEntriesRead() {
        return this.totalEntriesRead;
    }

    public long getTotalSizeRead() {
        return this.totalSizeRead;
    }

    public long getTotalEntrySizeRead() {
        return this.totalEntrySizeRead;
    }

    public ZipEntry getCurrentEntry() {
        return this.currentEntry;
    }
}

