/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaMapper;
import com.fasterxml.jackson.jakarta.rs.json.JacksonXmlBindJsonProvider;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.general.AutomateGeneratedRequestFilter;
import com.nuix.automate.utils.general.ClientManager;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.general.WhitelistedX509TrustManager;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.utilization.AutomateModule;
import io.dropwizard.client.JerseyClientBuilder;
import io.dropwizard.client.JerseyClientConfiguration;
import io.dropwizard.client.proxy.ProxyConfiguration;
import io.dropwizard.util.Duration;
import jakarta.ws.rs.client.Client;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;

public final class DropwizardRestClientFactory {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DropwizardRestClientFactory.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    private static final Map<String, ClientManager> clientManagers = new HashMap<String, ClientManager>();
    private static CountDownLatch clientBuilderCountDownLatch;

    public static Client getClient(String name, AutomateApplication app, AutomateConfiguration config) {
        return DropwizardRestClientFactory.getClient(name, false, true, true, app, config);
    }

    public static Client getClient(String name, boolean failOnUnknownProperties, boolean disableChunkedEncoding, boolean disableGzipEncoding, AutomateApplication app, AutomateConfiguration config) {
        try {
            return DropwizardRestClientFactory.getClientWithWhitelistValidation(name, null, failOnUnknownProperties, disableChunkedEncoding, disableGzipEncoding, app, config);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Client getClientWithWhitelistValidation(String name, Set<String> whitelistedCertFingerprints, AutomateApplication app, AutomateConfiguration config) throws GeneralSecurityException {
        return DropwizardRestClientFactory.getClientWithWhitelistValidation(name, whitelistedCertFingerprints, false, true, true, app, config);
    }

    public static Client getClientWithWhitelistValidation(final String name, final Set<String> whitelistedCertFingerprints, final boolean failOnUnknownProperties, final boolean disableChunkedEncoding, final boolean disableGzipEncoding, final AutomateApplication app, final AutomateConfiguration config) throws GeneralSecurityException {
        DropwizardRestClientFactory.closePreviousClient(name);
        ClientManager clientManager = new ClientManager(){

            @Override
            protected Client createClient() throws GeneralSecurityException {
                return DropwizardRestClientFactory.getClientWithWhitelistValidationInternal(name, whitelistedCertFingerprints, failOnUnknownProperties, disableChunkedEncoding, disableGzipEncoding, app, config);
            }
        };
        clientManagers.put(name, clientManager);
        return clientManager;
    }

    private static Client getClientInternal(String name, boolean failOnUnknownProperties, boolean disableChunkedEncoding, boolean disableGzipEncoding, AutomateApplication app, AutomateConfiguration config) {
        LOGGER.info("Initializing API Client " + name + " with failOnUnknownProperties=" + failOnUnknownProperties + ", disableChunkedEncoding=" + disableChunkedEncoding + ", disableGzipEncoding=" + disableGzipEncoding);
        JerseyClientConfiguration jerseyConfig = DropwizardRestClientFactory.buildJerseyConfiguration(config);
        if (disableChunkedEncoding) {
            jerseyConfig.setChunkedEncodingEnabled(false);
        }
        if (disableGzipEncoding) {
            jerseyConfig.setGzipEnabled(false);
        }
        JerseyClientBuilder clientBuilder = new JerseyClientBuilder(app.getEnvironment()).withProperty("jersey.config.disableAutoDiscovery", (Object)Boolean.TRUE).using(jerseyConfig);
        return DropwizardRestClientFactory.buildClient(clientBuilder, name, config, failOnUnknownProperties);
    }

    private static Client getClientWithWhitelistValidationInternal(String name, Set<String> whitelistedCertFingerprints, boolean failOnUnknownProperties, boolean disableChunkedEncoding, boolean disableGzipEncoding, AutomateApplication app, AutomateConfiguration config) throws GeneralSecurityException {
        HashSet<String> fingerprints = new HashSet<String>();
        NetworkConfiguration networkConfiguration = NetworkConfiguration.fromSystemProperties();
        if (networkConfiguration.getWhitelistedCertFingerprints() != null) {
            for (String fingerprint : networkConfiguration.getWhitelistedCertFingerprints()) {
                if (fingerprint == null || fingerprint.trim().isEmpty()) continue;
                fingerprints.add(fingerprint.trim().toLowerCase());
            }
        }
        if (whitelistedCertFingerprints != null) {
            for (String fingerprint : whitelistedCertFingerprints) {
                if (fingerprint == null || fingerprint.trim().isEmpty()) continue;
                fingerprints.add(fingerprint.trim().toLowerCase());
            }
        }
        if (fingerprints.isEmpty()) {
            return DropwizardRestClientFactory.getClientInternal(name, failOnUnknownProperties, disableChunkedEncoding, disableGzipEncoding, app, config);
        }
        LOGGER.info("Initializing API Client " + name + " with fingerprints=" + String.join((CharSequence)";", fingerprints) + ", failOnUnknownProperties=" + failOnUnknownProperties);
        JerseyClientConfiguration jerseyConfig = DropwizardRestClientFactory.buildJerseyConfiguration(config);
        if (disableGzipEncoding) {
            jerseyConfig.setGzipEnabled(false);
        }
        if (disableChunkedEncoding) {
            jerseyConfig.setChunkedEncodingEnabled(false);
        }
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{DropwizardRestClientFactory.getTrustManager(fingerprints)}, new SecureRandom());
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslConnectionSocketFactory).build();
        JerseyClientBuilder clientBuilder = new JerseyClientBuilder(app.getEnvironment()).withProperty("jersey.config.disableAutoDiscovery", (Object)Boolean.TRUE).using(registry).using(jerseyConfig);
        Client client = DropwizardRestClientFactory.buildClient(clientBuilder, name, config, failOnUnknownProperties);
        client.property("jersey.config.client.followRedirects", (Object)false);
        return client;
    }

    private static Client buildClient(JerseyClientBuilder builder, String name, AutomateConfiguration config, boolean failOnUnknownProperties) {
        Client client = builder.build(name + "-" + UidUtils.getRandom());
        client.property("jersey.config.client.connectTimeout", (Object)((int)config.getApiClientConnectionTimeout()));
        client.property("jersey.config.client.readTimeout", (Object)((int)config.getApiClientReadTimeout()));
        if (!failOnUnknownProperties) {
            JacksonXmlBindJsonProvider jacksonJsonProvider = new JacksonXmlBindJsonProvider();
            jacksonJsonProvider.setMapper((ObjectMapper)new JodaMapper());
            jacksonJsonProvider.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            client.register((Object)jacksonJsonProvider);
        }
        client.register((Object)new AutomateGeneratedRequestFilter(AutomateModule.find(config.getRole())));
        return client;
    }

    public static X509TrustManager getTrustManager(Set<String> fingerprints) throws NoSuchAlgorithmException, KeyStoreException {
        return new WhitelistedX509TrustManager(fingerprints);
    }

    private static void closePreviousClient(String name) {
        block6: {
            Client previousClient;
            if (clientBuilderCountDownLatch != null) {
                try {
                    clientBuilderCountDownLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.error("Client Factory interrupted while waiting for clientBuilderCounterDownLatch", e);
                }
            }
            if ((previousClient = (Client)clientManagers.remove(name)) != null) {
                try {
                    previousClient.close();
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug("Cannot close client", e);
                }
            }
        }
    }

    private static JerseyClientConfiguration buildJerseyConfiguration(AutomateConfiguration config) {
        JerseyClientConfiguration jerseyConfig = new JerseyClientConfiguration();
        jerseyConfig.setTimeout(Duration.milliseconds((long)config.getApiClientConnectionTimeout()));
        jerseyConfig.setConnectionTimeout(Duration.milliseconds((long)config.getApiClientReadTimeout()));
        jerseyConfig.setConnectionRequestTimeout(Duration.milliseconds((long)config.getApiClientConnectionTimeout()));
        NetworkConfiguration networkConfiguration = NetworkConfiguration.fromSystemProperties();
        if (networkConfiguration.isProxyConfigured()) {
            ProxyConfiguration proxyConfiguration = new ProxyConfiguration(networkConfiguration.getProxyHost(), networkConfiguration.getProxyPort().intValue());
            proxyConfiguration.setNonProxyHosts(new ArrayList<String>(networkConfiguration.getNonProxyHosts()));
            jerseyConfig.setProxyConfiguration(proxyConfiguration);
        }
        return jerseyConfig;
    }

    public static void restartClients() {
        for (ClientManager clientManager : new ArrayList<ClientManager>(clientManagers.values())) {
            try {
                clientManager.restart();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setClientBuilderCountDownLatch(CountDownLatch countDownLatch) {
        clientBuilderCountDownLatch = countDownLatch;
    }
}

