/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import au.com.bytecode.opencsv.CSVReader;
import com.google.gdata.util.common.io.CharStreams;
import com.google.gdata.util.io.base.UnicodeReader;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Exchanger;
import java.util.concurrent.Phaser;
import java.util.concurrent.SynchronousQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class FileUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FileUtils.class);
    private static InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    private static Set<String> knownFileExtensions = null;
    public static final String UTF_BOM = "\ufeff";
    public static final String UTF8_BOM = "\ufffd";

    public static String stripBom(String data) {
        if (data.startsWith(UTF_BOM)) {
            return data.substring(UTF_BOM.length());
        }
        if (data.startsWith(UTF8_BOM)) {
            return data.substring(UTF8_BOM.length());
        }
        return data;
    }

    public static void deleteRecursively(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                Files.delete(path);
            } else {
                org.apache.commons.io.FileUtils.deleteDirectory((File)path.toFile());
            }
        }
    }

    public static Path createTempFilePath(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        if (SystemUtils.IS_OS_UNIX) {
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
            return Files.createTempFile(prefix, suffix, attr);
        }
        Path path = Files.createTempFile(prefix, suffix, attrs);
        File f = path.toFile();
        f.setReadable(true, true);
        f.setWritable(true, true);
        f.setExecutable(true, true);
        return path;
    }

    public static byte[] decodeFileData(String encodedFileData) {
        byte[] fileData;
        if (encodedFileData == null) {
            return null;
        }
        try {
            fileData = Base64.getDecoder().decode(encodedFileData);
        }
        catch (Exception e) {
            fileData = encodedFileData.getBytes(StandardCharsets.UTF_8);
        }
        return fileData;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtils.createTempFilePath(prefix, suffix, new FileAttribute[0]).toFile();
    }

    public static void writeWithSingleThread(FileChannel fileChannel, ReadableByteChannel readableByteChannel) throws IOException {
        FileUtils.writeWithSingleThread(fileChannel, readableByteChannel, 8192);
    }

    public static void writeWithSingleThread(FileChannel fileChannel, ReadableByteChannel readableByteChannel, int bufferCapacity) throws IOException {
        FileUtils.writeWithSingleThread(fileChannel, readableByteChannel, bufferCapacity, null);
    }

    public static void writeWithSingleThread(FileChannel fileChannel, ReadableByteChannel readableByteChannel, int bufferCapacity, Collection<MessageDigest> digests) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferCapacity);
        byte[] digestBuffer = null;
        if (digests != null && digests.size() > 0) {
            digestBuffer = new byte[Math.min(bufferCapacity, 8192)];
        }
        while (FileUtils.fullReadIntoBuffer(readableByteChannel, buffer) != -1) {
            buffer.flip();
            if (digestBuffer != null) {
                FileUtils.updateDigestsWithByteBuffer(digests, buffer.asReadOnlyBuffer(), digestBuffer);
            }
            while (buffer.hasRemaining()) {
                fileChannel.write(buffer);
            }
            buffer.compact();
        }
    }

    public static void writeWithSeparateWriteThread(FileChannel fileChannel, ReadableByteChannel readableByteChannel) throws IOException {
        FileUtils.writeWithSeparateWriteThread(fileChannel, readableByteChannel, 65536, null);
    }

    public static void writeWithSeparateWriteThread(FileChannel fileChannel, ReadableByteChannel readableByteChannel, int bufferCapacity) throws IOException {
        FileUtils.writeWithSeparateWriteThread(fileChannel, readableByteChannel, bufferCapacity, null);
    }

    public static void writeWithSeparateWriteThread(FileChannel fileChannel, ReadableByteChannel readableByteChannel, final int bufferCapacity, final Collection<MessageDigest> digests) throws IOException {
        Phaser phaser;
        SynchronousQueue hashQueue;
        if (digests != null && digests.size() > 0) {
            hashQueue = new SynchronousQueue();
            phaser = new Phaser(2);
            Thread hashThread = new Thread(new Runnable(){
                private final byte[] digestBuffer;
                {
                    this.digestBuffer = new byte[Math.min(bufferCapacity, 8192)];
                }

                @Override
                public void run() {
                    try {
                        ByteBuffer buffer;
                        while ((buffer = (ByteBuffer)hashQueue.take()).capacity() != 0) {
                            if (digests.size() > 0) {
                                FileUtils.updateDigestsWithByteBuffer(digests, buffer, this.digestBuffer);
                            }
                            phaser.arrive();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.error("Error updating digest", e);
                    }
                }
            });
            hashThread.setName("Automate Upload Hash Thread");
            hashThread.start();
        } else {
            hashQueue = null;
            phaser = null;
        }
        Exchanger<ByteBuffer> bufferExchanger = new Exchanger<ByteBuffer>();
        Thread writeThread = new Thread(() -> {
            try {
                ByteBuffer buffer = null;
                while (true) {
                    buffer = bufferExchanger.exchange(buffer);
                    if (hashQueue != null) {
                        hashQueue.put(buffer.asReadOnlyBuffer());
                    }
                    if (buffer.capacity() != 0) {
                        while (buffer.hasRemaining()) {
                            fileChannel.write(buffer);
                        }
                        if (phaser == null) continue;
                        phaser.arriveAndAwaitAdvance();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                LOGGER.error("Error writing to file channel", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Error writing to file channel", e);
            }
        });
        writeThread.setName("Automate Upload Write Thread");
        writeThread.start();
        try {
            int read;
            ByteBuffer buffer = null;
            do {
                if (buffer == null) {
                    buffer = ByteBuffer.allocateDirect(bufferCapacity);
                }
                buffer.clear();
                read = FileUtils.fullReadIntoBuffer(readableByteChannel, buffer);
                buffer.flip();
                buffer = bufferExchanger.exchange(buffer);
            } while (read != -1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error(e);
        }
        try {
            bufferExchanger.exchange(ByteBuffer.allocate(0));
            writeThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error(e);
        }
    }

    public static void updateDigestsWithByteBuffer(Collection<MessageDigest> digests, ByteBuffer buffer, byte[] tempArray) {
        int chunk;
        for (int len = buffer.remaining(); len > 0; len -= chunk) {
            chunk = Math.min(len, tempArray.length);
            buffer.get(tempArray, 0, chunk);
            for (MessageDigest digest : digests) {
                digest.update(tempArray, 0, chunk);
            }
        }
    }

    public static int fullReadIntoBuffer(ReadableByteChannel readableByteChannel, ByteBuffer buffer) throws IOException {
        int currentRead;
        int read = 0;
        do {
            try {
                currentRead = readableByteChannel.read(buffer);
            }
            catch (EOFException e) {
                currentRead = -1;
            }
            if (currentRead <= 0 && read != 0) continue;
            read += currentRead;
        } while (currentRead != -1 && buffer.hasRemaining());
        return read;
    }

    public static int calculateBufferSize(long byteCount) {
        return FileUtils.calculateBufferSize(byteCount, 65536);
    }

    public static int calculateBufferSize(long byteCount, Integer maxBufferSize) {
        int capacity;
        int minSizeForParallelWrite = 65536;
        int bufferCount = 2;
        if (byteCount < (long)minSizeForParallelWrite) {
            capacity = (int)byteCount;
        } else {
            Integer uploadBufferSizeMax = maxBufferSize;
            if (uploadBufferSizeMax == null || uploadBufferSizeMax <= 0) {
                uploadBufferSizeMax = 8192;
            }
            int maxCapacity = (int)Math.min((long)uploadBufferSizeMax.intValue() * 1024L, Integer.MAX_VALUE);
            capacity = (int)Math.min(byteCount / (long)bufferCount, (long)maxCapacity);
        }
        int minCapacity = 8;
        if (capacity < minCapacity) {
            capacity = minCapacity;
        }
        return capacity / 8 * 8;
    }

    public static boolean isDirectoryEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    public static void deleteAllEmptyDirectories(final Path path, final boolean deleteSelf) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e != null) {
                    throw e;
                }
                if (FileUtils.isDirectoryEmpty(dir) && (deleteSelf || !path.equals(dir))) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void skipInputStream(InputStream is, long n) throws IOException {
        while (n > 0L) {
            long n1 = is.skip(n);
            if (n1 > 0L) {
                n -= n1;
                continue;
            }
            if (n1 == 0L) {
                if (is.read() == -1) break;
                --n;
                continue;
            }
            throw new IOException("skip() returned a negative value. This should never happen");
        }
    }

    public static boolean mergeLoadfiles(String exportFolder) throws IOException {
        File file1 = new File(exportFolder + "/loadfile.dat");
        File file2 = new File(exportFolder + "/loadfile_1.dat");
        if (file1.exists() && file2.exists()) {
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file1.toPath(), StandardOpenOption.APPEND), StandardCharsets.UTF_8));
                 BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(file2.toPath(), new OpenOption[0])));){
                String line = bufferedReader.readLine();
                line = bufferedReader.readLine();
                while (line != null) {
                    bufferedWriter.write(line);
                    bufferedWriter.write("\r\n");
                    line = bufferedReader.readLine();
                }
            }
            file2.delete();
            return true;
        }
        return false;
    }

    public static void writeToFile(StringBuilder stringBuilder, Path path) throws IOException {
        FileUtils.writeToFile(stringBuilder, path, false);
    }

    public static void writeToFile(StringBuilder stringBuilder, Path path, boolean writeBom) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), StandardCharsets.UTF_8);){
            if (writeBom) {
                writer.write(UTF_BOM);
            }
            writer.write(stringBuilder.toString());
        }
    }

    public static void writeToFile(String string, Path path) throws IOException {
        FileUtils.writeToFile(string, path, false);
    }

    public static void writeToFile(String string, Path path, boolean writeBom) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), StandardCharsets.UTF_8);){
            if (writeBom) {
                writer.write(UTF_BOM);
            }
            writer.write(string);
        }
    }

    public static void appendToFile(String string, Path path) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(path, StandardOpenOption.APPEND), StandardCharsets.UTF_8);){
            writer.write(string);
        }
    }

    public static String getFileExtension(String filename) {
        String extension = "";
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            extension = filename.substring(i + 1);
        }
        return extension;
    }

    public static String getFileNameWithoutExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(0, i);
        }
        return filename;
    }

    public static synchronized String getKnownFileExtension(String filename) {
        block14: {
            try {
                String[] splits;
                String fileExtension;
                if (knownFileExtensions == null) {
                    knownFileExtensions = new HashSet<String>();
                    try (InputStream stream = FileUtils.class.getResourceAsStream("/dictionary/FileExtensions.txt");){
                        String[] lines;
                        String script = IOUtils.toString((InputStream)stream);
                        for (String line : lines = script.split("[\\r\\n]+")) {
                            knownFileExtensions.add(StringUtils.strip((String)line).toLowerCase());
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot read dictionary", e);
                    }
                }
                if (knownFileExtensions.contains(fileExtension = (splits = filename.split("\\."))[splits.length - 1].toLowerCase())) {
                    return fileExtension;
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block14;
                LOGGER.debug("Cannot get file extension", e);
            }
        }
        return "Other";
    }

    public static Path safePathAppend(String first, String ... more) throws FileTraversalException {
        Path path = Paths.get(first, new String[0]);
        for (String m : more) {
            Path childPath = path.resolve(m);
            if (!path.toFile().equals(childPath.toFile().getParentFile())) {
                throw new FileTraversalException("Path: " + path + ", child: " + m);
            }
            path = childPath;
        }
        return path;
    }

    public static Path safeResolve(Path path, String childName) throws FileTraversalException {
        Path childPath = path.resolve(childName);
        if (!path.toFile().equals(childPath.toFile().getParentFile())) {
            throw new FileTraversalException("ChildPath: " + childPath + ", Path: " + path + ", childName: " + childName);
        }
        return childPath;
    }

    public static Path safeResolveParent(String parent, String ... children) throws FileTraversalException {
        return FileUtils.safeResolveParent(Paths.get(parent, new String[0]), children);
    }

    public static Path safeResolveParent(Path parent, String ... children) throws FileTraversalException {
        Path path = Paths.get(parent.toString(), children).normalize();
        if (!path.startsWith(parent.toAbsolutePath())) {
            throw new FileTraversalException("Path: " + path + ", children: " + String.join((CharSequence)";", children));
        }
        return path;
    }

    public static void moveMergeDirectories(Path sourcePath, Path destinationPath) throws IOException {
        if (!Files.exists(destinationPath, new LinkOption[0])) {
            Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.createDirectories(destinationPath, new FileAttribute[0]);
            try (Stream<Path> filesList = Files.list(sourcePath);){
                for (Path path : filesList.collect(Collectors.toList())) {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        Path destinationDirectory = destinationPath.resolve(path.getFileName().toString());
                        FileUtils.moveMergeDirectories(path, destinationDirectory);
                        continue;
                    }
                    Files.move(path, destinationPath.resolve(path.getFileName().toString()), new CopyOption[0]);
                }
            }
        }
    }

    public static String readFileWithAutodetectEncoding(File resourceFile) throws IOException {
        Charset utf8 = StandardCharsets.UTF_8;
        try (UnicodeReader reader = new UnicodeReader((InputStream)org.apache.commons.io.FileUtils.openInputStream((File)resourceFile), utf8.name());){
            String result;
            String string = result = CharStreams.toString((Readable)reader);
            return string;
        }
    }

    public static Reader readFileWithAutoDetectEncoding(InputStream origin) throws IOException {
        Charset utf8 = StandardCharsets.UTF_8;
        return new UnicodeReader(origin, utf8.name());
    }

    public static List<String> readFileNonBlankLinesWithAutodetectEncoding(File resourceFile, boolean trim, boolean toLower) throws IOException {
        String fileContents = FileUtils.readFileWithAutodetectEncoding(resourceFile);
        ArrayList<String> result = new ArrayList<String>();
        for (String line : fileContents.split("\\r?\\n")) {
            if (trim) {
                line = line.trim();
            }
            if (toLower) {
                line = line.toLowerCase();
            }
            if (line.length() <= 0) continue;
            result.add(line);
        }
        return result;
    }

    public static List<String> readFileLinesWithAutodetectEncoding(File resourceFile) throws IOException {
        String fileContents = FileUtils.readFileWithAutodetectEncoding(resourceFile);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(fileContents.split("\\r?\\n")));
        return list;
    }

    public static List<Object[]> loadNoColumnTsv(File f) throws IOException {
        LOGGER.info("Reading file " + f + " as TSV");
        String fileContents = FileUtils.readFileWithAutodetectEncoding(f);
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (String line : fileContents.split("\\r?\\n")) {
            String[] listEntry = new String[]{line};
            list.add(listEntry);
        }
        return list;
    }

    public static List<Object[]> loadTwoColumnDetectFormat(File f, String listName, String column1Name, String column2Name) throws IOException {
        LOGGER.info("Reading file " + f + " as 2 column with detect format");
        String fileExtension = FileUtils.getFileExtension(f.getName());
        switch (fileExtension.toLowerCase()) {
            case "csv": {
                return FileUtils.loadTwoColumnCsv(f, column1Name, column2Name);
            }
            case "json": {
                return FileUtils.loadTwoColumnJson(f, listName, column1Name, column2Name);
            }
        }
        return FileUtils.loadTwoColumnTsv(f);
    }

    private static List<Object[]> loadTwoColumnTsv(File f) throws IOException {
        LOGGER.info("Loading file " + f + " as 2 column TSV");
        String fileContents = FileUtils.readFileWithAutodetectEncoding(f);
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (String line : fileContents.split("\\r?\\n")) {
            String[] wordsArray = line.split("\\t");
            String[] listEntry = new String[]{wordsArray.length > 0 ? wordsArray[0] : "", wordsArray.length > 1 && wordsArray[1] != null ? wordsArray[1] : "", wordsArray.length > 2 ? "Additional text detected in 3rd column was ignored" : ""};
            list.add(listEntry);
        }
        return list;
    }

    public static List<Object[]> loadVariableColumnDetectFormatFile(File f) throws IOException {
        LOGGER.info("Reading file " + f + " with detected format");
        String fileExtension = FileUtils.getFileExtension(f.getName());
        switch (fileExtension.toLowerCase()) {
            case "csv": {
                return FileUtils.loadVariableColumnCsv(f);
            }
        }
        return FileUtils.loadVariableColumnTsv(f);
    }

    public static List<Object[]> loadVariableColumnTsv(File f) throws IOException {
        LOGGER.info("Reading file " + f + " as TSV");
        String fileContents = FileUtils.readFileWithAutodetectEncoding(f);
        return FileUtils.loadVariableColumnTsv(fileContents);
    }

    public static List<Object[]> loadVariableColumnTsv(String fileContents) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        boolean header = true;
        int columnsCount = 0;
        for (String line : fileContents.split("\\r?\\n")) {
            if (header) {
                columnsCount = line.split("\\t").length;
                header = false;
            }
            String[] listEntry = new String[columnsCount];
            String[] wordsArray = line.split("\\t");
            System.arraycopy(wordsArray, 0, listEntry, 0, Math.min(columnsCount, wordsArray.length));
            list.add(listEntry);
        }
        return list;
    }

    public static List<Object[]> loadVariableColumnCsv(File f) throws IOException {
        LOGGER.info("Reading file " + f + " as CSV");
        String fileContents = FileUtils.readFileWithAutodetectEncoding(f);
        return FileUtils.loadVariableColumnCsv(fileContents);
    }

    public static List<Object[]> loadVariableColumnCsv(String fileContents) throws IOException {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        boolean header = true;
        int columnsCount = 0;
        try (CSVReader csvReader = new CSVReader((Reader)new StringReader(fileContents));){
            String[] values = null;
            while ((values = csvReader.readNext()) != null) {
                if (header) {
                    columnsCount = values.length;
                }
                String[] listEntry = new String[columnsCount];
                System.arraycopy(values, 0, listEntry, 0, Math.min(columnsCount, values.length));
                list.add(listEntry);
            }
        }
        return list;
    }

    public static List<Object[]> loadTwoColumnCsv(File f, String column1Name, String column2Name) throws IOException {
        LOGGER.info("Reading file " + f + " as 2 column TSV");
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        String fileContents = FileUtils.readFileWithAutodetectEncoding(f);
        boolean header = true;
        int columnsCount = 2;
        try (CSVReader csvReader = new CSVReader((Reader)new StringReader(fileContents));){
            String[] values = null;
            while ((values = csvReader.readNext()) != null) {
                String[] listEntry = new String[columnsCount];
                System.arraycopy(values, 0, listEntry, 0, Math.min(columnsCount, values.length));
                if (header && listEntry[0].equalsIgnoreCase(column1Name) && listEntry[1].equalsIgnoreCase(column2Name)) continue;
                list.add(listEntry);
            }
        }
        return list;
    }

    public static List<Object[]> loadTwoColumnJson(File f, String listName, String column1Name, String column2Name) throws IOException {
        LOGGER.info("Reading file " + f + " as 2 column JSON");
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        String fileContents = FileUtils.readFileWithAutodetectEncoding(f);
        try {
            Map result = SerializationUtils.fromJson(fileContents, Map.class);
            String key = listName;
            if (!result.containsKey(key)) {
                if (result.keySet().size() == 1) {
                    key = (String)result.keySet().iterator().next();
                } else {
                    throw new IOException("Invalid JSON file format");
                }
            }
            List searches = (List)result.get(key);
            for (Map search : searches) {
                String[] listEntry = new String[]{String.valueOf(search.get(column1Name)), String.valueOf(search.get(column2Name))};
                list.add(listEntry);
            }
        }
        catch (Exception e) {
            throw new IOException("Invalid JSON file format", e);
        }
        return list;
    }

    public static Path getPathWithSuffixInDir(Path dirPath, String suffix) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dirPath);){
            for (Path file : dirStream) {
                if (!file.toString().endsWith(suffix)) continue;
                Path path = file;
                return path;
            }
        }
        LOGGER.info("Did not find file ending with " + suffix + " in " + dirPath);
        return null;
    }

    public static String normalize(String path) {
        Path p = Paths.get(path, new String[0]);
        p = p.normalize();
        return p.toString();
    }

    public static boolean isPathAbsolute(String path) {
        boolean pathIsAbsolute;
        String absPath = new File(path).getAbsolutePath();
        if (path.length() > absPath.length()) {
            path = path.substring(0, path.length() - 1);
        }
        if (pathIsAbsolute = path.equals(absPath)) {
            return true;
        }
        pathIsAbsolute = path.replace("/", "\\").equals(absPath);
        if (pathIsAbsolute) {
            return true;
        }
        pathIsAbsolute = path.replace("/", "\\").equalsIgnoreCase(absPath);
        return pathIsAbsolute;
    }

    public static boolean isPathValid(String path) {
        try {
            Paths.get(path, new String[0]);
        }
        catch (NullPointerException | InvalidPathException e) {
            return false;
        }
        return true;
    }
}

