/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.InterruptibleCharSequence;
import com.nuix.automate.utils.general.ReflectionUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nuix.Address;
import nuix.Communication;
import nuix.Item;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.tools.ant.types.Commandline;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public final class FormattingUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FormattingUtils.class);
    private static InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    private static final String typicalUriPatternString = "(https?:\\/\\/[^\\/]+\\/)(.+)";
    private static final Pattern typicalUriPattern = Pattern.compile("(https?:\\/\\/[^\\/]+\\/)(.+)");
    private static final int DEFAULT_MAXCHARS = 3;
    private static final BigDecimal KILO_DIVISOR = new BigDecimal(1000L);
    private static final String CONCORDANCE_NEWLINE = "\u00ae";
    private static final String CONCORDANCE_QUOTES = "\u00fe";
    private static final String CONCORDANCE_SEPARATOR = "\u0014";

    public static String[] translateCommandline(String commandline) {
        commandline = commandline.replace("\n", " ");
        String[] commandElements = Commandline.translateCommandline((String)commandline);
        return commandElements;
    }

    public static String cellRowColumnToExcelA1Style(int row, int column) {
        return FormattingUtils.getExcelA1FromColumn(column) + (row + 1);
    }

    public static String getHostnameFromUrl(String url) throws URISyntaxException {
        URI uri = new URI(url.trim());
        String hostname = uri.getHost();
        if (hostname == null) {
            throw new URISyntaxException(url, "Cannot parse URL");
        }
        return hostname;
    }

    public static String getUrlFromHostname(String hostname, String protocol, Integer port) throws URISyntaxException {
        try {
            FormattingUtils.getHostnameFromUrl(hostname);
        }
        catch (URISyntaxException e) {
            String url = protocol + "://" + hostname;
            if (port != null && !hostname.contains(":")) {
                url = url + ":" + port;
            }
            return url;
        }
        throw new URISyntaxException(hostname, "Hostname is already a URL");
    }

    public static String getUrlFromHostname(String hostname) throws URISyntaxException {
        return FormattingUtils.getUrlFromHostname(hostname, "https", null);
    }

    public static String encodeCommandLineForPrinting(List<String> elements) {
        ArrayList<String> normalizedElements = new ArrayList<String>();
        for (String element : elements) {
            if (element.contains(" ")) {
                normalizedElements.add("\"" + element + "\"");
                continue;
            }
            normalizedElements.add(element);
        }
        return String.join((CharSequence)" ", normalizedElements);
    }

    private static String getExcelA1FromColumn(int column) {
        int number1 = column % 26;
        byte b = (byte)(65 + number1);
        char letter = (char)b;
        int number2 = Math.floorDiv(column, 26);
        if (number2 > 0) {
            return FormattingUtils.getExcelA1FromColumn(number2 - 1) + letter;
        }
        return String.valueOf(letter);
    }

    public static String getLocalizedPercentage(double percentageComplete) {
        return String.format("%.2f%%", percentageComplete * 100.0);
    }

    public static String relativityVersionToNuixString(String version) {
        version = version.replace("10", "TEN");
        version = version.replace("11", "ELEVEN");
        version = version.replace("12", "TWELVE");
        version = version.replace("13", "THIRTEEN");
        version = version.replace("14", "FOURTEEN");
        version = version.replace("15", "FIFTEEN");
        version = version.replace("16", "SIXTEEN");
        version = version.replace("17", "SEVENTEEN");
        version = version.replace("18", "EIGHTEEN");
        version = version.replace("19", "NINETEEN");
        version = version.replace("20", "TWENTY");
        version = version.replace("0", "");
        version = version.replace("1", "ONE");
        version = version.replace("2", "TWO");
        version = version.replace("3", "THREE");
        version = version.replace("4", "FOUR");
        version = version.replace("5", "FIVE");
        version = version.replace("6", "SIX");
        version = version.replace("7", "SEVEN");
        version = version.replace("8", "EIGHT");
        version = version.replace("9", "NINE");
        version = version.replace(".", "_");
        version = version.trim();
        return version;
    }

    public static boolean isInteger(String value) {
        if (value.isEmpty()) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!(i == 0 && c == '-' ? value.length() == 1 : Character.digit(c, 10) < 0)) continue;
            return false;
        }
        return true;
    }

    public static String constToUserFriendlyString(Object object) {
        String result = object.toString().replace("_", " ");
        result = result.substring(0, 1).toUpperCase() + result.substring(1).toLowerCase();
        return result;
    }

    public static boolean safeMatchesRegex(String value, String regex, long timeoutMs) {
        if (regex == null) {
            return true;
        }
        AtomicBoolean result = new AtomicBoolean();
        result.set(false);
        Thread thread = new Thread(() -> {
            try {
                Pattern pattern = Pattern.compile(regex);
                Matcher interruptableMatcher = pattern.matcher(new InterruptibleCharSequence(value));
                result.set(interruptableMatcher.matches());
            }
            catch (Exception e) {
                result.set(false);
            }
        });
        thread.setName("Automate - Utils Regex matcher");
        thread.start();
        try {
            thread.join(timeoutMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("Join interrupted");
        }
        if (thread.isAlive()) {
            LOGGER.info("Regex evaluation did not respond, interrupting evaluation");
            thread.interrupt();
        }
        return result.get();
    }

    public static boolean safeIsRegexValid(String regex) {
        if (regex == null) {
            return true;
        }
        AtomicBoolean result = new AtomicBoolean();
        result.set(false);
        Thread thread = new Thread(() -> {
            try {
                Pattern pattern = Pattern.compile(regex);
                Matcher interruptableMatcher = pattern.matcher(new InterruptibleCharSequence("test1234"));
                interruptableMatcher.matches();
                result.set(true);
            }
            catch (Exception e) {
                result.set(false);
            }
        });
        thread.setName("Automate - Utils Regex matcher");
        thread.start();
        try {
            thread.join(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("Join interrupted");
        }
        if (thread.isAlive()) {
            LOGGER.info("Regex evaluation did not respond, interrupting evaluation");
            thread.interrupt();
        }
        return result.get();
    }

    public static Set<String> getAvailableTimezoneIDs() {
        HashSet<String> timeZones = new HashSet<String>(DateTimeZone.getAvailableIDs());
        return timeZones;
    }

    public static String timeZoneIdToDisplayName(String timeZoneId) {
        try {
            return FormattingUtils.timeZoneToDisplayName(DateTimeZone.forID((String)timeZoneId));
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse timezone ID: " + timeZoneId, e);
            return "Invalid, " + e.getMessage();
        }
    }

    public static DateTimeFormatter generateDateTimeFormatter() {
        String shortTimePattern = DateTimeFormat.patternForStyle((String)"-S", (Locale)Locale.getDefault());
        String mediumTimePattern = DateTimeFormat.patternForStyle((String)"-M", (Locale)Locale.getDefault());
        String longTimePattern = DateTimeFormat.patternForStyle((String)"-L", (Locale)Locale.getDefault()).replace("z", "Z");
        String fullTimePattern = DateTimeFormat.patternForStyle((String)"-F", (Locale)Locale.getDefault()).replace("z", "Z");
        return new DateTimeFormatterBuilder().appendOptional(DateTimeFormat.forPattern((String)DateTimeFormat.patternForStyle((String)"S-", (Locale)Locale.getDefault())).getParser()).appendOptional(DateTimeFormat.forPattern((String)DateTimeFormat.patternForStyle((String)"M-", (Locale)Locale.getDefault())).getParser()).appendOptional(DateTimeFormat.forPattern((String)DateTimeFormat.patternForStyle((String)"L-", (Locale)Locale.getDefault())).getParser()).appendOptional(DateTimeFormat.forPattern((String)DateTimeFormat.patternForStyle((String)"F-", (Locale)Locale.getDefault())).getParser()).appendOptional(DateTimeFormat.forPattern((String)" ").getParser()).appendOptional(DateTimeFormat.forPattern((String)"'T'").getParser()).appendOptional(new DateTimeFormatterBuilder().appendOptional(DateTimeFormat.forPattern((String)fullTimePattern).getParser()).appendOptional(DateTimeFormat.forPattern((String)fullTimePattern.replace("Z", "ZZ")).getParser()).appendOptional(DateTimeFormat.forPattern((String)fullTimePattern.replace("Z", "ZZZ")).getParser()).appendOptional(DateTimeFormat.forPattern((String)longTimePattern).getParser()).appendOptional(DateTimeFormat.forPattern((String)longTimePattern.replace("Z", "ZZ")).getParser()).appendOptional(DateTimeFormat.forPattern((String)longTimePattern.replace("Z", "ZZZ")).getParser()).appendOptional(DateTimeFormat.forPattern((String)mediumTimePattern).getParser()).appendOptional(DateTimeFormat.forPattern((String)shortTimePattern).getParser()).appendOptional(DateTimeFormat.forPattern((String)fullTimePattern.replaceFirst("(hh|h)", "HH").replace(" a", "")).getParser()).appendOptional(DateTimeFormat.forPattern((String)fullTimePattern.replaceFirst("(hh|h)", "HH").replace(" a", "").replace("Z", "ZZ")).getParser()).appendOptional(DateTimeFormat.forPattern((String)fullTimePattern.replaceFirst("(hh|h)", "HH").replace(" a", "").replace("Z", "ZZZ")).getParser()).appendOptional(DateTimeFormat.forPattern((String)longTimePattern.replaceFirst("(hh|h)", "HH").replace(" a", "")).getParser()).appendOptional(DateTimeFormat.forPattern((String)longTimePattern.replaceFirst("(hh|h)", "HH").replace(" a", "").replace("Z", "ZZ")).getParser()).appendOptional(DateTimeFormat.forPattern((String)longTimePattern.replaceFirst("(hh|h)", "HH").replace(" a", "").replace("Z", "ZZZ")).getParser()).appendOptional(DateTimeFormat.forPattern((String)mediumTimePattern.replaceFirst("(hh|h)", "HH").replace(" a", "")).getParser()).appendOptional(DateTimeFormat.forPattern((String)shortTimePattern.replaceFirst("(hh|h)", "HH").replace(" a", "")).getParser()).toParser()).toFormatter().withLocale(Locale.getDefault());
    }

    public static Long parseZuluDateTime(String dateTime) {
        if (dateTime != null) {
            return Instant.parse(dateTime).toEpochMilli();
        }
        return null;
    }

    public static String timeZoneToDisplayName(DateTimeZone dateTimeZone) {
        String timeZoneId = dateTimeZone.getID();
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        return timeZone.getDisplayName();
    }

    public static String dateToLocalString(Date date) {
        return FormattingUtils.dateTimeToLocalString(new DateTime((Object)date));
    }

    public static String dateToGMT(Date date) {
        return FormattingUtils.dateTimeToGMTString(new DateTime((Object)date));
    }

    public static String dateTimeToGMTString(DateTime dateTime) {
        return dateTime.toString();
    }

    public static String dateTimeToLocalString(DateTime dateTime) {
        return dateTime.withZone(DateTimeZone.getDefault()).toString(DateTimeFormat.shortDateTime().withLocale(Locale.getDefault(Locale.Category.DISPLAY)));
    }

    public static String dateTimeToLocalTimeString(DateTime dateTime) {
        return dateTime.withZone(DateTimeZone.getDefault()).toString(DateTimeFormat.shortTime().withLocale(Locale.getDefault(Locale.Category.DISPLAY)));
    }

    public static String dateTimeToLocalDateString(DateTime dateTime) {
        return dateTime.withZone(DateTimeZone.getDefault()).toString(DateTimeFormat.shortDate().withLocale(Locale.getDefault(Locale.Category.DISPLAY)));
    }

    public static String dateTimeToExcelDateString(DateTime dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        return dateTimeFormatter.print((ReadableInstant)dateTime.withZone(DateTimeZone.getDefault()));
    }

    public static String dateTimeToInternationalDateString(DateTime dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
        return dateTimeFormatter.print((ReadableInstant)dateTime.withZone(DateTimeZone.getDefault()));
    }

    public static String dateTimeToInternationalTimeString(DateTime dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"HHmmss");
        return dateTimeFormatter.print((ReadableInstant)dateTime.withZone(DateTimeZone.getDefault()));
    }

    public static String dateTimeToExcelTimeString(DateTime dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss");
        return dateTimeFormatter.print((ReadableInstant)dateTime.withZone(DateTimeZone.getDefault()));
    }

    public static String dateTimeToInternationalDateTimeString(DateTime dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd-HHmmss");
        return dateTimeFormatter.print((ReadableInstant)dateTime.withZone(DateTimeZone.getDefault()));
    }

    public static String dateTimeToInternationalDateTimeMillisString(DateTime dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd_HHmmss_SSS");
        return dateTimeFormatter.print((ReadableInstant)dateTime.withZone(DateTimeZone.getDefault()));
    }

    public static String dateTimeToIsoString(DateTime dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        return dateTimeFormatter.print((ReadableInstant)dateTime.withZone(DateTimeZone.UTC));
    }

    public static String dateTimeToExcelDateTimeString(DateTime dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        return dateTimeFormatter.print((ReadableInstant)dateTime.withZone(DateTimeZone.getDefault()));
    }

    public static String dateTimeToEmailDateTimeString(DateTime dateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"E, d MMM yyyy H:mm:ss Z");
        return dateTimeFormatter.print((ReadableInstant)dateTime.withZone(DateTimeZone.getDefault()));
    }

    public static String mapToString(Map<String, String> map) {
        StringBuilder result = new StringBuilder();
        for (String key : map.keySet()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(key).append(":").append(map.get(key));
        }
        return result.toString();
    }

    public static String encodeForLog(String data) {
        if (data != null) {
            return data.replaceAll("[\n\r]", "_");
        }
        return null;
    }

    public static String encodeForCsv(String cellValue) {
        if (cellValue == null) {
            return null;
        }
        String result = StringEscapeUtils.escapeCsv((String)cellValue);
        return result;
    }

    public static String encodeForHtml(String value) {
        if (value == null) {
            return null;
        }
        String result = StringEscapeUtils.escapeHtml4((String)value);
        return result;
    }

    public static String encodeForXml(String value) {
        if (value == null) {
            return null;
        }
        String result = StringEscapeUtils.escapeXml11((String)value);
        return result;
    }

    public static String encodeForUriQuotes(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("\"", FormattingUtils.encodeForUrl("\""));
    }

    public static String encodeForUrl(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Error encoding URL");
            return null;
        }
    }

    public static String encodeForConcordance(String cellValue) {
        if (cellValue == null) {
            return null;
        }
        String result = cellValue.replace("\r\n", CONCORDANCE_NEWLINE);
        result = result.replace("\r", CONCORDANCE_NEWLINE);
        result = result.replace("\n", CONCORDANCE_NEWLINE);
        return result;
    }

    public static String encodeConcordanceRow(String ... cellValue) {
        CharSequence[] encodedCellValues = (String[])Arrays.stream(cellValue).map(FormattingUtils::encodeForConcordance).toArray(String[]::new);
        String concordanceSeparator = "\u00fe\u0014\u00fe";
        return CONCORDANCE_QUOTES + String.join((CharSequence)concordanceSeparator, encodedCellValues) + CONCORDANCE_QUOTES;
    }

    public static String stageToString(String stage) {
        switch (stage) {
            case "items_add_tag": {
                return iu.getString("FormattingUtils.AddingTags");
            }
            case "items_remove_tag": {
                return iu.getString("FormattingUtils.RemovingTags");
            }
            case "items_exclude": {
                return iu.getString("FormattingUtils.ItemsExcludedFromCase");
            }
            case "items_include": {
                return iu.getString("FormattingUtils.ItemsReIntoCase");
            }
            case "items_assign_custodian": {
                return iu.getString("FormattingUtils.AssigningToCustodian");
            }
            case "items_unassign_custodian": {
                return iu.getString("FormattingUtils.UnassigningFromCustodian");
            }
            case "items_add_custom_metadata": {
                return iu.getString("FormattingUtils.AddCustomMetadata");
            }
            case "items_remove_custom_metadata": {
                return iu.getString("FormattingUtils.RemoveCustomMetadata");
            }
            case "items_apply_custom_metadata_template": {
                return iu.getString("FormattingUtils.ApplyCustomMetadataTemplate");
            }
            case "item_set_deduplicating": {
                return iu.getString("FormattingUtils.DeduplicatingItemSet");
            }
            case "item_set_assigning": {
                return iu.getString("FormattingUtils.AssigningItems");
            }
            case "export_item_discovering": {
                return iu.getString("FormattingUtils.DiscoveringItems");
            }
            case "export_work_queue": {
                return iu.getString("FormattingUtils.PerformingPreWork");
            }
            case "export_load_file_sorting": {
                return iu.getString("FormattingUtils.SortingItems");
            }
            case "export_selected_item_sorting": {
                return iu.getString("FormattingUtils.SortingSelectedItems");
            }
            case "export_item_paths_discovering": {
                return iu.getString("FormattingUtils.GettingItemPaths");
            }
            case "export_top_level_item_deduplicating": {
                return iu.getString("FormattingUtils.FilteringDuplicateTopLevelItems");
            }
            case "work_queue": {
                return iu.getString("FormattingUtils.PreparingItemsForExport");
            }
            case "pre_native": {
                return iu.getString("FormattingUtils.NativeExportSetup");
            }
            case "native": {
                return iu.getString("FormattingUtils.NativeExport");
            }
            case "stored_email_fixup": {
                return iu.getString("FormattingUtils.HandleEmails");
            }
            case "pdf": {
                return iu.getString("FormattingUtils.PrintingImages");
            }
            case "export_print_preview_pdf": {
                return iu.getString("FormattingUtils.ExportOfPrintPreviewImage");
            }
            case "numbering": {
                return iu.getString("FormattingUtils.PageNumbering");
            }
            case "binary_store": {
                return iu.getString("FormattingUtils.StoringNativeIntoBinaryStore");
            }
            case "mailbox": {
                return iu.getString("FormattingUtils.MailboxProcessing");
            }
            case "network_upload": {
                return iu.getString("FormattingUtils.UploadingToNetworkArchive");
            }
            case "ocr": {
                return iu.getString("FormattingUtils.OCRProcessing");
            }
            case "print_store": {
                return iu.getString("FormattingUtils.StoringPrintImages");
            }
            case "print_preview_store": {
                return iu.getString("FormattingUtils.StoringPreviewImages");
            }
            case "markup": {
                return iu.getString("FormattingUtils.ApplyingMarkups");
            }
            case "text_replacement": {
                return iu.getString("FormattingUtils.UpdatingText");
            }
            case "bulk_redaction": {
                return iu.getString("FormattingUtils.FindingRedactionCoordinates");
            }
            case "bulk_redaction_store": {
                return iu.getString("FormattingUtils.StoringRedactionCoordinates");
            }
            case "text": {
                return iu.getString("FormattingUtils.TextExport");
            }
            case "thumbnails": {
                return iu.getString("FormattingUtils.ThumbnailExport");
            }
            case "text_per_page": {
                return iu.getString("FormattingUtils.PerTextExports");
            }
            case "slip_sheet": {
                return iu.getString("FormattingUtils.ImagesSlip");
            }
            case "stamping": {
                return iu.getString("FormattingUtils.ImagesStamping");
            }
            case "tiff": {
                return iu.getString("FormattingUtils.ImagesExport");
            }
            case "image": {
                return iu.getString("FormattingUtils.ImagesExport");
            }
            case "file_naming": {
                return iu.getString("FormattingUtils.FileRenaming");
            }
            case "set_file_times": {
                return iu.getString("FormattingUtils.SettingNativeFileTimes");
            }
            case "digest": {
                return iu.getString("FormattingUtils.WritingOutDigestReport");
            }
            case "create_production_set": {
                return iu.getString("FormattingUtils.CreatingProductionSetForExport");
            }
            case "xhtml_reports": {
                return iu.getString("FormattingUtils.XHTMLItemReportExport");
            }
            case "thumbnail_report": {
                return iu.getString("FormattingUtils.ThumbnailReportExport");
            }
            case "load_files": {
                return iu.getString("FormattingUtils.LoadFileExport");
            }
        }
        return stage;
    }

    public static String join(Set<String> collection, String separator, int maxLength) {
        return FormattingUtils.joinExcept(collection, separator, new HashSet<String>(), maxLength);
    }

    public static String joinExcept(Set<String> collection, String separator, Set<String> blackList, int maxLength) {
        int stopAppendingThreshold = maxLength - 3 - separator.length();
        Iterator<String> iterator = collection.iterator();
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer buf = new StringBuffer(256);
        boolean firstElement = true;
        for (String element : collection) {
            if (element.length() == 0 || blackList != null && blackList.contains(element)) continue;
            if (!firstElement) {
                buf.append(separator);
                if (buf.length() + element.length() >= stopAppendingThreshold) {
                    buf.append("...");
                    break;
                }
            }
            String normalizedElement = element;
            if (separator.length() > 0 && !separator.equals(" ")) {
                normalizedElement = normalizedElement.replace(separator, " ");
                normalizedElement = normalizedElement.replace(separator.trim(), " ");
            }
            buf.append(normalizedElement);
            firstElement = false;
        }
        return buf.toString();
    }

    public static String joinExcept(Set<String> collection, String separator, String blackListed, int maxLength) {
        int stopAppendingThreshold = maxLength - 3 - separator.length();
        Iterator<String> iterator = collection.iterator();
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer buf = new StringBuffer(256);
        boolean firstElement = true;
        for (String element : collection) {
            if (element.length() == 0 || blackListed != null && blackListed.equals(element)) continue;
            if (!firstElement) {
                buf.append(separator);
                if (buf.length() + element.length() >= stopAppendingThreshold) {
                    buf.append("...");
                    break;
                }
            }
            buf.append(element);
            firstElement = false;
        }
        return buf.toString();
    }

    public static String itemsCountToDisplay(long count) {
        return iu.getNumeralString("FormattingUtils.ItemsProcessed", count);
    }

    public static String getOrdinal(int number) {
        int mod100 = number % 100;
        int mod10 = number % 10;
        if (mod10 == 1 && mod100 != 11) {
            return number + iu.getString("FormattingUtils.First");
        }
        if (mod10 == 2 && mod100 != 12) {
            return number + iu.getString("FormattingUtils.Second");
        }
        if (mod10 == 3 && mod100 != 13) {
            return number + iu.getString("FormattingUtils.Third");
        }
        return number + iu.getString("FormattingUtils.Fourth");
    }

    public static String countToDisplay(long count, String singular, String plural) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
        return numberFormat.format(count) + " " + (count != 1L ? plural : singular);
    }

    public static String countToDisplay(long count) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
        return numberFormat.format(count);
    }

    public static String sizeToDisplaySize(BigInteger size, int maxChars) {
        String displaySize;
        BigDecimal bdSize = new BigDecimal(size);
        SizeSuffix selectedSuffix = SizeSuffix.B;
        for (SizeSuffix sizeSuffix : SizeSuffix.values()) {
            if (sizeSuffix.equals((Object)SizeSuffix.B)) continue;
            if (bdSize.setScale(0, RoundingMode.HALF_UP).toString().length() <= maxChars) break;
            selectedSuffix = sizeSuffix;
            bdSize = bdSize.divide(KILO_DIVISOR);
        }
        if ((displaySize = bdSize.setScale(0, RoundingMode.HALF_UP).toString()).length() < maxChars - 1) {
            displaySize = bdSize.setScale(maxChars - 1 - displaySize.length(), RoundingMode.HALF_UP).toString();
        }
        if (selectedSuffix == SizeSuffix.B) {
            return displaySize.replace(".0", "") + " " + (Object)((Object)selectedSuffix);
        }
        return displaySize + " " + (Object)((Object)selectedSuffix);
    }

    public static String sizeToDisplaySize(long size, int maxChars) {
        return FormattingUtils.sizeToDisplaySize(BigInteger.valueOf(size), maxChars);
    }

    public static String sizeToDisplaySize(long size) {
        return FormattingUtils.sizeToDisplaySize(BigInteger.valueOf(size), 3);
    }

    public static String normalizeParameterName(String name) {
        name = name.toLowerCase();
        name = name.replaceAll("[^a-z0-9]", "_");
        name = name.replaceAll("_+", "_");
        name = name.replaceAll("^_", "");
        name = name.replaceAll("_$", "");
        name = "{" + name + "}";
        return name;
    }

    public static String trimEnd(String value, char charToString) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        if (len > 0 && value.charAt(len - 1) == charToString) {
            return value.substring(0, len - 1);
        }
        return value;
    }

    public static String getExceptionPrintableMessage(Exception e) {
        Throwable t = e;
        StringBuilder message = new StringBuilder();
        do {
            String cause = t.getMessage();
            if ((cause = FormattingUtils.trimEnd(cause, ':')) == null || message.toString().contains(cause)) continue;
            if (message.length() > 0) {
                message.append(", ");
            }
            message.append(cause);
        } while ((t = t.getCause()) != null);
        return message.toString();
    }

    public static String getLastSubstring(String main, String split) {
        String[] splits = main.split(split);
        return splits[splits.length - 1];
    }

    public static String getShortId(String id) {
        return FormattingUtils.getShortId(id, 3);
    }

    public static String getShortId(String id, int maxLength) {
        if (id == null) {
            return "Unknown";
        }
        return UidUtils.getShortId(id, maxLength);
    }

    public static String getExportStageTranslation(String stage) {
        try {
            return iu.getString("MimeType.Stage." + stage, true);
        }
        catch (Exception e) {
            return stage;
        }
    }

    public static String removeAnsiColors(String text) {
        return text.replaceAll("\u001b\\[[;\\d]*[ -/]*[@-~]", "");
    }

    public static Set<String> splitLines(String source) {
        String[] splits;
        HashSet<String> result = new HashSet<String>();
        if (source == null) {
            return result;
        }
        for (String split : splits = source.split("\\n")) {
            String normalizedSplit = split.trim();
            if (normalizedSplit.length() <= 0) continue;
            result.add(normalizedSplit);
        }
        return result;
    }

    public static String encodeHexString(byte[] byteArray) {
        StringBuilder stringBuilder = new StringBuilder(byteArray.length * 2);
        for (byte b : byteArray) {
            stringBuilder.append(String.format("%02x", b));
        }
        return stringBuilder.toString();
    }

    public static String toConstantName(String source) {
        return source.replace(' ', '_').toUpperCase();
    }

    public static String fromConstantName(String constName) {
        return WordUtils.capitalizeFully((String)constName.replace('_', ' '));
    }

    public static String getTrimmedText(String text) {
        if (text != null) {
            return text.trim();
        }
        return null;
    }

    public static String getNonEmptyTrimmedText(String text) {
        if (text != null && !text.trim().isEmpty()) {
            return text.trim();
        }
        return null;
    }

    public static boolean isTextEmpty(String text) {
        return FormattingUtils.getNonEmptyTrimmedText(text) == null;
    }

    public static String constantToCamelCase(String constant) {
        String[] split = constant.toLowerCase().split("_");
        StringBuilder result = new StringBuilder(split[0]);
        for (int i = 1; i < split.length; ++i) {
            result.append(split[i].substring(0, 1).toUpperCase()).append(split[i], 1, split[i].length());
        }
        return result.toString();
    }

    public static String constantToCamelCaseFirstUpper(String constant) {
        String[] split = constant.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            result.append(split[i].substring(0, 1).toUpperCase()).append(split[i], 1, split[i].length());
        }
        return result.toString();
    }

    public static String constantUppercaseToUserPrintable(String constant) {
        if (constant == null || constant.trim().length() == 0) {
            return "";
        }
        constant = constant.replaceAll("[^A-Za-z0-9 \\\\.\\\\(\\\\)]", "");
        char[] chArray = constant.toCharArray();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < chArray.length; ++i) {
            char ch = chArray[i];
            if (i == 0) {
                result.append(ch);
                continue;
            }
            if (Character.isUpperCase(ch) && !Character.isSpaceChar(ch)) {
                boolean nextCharSpace;
                boolean nextCharCapitalized = i + 1 < chArray.length && Character.isUpperCase(chArray[i + 1]);
                boolean bl = nextCharSpace = i + 1 < chArray.length && Character.isSpaceChar(chArray[i + 1]);
                if (chArray[i - 1] != '(' && chArray[i - 1] != '.' && !Character.isSpaceChar(chArray[i - 1])) {
                    if (!Character.isUpperCase(chArray[i - 1]) && nextCharCapitalized) {
                        result.append(" ");
                    }
                    if (!nextCharCapitalized && !nextCharSpace) {
                        result.append(" ");
                    }
                }
            }
            if (Character.isSpaceChar(ch) && (Character.isSpaceChar(chArray[i - 1]) || i + 1 < chArray.length && chArray[i + 1] == '.')) continue;
            result.append(ch);
        }
        return result.toString().trim();
    }

    public static String constantToUserPrintable(String constant) {
        String[] split = constant.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(split[i].substring(0, 1).toUpperCase()).append(split[i], 1, split[i].length());
        }
        return result.toString();
    }

    public static String camelCaseToSnakeCase(String value) {
        return value.replaceAll("(.)([A-Z][a-z]+)", "$1_$2").replaceAll("__([A-Z])", "_$1").replaceAll("([a-z0-9])([A-Z])", "$1_$2").toLowerCase();
    }

    public static String camelCaseToPrintable(String value) {
        String result = value.replaceAll("(.)([A-Z][a-z]+)", "$1_$2").replaceAll("__([A-Z])", "_$1").replaceAll("([a-z0-9])([A-Z])", "$1_$2");
        return result.substring(0, 1).toUpperCase() + result.substring(1, result.length() - 1);
    }

    public static Set<String> normalizeCertificateFingerprints(Set<String> fingerprints) {
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
        if (fingerprints != null) {
            for (String fingerprint : fingerprints) {
                whitelistedCertFingerprints.add(fingerprint.toLowerCase().replaceAll("[^a-f0-9 ]", ""));
            }
        }
        return whitelistedCertFingerprints;
    }

    public static String[] getExtensionColor(String fileType) {
        if (fileType == null) {
            return new String[]{"#BA68C8", "#F3E5F5"};
        }
        switch (fileType) {
            case "executable": {
                return new String[]{"#FF80AB", "#FCE4EC"};
            }
            case "document": {
                return new String[]{"#1976D2", "#E3F2FD"};
            }
            case "spreadsheet": {
                return new String[]{"#388E3C", "#E8F5E9"};
            }
            case "image": {
                return new String[]{"#ffa000", "#FFF3E0"};
            }
            case "archive": {
                return new String[]{"#ff9100", "#FFE0B2"};
            }
        }
        return new String[]{"#BA68C8", "#F3E5F5"};
    }

    public static String usernameToInitials(String username) {
        if (username.length() <= 2) {
            return username.toUpperCase();
        }
        String[] emailSplits = username.split("@");
        String[] nameSplits = emailSplits[0].split("\\.");
        if (nameSplits.length > 1) {
            return (nameSplits[0].substring(0, 1) + nameSplits[1].substring(0, 1)).toUpperCase();
        }
        return username.substring(0, 1).toUpperCase();
    }

    public static Color usernameToColor(String username) {
        float saturation = 0.75f;
        float brightness = 0.6f;
        username.toLowerCase();
        Random r = new Random(FormattingUtils.stringToSeed(username));
        float hue = r.nextFloat();
        Color color = Color.getHSBColor(hue, saturation, brightness);
        return color;
    }

    public static String colorToHex(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    static long stringToSeed(String s) {
        if (s == null) {
            return 0L;
        }
        long hash = 0L;
        for (char c : s.toCharArray()) {
            hash = 31L * hash + (long)c;
        }
        return hash;
    }

    public static void appendBOM(OutputStream out) throws IOException {
        out.write(65263);
        out.write(65211);
        out.write(65215);
    }

    public static String sanitizeFilename(String inputName) {
        String filename = inputName.replaceAll("[:\\\\/*\"?|<>']", " ").replace('\n', ' ').replace('\r', ' ').replace('\t', ' ');
        if (filename.length() > 255) {
            filename = filename.substring(0, 255);
        }
        return filename;
    }

    public static String incrementName(String name, Set<String> existingNames) {
        String result = name;
        if (existingNames.contains(result)) {
            int i = 2;
            if (result.matches(".*\\([0-9]+\\)$")) {
                int leftParenthesisIndex = result.lastIndexOf(" (");
                i = Integer.parseInt(result.substring(leftParenthesisIndex + 2, result.length() - 1)) + 1;
                result = result.substring(0, leftParenthesisIndex);
            }
            while (existingNames.contains(result + " (" + i + ")")) {
                ++i;
            }
            result = result + " (" + i + ")";
        }
        return result;
    }

    public static String anonymizeUrlPathAndParams(String url) {
        if (url != null) {
            Matcher matcher = typicalUriPattern.matcher(url);
            url = matcher.find() ? matcher.group(1) + "..." : "...";
        }
        return url;
    }

    public static long parseLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static int parseInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static double parseDouble(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static boolean parseBoolean(String value) {
        return FormattingUtils.parseBoolean(value, true);
    }

    public static boolean parseBoolean(String value, boolean acceptSimilar) {
        boolean result = Boolean.parseBoolean(value);
        if (acceptSimilar) {
            result = result || value.equalsIgnoreCase("y");
            result = result || value.equalsIgnoreCase("yes");
        }
        return result;
    }

    public static void trimAllStrings(Object object) {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        int trimCount = 0;
        try {
            for (Field field : ReflectionUtils.getAllDeclaredFields(clazz, true)) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                Object value = field.get(object);
                if (value == null) continue;
                try {
                    Class collectionType;
                    Class<?> fieldClazz = field.getType();
                    if (String.class.isAssignableFrom(fieldClazz)) {
                        field.set(object, ((String)value).trim());
                        ++trimCount;
                        continue;
                    }
                    if (clazz.isArray()) {
                        collectionType = clazz.getComponentType();
                        if (!String.class.isAssignableFrom(collectionType)) continue;
                        String[] strArray = (String[])value;
                        for (int i = 0; i < strArray.length; ++i) {
                            if (strArray[i] == null) continue;
                            strArray[i] = strArray[i].trim();
                            ++trimCount;
                        }
                        continue;
                    }
                    if (!Collection.class.isAssignableFrom(clazz)) continue;
                    collectionType = (Class)ReflectionUtils.getGenericParameterizedTypeArguments(field)[0];
                    if (!(value instanceof Collection) || !String.class.isAssignableFrom(collectionType)) continue;
                    Collection collValue = (Collection)value;
                    String[] strArray = collValue.toArray(new String[0]);
                    for (int i = 0; i < strArray.length; ++i) {
                        String str = strArray[i];
                        if (str == null) continue;
                        if (collValue instanceof List) {
                            ((List)collValue).set(i, str.trim());
                        } else {
                            collValue.remove(str);
                            collValue.add(str.trim());
                        }
                        ++trimCount;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error trimming field: " + field.getName(), e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error trimming Strings for class: " + clazz.getSimpleName());
        }
        LOGGER.info("Trimmed " + trimCount + " fields, " + clazz.getSimpleName());
    }

    public static String getEmailHeader(Item item) {
        DateTime dateTime;
        Object subject;
        Communication communication = item.getCommunication();
        if (communication == null) {
            return "";
        }
        StringBuilder header = new StringBuilder();
        List addresses = communication.getFrom();
        if (!addresses.isEmpty()) {
            header.append("From: ").append(FormattingUtils.getEmailHeaderAddresses(addresses));
        }
        if (!(addresses = communication.getTo()).isEmpty()) {
            header.append("To: ").append(FormattingUtils.getEmailHeaderAddresses(addresses));
        }
        if (!(addresses = communication.getCc()).isEmpty()) {
            header.append("CC: ").append(FormattingUtils.getEmailHeaderAddresses(addresses));
        }
        if (!(addresses = communication.getBcc()).isEmpty()) {
            header.append("BCC: ").append(FormattingUtils.getEmailHeaderAddresses(addresses));
        }
        if ((subject = item.getProperties().get("Subject")) == null) {
            subject = item.getProperties().get("Mapi-Subject");
        }
        if (subject != null) {
            header.append("Subject: ").append(subject).append("\n");
        }
        if ((dateTime = communication.getDateTime()) != null) {
            header.append("Date: ").append(FormattingUtils.dateTimeToEmailDateTimeString(communication.getDateTime())).append("\n");
        }
        header.append("\n");
        return header.toString();
    }

    public static String getEmailHeaderAddresses(List<Address> addresses) {
        StringBuilder header = new StringBuilder();
        if (!addresses.isEmpty()) {
            for (Address address : addresses) {
                if (header.length() > 0) {
                    header.append(", ");
                }
                header.append(address.toRfc822String());
            }
        }
        return header.toString();
    }

    static enum SizeSuffix {
        B,
        KB,
        MB,
        GB,
        TB,
        PB,
        EB,
        ZB,
        YB;

    }
}

