/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.exception.ExceptionUtils;

public final class JavaUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JavaUtils.class);
    private static final int RECOMMENDED_JAVA_VERSION = 11;

    public static String getDisableCrashDumpString(int javaVersion) {
        if (javaVersion >= 9) {
            return "-XX:-CreateCoredumpOnCrash";
        }
        return "-XX:-CreateMinidumpOnCrash";
    }

    public static boolean isVersionBelowRecommended() {
        return JavaUtils.getVersion() < 11;
    }

    public static int getVersion() {
        String version = System.getProperty("java.version");
        return JavaUtils.getVersionFromString(version);
    }

    public static int getVersionFromString(String version) {
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static int getVersion(String javaExecutable) {
        Pattern pattern = Pattern.compile("(\\d{1,5}\\.\\d{1,5}\\.\\d{1,5})");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(javaExecutable);
        commands.add("-version");
        ProcessBuilder pb = new ProcessBuilder(commands);
        Process p = null;
        String output = null;
        Exception ex = null;
        try {
            p = pb.start();
            int errCode = p.waitFor();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error getting java version: " + errCode);
            }
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((output = stdInput.readLine()) != null) {
                LOGGER.info("java -version: " + output);
                Matcher matcher = pattern.matcher(output);
                if (!matcher.find()) continue;
                return JavaUtils.getVersionFromString(matcher.group());
            }
        }
        catch (IOException | InterruptedException e) {
            ex = e;
            LOGGER.error("Unexpected error", e);
        }
        String errorMessage = "Cannot get java version from " + javaExecutable;
        if (output != null) {
            errorMessage = errorMessage + " from output " + output;
        }
        if (ex != null) {
            errorMessage = errorMessage + ", " + ExceptionUtils.getMessage((Throwable)ex);
        }
        throw new IllegalArgumentException(errorMessage);
    }
}

