/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.smtp.EmailModel;
import com.nuix.automate.utils.ui.IconType;
import com.nuix.automate.utils.ui.Icons;
import com.nuix.automate.utils.ui.PngIcon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.swing.Icon;

public class JavaxEmailUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JavaxEmailUtils.class);

    public static void sendEmail(String emailSmtpServer, boolean emailTLS, int emailSmtpPort, String emailFrom, String emailTo, String emailSubject, String emailMessage, boolean emailMessageIsHtml, String workflowLog, String reportFilePath, Set<String> additionalAttachments, String smtpUsername, String smtpPassword) throws MessagingException {
        JavaxEmailUtils.sendEmail(emailSmtpServer, emailTLS, emailSmtpPort, emailFrom, emailTo, emailSubject, emailMessage, emailMessageIsHtml, workflowLog, reportFilePath, additionalAttachments, smtpUsername, smtpPassword, null);
    }

    public static void sendEmail(String emailSmtpServer, boolean emailTLS, int emailSmtpPort, String emailFrom, String emailTo, String emailSubject, String emailMessage, boolean emailMessageIsHtml, String workflowLog, String reportFilePath, Set<String> additionalAttachments, String smtpUsername, String smtpPassword, String emailCc) throws MessagingException {
        EmailModel emailModel = new EmailModel(emailSmtpServer, emailSmtpPort, emailMessageIsHtml, emailTLS);
        emailModel.setSmtpUser(smtpUsername, smtpPassword);
        emailModel.setParticipants(emailFrom, emailTo, emailCc, null);
        emailModel.setMessage(emailSubject, emailMessage);
        emailModel.setAdditionalMessages(additionalAttachments, reportFilePath, workflowLog);
        JavaxEmailUtils.sendEmail(emailModel);
    }

    public static void sendEmail(EmailModel emailModel) throws MessagingException {
        Set<String> additionalAttachments;
        String reportFilePath;
        String emailBcc;
        String[] emailToAddresses;
        boolean authentication;
        LOGGER.info("Preparing email");
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", emailModel.getSmtpServer());
        if (emailModel.isEmailTls()) {
            properties.put("mail.smtp.starttls.enable", "true");
        } else {
            properties.put("mail.smtp.starttls.enable", "false");
        }
        properties.put("mail.smtp.connectiontimeout", "30000");
        properties.put("mail.smtp.timeout", "30000");
        properties.put("mail.smtps.timeout", "30000");
        properties.put("mail.smtps.connectiontimeout", "30000");
        final String smtpUsername = emailModel.getSmtpUsername();
        final String smtpPassword = emailModel.getSmtpPassword();
        boolean bl = authentication = smtpUsername != null && smtpPassword != null;
        if (authentication) {
            properties.put("mail.smtp.auth", "true");
        } else {
            properties.put("mail.smtp.auth", "false");
        }
        properties.put("mail.smtp.port", String.valueOf(emailModel.getSmtpPort()));
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(smtpUsername, smtpPassword);
            }
        };
        Session session = authentication ? Session.getInstance((Properties)properties, (Authenticator)authenticator) : Session.getInstance((Properties)properties);
        MimeMessage message = new MimeMessage(session);
        MimeMultipart messageMultiPart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        message.setFrom((Address)new InternetAddress(emailModel.getFrom()));
        for (String emailToAddress : emailToAddresses = emailModel.getTo().split(";")) {
            if (emailToAddress.trim().length() <= 0) continue;
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(emailToAddress.trim()));
        }
        String emailCc = emailModel.getCc();
        if (emailCc != null) {
            String[] emailCcAddresses;
            for (String emailCcAddress : emailCcAddresses = emailCc.split(";")) {
                if (emailCcAddress.trim().length() <= 0) continue;
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(emailCcAddress.trim()));
            }
        }
        if ((emailBcc = emailModel.getBcc()) != null) {
            String[] emailBccAddresses;
            for (String string : emailBccAddresses = emailBcc.split(";")) {
                if (string.trim().length() <= 0) continue;
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(string.trim()));
            }
        }
        message.setSubject(emailModel.getSubject());
        String emailMessage = emailModel.getMessage();
        if (emailModel.isHtmlMessage()) {
            String iconSrc;
            MimeMultipart htmlMultipart = new MimeMultipart("related");
            MimeBodyPart htmlBodyPart = new MimeBodyPart();
            String temp = emailMessage;
            for (IconType iconType : IconType.values()) {
                iconSrc = "src=\"" + Icons.getInstance().getIconUrl(iconType) + "\"";
                if (!emailMessage.contains(iconSrc)) continue;
                emailMessage = emailMessage.replace(iconSrc, "src=\"cid:automate-" + iconType.name() + "\"");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Message body:\n-------\n" + emailMessage + "\n-------");
            }
            htmlBodyPart.setContent((Object)emailMessage, "text/html; charset=utf-8");
            htmlMultipart.addBodyPart((BodyPart)htmlBodyPart);
            for (IconType iconType : IconType.values()) {
                Icon icon;
                iconSrc = "src=\"" + Icons.getInstance().getIconUrl(iconType) + "\"";
                if (!temp.contains(iconSrc)) continue;
                temp = temp.replace(iconSrc, "src=\"cid:automate-" + iconType.name() + "\"");
                MimeBodyPart iconBodyPart = new MimeBodyPart();
                iconBodyPart.setDisposition("inline");
                int size = 80;
                if (iconType == IconType.LOGO) {
                    size = 0;
                }
                if ((icon = Icons.getInstance().getIcon(iconType, size)) instanceof PngIcon) {
                    PngIcon pngIcon = (PngIcon)icon;
                    ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
                    try {
                        pngIcon.getPngStream(pngOutputStream);
                        ByteArrayInputStream pngInputStream = new ByteArrayInputStream(pngOutputStream.toByteArray());
                        iconBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((InputStream)pngInputStream, "image/png")));
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot get PNG stream", e);
                        LOGGER.error("Unexpected error", e);
                    }
                } else {
                    URLDataSource dataSource = new URLDataSource(JavaxEmailUtils.class.getResource(Icons.getInstance().getIconUrl(iconType)));
                    iconBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                }
                iconBodyPart.setContentID("<automate-" + iconType.name() + ">");
                iconBodyPart.setFileName("automate-" + iconType.toString().toLowerCase() + ".png");
                htmlMultipart.addBodyPart((BodyPart)iconBodyPart);
            }
            messageBodyPart.setContent((Multipart)htmlMultipart);
            messageMultiPart.addBodyPart((BodyPart)messageBodyPart);
        } else {
            messageBodyPart.setText(emailMessage);
            messageMultiPart.addBodyPart((BodyPart)messageBodyPart);
        }
        String workflowLog = emailModel.getWorkflowLog();
        if (workflowLog != null) {
            try {
                LOGGER.info("Attaching workflow log");
                File workflowLogFile = FileUtils.createTempFile("WorkflowLog", ".txt");
                Files.write(Paths.get(workflowLogFile.getAbsolutePath(), new String[0]), workflowLog.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                FileDataSource fileDataSource = new FileDataSource(workflowLogFile);
                attachmentBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                attachmentBodyPart.setFileName("WorkflowLog.txt");
                attachmentBodyPart.setDisposition("attachment");
                messageMultiPart.addBodyPart((BodyPart)attachmentBodyPart);
            }
            catch (Exception ex) {
                LOGGER.error("Cannot attach workflow log file", ex);
            }
        }
        if ((reportFilePath = emailModel.getReportFilePath()) != null) {
            try {
                LOGGER.info("Attaching report");
                File workflowReportFile = new File(reportFilePath);
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(workflowReportFile);
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)source));
                mimeBodyPart.setFileName(workflowReportFile.getName());
                mimeBodyPart.setDisposition("attachment");
                messageMultiPart.addBodyPart((BodyPart)mimeBodyPart);
            }
            catch (Exception ex) {
                LOGGER.error("Cannot attach report file", ex);
            }
        }
        if ((additionalAttachments = emailModel.getAdditionalAttachments()) != null) {
            for (String additionalAttachment : additionalAttachments) {
                try {
                    LOGGER.info("Attaching file " + additionalAttachment);
                    File workflowReportFile = new File(additionalAttachment);
                    MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(workflowReportFile);
                    attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    attachmentBodyPart.setFileName(workflowReportFile.getName());
                    attachmentBodyPart.setDisposition("attachment");
                    messageMultiPart.addBodyPart((BodyPart)attachmentBodyPart);
                }
                catch (Exception ex) {
                    LOGGER.error("Cannot attach file", ex);
                }
            }
        }
        message.setContent((Multipart)messageMultiPart);
        Transport.send((Message)message);
        LOGGER.info("Email sent successfully");
    }
}

