/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.exceptions.JwtException;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class JwtUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JwtUtils.class);

    public static Map<String, Object> getTokenClaimsNoVerify(String token) throws JwtException {
        Map<String, Object> result = new HashMap<String, Object>();
        if (token == null) {
            LOGGER.debug("JWT token is null");
            return result;
        }
        String[] splits = token.split("\\.");
        if (splits.length != 3) {
            LOGGER.debug("JWT token splits expected 3, got " + splits.length);
            return result;
        }
        String decodedClaims = new String(Base64.getDecoder().decode(splits[1]), StandardCharsets.UTF_8);
        result = SerializationUtils.fromJson(decodedClaims, Map.class);
        return result;
    }
}

