/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.MimeTypeUtils;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class MimeTypeStat
implements Serializable {
    private String mimeType;
    private String fileType;
    private Map<String, AtomicLong> columnItemCount;

    public MimeTypeStat() {
    }

    public MimeTypeStat(String mimeType) {
        this.mimeType = mimeType;
        this.columnItemCount = new LinkedHashMap<String, AtomicLong>();
        this.fileType = MimeTypeUtils.getInstance().getFileType(mimeType);
    }

    public MimeTypeStat(String mimeType, String fileType) {
        this.mimeType = mimeType;
        this.fileType = fileType;
        this.columnItemCount = new LinkedHashMap<String, AtomicLong>();
    }

    @JsonIgnore
    public long getProcessed() {
        AtomicLong processed = this.columnItemCount.get("processed");
        if (processed == null) {
            Optional<AtomicLong> firstColumnValue = this.columnItemCount.values().stream().findFirst();
            return firstColumnValue.orElse(new AtomicLong(0L)).get();
        }
        return processed.get();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public synchronized void incrementStageCount(String columnName) {
        AtomicLong currentCount = this.columnItemCount.computeIfAbsent(columnName, s -> new AtomicLong(0L));
        currentCount.incrementAndGet();
    }

    public Map<String, Long> getColumnItemCount() {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> entry : this.columnItemCount.entrySet()) {
            result.put(entry.getKey(), entry.getValue().longValue());
        }
        return result;
    }
}

