/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.MimeTypeInfo;
import com.nuix.automate.utils.general.MimeTypeInfos;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class MimeTypeUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MimeTypeUtils.class);
    private static MimeTypeUtils instance;
    private Map<String, MimeTypeInfo> mimeTypeToInfo;
    private Map<String, MimeTypeInfo> extensionToInfo;

    public static synchronized MimeTypeUtils getInstance() {
        if (instance == null) {
            instance = new MimeTypeUtils();
        }
        return instance;
    }

    private MimeTypeUtils() {
        try (InputStream stream = this.getClass().getResourceAsStream("/dictionary/mimeTypes.json");){
            String mappingText = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            MimeTypeInfos mimeTypeInfos = SerializationUtils.fromJson(mappingText, MimeTypeInfos.class);
            this.mimeTypeToInfo = new HashMap<String, MimeTypeInfo>();
            this.extensionToInfo = new HashMap<String, MimeTypeInfo>();
            for (MimeTypeInfo mimeTypeInfo : mimeTypeInfos.getMimeTypeInfos()) {
                this.mimeTypeToInfo.put(mimeTypeInfo.getMimeType(), mimeTypeInfo);
                if (mimeTypeInfo.getPreferredExtension() == null) continue;
                this.extensionToInfo.put(mimeTypeInfo.getPreferredExtension(), mimeTypeInfo);
            }
            for (MimeTypeInfo mimeTypeInfo : mimeTypeInfos.getMimeTypeInfos()) {
                for (String extension : mimeTypeInfo.getKnownExtensions()) {
                    this.extensionToInfo.putIfAbsent(extension, mimeTypeInfo);
                }
            }
            this.extensionToInfo.put("txt", this.mimeTypeToInfo.get("text/plain"));
            this.extensionToInfo.put("doc", this.mimeTypeToInfo.get("application/vnd.ms-word"));
            this.extensionToInfo.put("pdf", this.mimeTypeToInfo.get("application/pdf"));
            this.extensionToInfo.put("jpg", this.mimeTypeToInfo.get("image/jpeg"));
            this.extensionToInfo.put("jpeg", this.mimeTypeToInfo.get("image/jpeg"));
            this.extensionToInfo.put("xml", this.mimeTypeToInfo.get("application/xml"));
            this.extensionToInfo.put("bin", this.mimeTypeToInfo.get("application/octet-stream"));
            this.extensionToInfo.put("", this.mimeTypeToInfo.get("application/octet-stream"));
            this.extensionToInfo.put("msg", this.mimeTypeToInfo.get("application/vnd.ms-outlook-item"));
            this.extensionToInfo.put("html", this.mimeTypeToInfo.get("text/html"));
            this.extensionToInfo.put("htm", this.mimeTypeToInfo.get("text/html"));
            this.extensionToInfo.put("csv", this.mimeTypeToInfo.get("text/csv"));
            this.extensionToInfo.put("zip", this.mimeTypeToInfo.get("application/x-zip-compressed"));
        }
        catch (IOException e) {
            LOGGER.error("Cannot load mime types dictionary", e);
        }
    }

    public String getDefaultExtension(String mimeType) {
        MimeTypeInfo mimeTypeInfo = this.mimeTypeToInfo.get(mimeType);
        if (mimeTypeInfo == null) {
            return null;
        }
        return mimeTypeInfo.getPreferredExtension();
    }

    public String getMimeType(String extension) {
        MimeTypeInfo mimeTypeInfo;
        String effectiveExtension = extension;
        if (effectiveExtension == null) {
            effectiveExtension = "";
        }
        if ((mimeTypeInfo = this.extensionToInfo.get(effectiveExtension = effectiveExtension.trim())) == null) {
            return "application/octet-stream";
        }
        return mimeTypeInfo.getMimeType();
    }

    public String getFileType(String mimeType) {
        MimeTypeInfo mimeTypeInfo = this.mimeTypeToInfo.get(mimeType);
        if (mimeTypeInfo == null) {
            return mimeType;
        }
        return mimeTypeInfo.getFileType();
    }

    public Collection<MimeTypeInfo> getAllMimeTypes() {
        return this.mimeTypeToInfo.values();
    }
}

