/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class MockUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MockUtils.class);
    private static MockUtils instance;
    private List<String> firstNames;

    private MockUtils() {
        this.readFirstNamesDictionary();
    }

    public String getName(int seed) {
        int index = seed * 13;
        return this.firstNames.get(index %= this.firstNames.size());
    }

    private void readFirstNamesDictionary() {
        ArrayList<String> dictionaryNames = new ArrayList<String>();
        dictionaryNames.add("/dictionary/EnglishNames.txt");
        dictionaryNames.add("/dictionary/FrenchNames.txt");
        dictionaryNames.add("/dictionary/IrishNames.txt");
        this.firstNames = new ArrayList<String>();
        for (String dictionaryName : dictionaryNames) {
            LOGGER.info("Loading dictionary " + dictionaryName);
            try {
                InputStream stream = this.getClass().getResourceAsStream(dictionaryName);
                try {
                    String[] lines;
                    String script = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                    for (String line : lines = script.split("[\\r\\n]+")) {
                        this.firstNames.add(StringUtils.strip((String)line).toLowerCase());
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot read dictionary", e);
            }
        }
    }

    public static synchronized MockUtils getInstance() {
        if (instance == null) {
            instance = new MockUtils();
        }
        return instance;
    }
}

