/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class MultiplexOutputStream
extends OutputStream {
    private final OutputStream[] outputStreams;

    public MultiplexOutputStream(OutputStream ... outputStreams) {
        Objects.requireNonNull(outputStreams);
        assert (outputStreams.length > 0);
        for (OutputStream o : outputStreams) {
            Objects.requireNonNull(o);
        }
        this.outputStreams = outputStreams;
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.close();
        }
    }
}

