/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDFUtils {
    public static String hashPassword(String password, String salt, int iterations) {
        byte[] result = PBKDFUtils.hashPassword(password.toCharArray(), Base64.getDecoder().decode(salt), iterations);
        return Base64.getEncoder().encodeToString(result);
    }

    public static byte[] hashPassword(char[] password, byte[] salt, int iterations) {
        try {
            int keyLength = 512;
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, keyLength);
            SecretKey key = skf.generateSecret(spec);
            byte[] res = key.getEncoded();
            return res;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }
}

