/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ReflectionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<?>> getClassesForPackage(String packageName, Class<?> superClazz) throws IOException, URISyntaxException {
        String packagePathName = packageName.replace('.', '/');
        URI packageUri = Objects.requireNonNull(ClassLoader.getSystemClassLoader().getResource(packagePathName)).toURI();
        ArrayList classes = new ArrayList();
        try (FileSystem fileSystem = null;){
            Path rootPath;
            if (packageUri.toString().startsWith("jar:")) {
                try {
                    rootPath = FileSystems.getFileSystem(packageUri).getPath(packagePathName, new String[0]);
                }
                catch (FileSystemNotFoundException e) {
                    fileSystem = FileSystems.newFileSystem(packageUri, Collections.emptyMap());
                    rootPath = fileSystem.getPath(packagePathName, new String[0]);
                }
            } else {
                rootPath = Paths.get(packageUri);
            }
            String extension = ".class";
            try (Stream<Path> allPaths = Files.walk(rootPath, new FileVisitOption[0]);){
                allPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    try {
                        String path = file.toString().replace("/", ".").replace("\\", ".");
                        String name = path.substring(path.indexOf(packageName), path.length() - extension.length());
                        Class<?> clazz = Class.forName(name);
                        if (superClazz == null || superClazz.isAssignableFrom(clazz)) {
                            classes.add(clazz);
                        }
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError | StringIndexOutOfBoundsException throwable) {
                        // empty catch block
                    }
                });
            }
        }
        return classes;
    }

    public static List<Field> getAllDeclaredFields(Class<?> clazz, boolean includeSuperClassFields) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        if (includeSuperClassFields) {
            Class<?> parentClazz = clazz;
            while ((parentClazz = parentClazz.getSuperclass()) != null && !parentClazz.equals(Object.class)) {
                fields.addAll(Arrays.asList(parentClazz.getDeclaredFields()));
            }
        }
        return fields;
    }

    public static <T> T initializeDefaultClassInstance(Class<T> clazz) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Object defaultInstance;
            if (constructor.getParameterTypes().length != 0 || !clazz.isInstance(defaultInstance = constructor.newInstance(new Object[0]))) continue;
            return clazz.cast(defaultInstance);
        }
        return null;
    }

    public static Type[] getGenericParameterizedTypeArguments(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getActualTypeArguments();
        }
        return new Type[]{genericType};
    }

    public static Class<?> getArrayOrCollectionType(Class<?> clazz, Field field) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return (Class)ReflectionUtils.getGenericParameterizedTypeArguments(field)[0];
        }
        return null;
    }

    public static Method tryGetMethod(Class<?> clazz, Class<?>[] parameterTypes, String ... methods) throws NoSuchMethodException {
        for (int i = 0; i < methods.length; ++i) {
            try {
                return clazz.getMethod(methods[i], parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (i != methods.length - 1) continue;
                throw e;
            }
        }
        return null;
    }
}

