/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class SystemResourcesUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SystemResourcesUtils.class);
    private static SystemResourcesUtils instance;
    private Timer timer;
    private TimerTask timerTask;
    private long upTime;
    private long gcTime;
    private long uiGcSkip;
    private boolean lowJvmMemory;
    private boolean lowSystemMemory;
    private int refreshMs = 500;
    private RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();

    public static synchronized SystemResourcesUtils getInstance() {
        if (instance == null) {
            instance = new SystemResourcesUtils();
        }
        return instance;
    }

    private SystemResourcesUtils() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                SystemResourcesUtils.this.call();
            }
        };
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(this.timerTask, 0L, (long)this.refreshMs);
    }

    private void checkMemoryUsage() {
        this.checkMemoryUsage(null);
    }

    public void checkMemoryUsage(String message) {
        if (message != null) {
            this.uiGcSkip = 0L;
        } else {
            ++this.uiGcSkip;
            if (this.uiGcSkip < 120L) {
                return;
            }
        }
        this.uiGcSkip = 0L;
        long currentUpTime = this.runtimeMXBean.getUptime();
        long currentGcTime = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            currentGcTime += garbageCollectorMXBean.getCollectionTime();
        }
        long deltaUpTime = currentUpTime - this.upTime;
        long deltaGcTime = currentGcTime - this.gcTime;
        double percentageGc = (double)deltaGcTime / (double)deltaUpTime;
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().printZeroNever().appendHours().appendSuffix("h").appendSeparator(" ").printZeroNever().appendMinutes().appendSuffix("m").appendSeparator(" ").printZeroAlways().appendSeconds().appendSuffix("s").toFormatter();
        LOGGER.info(String.format(Locale.ROOT, "JVM GC time: %s, Total GC time: %s, GC percentage: %.2f%%, Max memory: %s, Total memory: %s, Free memory %s", periodFormatter.print((ReadablePeriod)new Period(deltaGcTime)), periodFormatter.print((ReadablePeriod)new Period(currentGcTime)), 100.0 * percentageGc, FormattingUtils.sizeToDisplaySize(Runtime.getRuntime().maxMemory()), FormattingUtils.sizeToDisplaySize(Runtime.getRuntime().totalMemory()), FormattingUtils.sizeToDisplaySize(Runtime.getRuntime().freeMemory())));
        try {
            long physicalMemorySize = -1L;
            long freePhysicalMemory = -1L;
            long freeSwapSize = -1L;
            long commitedVirtualMemorySize = -1L;
            double processCpuLoad = -1.0;
            double systemCpuLoad = -1.0;
            long processCpuTime = -1L;
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            int processorsCount = operatingSystemMXBean.getAvailableProcessors();
            for (Method method : operatingSystemMXBean.getClass().getDeclaredMethods()) {
                try {
                    method.setAccessible(true);
                    if (!method.getName().startsWith("get") || !Modifier.isPublic(method.getModifiers())) continue;
                    Object value = 0;
                    try {
                        value = method.invoke((Object)operatingSystemMXBean, new Object[0]);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error", e);
                    }
                    if (method.getName().equals("getTotalPhysicalMemorySize")) {
                        physicalMemorySize = (Long)value;
                    }
                    if (method.getName().equals("getFreePhysicalMemorySize")) {
                        freePhysicalMemory = (Long)value;
                    }
                    if (method.getName().equals("getFreeSwapSpaceSize")) {
                        freeSwapSize = (Long)value;
                    }
                    if (method.getName().equals("getCommittedVirtualMemorySize")) {
                        commitedVirtualMemorySize = (Long)value;
                    }
                    if (method.getName().equals("getProcessCpuLoad")) {
                        processCpuLoad = (Double)value;
                    }
                    if (method.getName().equals("getProcessCpuTime")) {
                        processCpuTime = (Long)value / 1000L / 1000L / 1000L;
                    }
                    if (!method.getName().equals("getSystemCpuLoad")) continue;
                    systemCpuLoad = (Double)value;
                }
                catch (Exception e) {
                    LOGGER.debug("Cannot get operatingSystemMXBean value");
                }
            }
            if (physicalMemorySize > 0L) {
                LOGGER.info(String.format(Locale.ROOT, "OS Physical memory: %s, Free Physical Memory: %s, Free Swap Size: %s, Committed Virtual Memory: %s", FormattingUtils.sizeToDisplaySize(physicalMemorySize), FormattingUtils.sizeToDisplaySize(freePhysicalMemory), FormattingUtils.sizeToDisplaySize(freeSwapSize), FormattingUtils.sizeToDisplaySize(commitedVirtualMemorySize)));
                if (freePhysicalMemory < 100000L && !this.lowSystemMemory) {
                    LOGGER.warn("Low system memory");
                    this.lowSystemMemory = true;
                }
            }
            if (processCpuLoad > 0.0) {
                LOGGER.info(String.format(Locale.ROOT, "OS System CPU Load: %s, Processors: %d, Process CPU Load: %s, Process CPU Time: %d", FormattingUtils.getLocalizedPercentage(systemCpuLoad), processorsCount, FormattingUtils.getLocalizedPercentage(processCpuLoad), processCpuTime));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.upTime = currentUpTime;
        this.gcTime = currentGcTime;
    }

    public void call() {
        this.checkMemoryUsage();
    }
}

