/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import java.nio.file.Paths;

public class SystemUtils {
    public static boolean getOsWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static String getProgramFilesDir() {
        return System.getenv("ProgramFiles");
    }

    public static String getProgramFilesDir(String ... paths) {
        return Paths.get(SystemUtils.getProgramFilesDir(), paths).toAbsolutePath().toString();
    }

    public static Integer getIntegerProperty(String key, Integer defaultValue) {
        return (Integer)SystemUtils.getSystemProperty(key, defaultValue, Integer.class);
    }

    public static String getSystemProperty(String key, String defaultValue) {
        return (String)SystemUtils.getSystemProperty(key, defaultValue, String.class);
    }

    public static Object getSystemProperty(String key, Object defaultValue, Class<?> clazz) {
        String property = System.getProperty(key);
        if (property != null) {
            if (Integer.class.equals(clazz)) {
                return Integer.parseInt(property);
            }
            if (String.class.equals(clazz)) {
                return property;
            }
        }
        return defaultValue;
    }
}

