/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class UnicodeUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UnicodeUtils.class);
    private Map<String, String> nameToCharacter = new HashMap<String, String>();
    private Map<String, String> nameLowercaseNoSpaceToCharacter = new HashMap<String, String>();
    private static UnicodeUtils instance;

    private UnicodeUtils() {
        LOGGER.info("Loading Unicode definition");
        int linesCount = 0;
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("unicode/UnicodeData.txt");
             BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = reader.readLine();
            while (line != null) {
                try {
                    String[] splits = line.split(";");
                    String code = splits[0];
                    String name = splits[1];
                    String c = "" + (char)Integer.decode("0x" + code).intValue();
                    this.nameToCharacter.put(name, c);
                    this.nameLowercaseNoSpaceToCharacter.put(name.toLowerCase().replace(" ", ""), c);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse line |" + line + "|", e);
                }
                line = reader.readLine();
                ++linesCount;
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot load unicode data;");
        }
        LOGGER.info("Loaded " + linesCount + " lines from Unicode definition file");
    }

    public static UnicodeUtils getInstance() {
        if (instance == null) {
            instance = new UnicodeUtils();
        }
        return instance;
    }

    public String getCharFromName(String name) {
        if (name == null) {
            return null;
        }
        String c = this.nameToCharacter.get(name);
        if (c != null) {
            return c;
        }
        return this.nameLowercaseNoSpaceToCharacter.get(name.replace(":", "").replace("_", "").replace(" ", "").toLowerCase());
    }
}

