/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.FileLibraryUtils;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;

public class UserDataDirUtils {
    public static String getNuixProfileName(Path relativePath) {
        int nameCount = relativePath.getNameCount();
        Path profileName = nameCount > 1 ? relativePath.subpath(1, nameCount) : relativePath.getFileName();
        String name = FilenameUtils.removeExtension((String)profileName.toString());
        return FilenameUtils.separatorsToUnix((String)name);
    }

    public static LibraryNuixFileType parseNuixProfileType(Path relativePath, byte[] fileBytes) throws IOException {
        LibraryNuixFileType expectedType;
        String fileName = relativePath.getFileName().toString().toLowerCase();
        if ((fileName.endsWith(".profile") || fileName.endsWith(".xml") || fileName.endsWith(".npf") || fileName.endsWith(".yml")) && (expectedType = UserDataDirUtils.getExpectedProfileType(relativePath)) != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(fileBytes), StandardCharsets.UTF_8));){
                String line;
                ArrayList<String> fileLines = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    fileLines.add(line);
                }
                LibraryNuixFileType libraryNuixFileType = FileLibraryUtils.getInstance().parseNuixFileTypeFromFileLines(fileLines.toArray(new String[0]), expectedType);
                return libraryNuixFileType;
            }
        }
        return null;
    }

    public static LibraryNuixFileType parseNuixProfileType(Path userDataDirPath, Path absPath) throws IOException {
        Path relativePath;
        LibraryNuixFileType expectedType;
        String fileName = absPath.getFileName().toString().toLowerCase();
        if ((fileName.endsWith(".profile") || fileName.endsWith(".xml") || fileName.endsWith(".npf")) && (expectedType = UserDataDirUtils.getExpectedProfileType(relativePath = userDataDirPath.relativize(absPath))) != null) {
            String[] fileLines = Files.readAllLines(absPath).toArray(new String[0]);
            return FileLibraryUtils.getInstance().parseNuixFileTypeFromFileLines(fileLines, expectedType);
        }
        return null;
    }

    private static LibraryNuixFileType getExpectedProfileType(Path relativePath) {
        String rootFolder;
        switch (rootFolder = relativePath.getName(0).toString().toLowerCase()) {
            case "profiles": {
                return LibraryNuixFileType.CONFIGURATION_PROFILE;
            }
            case "processing profiles": {
                return LibraryNuixFileType.PROCESSING_PROFILE;
            }
            case "production profiles": {
                return LibraryNuixFileType.PRODUCTION_PROFILE;
            }
            case "metadata profiles": {
                return LibraryNuixFileType.METADATA_PROFILE;
            }
            case "metadata import profiles": {
                return LibraryNuixFileType.METADATA_IMPORT_PROFILE;
            }
            case "playbooks": {
                return LibraryNuixFileType.PLAYBOOK;
            }
            case "imaging profiles": {
                return LibraryNuixFileType.IMAGING_PROFILE;
            }
            case "ocr profiles": {
                return LibraryNuixFileType.OCR_PROFILE;
            }
        }
        return null;
    }
}

