/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public class XmlTransformerFactory {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(XmlTransformerFactory.class);
    private static final String TRANSFORMER_FACTORY_IMPL_CLASS = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";

    public static TransformerFactory newInstance() {
        TransformerFactory factory;
        try {
            LOGGER.info("Initializing default TransformerFactory instance");
            factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error setting ACCESS_EXTERNAL attributes on default TransformerFactory instance", e);
            LOGGER.info("Initializing com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl implementation instead");
            factory = TransformerFactory.newInstance(TRANSFORMER_FACTORY_IMPL_CLASS, ClassLoader.getSystemClassLoader());
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            LOGGER.error("Error setting FEATURE_SECURE_PROCESSING on TransformerFactory", e);
        }
        return factory;
    }
}

