/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.licence;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.licence.Licence;
import com.nuix.automate.utils.licence.LicenceFactory;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.ThirdPartyProduct;
import com.nuix.automate.utils.licence.exceptions.LicenceNotValidException;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.licence.exceptions.NoLicenceFoundException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.ThirdPartyLicense;
import java.util.HashSet;
import java.util.Set;

public class LicenceUtils {
    protected static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    private LicenceInfo licenceInfo;
    private Licence legacyLicence;

    public LicenceUtils() {
        this.licenceInfo = null;
    }

    public LicenceUtils(LicenceInfo licenceInfo) {
        this.licenceInfo = licenceInfo;
    }

    public void setLicenceInfo(LicenceInfo licenceInfo) {
        this.licenceInfo = licenceInfo;
        this.legacyLicence = null;
    }

    public void setLegacyLicence(Licence legacyLicence) {
        this.legacyLicence = legacyLicence;
        this.licenceInfo = LicenceFactory.getInstance().convertToLicenseInfo(legacyLicence);
    }

    public boolean getModuleLicensed(ModuleType moduleType) {
        try {
            this.assertModuleLicensed(moduleType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void assertModuleLicensed(ModuleType moduleType) {
        this.assertModuleLicensed(moduleType, true);
    }

    public boolean getAnyThirdPartyLicense(ThirdPartyProduct thirdPartyProduct) {
        if (this.licenceInfo.getThirdPartyLicenses() != null) {
            for (ThirdPartyLicense thirdPartyLicense : this.licenceInfo.getThirdPartyLicenses()) {
                if (!thirdPartyProduct.equals((Object)thirdPartyLicense.getThirdPartyProductType())) continue;
                return true;
            }
        }
        return false;
    }

    public void assertModuleLicensed(ModuleType moduleType, boolean validateLicense) {
        String errorMessage;
        if (this.licenceInfo == null) {
            throw new NoLicenceFoundException();
        }
        if (validateLicense && (errorMessage = LicenceFactory.getInstance().getLicenceErrorMessage(this.licenceInfo)) != null) {
            throw new LicenceNotValidException(errorMessage);
        }
        this.licenceInfo.assertModuleLicensed(moduleType);
    }

    public Set<ModuleType> getAllModulesLicensed() {
        if (this.licenceInfo != null) {
            return this.licenceInfo.getAllModules();
        }
        return new HashSet<ModuleType>();
    }

    public Set<String> getThirdPartyLicenseAllowedIds(ThirdPartyProduct thirdPartyProduct) {
        HashSet<String> ids = new HashSet<String>();
        if (this.licenceInfo != null && this.licenceInfo.getThirdPartyLicenses() != null) {
            for (ThirdPartyLicense thirdPartyLicense : this.licenceInfo.getThirdPartyLicenses()) {
                if (thirdPartyLicense.getThirdPartyProductType() == null || !thirdPartyLicense.getThirdPartyProductType().equals((Object)thirdPartyProduct)) continue;
                ids.add(thirdPartyLicense.getId());
            }
        }
        return ids;
    }

    public boolean getModule(ModuleType moduleType) {
        return this.getModule(moduleType, true);
    }

    public boolean getModule(ModuleType moduleType, boolean validateLicense) {
        try {
            this.assertModuleLicensed(moduleType, validateLicense);
            return true;
        }
        catch (LicenceValidationException e) {
            return false;
        }
    }

    public LicenceInfo getLicenceInfo() {
        return this.licenceInfo;
    }

    public LicenceInfo assertLicenceInfo() {
        if (this.licenceInfo == null) {
            throw new NoLicenceFoundException();
        }
        return this.licenceInfo;
    }
}

