/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.licence.services;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.TimerTask;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.licence.services.Type;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.license.ServerRestClient;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.Client;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.ExecutionProfile;
import com.nuix.automate.utils.utilization.Job;
import com.nuix.automate.utils.utilization.Key;
import com.nuix.automate.utils.utilization.Library;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.Operation;
import com.nuix.automate.utils.utilization.RelativityWorkspace;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.Server;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.Workflow;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class LicenceSession
implements TimerTask.Callback,
Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LicenceSession.class);
    private transient InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    private static final int PING_INTERVAL = 60000;
    private String id;
    private LicenceInfo licenceInfo;
    private Product product;
    private String productVersion;
    private Timer timer;
    private TimerTask timerTask;
    private ServerRestClient serverRestClient;
    private boolean closed = false;
    private boolean started = false;
    private Key key;
    private DiagnosticLevel diagnosticLevel;
    private String relativityServiceId;
    private Map<String, ActivityDetails> userActivities;

    public LicenceSession(Credentials credentials, LicenceInfo licenceInfo, Product product, String productVersion, Key key, DiagnosticLevel diagnosticLevel) {
        this.licenceInfo = licenceInfo;
        this.id = UidUtils.getRandom();
        this.product = product;
        this.productVersion = productVersion;
        this.key = key;
        this.diagnosticLevel = diagnosticLevel;
        this.userActivities = new HashMap<String, ActivityDetails>();
        if (credentials != null && credentials.getLicenseId() != null) {
            if (credentials.getLicenseId().contains(":")) {
                String[] splits = credentials.getLicenseId().split(":");
                this.serverRestClient = new ServerRestClient("https://" + splits[0], splits[1], credentials.getLicenseKey(), key.getSecret(), diagnosticLevel);
            } else {
                this.serverRestClient = new ServerRestClient(credentials.getLicenseId(), credentials.getLicenseKey(), key.getSecret(), diagnosticLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleActivityEvent(String userId, String matterId, String activityKey, ActivityType activityType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Activity:" + (Object)((Object)activityType) + "\tuser:" + userId + "\tjobId:" + matterId + "\ttransferId:" + activityKey);
        }
        long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        ActivityDetails dummyActivity = new ActivityDetails();
        dummyActivity.setUserId(userId);
        dummyActivity.setStartEpoch(currentMillis);
        dummyActivity.setActivityType(activityType);
        dummyActivity.setMatterId(matterId);
        dummyActivity.setActivityKey(activityKey);
        ActivityDetails finishedActivity = null;
        Map<String, ActivityDetails> map = this.userActivities;
        synchronized (map) {
            ActivityDetails activity = this.userActivities.get(userId);
            if (activity != null) {
                if (activity.isExpired(currentMillis)) {
                    finishedActivity = activity;
                    this.userActivities.remove(userId);
                    activity = null;
                } else {
                    activity.setLastEpoch(currentMillis);
                    if (!activity.getActivityType().equals((Object)activityType) || activity.getActivityKey() != null && !activity.getActivityKey().equals(dummyActivity.getActivityKey()) || dummyActivity.getActivityKey() != null && !dummyActivity.getActivityKey().equals(activity.getActivityKey()) || activity.getMatterId() != null && !activity.getMatterId().equals(dummyActivity.getMatterId()) || dummyActivity.getMatterId() != null && !dummyActivity.getMatterId().equals(activity.getMatterId())) {
                        finishedActivity = activity;
                        this.userActivities.remove(userId);
                        activity = null;
                    }
                }
            }
            if (activity == null) {
                activity = dummyActivity;
                activity.setLastEpoch(currentMillis);
                this.userActivities.put(activity.getUserId(), activity);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("START " + activity);
                }
            }
        }
        if (finishedActivity != null && finishedActivity.getLastEpoch() > finishedActivity.getStartEpoch()) {
            UtilizationRecords utilizationRecords = new UtilizationRecords();
            utilizationRecords.setId(UidUtils.getRandom());
            HashSet<ActivityDetails> activities = new HashSet<ActivityDetails>();
            activities.add(finishedActivity);
            utilizationRecords.setActivityDetails(activities);
            this.tryTrackUtilizationRecordsAsync(utilizationRecords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishAllActivities(User user) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("FinishAllActivities \tuser:" + user);
        }
        UtilizationRecords utilizationRecords = null;
        Map<String, ActivityDetails> map = this.userActivities;
        synchronized (map) {
            if (this.userActivities.size() > 0) {
                utilizationRecords = new UtilizationRecords();
                utilizationRecords.setId(UidUtils.getRandom());
                HashSet<ActivityDetails> activities = new HashSet<ActivityDetails>();
                activities.addAll(this.userActivities.values());
                this.userActivities.clear();
                utilizationRecords.setActivityDetails(activities);
                if (user != null) {
                    HashSet<User> users = new HashSet<User>();
                    users.add(user);
                    utilizationRecords.setUsers(users);
                }
            }
        }
        if (utilizationRecords != null) {
            this.tryTrackUtilizationRecordsAsync(utilizationRecords);
        }
    }

    public void setKey(Key key) {
        this.key = key;
        if (this.serverRestClient != null) {
            this.serverRestClient.setEncryptionKey(key.getSecret());
        }
    }

    public void setDiagnosticLevel(DiagnosticLevel diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel;
        if (this.serverRestClient != null) {
            this.serverRestClient.setDiagnosticLevel(diagnosticLevel);
        }
    }

    protected ServerRestClient getServerRestClient() {
        return this.serverRestClient;
    }

    public void tryTrackOperationUtilizationAsync(Operation operation) {
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<Operation> operations = new HashSet<Operation>();
        operations.add(operation);
        utilizationRecords.setOperations(operations);
        this.tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public void tryTrackJobStartAsync(Client client, Matter matter, Library library, Workflow workflow, Server server, Engine engine, ResourcePool resourcePool, ExecutionProfile executionProfile, Job job, User user) {
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<Client> clients = new HashSet<Client>();
        clients.add(client);
        utilizationRecords.setClients(clients);
        HashSet<Matter> matters = new HashSet<Matter>();
        matters.add(matter);
        utilizationRecords.setMatters(matters);
        HashSet<Library> libraries = new HashSet<Library>();
        libraries.add(library);
        utilizationRecords.setLibraries(libraries);
        HashSet<Workflow> workflows = new HashSet<Workflow>();
        workflows.add(workflow);
        utilizationRecords.setWorkflows(workflows);
        HashSet<User> users = new HashSet<User>();
        users.add(user);
        utilizationRecords.setUsers(users);
        HashSet<Server> servers = new HashSet<Server>();
        servers.add(server);
        utilizationRecords.setServers(servers);
        HashSet<Engine> engines = new HashSet<Engine>();
        engines.add(engine);
        utilizationRecords.setEngines(engines);
        HashSet<ResourcePool> resourcePools = new HashSet<ResourcePool>();
        resourcePools.add(resourcePool);
        utilizationRecords.setResourcePools(resourcePools);
        HashSet<ExecutionProfile> executionProfiles = new HashSet<ExecutionProfile>();
        executionProfiles.add(executionProfile);
        utilizationRecords.setExecutionProfiles(executionProfiles);
        this.tryTrackUtilizationRecordsAsync(utilizationRecords);
        HashSet<Job> jobs = new HashSet<Job>();
        jobs.add(job);
        utilizationRecords.setJobs(jobs);
        utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        utilizationRecords.setId(job.getJobId());
        this.tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public void tryTrackNuixCaseAsync(NuixCase nuixCase) {
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<NuixCase> nuixCases = new HashSet<NuixCase>();
        nuixCases.add(nuixCase);
        utilizationRecords.setNuixCases(nuixCases);
        this.tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public void tryTrackRelativityWorkspaceAsync(RelativityWorkspace relativityWorkspace) {
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<RelativityWorkspace> relativityWorkspaces = new HashSet<RelativityWorkspace>();
        relativityWorkspaces.add(relativityWorkspace);
        utilizationRecords.setRelativityWorkspaces(relativityWorkspaces);
        this.tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public void tryTrackJobUpdateAsync(Job job) {
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<Job> jobs = new HashSet<Job>();
        jobs.add(job);
        utilizationRecords.setJobs(jobs);
        this.tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public void tryTrackUtilizationRecordsAsync(UtilizationRecords utilizationRecords) {
        new Thread(() -> this.tryTrackUtilizationRecords(utilizationRecords, true)).start();
    }

    public synchronized boolean tryTrackUtilizationRecords(UtilizationRecords utilizationRecords, boolean cacheFailedSubmissions) {
        boolean success;
        block2: {
            success = false;
            try {
                this.serverRestClient.trackUtilizationRecords(utilizationRecords);
                success = true;
            }
            catch (IOException | NullPointerException e) {
                if (!cacheFailedSubmissions) break block2;
                this.handleFailedUtilizationTracking(utilizationRecords, e);
            }
        }
        return success;
    }

    public synchronized void startSchedule() {
        if (!this.started) {
            this.started = true;
            if (this.key != null) {
                LOGGER.info("Starting session with key " + this.key.getId());
            }
            this.tryTrackEventAsync(this.getSessionStartEvent());
            this.timerTask = new TimerTask(this);
            this.timer = new Timer("Automate Session Timer");
            this.timer.scheduleAtFixedRate((java.util.TimerTask)this.timerTask, 0L, 60000L);
        } else {
            LOGGER.warn("Cannot start already started session " + this.id);
        }
    }

    public LicenceInfo getLicenceInfo() {
        return this.licenceInfo;
    }

    public void tryTrackEventAsync(EventInfo eventInfo) {
        new Thread(() -> this.tryTrackEvent(eventInfo, true)).start();
    }

    public void tryTrackConsumptionAsync(Consumption consumption) {
        new Thread(() -> this.tryTrackConsumption(consumption, true, false)).start();
    }

    public synchronized boolean tryTrackEvent(EventInfo eventInfo) {
        return this.tryTrackEvent(eventInfo, true);
    }

    public synchronized boolean tryTrackEvent(EventInfo eventInfo, boolean cachedFailedSubmissions) {
        boolean success;
        block2: {
            success = false;
            try {
                this.trackEvent(eventInfo);
                success = true;
            }
            catch (IOException | NullPointerException e) {
                if (!cachedFailedSubmissions) break block2;
                this.handleFailedEventTracking(eventInfo, e);
            }
        }
        return success;
    }

    public synchronized boolean tryTrackConsumption(Consumption consumption, boolean cachedFailedSubmissions, boolean isRetry) {
        boolean success;
        block2: {
            success = false;
            try {
                consumption.setRetry(isRetry);
                this.trackConsumption(consumption);
                success = true;
            }
            catch (IOException | NullPointerException e) {
                if (!cachedFailedSubmissions || isRetry) break block2;
                this.handleFailedConsumptionTracking(consumption, e);
            }
        }
        return success;
    }

    protected void onBeforePing() {
    }

    protected synchronized void trackEvent(EventInfo eventInfo) throws IOException {
        if (this.serverRestClient != null) {
            this.serverRestClient.trackEvent(eventInfo);
        }
    }

    protected synchronized void trackConsumption(Consumption consumption) throws IOException {
        if (this.serverRestClient != null) {
            this.serverRestClient.trackConsumption(consumption);
        }
    }

    protected abstract void handleFailedEventTracking(EventInfo var1, Exception var2);

    protected abstract void handleFailedConsumptionTracking(Consumption var1, Exception var2);

    protected abstract void handleFailedUtilizationTracking(UtilizationRecords var1, Exception var2);

    protected abstract boolean retryTrackingPreviouslyFailedEvents();

    public EventInfo getSessionStartEvent() {
        EventInfo eventInfo = new EventInfo();
        eventInfo.setDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        eventInfo.setSessionId(this.id);
        eventInfo.setType(Type.SESSION_START);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("productName", this.product.name());
        properties.put("productVersion", this.productVersion);
        properties.put("diagnosticLevel", this.diagnosticLevel.name());
        properties.put("rampivaLicenseId", this.licenceInfo.getId());
        if (this.key != null) {
            properties.put("keyId", this.key.getId());
        }
        eventInfo.setProperties(properties);
        return eventInfo;
    }

    public void trackConsumptionAsync(Consumption consumption) {
        this.tryTrackConsumptionAsync(consumption);
    }

    public void trackMetricsAsync(Activity activity, long volume) {
        this.tryTrackEventAsync(this.getSessionMetrics(activity, volume));
    }

    private EventInfo getSessionMetrics(Activity activity, long volume) {
        EventInfo eventInfo = new EventInfo();
        eventInfo.setDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        eventInfo.setSessionId(this.id);
        eventInfo.setSubSessionId(UidUtils.getRandom());
        eventInfo.setType(Type.SESSION_METRICS);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("activity", (Object)activity);
        properties.put("volume", volume);
        eventInfo.setProperties(properties);
        return eventInfo;
    }

    public EventInfo getSessionEndEvent() {
        EventInfo eventInfo = new EventInfo();
        eventInfo.setDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        eventInfo.setType(Type.SESSION_END);
        eventInfo.setSessionId(this.id);
        if (this.relativityServiceId != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("relativityServiceId", this.relativityServiceId);
            eventInfo.setProperties(properties);
        }
        return eventInfo;
    }

    public EventInfo getPingEvent() {
        EventInfo eventInfo = new EventInfo();
        eventInfo.setDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        eventInfo.setType(Type.SESSION_PING);
        eventInfo.setSessionId(this.id);
        if (this.relativityServiceId != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("relativityServiceId", this.relativityServiceId);
            eventInfo.setProperties(properties);
        }
        return eventInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UtilizationRecords removeExpiredUserActivities() {
        HashSet<ActivityDetails> expiredActivities = new HashSet<ActivityDetails>();
        long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        Map<String, ActivityDetails> map = this.userActivities;
        synchronized (map) {
            Iterator<Map.Entry<String, ActivityDetails>> it = this.userActivities.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ActivityDetails> entry = it.next();
                ActivityDetails activity = entry.getValue();
                if (!activity.isExpired(currentMillis)) continue;
                expiredActivities.add(activity);
                it.remove();
            }
        }
        if (expiredActivities.size() > 0) {
            UtilizationRecords utilizationRecords = new UtilizationRecords();
            utilizationRecords.setId(UidUtils.getRandom());
            utilizationRecords.setActivityDetails(expiredActivities);
            return utilizationRecords;
        }
        return null;
    }

    @Override
    public void call() {
        this.onBeforePing();
        if (!this.closed) {
            boolean serverOnline;
            UtilizationRecords utilizationRecords = this.removeExpiredUserActivities();
            if (utilizationRecords != null) {
                this.tryTrackUtilizationRecordsAsync(utilizationRecords);
            }
            if ((serverOnline = this.tryTrackEvent(this.getPingEvent())) && this.retryTrackingPreviouslyFailedEvents()) {
                this.tryTrackEventAsync(this.getPingEvent());
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.started) {
            if (!this.closed) {
                this.closed = true;
                this.tryTrackEventAsync(this.getSessionEndEvent());
                try {
                    this.timer.cancel();
                }
                catch (Throwable t) {
                    LOGGER.warn("Cannot stop license session timer", t);
                }
                this.serverRestClient = null;
            } else {
                LOGGER.warn("Cannot close already closed session " + this.id);
            }
        } else {
            LOGGER.warn("Cannot close not started session " + this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    public Key getKey() {
        return this.key;
    }

    public Product getProduct() {
        return this.product;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getRelativityServiceId() {
        return this.relativityServiceId;
    }

    public void setRelativityServiceId(String relativityServiceId) {
        this.relativityServiceId = relativityServiceId;
    }
}

