/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.licence.services;

import com.google.gson.Gson;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.IdEncryptor;
import jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class SerializerUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SerializerUtils.class);

    public <ObjectType> ObjectType deserialize(Path path, GenericType<ObjectType> objectType) throws IOException {
        byte[] serializedBytes = Files.readAllBytes(path);
        return this.deserialize(new String(serializedBytes, StandardCharsets.UTF_8), objectType);
    }

    public <ObjectType> ObjectType deserializeEncrypted(String key, Path path, GenericType<ObjectType> objectType) throws IOException {
        byte[] serializedBytes = Files.readAllBytes(path);
        IdEncryptor idEncryptor = new IdEncryptor(key);
        String decrypted = idEncryptor.decrypt(new String(serializedBytes, StandardCharsets.UTF_8));
        return this.deserialize(decrypted, objectType);
    }

    public <ObjectType> ObjectType deserialize(String s, GenericType<ObjectType> objectType) {
        Gson gson = new Gson();
        Object object = gson.fromJson(s, objectType.getType());
        return (ObjectType)object;
    }

    public <ObjectType> String serialize(ObjectType object) {
        Gson gson = new Gson();
        return gson.toJson(object);
    }

    public void serialize(Object object, Path path) throws IOException {
        byte[] serializedBytes = this.serialize(object).getBytes(StandardCharsets.UTF_8);
        Files.write(path, serializedBytes, new OpenOption[0]);
    }

    public void serializeEncrypted(String key, Object object, Path path) throws IOException {
        IdEncryptor idEncryptor = new IdEncryptor(key);
        String encrypted = idEncryptor.encrypt(this.serialize(object));
        Files.write(path, encrypted.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

