/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.logging;

import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.models.internal.logging.LogEventModel;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.joda.time.DateTime;

public class LogChannel {
    private String id;
    private String jobId;
    private File channel;
    private SchedulerComponent component;
    private long lastModified;
    private long logLine = 1L;
    private long position = 0L;
    private boolean enabled;

    public LogChannel(String id, String jobId, File channel, SchedulerComponent component, long lastModified) {
        this.id = id;
        this.jobId = jobId;
        this.channel = channel;
        this.component = component;
        this.lastModified = lastModified;
        this.enabled = true;
    }

    public synchronized LogEventModel getLogEventTemplate() {
        if (this.enabled) {
            return new LogEventModel(this.id, this.jobId, this.component.name(), Instant.now().toEpochMilli(), this.logLine++);
        }
        return null;
    }

    public synchronized LogEventModel getPreTimeStampedLogEvent(String message) {
        if (this.enabled) {
            LogEventModel logEventModel = new LogEventModel(this.id, this.jobId, this.component.name(), Instant.now().toEpochMilli(), this.logLine++);
            logEventModel.setMessage((DateTime.now() + "\n" + message + "\n").getBytes(StandardCharsets.UTF_8));
            return logEventModel;
        }
        return null;
    }

    public synchronized LogEventModel getSeparator() {
        if (this.enabled) {
            LogEventModel logEventModel = new LogEventModel(this.id, this.jobId, this.component.name(), Instant.now().toEpochMilli(), this.logLine++);
            logEventModel.setMessage("---\n\n".getBytes(StandardCharsets.UTF_8));
            return logEventModel;
        }
        return null;
    }

    public synchronized LogEventModel getLogEvent(String message) {
        if (this.enabled) {
            LogEventModel logEventModel = new LogEventModel(this.id, this.jobId, this.component.name(), Instant.now().toEpochMilli(), this.logLine++);
            logEventModel.setMessage((message + "\n").getBytes(StandardCharsets.UTF_8));
            return logEventModel;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public File getChannel() {
        return this.channel;
    }

    public void setChannel(File channel) {
        this.channel = channel;
    }

    public SchedulerComponent getComponent() {
        return this.component;
    }

    public void setComponent(SchedulerComponent component) {
        this.component = component;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public String toString() {
        return "LogChannel{id='" + this.id + '\'' + ", jobId='" + this.jobId + '\'' + ", channel=" + this.channel + ", component=" + (Object)((Object)this.component) + ", logLine=" + this.logLine + '}';
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

