/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.computer;

import com.nuix.automate.utils.ecc.responses.jobs.JobStatus;
import com.nuix.automate.utils.models.internal.collection.ComputerPlatform;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComputerDetails
implements Serializable,
Cloneable {
    @Schema(description="Computer ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Computer Name", example="COMPUTER1")
    private String name;
    @Schema(description="Collection ID", example="11111111-1111-1111-1111-111111111111")
    private String collectionId;
    @Schema(description="Computer Platform")
    private ComputerPlatform platform;
    @Schema(description="Task Name", example="Installing agent")
    private String taskName;
    @Schema(description="Dataset ID", example="11111111-1111-1111-1111-111111111111")
    private String datasetId;
    @Schema(description="Transfer ID", example="11111111-1111-1111-1111-111111111111")
    private String transferId;
    @Schema(description="User ID", example="11111111-1111-1111-1111-111111111111")
    private String userId;
    @Schema(description="Tasks Upload In Progress")
    private Map<Integer, Boolean> taskUploadStatus;
    @Schema(description="Is Collection Ready?", example="true")
    private boolean collectionReady;
    @Schema(description="Remote Log Files")
    private Set<String> remoteLogs;
    @Schema(description="Computer Logs folder")
    private String logFolder;
    @Schema(description="Status")
    private JobStatus status;
    @Schema(description="Execution Percentage Completion", example="17.25")
    private double percentageComplete;
    @Schema(description="Computer Has Warnings?", example="false")
    private Boolean hasWarning;
    @Schema(description="Warning Messages")
    private List<String> warnings;
    @Schema(description="Error Messages")
    private List<String> errors;
    @Schema(description="Trimmed Error Messages")
    private String trimmedError;
    @Schema(description="Computer Started Date (Epoch)", example="1641034800000")
    private Long startDate;
    @Schema(description="Computer Ended Date (Epoch)", example="1641034800000")
    private Long endDate;

    protected Object clone() {
        try {
            ComputerDetails clonedObject = (ComputerDetails)super.clone();
            clonedObject.taskUploadStatus = new HashMap<Integer, Boolean>();
            if (this.taskUploadStatus != null) {
                clonedObject.taskUploadStatus = this.taskUploadStatus;
            }
            clonedObject.remoteLogs = new HashSet<String>();
            if (this.remoteLogs != null) {
                clonedObject.remoteLogs.addAll(this.remoteLogs);
            }
            clonedObject.warnings = new ArrayList<String>();
            if (this.warnings != null) {
                clonedObject.warnings.addAll(this.warnings);
            }
            clonedObject.errors = new ArrayList<String>();
            if (this.errors != null) {
                clonedObject.errors.addAll(this.errors);
            }
            return clonedObject;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public ComputerPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(ComputerPlatform platform) {
        this.platform = platform;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public void setStatus(JobStatus status) {
        this.status = status;
    }

    public double getPercentageComplete() {
        return this.percentageComplete;
    }

    public void setPercentageComplete(double percentageComplete) {
        this.percentageComplete = percentageComplete;
    }

    public boolean getCollectionReady() {
        return this.collectionReady;
    }

    public boolean isCollectionReady() {
        return this.collectionReady;
    }

    public void setCollectionReady(boolean collectionReady) {
        this.collectionReady = collectionReady;
    }

    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public Set<String> getRemoteLogs() {
        if (this.remoteLogs == null) {
            this.remoteLogs = new HashSet<String>();
        }
        return this.remoteLogs;
    }

    public void setRemoteLogs(Set<String> remoteLogs) {
        this.remoteLogs = remoteLogs;
    }

    public String getLogFolder() {
        return this.logFolder;
    }

    public void setLogFolder(String logFolder) {
        this.logFolder = logFolder;
    }

    public Boolean getHasWarning() {
        if (this.hasWarning == null) {
            this.hasWarning = false;
        }
        return this.hasWarning;
    }

    public void setHasWarning(Boolean hasWarning) {
        this.hasWarning = hasWarning;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public String getTrimmedError() {
        String error;
        this.trimmedError = this.errors != null && this.errors.size() > 0 ? ((error = this.errors.get(this.errors.size() - 1)).length() > 140 ? error.substring(0, 137) + "..." : error) : null;
        return this.trimmedError;
    }

    public Map<Integer, Boolean> getTaskUploadStatus() {
        return this.taskUploadStatus;
    }

    public void setTaskUploadStatus(Map<Integer, Boolean> taskUploadStatus) {
        this.taskUploadStatus = taskUploadStatus;
    }

    public Boolean getTaskStatus(Integer taskNum) {
        if (this.taskUploadStatus != null && this.taskUploadStatus.get(taskNum) != null) {
            return this.taskUploadStatus.get(taskNum);
        }
        return false;
    }

    public void setTaskStatus(Integer taskNum) {
        if (this.taskUploadStatus == null) {
            this.taskUploadStatus = new HashMap<Integer, Boolean>();
        }
        this.taskUploadStatus.put(taskNum, Boolean.TRUE);
    }

    public void appendError(String error) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(error);
    }

    public void clearErrors() {
        this.errors = new ArrayList<String>();
    }

    public void appendWarning(String warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warning);
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public void clearWarnings() {
        this.warnings = new ArrayList<String>();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

