/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.dataset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.FilePathUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class FileInfo
implements Cloneable {
    @Schema(description="File Info ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Dataset ID", example="11111111-1111-1111-1111-111111111111")
    private String datasetId;
    @Schema(description="Root File ID", example="11111111-1111-1111-1111-111111111111")
    private String rootFileId;
    @Schema(description="File Name", example="file.txt")
    private String name;
    @Schema(description="Relative Path")
    private String relativePath;
    @Schema(description="Directory")
    private Boolean directory;
    @Schema(description="File Count", example="3000")
    private long fileCount;
    @Schema(description="File Size", example="1000000000")
    private long size;
    @Schema(description="Total File Size Uploaded", example="1000000000")
    private Long totalSizeUploaded;
    @Schema(description="Added By")
    private String addedBy;
    @Schema(description="File Added Date (Epoch)", example="1641034800000")
    private Long addedDate;
    @Schema(description="Upload Duration (seconds)", example="53")
    private long uploadDuration;
    @Schema(description="Interrupted Count", example="0")
    private int interruptedCount;
    @Schema(description="Client IP Address", example="127.0.0.1")
    private String clientIpAddresses;
    @Schema(description="Server IP Address", example="127.0.0.1")
    private String serverIpAddress;
    @Schema(description="Server Name", example="localhost")
    private String serverName;
    @Schema(description="Server Role", example="Scheduler")
    private String serverRole;
    @Schema(description="File Hashes")
    private Map<String, String> hashes;
    @Schema(description="Metadata")
    private List<String> metadata;

    public FileInfo() {
    }

    public FileInfo(String name) {
        this.name = name;
    }

    public FileInfo clone() {
        try {
            return (FileInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static boolean isRoot(String fileName, String relativePath) {
        return fileName.equals(relativePath);
    }

    @JsonIgnore
    public boolean isRoot() {
        return FileInfo.isRoot(this.getName(), this.getRelativePath());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static String computeId(String id, String relativePath) {
        return id + ":" + relativePath;
    }

    public void computeId() {
        this.id = FileInfo.computeId(this.datasetId, this.getRelativePath());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(String addedBy) {
        this.addedBy = addedBy;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Long getTotalSizeUploaded() {
        return this.totalSizeUploaded;
    }

    public void setTotalSizeUploaded(Long totalSizeUploaded) {
        this.totalSizeUploaded = totalSizeUploaded;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getRootFileId() {
        return this.rootFileId;
    }

    public void setRootFileId(String rootFileId) {
        this.rootFileId = rootFileId;
    }

    public Boolean getDirectory() {
        return this.directory;
    }

    public void setDirectory(Boolean directory) {
        this.directory = directory;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }

    public void incrementFileCount() {
        ++this.fileCount;
    }

    public void decrementFileCount() {
        this.fileCount = this.fileCount > 0L ? --this.fileCount : 0L;
    }

    public List<String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<String> metadata) {
        this.metadata = metadata;
    }

    public Map<String, String> getHashes() {
        return this.hashes;
    }

    public void setHashes(Map<String, String> hashes) {
        this.hashes = hashes;
    }

    public Long getAddedDate() {
        return this.addedDate;
    }

    public void setAddedDate(Long addedDate) {
        this.addedDate = addedDate;
    }

    public long getUploadDuration() {
        return this.uploadDuration;
    }

    public void setUploadDuration(long uploadDuration) {
        this.uploadDuration = uploadDuration;
    }

    public int getInterruptedCount() {
        return this.interruptedCount;
    }

    public void setInterruptedCount(int interruptedCount) {
        this.interruptedCount = interruptedCount;
    }

    public String getRelativePath() {
        return this.getRelativePath(true);
    }

    public String getRelativePath(boolean defaultToName) {
        if (!defaultToName || this.relativePath != null) {
            return this.relativePath;
        }
        return this.name;
    }

    public void setRelativePath(String relativePath) {
        this.setRelativePath(relativePath, false);
    }

    public void setRelativePath(String relativePath, boolean normalize) {
        this.relativePath = normalize && relativePath != null ? FileInfo.getNormalizedRelativePath(relativePath) : relativePath;
    }

    @JsonIgnore
    public static String getNormalizedRelativePath(String relativePath) {
        String[] relativePathParts = FilePathUtils.getRelativePathSplit(relativePath);
        return Paths.get(relativePathParts[0], Arrays.copyOfRange(relativePathParts, 1, relativePathParts.length)).toString();
    }

    public String getClientIpAddresses() {
        return this.clientIpAddresses;
    }

    public void setClientIpAddresses(String clientIpAddresses) {
        this.clientIpAddresses = clientIpAddresses;
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    public void setServerIpAddress(String serverIpAddress) {
        this.serverIpAddress = serverIpAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerRole() {
        return this.serverRole;
    }

    public void setServerRole(String serverRole) {
        this.serverRole = serverRole;
    }
}

