/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.executionprofile;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.executionprofile.JobProgressSettings;
import com.nuix.automate.utils.models.api.executionprofile.JobTimeoutSettings;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.workflow.StaticParameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExecutionProfile
extends UserPermissionModel
implements Serializable,
Cloneable {
    @Schema(description="Execution Profile ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Execution Profile Name", example="Default Profile")
    private String name;
    @Schema(description="Execution Profile Description", example="2GB memory and standard flags")
    private String description;
    @Schema(description="Engine Account Username", example="EXAMPLE\\serviceaccount")
    private String engineAccountUsername;
    @Schema(description="Engine Command-Line Parameters", example="-Xmx2g -Duser.language=en -Duser.country=US")
    private String engineCommandLineParameters;
    @Schema(description="Workflow parameters", ref="#/components/schemas/ParametersValue")
    private Map<String, String> workflowParameters;
    @Schema(description="Engine Log Folder", example="\\\\Storage\\Logs")
    private String engineLogFolder;
    @Schema(description="Nuix Engine Folder", example="C:\\Program Files\\Nuix\\Nuix Engine")
    private String nuixEngineFolder;
    @Schema(description="Java Folder", example="C:\\Program Files\\AdoptOpenJDK\\jdk-hotspot\\bin")
    private String javaFolder;
    @Schema(description="Notification Rule IDs", example="[\"11111111-1111-1111-1111-111111111111\",\"22222222-2222-2222-2222-222222222222\"]")
    private List<String> notificationRuleIds;
    @Schema(description="Execution Profile Status", example="C:\\Program Files\\Nuix\\Nuix Engine")
    private Status status;
    @Schema(description="Job Progress Settings")
    private JobProgressSettings jobProgressSettings;
    @Schema(description="Job Timeout Settings")
    private JobTimeoutSettings jobTimeoutSettings;
    @Schema(description="Nuix Profiles")
    private Map<String, String> nuixProfiles;
    @Schema(description="Additional Files")
    private Map<String, String> additionalFiles;
    @Schema(description="Scheduler URL", example="https://automate.example.com")
    private String schedulerUrl;
    @Schema(description="Worker Temp Folder", example="C:\\Temp\\Nuix\\Automate\\Worker")
    private String workerTempFolder;

    public ExecutionProfile() {
    }

    public ExecutionProfile(ExecutionProfileModel ep) {
        this.id = ep.getId();
        this.name = ep.getName();
        this.description = ep.getDescription();
        this.engineAccountUsername = ep.getEngineAccountUsername();
        this.engineCommandLineParameters = ep.getEngineCommandLineParameters();
        this.workflowParameters = new LinkedHashMap<String, String>();
        if (ep.getWorkflowParameters() != null) {
            for (Map.Entry<String, String> entry : ep.getWorkflowParameters().entrySet()) {
                StaticParameter dummy = new StaticParameter(entry.getKey(), entry.getValue());
                this.workflowParameters.put(entry.getKey(), entry.getValue());
            }
        }
        this.engineLogFolder = ep.getEngineLogFolder();
        this.nuixEngineFolder = ep.getNuixEngineFolder();
        this.javaFolder = ep.getJavaFolder();
        this.schedulerUrl = ep.getSchedulerUrl();
        this.workerTempFolder = ep.getWorkerTempFolder();
        this.notificationRuleIds = new ArrayList<String>();
        if (ep.getNotificationRuleIds() != null) {
            this.notificationRuleIds.addAll(ep.getNotificationRuleIds());
        }
        this.status = ep.getStatus();
        this.jobTimeoutSettings = ep.getJobTimeoutSettings();
        this.jobProgressSettings = ep.getJobProgressSettings();
        if (ep.getNuixProfiles() != null) {
            this.nuixProfiles = ep.getNuixProfiles();
        }
        if (ep.getAdditionalFiles() != null) {
            this.additionalFiles = ep.getAdditionalFiles();
        }
    }

    @Override
    public ExecutionProfile clone() {
        ExecutionProfile clonedObject = (ExecutionProfile)super.clone();
        clonedObject.workflowParameters = new LinkedHashMap<String, String>();
        if (this.workflowParameters != null) {
            clonedObject.workflowParameters.putAll(this.workflowParameters);
        }
        clonedObject.notificationRuleIds = new ArrayList<String>();
        if (this.notificationRuleIds != null) {
            clonedObject.notificationRuleIds.addAll(this.notificationRuleIds);
        }
        clonedObject.nuixProfiles = new HashMap<String, String>();
        if (this.nuixProfiles != null) {
            clonedObject.nuixProfiles.putAll(this.nuixProfiles);
        }
        clonedObject.additionalFiles = new HashMap<String, String>();
        if (this.additionalFiles != null) {
            clonedObject.additionalFiles.putAll(this.additionalFiles);
        }
        return clonedObject;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEngineAccountUsername() {
        return this.engineAccountUsername;
    }

    public void setEngineAccountUsername(String engineAccountUsername) {
        this.engineAccountUsername = engineAccountUsername;
    }

    public String getEngineCommandLineParameters() {
        return this.engineCommandLineParameters;
    }

    public void setEngineCommandLineParameters(String engineCommandLineParameters) {
        this.engineCommandLineParameters = engineCommandLineParameters;
    }

    public Map<String, String> getWorkflowParameters() {
        if (this.workflowParameters != null) {
            return this.workflowParameters;
        }
        return new LinkedHashMap<String, String>();
    }

    public void setWorkflowParameters(Map<String, String> workflowParameters) {
        this.workflowParameters = this.normalizeParameterNamesStrict(workflowParameters);
    }

    private Map<String, String> normalizeParameterNamesStrict(Map<String, String> parameters) {
        LinkedHashMap<String, String> normalizedParameters = new LinkedHashMap<String, String>();
        if (parameters == null) {
            parameters = new LinkedHashMap<String, String>();
        }
        for (String parameterName : parameters.keySet()) {
            String normalizedParameterName = FormattingUtils.normalizeParameterName(parameterName);
            if (normalizedParameterName.length() <= 2) continue;
            normalizedParameters.put(normalizedParameterName, parameters.get(parameterName));
        }
        return normalizedParameters;
    }

    public Map<String, String> getNuixProfiles() {
        return this.nuixProfiles;
    }

    public void setNuixProfiles(Map<String, String> nuixProfiles) {
        this.nuixProfiles = nuixProfiles;
    }

    public Map<String, String> getAdditionalFiles() {
        return this.additionalFiles;
    }

    public void setAdditionalFiles(Map<String, String> additionalFiles) {
        this.additionalFiles = additionalFiles;
    }

    public String getEngineLogFolder() {
        if (this.engineLogFolder != null) {
            return this.engineLogFolder.trim();
        }
        return this.engineLogFolder;
    }

    public void setEngineLogFolder(String engineLogFolder) {
        this.engineLogFolder = engineLogFolder;
    }

    public String getNuixEngineFolder() {
        if (this.nuixEngineFolder != null) {
            return this.nuixEngineFolder.trim();
        }
        return this.nuixEngineFolder;
    }

    public void setNuixEngineFolder(String nuixEngineFolder) {
        this.nuixEngineFolder = nuixEngineFolder;
    }

    public String getJavaFolder() {
        return this.javaFolder;
    }

    public void setJavaFolder(String javaFolder) {
        this.javaFolder = javaFolder;
    }

    public String getSchedulerUrl() {
        return this.schedulerUrl;
    }

    public void setSchedulerUrl(String schedulerUrl) {
        this.schedulerUrl = schedulerUrl;
    }

    public String getWorkerTempFolder() {
        return this.workerTempFolder;
    }

    public void setWorkerTempFolder(String workerTempFolder) {
        this.workerTempFolder = workerTempFolder;
    }

    public List<String> getNotificationRuleIds() {
        return this.notificationRuleIds;
    }

    public void setNotificationRuleIds(List<String> notificationRuleIds) {
        this.notificationRuleIds = notificationRuleIds;
    }

    public String toString() {
        try {
            return "executionProfile " + this.getName() + " (" + FormattingUtils.getShortId(this.id, 8) + ")";
        }
        catch (Exception e) {
            return "executionProfile " + this.getName() + " (N/A)";
        }
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public JobTimeoutSettings getJobTimeoutSettings() {
        return this.jobTimeoutSettings;
    }

    public void setJobTimeoutSettings(JobTimeoutSettings jobTimeoutSettings) {
        this.jobTimeoutSettings = jobTimeoutSettings;
    }

    public ExecutionProfile cloneLimited() {
        ExecutionProfile limited = new ExecutionProfile();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        return limited;
    }

    public JobProgressSettings getJobProgressSettings() {
        return this.jobProgressSettings;
    }

    public void setJobProgressSettings(JobProgressSettings jobProgressSettings) {
        this.jobProgressSettings = jobProgressSettings;
    }
}

