/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.legalhold;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldState;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldSubmission;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldTaskState;
import com.nuix.automate.utils.models.api.legalhold.SurveyNoticesTrigger;
import com.nuix.automate.utils.models.api.legalhold.TriggerConfiguration;
import com.nuix.automate.utils.models.api.notice.NoticeConfiguration;
import com.nuix.automate.utils.models.api.smtp.SmtpEmailCounter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LegalHold
extends UserPermissionModel {
    public static final Set<LegalHoldState> manageStates = new HashSet<LegalHoldState>(Arrays.asList(LegalHoldState.DRAFT, LegalHoldState.ACTIVE, LegalHoldState.RELEASED));
    public static final Set<LegalHoldState> replyStates = new HashSet<LegalHoldState>(Arrays.asList(LegalHoldState.ACTIVE, LegalHoldState.RELEASED));
    public static final Set<LegalHoldState> editableStates = new HashSet<LegalHoldState>(Arrays.asList(LegalHoldState.DRAFT, LegalHoldState.ACTIVE));
    @Schema(description="Legal Hold ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Legal Hold Name", example="Globex Legal Hold")
    private String name;
    @Schema(description="Legal Hold Description", example="Sample description")
    private String description;
    @Schema(description="Client ID", example="11111111-1111-1111-1111-111111111111")
    private String clientId;
    @Schema(description="Matter ID", example="11111111-1111-1111-1111-111111111111")
    private String matterId;
    @Schema(description="Data Repository ID", example="11111111-1111-1111-1111-111111111111")
    private String dataRepositoryId;
    @Schema(description="SMTP Service ID", example="11111111-1111-1111-1111-111111111111")
    private String smtpServerId;
    @Schema(description="Execution Profile ID", example="11111111-1111-1111-1111-111111111111")
    private String executionProfileId;
    @Schema(description="Resource Pool ID", example="11111111-1111-1111-1111-111111111111")
    private String resourcePoolId;
    @Schema(description="Priority")
    private Priority priority;
    @Schema(description="Survey Notices Trigger")
    private SurveyNoticesTrigger surveyNoticesTrigger;
    @Schema(description="Automate URL", example="https://automate.nuix.local")
    private String schedulerUrl;
    @Schema(description="Enable login links", example="true")
    private Boolean enableLoginLinks;
    @Schema(description="Legal Hold Created Date (Epoch)", example="1641034800000")
    private Long createdDate;
    @Schema(description="Legal Hold Last Changed (Epoch)", example="1641034800000")
    private Long lastChangedDate;
    @Schema(description="Legal Hold Start Date (Epoch)", example="1641034800000")
    private Long startDate;
    @Schema(description="Legal Hold End Date (Epoch)", example="1641034800000")
    private Long endDate;
    @Schema(description="Legal Hold Submitted By", example="jsmith@example.com")
    private String createdBy;
    @Schema(description="Legal Hold Submitted By User ID", example="11111111-1111-1111-1111-111111111111")
    private String createdByUserId;
    @Schema(description="Legal Hold Last Changed By", example="jsmith@example.com")
    private String lastChangedBy;
    @Schema(description="Legal Hold Last Changed By User ID", example="11111111-1111-1111-1111-111111111111")
    private String lastChangedByUserId;
    @Schema(description="Legal Hold Status")
    private Status status;
    @Schema(description="Legal Hold State")
    private LegalHoldState state;
    @Schema(description="Legal Hold Task State")
    private LegalHoldTaskState taskState;
    @Schema(description="Legal Hold State Percent Progress")
    private int taskPercentProgress;
    @Schema(description="Legal Hold Administrator IDs", example="[\"11111111-1111-1111-1111-111111111111\",\"22222222-2222-2222-2222-222222222222\"]")
    private Set<String> administratorIds;
    @Schema(description="Silent Legal Hold")
    private Boolean silent;
    @Schema(description="Recurring Notice Configuration")
    private NoticeConfiguration recurringNoticeConfiguration;
    @Schema(description="Hold Notice Configuration")
    private NoticeConfiguration holdNoticeConfiguration;
    @Schema(description="Relase Notice Configuration")
    private NoticeConfiguration releaseNoticeConfiguration;
    @Schema(description="Survey Notice Configurations")
    private LinkedHashMap<String, NoticeConfiguration> surveyNoticeConfigurations;
    @Schema(description="Parameters")
    private Map<String, Parameter> parameters;
    @Schema(description="Enable Job Triggers")
    private Boolean triggerJobs;
    @Schema(description="Trigger Configurations")
    private LinkedHashMap<String, TriggerConfiguration> triggerConfigurations;
    @Schema(description="Consumption Tracking Epoch")
    private long lastConsumptionTrackingEpoch;
    private boolean commandInProgress;
    private SmtpEmailCounter emailCounter;

    public LegalHold() {
        this.status = new Status();
        this.taskState = LegalHoldTaskState.DONE;
    }

    public LegalHold(LegalHoldSubmission legalHoldSubmission) {
        this.name = legalHoldSubmission.getName();
        this.description = legalHoldSubmission.getDescription();
        this.clientId = legalHoldSubmission.getClientId();
        this.matterId = legalHoldSubmission.getMatterId();
        this.executionProfileId = legalHoldSubmission.getExecutionProfileId();
        this.resourcePoolId = legalHoldSubmission.getResourcePoolId();
        this.priority = legalHoldSubmission.getPriority();
        this.dataRepositoryId = legalHoldSubmission.getDataRepositoryId();
        this.smtpServerId = legalHoldSubmission.getSmtpServerId();
        this.surveyNoticesTrigger = legalHoldSubmission.getSurveyNoticesTrigger();
        this.schedulerUrl = legalHoldSubmission.getSchedulerUrl();
        this.enableLoginLinks = legalHoldSubmission.getEnableLoginLinks();
        this.administratorIds = legalHoldSubmission.getAdministratorIds();
        this.silent = legalHoldSubmission.getSilent();
        this.holdNoticeConfiguration = legalHoldSubmission.getHoldNoticeConfiguration();
        this.recurringNoticeConfiguration = legalHoldSubmission.getRecurringNoticeConfiguration();
        this.releaseNoticeConfiguration = legalHoldSubmission.getReleaseNoticeConfiguration();
        this.surveyNoticeConfigurations = legalHoldSubmission.getSurveyNoticeConfigurations();
        this.parameters = legalHoldSubmission.getParameters();
        this.triggerJobs = legalHoldSubmission.getTriggerJobs();
        this.triggerConfigurations = legalHoldSubmission.getTriggerConfigurations();
    }

    @Override
    public LegalHold clone() {
        return (LegalHold)super.clone();
    }

    @JsonIgnore
    public boolean canView() {
        if (this.getUserPermissions() != null) {
            return this.getUserPermissions().contains((Object)Permission.VIEW) || this.getUserPermissions().contains((Object)Permission.MANAGE) || this.getUserPermissions().contains((Object)Permission.RESPOND);
        }
        return false;
    }

    @JsonIgnore
    public boolean canViewSensitive() {
        if (this.getUserPermissions() != null) {
            return this.getUserPermissions().contains((Object)Permission.VIEW) || this.getUserPermissions().contains((Object)Permission.MANAGE);
        }
        return false;
    }

    @JsonIgnore
    public void setTaskError(String error) {
        this.setTaskState(LegalHoldTaskState.ERROR);
        this.setState(LegalHoldState.ERROR);
        this.getStatus().setError(error);
    }

    @JsonIgnore
    public void setTaskDone() {
        this.setTaskState(LegalHoldTaskState.DONE);
        if (this.getStatus().getCode() == State.ERROR) {
            this.getStatus().reset();
        }
    }

    @JsonIgnore
    public void updateTaskState(LegalHoldTaskState taskState) {
        this.setTaskState(taskState);
        this.setTaskPercentProgress(0);
    }

    @JsonIgnore
    public String getMatterUrl() {
        return "legalHold/matter?id=" + this.getId();
    }

    @JsonIgnore
    public String getNoticeUrl(String noticeId) {
        return "legalHold/overview?id=" + noticeId;
    }

    @JsonIgnore
    public String getLastModifiedByUserId() {
        return this.lastChangedByUserId != null ? this.lastChangedByUserId : this.createdByUserId;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public boolean getCommandInProgress() {
        return this.commandInProgress;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Legal Hold " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
    }

    public LegalHold cloneLimited() {
        LegalHold limited = new LegalHold();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.state = this.state;
        limited.clientId = this.clientId;
        limited.taskState = this.taskState;
        limited.taskPercentProgress = this.taskPercentProgress;
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        return limited;
    }

    public void normalize() {
        if (this.recurringNoticeConfiguration == null) {
            this.recurringNoticeConfiguration = new NoticeConfiguration();
            this.recurringNoticeConfiguration.setId(UidUtils.getRandom());
            this.recurringNoticeConfiguration.setEnabled(false);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getMatterId() {
        return this.matterId;
    }

    public String getDataRepositoryId() {
        return this.dataRepositoryId;
    }

    public String getSmtpServerId() {
        return this.smtpServerId;
    }

    public String getExecutionProfileId() {
        return this.executionProfileId;
    }

    public String getResourcePoolId() {
        return this.resourcePoolId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public SurveyNoticesTrigger getSurveyNoticesTrigger() {
        return this.surveyNoticesTrigger;
    }

    public String getSchedulerUrl() {
        return this.schedulerUrl;
    }

    public Boolean getEnableLoginLinks() {
        return this.enableLoginLinks;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Long getLastChangedDate() {
        return this.lastChangedDate;
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public String getLastChangedBy() {
        return this.lastChangedBy;
    }

    public String getLastChangedByUserId() {
        return this.lastChangedByUserId;
    }

    public LegalHoldState getState() {
        return this.state;
    }

    public LegalHoldTaskState getTaskState() {
        return this.taskState;
    }

    public int getTaskPercentProgress() {
        return this.taskPercentProgress;
    }

    public Set<String> getAdministratorIds() {
        return this.administratorIds;
    }

    public Boolean getSilent() {
        return this.silent;
    }

    public NoticeConfiguration getRecurringNoticeConfiguration() {
        return this.recurringNoticeConfiguration;
    }

    public NoticeConfiguration getHoldNoticeConfiguration() {
        return this.holdNoticeConfiguration;
    }

    public NoticeConfiguration getReleaseNoticeConfiguration() {
        return this.releaseNoticeConfiguration;
    }

    public LinkedHashMap<String, NoticeConfiguration> getSurveyNoticeConfigurations() {
        return this.surveyNoticeConfigurations;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public Boolean getTriggerJobs() {
        return this.triggerJobs;
    }

    public LinkedHashMap<String, TriggerConfiguration> getTriggerConfigurations() {
        return this.triggerConfigurations;
    }

    public long getLastConsumptionTrackingEpoch() {
        return this.lastConsumptionTrackingEpoch;
    }

    public SmtpEmailCounter getEmailCounter() {
        return this.emailCounter;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public void setDataRepositoryId(String dataRepositoryId) {
        this.dataRepositoryId = dataRepositoryId;
    }

    public void setSmtpServerId(String smtpServerId) {
        this.smtpServerId = smtpServerId;
    }

    public void setExecutionProfileId(String executionProfileId) {
        this.executionProfileId = executionProfileId;
    }

    public void setResourcePoolId(String resourcePoolId) {
        this.resourcePoolId = resourcePoolId;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public void setSurveyNoticesTrigger(SurveyNoticesTrigger surveyNoticesTrigger) {
        this.surveyNoticesTrigger = surveyNoticesTrigger;
    }

    public void setSchedulerUrl(String schedulerUrl) {
        this.schedulerUrl = schedulerUrl;
    }

    public void setEnableLoginLinks(Boolean enableLoginLinks) {
        this.enableLoginLinks = enableLoginLinks;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public void setLastChangedDate(Long lastChangedDate) {
        this.lastChangedDate = lastChangedDate;
    }

    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setCreatedByUserId(String createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    public void setLastChangedBy(String lastChangedBy) {
        this.lastChangedBy = lastChangedBy;
    }

    public void setLastChangedByUserId(String lastChangedByUserId) {
        this.lastChangedByUserId = lastChangedByUserId;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setState(LegalHoldState state) {
        this.state = state;
    }

    public void setTaskState(LegalHoldTaskState taskState) {
        this.taskState = taskState;
    }

    public void setTaskPercentProgress(int taskPercentProgress) {
        this.taskPercentProgress = taskPercentProgress;
    }

    public void setAdministratorIds(Set<String> administratorIds) {
        this.administratorIds = administratorIds;
    }

    public void setSilent(Boolean silent) {
        this.silent = silent;
    }

    public void setRecurringNoticeConfiguration(NoticeConfiguration recurringNoticeConfiguration) {
        this.recurringNoticeConfiguration = recurringNoticeConfiguration;
    }

    public void setHoldNoticeConfiguration(NoticeConfiguration holdNoticeConfiguration) {
        this.holdNoticeConfiguration = holdNoticeConfiguration;
    }

    public void setReleaseNoticeConfiguration(NoticeConfiguration releaseNoticeConfiguration) {
        this.releaseNoticeConfiguration = releaseNoticeConfiguration;
    }

    public void setSurveyNoticeConfigurations(LinkedHashMap<String, NoticeConfiguration> surveyNoticeConfigurations) {
        this.surveyNoticeConfigurations = surveyNoticeConfigurations;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setTriggerJobs(Boolean triggerJobs) {
        this.triggerJobs = triggerJobs;
    }

    public void setTriggerConfigurations(LinkedHashMap<String, TriggerConfiguration> triggerConfigurations) {
        this.triggerConfigurations = triggerConfigurations;
    }

    public void setLastConsumptionTrackingEpoch(long lastConsumptionTrackingEpoch) {
        this.lastConsumptionTrackingEpoch = lastConsumptionTrackingEpoch;
    }

    public void setCommandInProgress(boolean commandInProgress) {
        this.commandInProgress = commandInProgress;
    }

    public void setEmailCounter(SmtpEmailCounter emailCounter) {
        this.emailCounter = emailCounter;
    }
}

