/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notice;

import com.nuix.automate.utils.models.api.notice.FormElementType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.LinkedHashSet;

public class FormOption {
    @Schema(description="Is Form Option Enabled?", example="true")
    private boolean enabled;
    @Schema(description="Is Form Option Optional?", example="false")
    private boolean optional;
    @Schema(description="Form Option Type")
    private FormElementType type;
    @Schema(description="Form Option Key", example="11111111-1111-1111-1111-111111111111")
    private String key;
    @Schema(description="Form Option Title", example="Relevant Section Title")
    private String title;
    @Schema(description="Form Option Description", example="Do you have any relevant data")
    private String description;
    @Schema(description="Form Option Label", example="RelevantData")
    private String label;
    @Schema(description="Form Option Model Naming Pattern", example="{legal_hold_name} - {notice_subject} - {custodian_name}")
    private String modelNamingPattern;
    @Schema(description="Form Option Value", example="Yes")
    private String value;
    @Schema(description="Form Option Allowed Values")
    private LinkedHashSet<String> allowedValues;

    public FormOption() {
    }

    public FormOption(FormOption obj) {
        this.enabled = obj.enabled;
        this.optional = obj.optional;
        this.type = obj.type;
        this.key = obj.key;
        this.title = obj.title;
        this.description = obj.description;
        this.label = obj.label;
        this.modelNamingPattern = obj.modelNamingPattern;
        this.value = obj.value;
        if (obj.allowedValues != null) {
            this.allowedValues = new LinkedHashSet<String>(obj.allowedValues);
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public FormElementType getType() {
        return this.type;
    }

    public void setType(FormElementType type) {
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getModelNamingPattern() {
        return this.modelNamingPattern;
    }

    public void setModelNamingPattern(String modelNamingPattern) {
        this.modelNamingPattern = modelNamingPattern;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public LinkedHashSet<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(LinkedHashSet<String> allowedValues) {
        this.allowedValues = allowedValues;
    }
}

