/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notice;

import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.NoticeConfiguration;
import com.nuix.automate.utils.models.api.notice.NoticeTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Notice
extends NoticeTemplate {
    private String legalHoldId;
    private String parentNoticeId;
    private Long createdDate;
    private NoticeConfiguration configuration;

    public Notice() {
    }

    public Notice(String legalHoldId, NoticeTemplate noticeTemplate, NoticeConfiguration configuration) {
        this.legalHoldId = legalHoldId;
        this.setId(UidUtils.getRandom());
        this.setCreatedDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        configuration.setNoticeId(this.getId());
        configuration.setNoticeTemplateVersion(noticeTemplate.getVersion());
        this.setConfiguration(configuration);
        this.setName(noticeTemplate.getName());
        this.setType(noticeTemplate.getType());
        this.setSubject(noticeTemplate.getSubject());
        this.setMessage(noticeTemplate.getMessage());
        this.setParameters(new HashMap<String, Parameter>(noticeTemplate.getParameters()));
        List<FormOption> surveyFormOptions = noticeTemplate.getSurveyFormOptions();
        if (surveyFormOptions != null) {
            ArrayList<FormOption> formOptions = new ArrayList<FormOption>();
            for (FormOption formOption : surveyFormOptions) {
                FormOption option = new FormOption(formOption);
                formOptions.add(option);
            }
            this.setSurveyFormOptions(formOptions);
        }
    }

    @Override
    public Notice clone() {
        return (Notice)super.clone();
    }

    public String getLegalHoldId() {
        return this.legalHoldId;
    }

    public void setLegalHoldId(String legalHoldId) {
        this.legalHoldId = legalHoldId;
    }

    public String getParentNoticeId() {
        return this.parentNoticeId;
    }

    public void setParentNoticeId(String parentNoticeId) {
        this.parentNoticeId = parentNoticeId;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public NoticeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NoticeConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.configuration.setEnabled(enabled);
    }

    @Override
    public Boolean getEnabled() {
        return this.configuration != null && this.configuration.getEnabled() != false;
    }

    @Override
    public Notice cloneLimited() {
        Notice limited = this.clone();
        return limited;
    }
}

