/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notice;

import com.nuix.automate.utils.models.api.notice.NoticeType;
import com.nuix.automate.utils.models.api.notice.RecurringNoticeFrequency;
import io.swagger.v3.oas.annotations.media.Schema;

public class NoticeConfiguration
implements Cloneable {
    @Schema(description="Notice Configuration ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Notice Template ID", example="11111111-1111-1111-1111-111111111111")
    private String noticeTemplateId;
    @Schema(description="Notice Template Version", example="11111111-1111-1111-1111-111111111111")
    private String noticeTemplateVersion;
    @Schema(description="Notice ID", example="11111111-1111-1111-1111-111111111111")
    private String noticeId;
    @Schema(description="Is Notice Configuration Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Are Notice Configuration Comments Disabled?", example="false")
    private Boolean disableComments;
    @Schema(description="Are Notice Configuration Admin Notes Disabled?", example="false")
    private Boolean disableAdminNotes;
    @Schema(description="Is Notice Configuration Response Required", example="false")
    private Boolean requireResponse;
    @Schema(description="Notice Configuration Respond By Date (Epoch)", example="1641034800000")
    private Long respondByDate;
    @Schema(description="Notice Configuration Respond After (Days Count)", example="3")
    private Integer respondByNDays;
    @Schema(description="Are Notice Configuration Reminders Enabled?", example="false")
    private Boolean enableRemind;
    @Schema(description="Notice Configuration Remind Every (Days Count)", example="3")
    private Integer remindEveryNDays;
    @Schema(description="Notice Configuration Reminder Notice Template ID", example="11111111-1111-1111-1111-111111111111")
    private String reminderNoticeTemplateId;
    @Schema(description="Notice Configuration Reminder Notice ID", example="11111111-1111-1111-1111-111111111111")
    private String reminderNoticeId;
    @Schema(description="Notice Configuration Escalate If No Response?", example="false")
    private Boolean escalateOnResponseFail;
    @Schema(description="Notice Configuration Escalation Notice Template ID", example="11111111-1111-1111-1111-111111111111")
    private String escalateNoticeTemplateId;
    @Schema(description="Notice Configuration Escalation Notice ID", example="11111111-1111-1111-1111-111111111111")
    private String escalateNoticeId;
    @Schema(description="Notice Type")
    private NoticeType noticeType;
    @Schema(description="Send Recurring Notice Every N (Days or Months)", example="3")
    private Integer sendRecurringNoticeEveryN;
    @Schema(description="Recurring Notice Frequency")
    private RecurringNoticeFrequency recurringNoticeFrequency;

    public NoticeConfiguration clone() {
        try {
            return (NoticeConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isChangeValid(NoticeConfiguration configuration) {
        if (this.getNoticeId() == null) {
            return true;
        }
        if (configuration == null) {
            return false;
        }
        if (configuration.getNoticeTemplateId() != null && !configuration.getNoticeTemplateId().equals(this.getNoticeTemplateId())) {
            return false;
        }
        if (this.getReminderNoticeId() != null && configuration.getReminderNoticeTemplateId() != null && !configuration.getReminderNoticeTemplateId().equals(this.getReminderNoticeTemplateId())) {
            return false;
        }
        return this.getEscalateNoticeId() == null || configuration.getEscalateNoticeTemplateId() == null || configuration.getEscalateNoticeTemplateId().equals(this.getEscalateNoticeTemplateId());
    }

    public boolean different(NoticeConfiguration configuration) {
        if (configuration == null) {
            return true;
        }
        if (configuration.getNoticeTemplateId() != null && !configuration.getNoticeTemplateId().equals(this.getNoticeTemplateId())) {
            return true;
        }
        if (configuration.getEnabled() != null && !configuration.getEnabled().equals(this.getEnabled())) {
            return true;
        }
        if (configuration.getDisableComments() != null && !configuration.getDisableComments().equals(this.getDisableComments())) {
            return true;
        }
        if (configuration.getDisableAdminNotes() != null && !configuration.getDisableAdminNotes().equals(this.getDisableAdminNotes())) {
            return true;
        }
        if (configuration.getRequireResponse() != null && !configuration.getRequireResponse().equals(this.getRequireResponse())) {
            return true;
        }
        if (configuration.getRespondByDate() != null && !configuration.getRespondByDate().equals(this.getRespondByDate())) {
            return true;
        }
        if (configuration.getRespondByNDays() != null && !configuration.getRespondByNDays().equals(this.getRespondByNDays())) {
            return true;
        }
        if (configuration.getEnableRemind() != null && !configuration.getEnableRemind().equals(this.getEnableRemind())) {
            return true;
        }
        if (configuration.getRemindEveryNDays() != null && !configuration.getRemindEveryNDays().equals(this.getRemindEveryNDays())) {
            return true;
        }
        if (configuration.getReminderNoticeTemplateId() != null && !configuration.getReminderNoticeTemplateId().equals(this.getReminderNoticeTemplateId())) {
            return true;
        }
        if (configuration.getEscalateOnResponseFail() != null && !configuration.getEscalateOnResponseFail().equals(this.getEscalateOnResponseFail())) {
            return true;
        }
        if (configuration.getEscalateNoticeTemplateId() != null && !configuration.getEscalateNoticeTemplateId().equals(this.getEscalateNoticeTemplateId())) {
            return true;
        }
        if (configuration.getSendRecurringNoticeEveryN() != null && !configuration.getSendRecurringNoticeEveryN().equals(this.getSendRecurringNoticeEveryN())) {
            return true;
        }
        return configuration.getRecurringNoticeFrequency() != null && !configuration.getRecurringNoticeFrequency().equals((Object)this.getRecurringNoticeFrequency());
    }

    public void update(NoticeConfiguration configuration, boolean updateEnabled) {
        if (this.getNoticeId() == null && configuration.getNoticeTemplateId() != null) {
            this.setNoticeTemplateId(configuration.getNoticeTemplateId());
        }
        if (updateEnabled && configuration.getEnabled() != null) {
            this.setEnabled(configuration.getEnabled());
        }
        if (configuration.getDisableComments() != null) {
            this.setDisableComments(configuration.getDisableComments());
        }
        if (configuration.getDisableAdminNotes() != null) {
            this.setDisableAdminNotes(configuration.getDisableAdminNotes());
        }
        if (configuration.getRequireResponse() != null) {
            this.setRequireResponse(configuration.getRequireResponse());
        }
        if (configuration.getRespondByDate() != null) {
            this.setRespondByDate(configuration.getRespondByDate());
        }
        if (configuration.getRespondByNDays() != null) {
            this.setRespondByNDays(configuration.getRespondByNDays());
        }
        if (configuration.getEnableRemind() != null) {
            this.setEnableRemind(configuration.getEnableRemind());
        }
        if (configuration.getRemindEveryNDays() != null) {
            this.setRemindEveryNDays(configuration.getRemindEveryNDays());
        }
        if (this.getReminderNoticeId() == null && configuration.getReminderNoticeTemplateId() != null) {
            this.setReminderNoticeTemplateId(configuration.getReminderNoticeTemplateId());
        }
        if (configuration.getEscalateOnResponseFail() != null) {
            this.setEscalateOnResponseFail(configuration.getEscalateOnResponseFail());
        }
        if (this.getEscalateNoticeId() == null && configuration.getEscalateNoticeTemplateId() != null) {
            this.setEscalateNoticeTemplateId(configuration.getEscalateNoticeTemplateId());
        }
        if (configuration.getSendRecurringNoticeEveryN() != null) {
            this.setSendRecurringNoticeEveryN(configuration.getSendRecurringNoticeEveryN());
        }
        if (configuration.getRecurringNoticeFrequency() != null) {
            this.setRecurringNoticeFrequency(configuration.getRecurringNoticeFrequency());
        }
    }

    public void updateReminder(NoticeConfiguration parentConfiguration) {
        if (this.getNoticeId() == null && parentConfiguration.getReminderNoticeTemplateId() != null) {
            this.setNoticeTemplateId(parentConfiguration.getReminderNoticeTemplateId());
        }
        if (parentConfiguration.getEnableRemind() != null) {
            this.setEnabled(Boolean.TRUE.equals(parentConfiguration.getRequireResponse()) && parentConfiguration.getEnableRemind() != false);
        }
        if (parentConfiguration.getRequireResponse() != null) {
            this.setEnabled(parentConfiguration.getRequireResponse() != false && Boolean.TRUE.equals(this.getEnabled()));
        }
        if (parentConfiguration.getDisableComments() != null) {
            this.setDisableComments(parentConfiguration.getDisableComments());
        }
        if (parentConfiguration.getDisableAdminNotes() != null) {
            this.setDisableAdminNotes(parentConfiguration.getDisableAdminNotes());
        }
    }

    public void updateEscalate(NoticeConfiguration parentConfiguration) {
        if (this.getNoticeId() == null && parentConfiguration.getEscalateNoticeTemplateId() != null) {
            this.setNoticeTemplateId(parentConfiguration.getEscalateNoticeTemplateId());
        }
        if (parentConfiguration.getEscalateOnResponseFail() != null) {
            this.setEnabled(Boolean.TRUE.equals(parentConfiguration.getRequireResponse()) && parentConfiguration.getEscalateOnResponseFail() != false);
        }
        if (parentConfiguration.getRequireResponse() != null) {
            this.setEnabled(parentConfiguration.getRequireResponse() != false && Boolean.TRUE.equals(this.getEnabled()));
        }
        if (parentConfiguration.getDisableComments() != null) {
            this.setDisableComments(parentConfiguration.getDisableComments());
        }
        if (parentConfiguration.getDisableAdminNotes() != null) {
            this.setDisableAdminNotes(parentConfiguration.getDisableAdminNotes());
        }
    }

    public boolean isValid() {
        if (Boolean.TRUE.equals(this.enabled)) {
            if (this.noticeTemplateId == null) {
                return false;
            }
            return this.isRequireResponseValid() && this.isReminderOptionsValid() && this.isEscalateOptionsValid() && this.isRecurringValid();
        }
        return true;
    }

    public boolean isRequireResponseValid() {
        if (Boolean.TRUE.equals(this.requireResponse)) {
            if (this.respondByDate != null) {
                return true;
            }
            return this.respondByNDays != null;
        }
        return true;
    }

    public boolean isReminderOptionsValid() {
        if (Boolean.TRUE.equals(this.requireResponse) && Boolean.TRUE.equals(this.enableRemind)) {
            if (this.reminderNoticeTemplateId == null) {
                return false;
            }
            return this.remindEveryNDays != null && this.remindEveryNDays > 0;
        }
        return true;
    }

    public boolean isEscalateOptionsValid() {
        if (Boolean.TRUE.equals(this.requireResponse) && Boolean.TRUE.equals(this.escalateOnResponseFail)) {
            return this.escalateNoticeTemplateId != null;
        }
        return true;
    }

    public boolean isRecurringValid() {
        if (this.noticeType == NoticeType.RECURRING) {
            return this.recurringNoticeFrequency != null && this.sendRecurringNoticeEveryN != null && this.sendRecurringNoticeEveryN > 0;
        }
        return true;
    }

    public long getRespondByMillis(long noticeCreatedDate) {
        if (this.getRespondByDate() != null) {
            return this.getRespondByDate();
        }
        long respondByNDays = this.getRespondByNDays().intValue();
        return noticeCreatedDate + respondByNDays * 86400000L;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNoticeTemplateId() {
        return this.noticeTemplateId;
    }

    private void setNoticeTemplateId(String noticeTemplateId) {
        this.noticeTemplateId = noticeTemplateId;
    }

    public String getNoticeTemplateVersion() {
        return this.noticeTemplateVersion;
    }

    public void setNoticeTemplateVersion(String noticeTemplateVersion) {
        this.noticeTemplateVersion = noticeTemplateVersion;
    }

    public String getNoticeId() {
        return this.noticeId;
    }

    public void setNoticeId(String noticeId) {
        this.noticeId = noticeId;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getDisableComments() {
        return this.disableComments;
    }

    public void setDisableComments(Boolean disableComments) {
        this.disableComments = disableComments;
    }

    public Boolean getDisableAdminNotes() {
        return this.disableAdminNotes;
    }

    public void setDisableAdminNotes(Boolean disableAdminNotes) {
        this.disableAdminNotes = disableAdminNotes;
    }

    public Boolean getRequireResponse() {
        return this.requireResponse;
    }

    public void setRequireResponse(Boolean requireResponse) {
        this.requireResponse = requireResponse;
    }

    public Long getRespondByDate() {
        return this.respondByDate;
    }

    public void setRespondByDate(Long respondByDate) {
        this.respondByDate = respondByDate;
    }

    public Integer getRespondByNDays() {
        return this.respondByNDays;
    }

    public void setRespondByNDays(Integer respondByNDays) {
        this.respondByNDays = respondByNDays;
    }

    public Boolean getEnableRemind() {
        return this.enableRemind;
    }

    public void setEnableRemind(Boolean enableRemind) {
        this.enableRemind = enableRemind;
    }

    public Integer getRemindEveryNDays() {
        return this.remindEveryNDays;
    }

    public void setRemindEveryNDays(Integer remindEveryNDays) {
        this.remindEveryNDays = remindEveryNDays;
    }

    public String getReminderNoticeTemplateId() {
        return this.reminderNoticeTemplateId;
    }

    public void setReminderNoticeTemplateId(String reminderNoticeTemplateId) {
        this.reminderNoticeTemplateId = reminderNoticeTemplateId;
    }

    public String getReminderNoticeId() {
        return this.reminderNoticeId;
    }

    public void setReminderNoticeId(String reminderNoticeId) {
        this.reminderNoticeId = reminderNoticeId;
    }

    public Boolean getEscalateOnResponseFail() {
        return this.escalateOnResponseFail;
    }

    public void setEscalateOnResponseFail(Boolean escalateOnResponseFail) {
        this.escalateOnResponseFail = escalateOnResponseFail;
    }

    public String getEscalateNoticeTemplateId() {
        return this.escalateNoticeTemplateId;
    }

    public void setEscalateNoticeTemplateId(String escalateNoticeTemplateId) {
        this.escalateNoticeTemplateId = escalateNoticeTemplateId;
    }

    public String getEscalateNoticeId() {
        return this.escalateNoticeId;
    }

    public void setEscalateNoticeId(String escalateNoticeId) {
        this.escalateNoticeId = escalateNoticeId;
    }

    public NoticeType getNoticeType() {
        return this.noticeType;
    }

    public void setNoticeType(NoticeType noticeType) {
        this.noticeType = noticeType;
    }

    public Integer getSendRecurringNoticeEveryN() {
        return this.sendRecurringNoticeEveryN;
    }

    public void setSendRecurringNoticeEveryN(Integer sendRecurringNoticeEveryN) {
        this.sendRecurringNoticeEveryN = sendRecurringNoticeEveryN;
    }

    public RecurringNoticeFrequency getRecurringNoticeFrequency() {
        return this.recurringNoticeFrequency;
    }

    public void setRecurringNoticeFrequency(RecurringNoticeFrequency recurringNoticeFrequency) {
        this.recurringNoticeFrequency = recurringNoticeFrequency;
    }
}

