/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notice;

import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.notice.FormElementType;
import com.nuix.automate.utils.models.api.notice.FormOption;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class NoticeEvent
extends UserPermissionModel {
    @Schema(description="Notice Event ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Notice Event Parent ID", example="11111111-1111-1111-1111-111111111111")
    private String parentId;
    @Schema(description="Notice ID", example="11111111-1111-1111-1111-111111111111")
    private String noticeId;
    @Schema(description="User ID", example="11111111-1111-1111-1111-111111111111")
    private String userId;
    @Schema(description="Is Notice Event Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Notice Event Created Date (Epoch)", example="1641034800000")
    private Long createdDate;
    @Schema(description="Notice Event Reissued Date (Epoch)", example="1641034800000")
    private Long sentDate;
    @Schema(description="Notice Event First Viewed Date (Epoch)", example="1641034800000")
    private Long firstViewedDate;
    @Schema(description="Notice Event Last Viewed Date (Epoch)", example="1641034800000")
    private Long lastViewedDate;
    @Schema(description="Notice Event Last Responded Date (Epoch)", example="1641034800000")
    private Long lastRespondedDate;
    @Schema(description="Notice Event Responded Date (Epoch)", example="1641034800000")
    private Long respondedDate;
    @Schema(description="Notice Event Escalated Date (Epoch)", example="1641034800000")
    private Long escalatedDate;
    @Schema(description="Notice Event Last Reminded Date (Epoch)", example="1641034800000")
    private Long lastRemindedDate;
    @Schema(description="Notice Event Last Comment Date (Epoch)", example="1641034800000")
    private Long lastCommentedDate;
    @Schema(description="Notice Event Last Comment User ID", example="11111111-1111-1111-1111-111111111111")
    private String lastCommentedUserId;
    @Schema(description="Notice Event Last Admin Note Date (Epoch)", example="1641034800000")
    private Long lastAdminNoteDate;
    @Schema(description="Notice Event Last Admin Note User ID", example="11111111-1111-1111-1111-111111111111")
    private String lastAdminNoteUserId;
    @Schema(description="Notice Event Admins Last View Dates", example="1641034800000")
    private Map<String, Long> adminLastViewedDate;
    @Schema(description="Notice Event Survey Form Values")
    private Map<String, String> surveyFormValues;
    @Schema(description="Are Notice Event Comments Disabled", example="false")
    private Boolean disableComments;

    public NoticeEvent() {
    }

    public NoticeEvent(String noticeId, String userId) {
        this.id = UidUtils.getRandom();
        this.noticeId = noticeId;
        this.userId = userId;
        this.sentDate = this.createdDate = Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        this.enabled = true;
    }

    public boolean canView() {
        if (this.getUserPermissions() != null) {
            return this.getUserPermissions().contains((Object)Permission.VIEW) || this.getUserPermissions().contains((Object)Permission.MANAGE) || this.getUserPermissions().contains((Object)Permission.RESPOND);
        }
        return false;
    }

    public void setLastViewedDate(String userId, Set<Permission> permissions, long lastViewedDate) {
        if (permissions == null) {
            return;
        }
        if (permissions.contains((Object)Permission.RESPOND)) {
            this.setLastViewedDate(lastViewedDate);
        } else if (permissions.contains((Object)Permission.MANAGE)) {
            if (this.adminLastViewedDate == null) {
                this.adminLastViewedDate = new HashMap<String, Long>();
            }
            this.adminLastViewedDate.put(userId, lastViewedDate);
        }
    }

    public void resetSubmission(List<FormOption> formOptions) {
        this.setEnabled(true);
        this.setLastRespondedDate(null);
        if (this.surveyFormValues != null && formOptions != null) {
            for (FormOption formOption : formOptions) {
                if (formOption.getType() != FormElementType.DATA_UPLOAD) continue;
                this.surveyFormValues.put(formOption.getKey(), null);
            }
        }
    }

    @Override
    public NoticeEvent clone() {
        return (NoticeEvent)super.clone();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getNoticeId() {
        return this.noticeId;
    }

    public void setNoticeId(String noticeId) {
        this.noticeId = noticeId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public Long getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Long sentDate) {
        this.sentDate = sentDate;
    }

    public Long getLastViewedDate() {
        return this.lastViewedDate;
    }

    public void setLastViewedDate(Long lastViewedDate) {
        this.lastViewedDate = lastViewedDate;
        if (this.firstViewedDate == null) {
            this.firstViewedDate = lastViewedDate;
        }
    }

    public Long getFirstViewedDate() {
        return this.firstViewedDate;
    }

    public void setFirstViewedDate(Long firstViewedDate) {
        this.firstViewedDate = firstViewedDate;
    }

    public Long getLastRespondedDate() {
        return this.lastRespondedDate;
    }

    public void setLastRespondedDate(Long lastRespondedDate) {
        this.lastRespondedDate = lastRespondedDate;
    }

    public Long getRespondedDate() {
        return this.respondedDate;
    }

    public void setRespondedDate(Long respondedDate) {
        this.respondedDate = respondedDate;
    }

    public Long getEscalatedDate() {
        return this.escalatedDate;
    }

    public void setEscalatedDate(Long escalatedDate) {
        this.escalatedDate = escalatedDate;
    }

    public Long getLastRemindedDate() {
        return this.lastRemindedDate;
    }

    public void setLastRemindedDate(Long lastRemindedDate) {
        this.lastRemindedDate = lastRemindedDate;
    }

    public Long getLastCommentedDate() {
        return this.lastCommentedDate;
    }

    public void setLastCommentedDate(Long lastCommentedDate) {
        this.lastCommentedDate = lastCommentedDate;
    }

    public String getLastCommentedUserId() {
        return this.lastCommentedUserId;
    }

    public void setLastCommentedUserId(String lastCommentedUserId) {
        this.lastCommentedUserId = lastCommentedUserId;
    }

    public Long getLastAdminNoteDate() {
        return this.lastAdminNoteDate;
    }

    public void setLastAdminNoteDate(Long lastAdminNoteDate) {
        this.lastAdminNoteDate = lastAdminNoteDate;
    }

    public String getLastAdminNoteUserId() {
        return this.lastAdminNoteUserId;
    }

    public void setLastAdminNoteUserId(String lastAdminNoteUserId) {
        this.lastAdminNoteUserId = lastAdminNoteUserId;
    }

    public Map<String, Long> getAdminLastViewedDate() {
        return this.adminLastViewedDate;
    }

    public void setAdminLastViewedDate(Map<String, Long> adminLastViewedDate) {
        this.adminLastViewedDate = adminLastViewedDate;
    }

    public Map<String, String> getSurveyFormValues() {
        return this.surveyFormValues;
    }

    public void setSurveyFormValues(Map<String, String> surveyFormValues) {
        this.surveyFormValues = surveyFormValues;
    }

    public Boolean getDisableComments() {
        return this.disableComments;
    }

    public void setDisableComments(Boolean disableComments) {
        this.disableComments = disableComments;
    }
}

